"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaAvailabilityControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediaavailabilitycontrol.html

    **Detailed Description**

    An instance of **QMediaObject**  (or its derived classes) can report any
    changes in availability via this control.

    The interface name of QMediaAvailabilityControl is `org.qt-
    project.qt.mediaavailabilitycontrol/5.0` as defined in
    **QMediaAvailabilityControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaObject** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaavailabilitycontrol.html#QMediaAvailability
        Control

        **[protected]
        QMediaAvailabilityControl::QMediaAvailabilityControl(QObject * parent =
        nullptr)**

        Constructs an availability control object with **parent**.
        """
        ...

    def availability(self) -> "QMultimedia.AvailabilityStatus":
        """
        https://doc.qt.io/qt-5/qmediaavailabilitycontrol.html#availability

        **[pure virtual] QMultimedia::AvailabilityStatus
        QMediaAvailabilityControl::availability() const**

        Returns the current availability of this instance of the media service.
        If the availability changes at run time (for example, some other media
        client takes all media resources) the availabilityChanges() signal
        should be emitted.
        """
        ...

    @property
    def availabilityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaavailabilitycontrol.html#availabilityChange
        d

        **[signal] void QMediaAvailabilityControl::availabilityChanged(QMultimed
        ia::AvailabilityStatus availability )**

        Signal emitted when the current **availability** value changed.
        """
        ...
