"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCameraInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcamerainfo.html

    **Detailed Description**

    QCameraInfo lets you query for camera devices that are currently available
    on the system.

    The static functions **defaultCamera** () and **availableCameras** ()
    provide you a list of all available cameras.

    This example prints the name of all available cameras:

    const **QList** <**QCameraInfo** > cameras = **QCameraInfo**
    ::availableCameras();
        for (const **QCameraInfo**  &cameraInfo : cameras)
    **qDebug** () << cameraInfo.deviceName();

    A QCameraInfo can be used to construct a **QCamera** . The following example
    instantiates a **QCamera**  whose camera device is named 'mycamera':

    const **QList** <**QCameraInfo** > cameras = **QCameraInfo**
    ::availableCameras();
        for (const **QCameraInfo**  &cameraInfo : cameras)
    {
            if (cameraInfo.deviceName() == "mycamera")
                camera =
    new **QCamera** (cameraInfo);
        }

    You can also use QCameraInfo to get general information about a camera
    device such as description, physical position on the system, or camera
    sensor orientation.

    **QCamera**  myCamera;
        **QCameraInfo**  cameraInfo(myCamera);
    if (cameraInfo.position() == **QCamera** ::FrontFace)
            **qDebug** ()
    << "The camera is on the front face of the hardware system.";
        else if
    (cameraInfo.position() == **QCamera** ::BackFace)
            **qDebug** () <<
    "The camera is on the back face of the hardware system.";
    **qDebug** () << "The camera sensor orientation is " <<
    cameraInfo.orientation() << " degrees.";

    **See also** **QCamera** .
    """

    @typing.overload
    def __init__(
        self, name: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#QCameraInfo

        **QCameraInfo::QCameraInfo(const QByteArray & name = QByteArray())**

        Constructs a camera info object from a camera device **name**.

        If no such device exists, the QCameraInfo object will be invalid and
        **isNull** () will return true.
        """
        ...

    @typing.overload
    def __init__(self, camera: QCamera) -> None:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#QCameraInfo-1

        **QCameraInfo::QCameraInfo(const QCamera & camera )**

        Constructs a camera info object for **camera**.

        You can use it to query information about the **camera** object passed
        as argument.

        If the **camera** is invalid, for example when no camera device is
        available on the system, the QCameraInfo object will be invalid and
        **isNull** () will return true.
        """
        ...

    @typing.overload
    def __init__(self, other: "QCameraInfo") -> None:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#QCameraInfo-2

        **QCameraInfo::QCameraInfo(const QCameraInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def availableCameras(
        position: QCamera.Position = ...,
    ) -> typing.List["QCameraInfo"]:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#availableCameras

        **[static] QList<QCameraInfo>
        QCameraInfo::availableCameras(QCamera::Position position =
        QCamera::UnspecifiedPosition)**

        Returns a list of available cameras on the system which are located at
        **position**.

        If **position** is not specified or if the value is
        **QCamera::UnspecifiedPosition** , a list of all available cameras will
        be returned.
        """
        ...

    @staticmethod
    def defaultCamera() -> "QCameraInfo":
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#defaultCamera

        **[static] QCameraInfo QCameraInfo::defaultCamera()**

        Returns the default camera on the system.

        The returned object should be checked using **isNull** () before being
        used, in case there is no default camera or no cameras at all.

        **See also** **availableCameras** ().
        """
        ...

    def orientation(self) -> int:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#orientation

        **int QCameraInfo::orientation() const**

        Returns the physical orientation of the camera sensor.

        The value is the orientation angle (clockwise, in steps of 90 degrees)
        of the camera sensor in relation to the display in its natural
        orientation.

        You can show the camera image in the correct orientation by rotating it
        by this value in the anti-clockwise direction.

        For example, suppose a mobile device which is naturally in portrait
        orientation. The back-facing camera is mounted in landscape. If the top
        side of the camera sensor is aligned with the right edge of the screen
        in natural orientation, the value should be 270. If the top side of a
        front-facing camera sensor is aligned with the right of the screen, the
        value should be 90.
        """
        ...

    def position(self) -> QCamera.Position:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#position

        **QCamera::Position QCameraInfo::position() const**

        Returns the physical position of the camera on the hardware system.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#description

        **QString QCameraInfo::description() const**

        Returns the human-readable description of the camera.
        """
        ...

    def deviceName(self) -> str:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#deviceName

        **QString QCameraInfo::deviceName() const**

        Returns the device name of the camera

        This is a unique ID to identify the camera and may not be human-
        readable.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerainfo.html#isNull

        **bool QCameraInfo::isNull() const**

        Returns true if this **QCameraInfo**  is null or invalid.
        """
        ...
