"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraImageProcessingControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameraimageprocessingcontrol.html

    **Detailed Description**

    The interface name of QCameraImageProcessingControl is `org.qt-
    project.qt.cameraimageprocessingcontrol/5.0` as defined in
    **QCameraImageProcessingControl_iid** .

    Camera service may choose the parameters of image processing pipeline
    depending on sensor properties camera settings and capture parameters.

    This control allows to modify some parameters of image processing pipeline
    to achieve desired results.

    Parameters with the "Adjustment" suffix, like **ContrastAdjustment** ,
    **SaturationAdjustment**  etc allows to adjust the parameter values,
    selected by camera engine, while parameters like Contrast and Saturation
    overwrites them.

    For example setting the **SharpeningAdjustment**  parameter to -0.1 slightly
    reduces the amount of sharpening applied, while settings the Sharpening
    parameter to 0 disables sharpening at all.

    **See also** **QMediaService::requestControl** () and **QCamera** .
    """

    class ProcessingParameter(int):
        WhiteBalancePreset: QCameraImageProcessingControl = ...
        ColorTemperature: QCameraImageProcessingControl = ...
        Contrast: QCameraImageProcessingControl = ...
        Saturation: QCameraImageProcessingControl = ...
        Brightness: QCameraImageProcessingControl = ...
        Sharpening: QCameraImageProcessingControl = ...
        Denoising: QCameraImageProcessingControl = ...
        ContrastAdjustment: QCameraImageProcessingControl = ...
        SaturationAdjustment: QCameraImageProcessingControl = ...
        BrightnessAdjustment: QCameraImageProcessingControl = ...
        SharpeningAdjustment: QCameraImageProcessingControl = ...
        DenoisingAdjustment: QCameraImageProcessingControl = ...
        ColorFilter: QCameraImageProcessingControl = ...
        ExtendedParameter: QCameraImageProcessingControl = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessingcontrol.html#QCameraImagePr
        ocessingControl

        **[protected]
        QCameraImageProcessingControl::QCameraImageProcessingControl(QObject *
        parent = nullptr)**

        Constructs an image processing control object with **parent**.
        """
        ...

    def setParameter(
        self,
        parameter: "QCameraImageProcessingControl.ProcessingParameter",
        value: typing.Any,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessingcontrol.html#setParameter

        **[pure virtual] void QCameraImageProcessingControl::setParameter(QCamer
        aImageProcessingControl::ProcessingParameter parameter , const QVariant
        & value )**

        Sets the image processing **parameter** **value**. Passing the null or
        invalid **QVariant**  value allows backend to choose the suitable
        parameter value.

        The valid values range depends on the parameter type. For
        **WhiteBalancePreset**  the value should be one of
        **QCameraImageProcessing::WhiteBalanceMode**  values; for Contrast,
        Saturation, Brightness, Sharpening and Denoising the value should be in
        [0..1.0] range with invalid **QVariant**  value indicating the default
        parameter value; for **ContrastAdjustment** , **SaturationAdjustment** ,
        **BrightnessAdjustment** , **SharpeningAdjustment**  and
        **DenoisingAdjustment**  the value should be in [-1.0..1.0] range with
        default 0.

        **See also** **parameter** ().
        """
        ...

    def parameter(
        self, parameter: "QCameraImageProcessingControl.ProcessingParameter"
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessingcontrol.html#parameter

        **[pure virtual] QVariant QCameraImageProcessingControl::parameter(QCame
        raImageProcessingControl::ProcessingParameter parameter ) const**

        Returns the image processing **parameter** value.

        **See also** **setParameter** ().
        """
        ...

    def isParameterValueSupported(
        self,
        parameter: "QCameraImageProcessingControl.ProcessingParameter",
        value: typing.Any,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessingcontrol.html#isParameterVal
        ueSupported

        **[pure virtual] bool QCameraImageProcessingControl::isParameterValueSup
        ported(QCameraImageProcessingControl::ProcessingParameter parameter ,
        const QVariant & value ) const**

        Returns true if the camera supports setting the image processing
        **parameter** **value**.

        It's used only for parameters with a limited set of values, like
        **WhiteBalancePreset** .
        """
        ...

    def isParameterSupported(
        self, a0: "QCameraImageProcessingControl.ProcessingParameter"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessingcontrol.html#isParameterSup
        ported

        **[pure virtual] bool QCameraImageProcessingControl::isParameterSupporte
        d(QCameraImageProcessingControl::ProcessingParameter parameter ) const**

        Returns true if the camera supports adjusting image processing
        **parameter**.

        Usually the supported setting is static, but some parameters may not be
        available depending on other camera settings, like presets. In such case
        the currently supported parameters should be returned.
        """
        ...
