"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraFeedbackControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html

    **Detailed Description**

    When using a camera, there are several times when some form of feedback to
    the user is given - for example, when an image is taken, or when recording
    is started. You can enable or disable some of this feedback, or adjust what
    sound might be played for these actions.

    In some cases it may be undesirable to play a sound effect - for example,
    when initiating video recording the sound itself may be recorded.

    **Note:** In some countries or regions, feedback sounds or other indications
    (e.g. a red light) are mandatory during camera operation. In these cases,
    you can check `isEventFeedbackLocked` to check if that type of feedback can
    be modified. Any attempts to change a locked feedback type will be ignored.

    The interface name of QCameraFeedbackControl is `org.qt-
    project.qt.camerafeedbackcontrol/5.0` as defined in
    **QCameraFeedbackControl_iid** .

    **See also** **QCamera** .
    """

    class EventType(int):
        ViewfinderStarted: QCameraFeedbackControl = ...
        ViewfinderStopped: QCameraFeedbackControl = ...
        ImageCaptured: QCameraFeedbackControl = ...
        ImageSaved: QCameraFeedbackControl = ...
        ImageError: QCameraFeedbackControl = ...
        RecordingStarted: QCameraFeedbackControl = ...
        RecordingInProgress: QCameraFeedbackControl = ...
        RecordingStopped: QCameraFeedbackControl = ...
        AutoFocusInProgress: QCameraFeedbackControl = ...
        AutoFocusLocked: QCameraFeedbackControl = ...
        AutoFocusFailed: QCameraFeedbackControl = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html#QCameraFeedbackContro
        l

        **[protected] QCameraFeedbackControl::QCameraFeedbackControl(QObject *
        parent = nullptr)**

        Constructs a camera feedback control object with **parent**.
        """
        ...

    def setEventFeedbackSound(
        self, a0: "QCameraFeedbackControl.EventType", filePath: str
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html#setEventFeedbackSound

        **[pure virtual] bool QCameraFeedbackControl::setEventFeedbackSound(QCam
        eraFeedbackControl::EventType event , const QString & filePath )**

        When the given **event** occurs, the sound effect referenced by
        **filePath** will be played instead of the default sound.

        If this feedback type is locked, or if the supplied path is
        inaccessible, this function will return false. In addition, some forms
        of feedback may be non-auditory (e.g. a red light, or a vibration), and
        false may be returned in this case.

        The file referenced should be linear PCM (WAV format).

        **Note:** In the case that a valid file path to an unsupported file is
        given, this function will return true but the feedback will use the
        original setting.

        This function was introduced in Qt 5.0.
        """
        ...

    def resetEventFeedback(self, a0: "QCameraFeedbackControl.EventType") -> None:
        """
        https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html#resetEventFeedback

        **[pure virtual] void QCameraFeedbackControl::resetEventFeedback(QCamera
        FeedbackControl::EventType event )**

        Restores the feedback setting for this **event** to its default setting.

        This function was introduced in Qt 5.0.
        """
        ...

    def setEventFeedbackEnabled(
        self, a0: "QCameraFeedbackControl.EventType", a1: bool
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html#setEventFeedbackEnabl
        ed

        **[pure virtual] bool QCameraFeedbackControl::setEventFeedbackEnabled(QC
        ameraFeedbackControl::EventType event , bool enabled )**

        Turns on feedback for the specific **event** if **enabled** is true,
        otherwise disables the feedback. Returns true if the feedback could be
        modified, or false otherwise (e.g. this feedback type is locked).

        This function was introduced in Qt 5.0.

        **See also** **isEventFeedbackEnabled** ().
        """
        ...

    def isEventFeedbackEnabled(self, a0: "QCameraFeedbackControl.EventType") -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html#isEventFeedbackEnable
        d

        **[pure virtual] bool QCameraFeedbackControl::isEventFeedbackEnabled(QCa
        meraFeedbackControl::EventType event ) const**

        Returns true if the feedback for **event** is enabled.

        This function was introduced in Qt 5.0.
        """
        ...

    def isEventFeedbackLocked(self, a0: "QCameraFeedbackControl.EventType") -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafeedbackcontrol.html#isEventFeedbackLocked

        **[pure virtual] bool QCameraFeedbackControl::isEventFeedbackLocked(QCam
        eraFeedbackControl::EventType event ) const**

        Returns true if the feedback setting for **event** is locked. This may
        be true because of legal compliance issues, or because configurability
        of this event's feedback is not supported.

        This function was introduced in Qt 5.0.
        """
        ...
