"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameracontrol.html

    **Detailed Description**

    This service is provided by a **QMediaService**  object via
    QMediaService::control(). It is used by **QCamera** .

    The interface name of QCameraControl is `org.qt-
    project.qt.cameracontrol/5.0` as defined in **QCameraControl_iid** .

    **See also** **QMediaService::requestControl** () and **QCamera** .
    """

    class PropertyChangeType(int):
        CaptureMode: QCameraControl = ...
        ImageEncodingSettings: QCameraControl = ...
        VideoEncodingSettings: QCameraControl = ...
        Viewfinder: QCameraControl = ...
        ViewfinderSettings: QCameraControl = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#QCameraControl

        **[protected] QCameraControl::QCameraControl(QObject * parent =
        nullptr)**

        Constructs a camera control object with **parent**.
        """
        ...

    def canChangeProperty(
        self, changeType: "QCameraControl.PropertyChangeType", status: QCamera.Status
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#canChangeProperty

        **[pure virtual] bool
        QCameraControl::canChangeProperty(QCameraControl::PropertyChangeType
        changeType , QCamera::Status status ) const**

        Returns true if backend can effectively apply changing camera properties
        of **changeType** type while the camera state is QCamera::Active and
        camera status matches **status** parameter.

        If backend doesn't support applying this change in the active state, it
        will be stopped before the settings are changed and restarted after.
        Otherwise the backend should apply the change in the current state, with
        the camera status indicating the progress, if necessary.
        """
        ...

    def isCaptureModeSupported(
        self, mode: typing.Union[QCamera.CaptureModes, QCamera.CaptureMode]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#isCaptureModeSupported

        **[pure virtual] bool
        QCameraControl::isCaptureModeSupported(QCamera::CaptureModes mode )
        const**

        Returns true if the capture **mode** is suported.
        """
        ...

    def setCaptureMode(
        self, a0: typing.Union[QCamera.CaptureModes, QCamera.CaptureMode]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#setCaptureMode

        **[pure virtual] void
        QCameraControl::setCaptureMode(QCamera::CaptureModes mode )**

        Sets the current capture **mode**.

        The capture mode changes are synchronous and allowed in any camera
        state.

        If the capture mode is changed while camera is active, it's recommended
        to change status to **QCamera::LoadedStatus**  and start activating the
        camera in the next event loop with the status changed to
        **QCamera::StartingStatus** . This allows the capture settings to be
        applied before camera is started. Than change the status to
        QCamera::StartedStatus when the capture mode change is done.

        **See also** **captureMode** ().
        """
        ...

    def captureMode(self) -> QCamera.CaptureModes:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#captureMode

        **[pure virtual] QCamera::CaptureModes QCameraControl::captureMode()
        const**

        Returns the current capture mode.

        **See also** **setCaptureMode** ().
        """
        ...

    def status(self) -> QCamera.Status:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#status

        **[pure virtual] QCamera::Status QCameraControl::status() const**

        Returns the status of the camera service.

        **See also** **QCamera::state** .
        """
        ...

    def setState(self, state: QCamera.State) -> None:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#setState

        **[pure virtual] void QCameraControl::setState(QCamera::State state )**

        Sets the camera **state**.

        State changes are synchronous and indicate user intention, while camera
        status is used as a feedback mechanism to inform application about
        backend status. Status changes are reported asynchronously with
        **QCameraControl::statusChanged** () signal.

        **See also** **state** () and **QCamera::State** .
        """
        ...

    def state(self) -> QCamera.State:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#state

        **[pure virtual] QCamera::State QCameraControl::state() const**

        Returns the state of the camera service.

        **See also** **setState** () and **QCamera::state** .
        """
        ...

    @property
    def captureModeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#captureModeChanged

        **[signal] void QCameraControl::captureModeChanged(QCamera::CaptureModes
        mode )**

        Signal emitted when the camera capture **mode** changes.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#error

        **[signal] void QCameraControl::error(int error , const QString &
        errorString )**

        Signal emitted when an error occurs with error code **error** and a
        description of the error **errorString**.
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#stateChanged

        **[signal] void QCameraControl::stateChanged(QCamera::State state )**

        Signal emitted when the camera **state** changes.

        In most cases the state chage is caused by **QCameraControl::setState**
        (), but if critical error has occurred the state changes to
        **QCamera::UnloadedState** .
        """
        ...

    @property
    def statusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameracontrol.html#statusChanged

        **[signal] void QCameraControl::statusChanged(QCamera::Status status )**

        Signal emitted when the camera **status** changes.
        """
        ...
