"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioOutput(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qaudiooutput.html

    **Detailed Description**

    You can construct an audio output with the system's **default audio output
    device** . It is also possible to create QAudioOutput with a specific
    **QAudioDeviceInfo** . When you create the audio output, you should also
    send in the **QAudioFormat**  to be used for the playback (see the
    **QAudioFormat**  class description for details).

    To play a file:

    Starting to play an audio stream is simply a matter of calling **start** ()
    with a **QIODevice** . QAudioOutput will then fetch the data it needs from
    the io device. So playing back an audio file is as simple as:

    **QFile**  sourceFile;   // class member.
        **QAudioOutput** * audio; //
    class member.
        {
            sourceFile.setFileName("/tmp/test.raw");
    sourceFile.open(**QIODevice** ::ReadOnly);

            **QAudioFormat**
    format;
            // Set up the format, eg.
    format.setSampleRate(8000);
            format.setChannelCount(1);
    format.setSampleSize(8);
            format.setCodec("audio/pcm");
    format.setByteOrder(**QAudioFormat** ::LittleEndian);
    format.setSampleType(**QAudioFormat** ::UnSignedInt);
    **QAudioDeviceInfo**  info(**QAudioDeviceInfo** ::defaultOutputDevice());
    if (!info.isFormatSupported(format)) {
                **qWarning** () << "Raw
    audio format not supported by backend, cannot play audio.";
    return;
            }

            audio = new **QAudioOutput** (format, this);
    connect(audio, SIGNAL(stateChanged(QAudio::State)), this,
    SLOT(handleStateChanged(QAudio::State)));
            audio->start(&sourceFile);
    }

    The file will start playing assuming that the audio system and output device
    support it. If you run out of luck, check what's up with the **error** ()
    function.

    After the file has finished playing, we need to stop the device:

    void AudioOutputExample::handleStateChanged(QAudio::State newState)
        {
    switch (newState) {
                case QAudio::IdleState:
                    //
    Finished playing (no more data)
                    audio->stop();
    sourceFile.close();
                    delete audio;
                    break;
    case QAudio::StoppedState:
                    // Stopped for other reasons
    if (audio->error() != QAudio::NoError) {
                        // Error
    handling
                    }
                    break;

                default:
    // ... other cases as appropriate
                    break;
            }
        }

    At any given time, the QAudioOutput will be in one of four states: active,
    suspended, stopped, or idle. These states are described by the
    **QAudio::State**  enum. State changes are reported through the
    **stateChanged** () signal. You can use this signal to, for instance, update
    the GUI of the application; the mundane example here being changing the
    state of a `play/pause` button. You request a state change directly with
    **suspend** (), **stop** (), **reset** (), **resume** (), and **start** ().

    While the stream is playing, you can set a notify interval in milliseconds
    with **setNotifyInterval** (). This interval specifies the time between two
    emissions of the **notify** () signal. This is relative to the position in
    the stream, i.e., if the QAudioOutput is in the SuspendedState or the
    IdleState, the **notify** () signal is not emitted. A typical use-case would
    be to update a **slider**  that allows seeking in the stream. If you want
    the time since playback started regardless of which states the audio output
    has been in, **elapsedUSecs** () is the function for you.

    If an error occurs, you can fetch the **error type**  with the **error** ()
    function. Please see the **QAudio::Error**  enum for a description of the
    possible errors that are reported. When an error is encountered, the state
    changes to **QAudio::StoppedState** . You can check for errors by connecting
    to the **stateChanged** () signal:

    void AudioOutputExample::handleStateChanged(QAudio::State newState)
        {
    switch (newState) {
                case QAudio::IdleState:
                    //
    Finished playing (no more data)
                    audio->stop();
    sourceFile.close();
                    delete audio;
                    break;
    case QAudio::StoppedState:
                    // Stopped for other reasons
    if (audio->error() != QAudio::NoError) {
                        // Error
    handling
                    }
                    break;

                default:
    // ... other cases as appropriate
                    break;
            }
        }

    **See also** **QAudioInput**  and **QAudioDeviceInfo** .
    """

    @typing.overload
    def __init__(
        self, format: QAudioFormat = ..., parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#QAudioOutput

        **QAudioOutput::QAudioOutput(const QAudioFormat & format =
        QAudioFormat(), QObject * parent = nullptr)**

        Construct a new audio output and attach it to **parent**. The default
        audio output device is used with the output **format** parameters.
        """
        ...

    @typing.overload
    def __init__(
        self,
        audioDevice: QAudioDeviceInfo,
        format: QAudioFormat = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#QAudioOutput-1

        **QAudioOutput::QAudioOutput(const QAudioDeviceInfo & audioDevice ,
        const QAudioFormat & format = QAudioFormat(), QObject * parent =
        nullptr)**

        Construct a new audio output and attach it to **parent**. The device
        referenced by **audioDevice** is used with the output **format**
        parameters.
        """
        ...

    def setCategory(self, category: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#setCategory

        **void QAudioOutput::setCategory(const QString & category )**

        Sets the audio category of this audio stream to **category**.

        Some platforms can group audio streams into categories and manage their
        volumes independently, or display them in a system mixer control. You
        can set this property to allow the platform to distinguish the purpose
        of your streams.

        Not all platforms support audio stream categorization. In this case, the
        function call will be ignored.

        Changing an audio output stream's category while it is opened will not
        take effect until it is reopened.

        **See also** **category** ().
        """
        ...

    def category(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#category

        **QString QAudioOutput::category() const**

        Returns the audio category of this audio stream.

        Some platforms can group audio streams into categories and manage their
        volumes independently, or display them in a system mixer control. You
        can set this property to allow the platform to distinguish the purpose
        of your streams.

        **See also** **setCategory** ().
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#volume

        **qreal QAudioOutput::volume() const**

        Returns the volume between 0.0 and 1.0 inclusive.

        **See also** **setVolume** ().
        """
        ...

    def setVolume(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#setVolume

        **void QAudioOutput::setVolume(qreal volume )**

        Sets the output volume to **volume**.

        The volume is scaled linearly from `0.0` (silence) to `1.0` (full
        volume). Values outside this range will be clamped.

        The default volume is `1.0`.

        Note: Adjustments to the volume will change the volume of this audio
        stream, not the global volume.

        UI volume controls should usually be scaled nonlinearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **See also** **volume** ().
        """
        ...

    def state(self) -> QAudio.State:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#state

        **QAudio::State QAudioOutput::state() const**

        Returns the state of audio processing.
        """
        ...

    def error(self) -> QAudio.Error:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#error

        **QAudio::Error QAudioOutput::error() const**

        Returns the error state.
        """
        ...

    def elapsedUSecs(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#elapsedUSecs

        **qint64 QAudioOutput::elapsedUSecs() const**

        Returns the microseconds since **start** () was called, including time
        in Idle and Suspend states.
        """
        ...

    def processedUSecs(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#processedUSecs

        **qint64 QAudioOutput::processedUSecs() const**

        Returns the amount of audio data processed since **start** () was called
        (in microseconds).
        """
        ...

    def notifyInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#notifyInterval

        **int QAudioOutput::notifyInterval() const**

        Returns the notify interval in milliseconds.

        **See also** **setNotifyInterval** ().
        """
        ...

    def setNotifyInterval(self, milliSeconds: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#setNotifyInterval

        **void QAudioOutput::setNotifyInterval(int ms )**

        Sets the interval for **notify** () signal to be emitted. This is based
        on the **ms** of audio data processed, not on wall clock time. The
        minimum resolution of the timer is platform specific and values should
        be checked with **notifyInterval** () to confirm the actual value being
        used.

        **See also** **notifyInterval** ().
        """
        ...

    def periodSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#periodSize

        **int QAudioOutput::periodSize() const**

        Returns the period size in bytes. This is the amount of data required
        each period to prevent buffer underrun, and to ensure uninterrupted
        playback.

        **Note:** It is recommended to provide at least enough data for a full
        period with each write operation.
        """
        ...

    def bytesFree(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#bytesFree

        **int QAudioOutput::bytesFree() const**

        Returns the number of free bytes available in the audio buffer.

        **Note:** The returned value is only valid while in
        **QAudio::ActiveState**  or **QAudio::IdleState**  state, otherwise
        returns zero.
        """
        ...

    def bufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#bufferSize

        **int QAudioOutput::bufferSize() const**

        Returns the audio buffer size in bytes.

        If called before **start** (), returns platform default value. If called
        before **start** () but **setBufferSize** () was called prior, returns
        value set by **setBufferSize** (). If called after **start** (), returns
        the actual buffer size being used. This may not be what was set
        previously by **setBufferSize** ().

        **See also** **setBufferSize** ().
        """
        ...

    def setBufferSize(self, bytes: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#setBufferSize

        **void QAudioOutput::setBufferSize(int value )**

        Sets the audio buffer size to **value** in bytes.

        **Note:** This function can be called anytime before **start** (). Calls
        to this are ignored after **start** (). It should not be assumed that
        the buffer size set is the actual buffer size used - call **bufferSize**
        () anytime after **start** () to return the actual buffer size being
        used.

        **See also** **bufferSize** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#resume

        **void QAudioOutput::resume()**

        Resumes processing audio data after a **suspend** ().

        Sets **error** () to **QAudio::NoError** . Sets **state** () to
        **QAudio::ActiveState**  if you previously called start(**QIODevice**
        *). Sets **state** () to **QAudio::IdleState**  if you previously called
        **start** (). emits **stateChanged** () signal.
        """
        ...

    def suspend(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#suspend

        **void QAudioOutput::suspend()**

        Stops processing audio data, preserving buffered audio data.

        Sets **error** () to **QAudio::NoError** , **state** () to
        **QAudio::SuspendedState**  and emits **stateChanged** () signal.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#reset

        **void QAudioOutput::reset()**

        Drops all audio data in the buffers, resets buffers to zero.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#stop

        **void QAudioOutput::stop()**

        Stops the audio output, detaching from the system resource.

        Sets **error** () to **QAudio::NoError** , **state** () to
        **QAudio::StoppedState**  and emit **stateChanged** () signal.
        """
        ...

    @typing.overload
    def start(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#start

        **void QAudioOutput::start(QIODevice * device )**

        Starts transferring audio data from the **device** to the system's audio
        output. The **device** must have been opened in the **ReadOnly**  or
        **ReadWrite**  modes.

        If the **QAudioOutput**  is able to successfully output audio data,
        **state** () returns **QAudio::ActiveState** , **error** () returns
        **QAudio::NoError**  and the **stateChanged** () signal is emitted.

        If a problem occurs during this process, **error** () returns
        **QAudio::OpenError** , **state** () returns **QAudio::StoppedState**
        and the **stateChanged** () signal is emitted.

        **See also** **QIODevice** .
        """
        ...

    @typing.overload
    def start(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#start-1

        **QIODevice *QAudioOutput::start()**

        Returns a pointer to the internal **QIODevice**  being used to transfer
        data to the system's audio output. The device will already be open and
        **write()**  can write data directly to it.

        **Note:** The pointer will become invalid after the stream is stopped or
        if you start another stream.

        If the **QAudioOutput**  is able to access the system's audio device,
        **state** () returns **QAudio::IdleState** , **error** () returns
        **QAudio::NoError**  and the **stateChanged** () signal is emitted.

        If a problem occurs during this process, **error** () returns
        **QAudio::OpenError** , **state** () returns **QAudio::StoppedState**
        and the **stateChanged** () signal is emitted.

        **See also** **QIODevice** .
        """
        ...

    def format(self) -> QAudioFormat:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#format

        **QAudioFormat QAudioOutput::format() const**

        Returns the **QAudioFormat**  being used.
        """
        ...

    @property
    def notify(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#notify

        **[signal] void QAudioOutput::notify()**

        This signal is emitted when a certain interval of milliseconds of audio
        data has been processed. The interval is set by **setNotifyInterval**
        ().
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiooutput.html#stateChanged

        **[signal] void QAudioOutput::stateChanged(QAudio::State state )**

        This signal is emitted when the device **state** has changed. This is
        the current state of the audio output.
        """
        ...
