"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioInputSelectorControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html

    **Detailed Description**

    The QAudioInputSelectorControl class provides descriptions of the audio
    inputs available on a system and allows one to be selected as the audio
    input of a media service.

    The interface name of QAudioInputSelectorControl is `org.qt-
    project.qt.audioinputselectorcontrol/5.0` as defined in
    **QAudioInputSelectorControl_iid** .

    **See also** **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#QAudioInputSelect
        orControl

        **[protected]
        QAudioInputSelectorControl::QAudioInputSelectorControl(QObject * parent
        = nullptr)**

        Constructs a new audio input selector control with the given **parent**.
        """
        ...

    def setActiveInput(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#setActiveInput

        **[pure virtual slot] void
        QAudioInputSelectorControl::setActiveInput(const QString & name )**

        Set the active audio input to **name**.

        **See also** **activeInput** ().
        """
        ...

    def activeInput(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#activeInput

        **[pure virtual] QString QAudioInputSelectorControl::activeInput()
        const**

        Returns the name of the currently selected audio input.

        **See also** **setActiveInput** ().
        """
        ...

    def defaultInput(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#defaultInput

        **[pure virtual] QString QAudioInputSelectorControl::defaultInput()
        const**

        Returns the name of the default audio input.
        """
        ...

    def inputDescription(self, name: str) -> str:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#inputDescription

        **[pure virtual] QString
        QAudioInputSelectorControl::inputDescription(const QString & name )
        const**

        Returns the description of the input **name**.
        """
        ...

    def availableInputs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#availableInputs

        **[pure virtual] QList<QString>
        QAudioInputSelectorControl::availableInputs() const**

        Returns a list of the names of the available audio inputs.
        """
        ...

    @property
    def activeInputChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#activeInputChange
        d

        **[signal] void QAudioInputSelectorControl::activeInputChanged(const
        QString & name )**

        Signals that the audio input has changed to **name**.
        """
        ...

    @property
    def availableInputsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudioinputselectorcontrol.html#availableInputsCh
        anged

        **[signal] void QAudioInputSelectorControl::availableInputsChanged()**

        Signals that list of available inputs has changed.
        """
        ...
