"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QAudioFormat(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qaudioformat.html

    **Detailed Description**

    An audio format specifies how data in an audio stream is arranged, i.e, how
    the stream is to be interpreted. The encoding itself is specified by the
    **codec** () used for the stream.

    In addition to the encoding, QAudioFormat contains other parameters that
    further specify how the audio sample data is arranged. These are the
    frequency, the number of channels, the sample size, the sample type, and the
    byte order. The following table describes these in more detail.

    ParameterDescription
    Sample RateSamples per second of audio data in Hertz.
    Number of channelsThe number of audio channels (typically one for mono or
    two for stereo)
    Sample sizeHow much data is stored in each sample
    (typically 8 or 16 bits)
    Sample typeNumerical representation of sample
    (typically signed integer, unsigned integer or float)
    Byte orderByte
    ordering of sample (typically little endian, big endian)

    This class is typically used in conjunction with **QAudioInput**  or
    **QAudioOutput**  to allow you to specify the parameters of the audio stream
    being read or written, or with **QAudioBuffer**  when dealing with samples
    in memory.

    You can obtain audio formats compatible with the audio device used through
    functions in **QAudioDeviceInfo** . This class also lets you query available
    parameter values for a device, so that you can set the parameters yourself.
    See the **QAudioDeviceInfo**  class description for details. You need to
    know the format of the audio streams you wish to play or record.

    In the common case of interleaved linear PCM data, the codec will be
    "audio/pcm", and the samples for all channels will be interleaved. One
    sample for each channel for the same instant in time is referred to as a
    frame in Qt Multimedia (and other places).
    """

    class Endian(int):
        BigEndian: QAudioFormat = ...
        LittleEndian: QAudioFormat = ...

    class SampleType(int):
        Unknown: QAudioFormat = ...
        SignedInt: QAudioFormat = ...
        UnSignedInt: QAudioFormat = ...
        Float: QAudioFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#QAudioFormat

        **QAudioFormat::QAudioFormat()**

        Construct a new audio format.

        Values are initialized as follows:

        * **sampleRate** () = -1
          * **channelCount** () = -1
          * **sampleSize**
        () = -1
          * **byteOrder** () = **QAudioFormat::Endian**
        (**QSysInfo::ByteOrder** )
          * **sampleType** () =
        **QAudioFormat::Unknown**  `codec()` = ""
        """
        ...

    @typing.overload
    def __init__(self, other: "QAudioFormat") -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#QAudioFormat-1

        **QAudioFormat::QAudioFormat(const QAudioFormat & other )**

        Construct a new audio format using **other**.
        """
        ...

    def bytesPerFrame(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#bytesPerFrame

        **int QAudioFormat::bytesPerFrame() const**

        Returns the number of bytes required to represent one frame (a sample in
        each channel) in this format.

        Returns 0 if this format is invalid.
        """
        ...

    def durationForFrames(self, frameCount: int) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#durationForFrames

        **qint64 QAudioFormat::durationForFrames(qint32 frameCount ) const**

        Return the number of microseconds represented by **frameCount** frames
        in this format.
        """
        ...

    def framesForDuration(self, duration: int) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#framesForDuration

        **qint32 QAudioFormat::framesForDuration(qint64 duration ) const**

        Returns the number of frames required to represent **duration**
        microseconds in this format.

        Note that some rounding may occur if **duration** is not an exact
        fraction of the **sampleRate** ().
        """
        ...

    def framesForBytes(self, byteCount: int) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#framesForBytes

        **qint32 QAudioFormat::framesForBytes(qint32 byteCount ) const**

        Returns the number of frames represented by **byteCount** in this
        format.

        Note that some rounding may occur if **byteCount** is not an exact
        multiple of the number of bytes per frame.

        Each frame has one sample per channel.

        **See also** **framesForDuration** ().
        """
        ...

    def bytesForFrames(self, frameCount: int) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#bytesForFrames

        **qint32 QAudioFormat::bytesForFrames(qint32 frameCount ) const**

        Returns the number of bytes required for **frameCount** frames of this
        format.

        Returns 0 if this format is not valid.

        **See also** **bytesForDuration** ().
        """
        ...

    def durationForBytes(self, byteCount: int) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#durationForBytes

        **qint64 QAudioFormat::durationForBytes(qint32 bytes ) const**

        Returns the number of microseconds represented by **bytes** in this
        format.

        Returns 0 if this format is not valid.

        Note that some rounding may occur if **bytes** is not an exact multiple
        of the number of bytes per frame.

        **See also** **bytesForDuration** ().
        """
        ...

    def bytesForDuration(self, duration: int) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#bytesForDuration

        **qint32 QAudioFormat::bytesForDuration(qint64 duration ) const**

        Returns the number of bytes required for this audio format for
        **duration** microseconds.

        Returns 0 if this format is not valid.

        Note that some rounding may occur if **duration** is not an exact
        fraction of the **sampleRate** ().

        **See also** **durationForBytes** ().
        """
        ...

    def channelCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#channelCount

        **int QAudioFormat::channelCount() const**

        Returns the current channel count value.

        **See also** **setChannelCount** ().
        """
        ...

    def setChannelCount(self, channelCount: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#setChannelCount

        **void QAudioFormat::setChannelCount(int channels )**

        Sets the channel count to **channels**.

        **See also** **channelCount** ().
        """
        ...

    def sampleRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#sampleRate

        **int QAudioFormat::sampleRate() const**

        Returns the current sample rate in Hertz.

        **See also** **setSampleRate** ().
        """
        ...

    def setSampleRate(self, sampleRate: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#setSampleRate

        **void QAudioFormat::setSampleRate(int samplerate )**

        Sets the sample rate to **samplerate** Hertz.

        **See also** **sampleRate** ().
        """
        ...

    def sampleType(self) -> "QAudioFormat.SampleType":
        """
        https://doc.qt.io/qt-5/qaudioformat.html#sampleType

        **QAudioFormat::SampleType QAudioFormat::sampleType() const**

        Returns the current **SampleType**  value.

        **See also** **setSampleType** ().
        """
        ...

    def setSampleType(self, sampleType: "QAudioFormat.SampleType") -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#setSampleType

        **void QAudioFormat::setSampleType(QAudioFormat::SampleType sampleType
        )**

        Sets the **sampleType**  to **sampleType**.

        **See also** **sampleType** ().
        """
        ...

    def byteOrder(self) -> "QAudioFormat.Endian":
        """
        https://doc.qt.io/qt-5/qaudioformat.html#byteOrder

        **QAudioFormat::Endian QAudioFormat::byteOrder() const**

        Returns the current byteOrder value.

        **See also** **setByteOrder** ().
        """
        ...

    def setByteOrder(self, byteOrder: "QAudioFormat.Endian") -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#setByteOrder

        **void QAudioFormat::setByteOrder(QAudioFormat::Endian byteOrder )**

        Sets the **byteOrder**  to **byteOrder**.

        **See also** **byteOrder** ().
        """
        ...

    def codec(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#codec

        **QString QAudioFormat::codec() const**

        Returns the current codec identifier.

        **See also** **setCodec** () and **QAudioDeviceInfo::supportedCodecs**
        ().
        """
        ...

    def setCodec(self, codec: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#setCodec

        **void QAudioFormat::setCodec(const QString & codec )**

        Sets the codec to **codec**.

        The parameter to this function should be one of the types reported by
        the **QAudioDeviceInfo::supportedCodecs** () function for the audio
        device you are working with.

        **See also** **codec** () and **QAudioDeviceInfo::supportedCodecs** ().
        """
        ...

    def sampleSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#sampleSize

        **int QAudioFormat::sampleSize() const**

        Returns the current sample size value, in bits.

        **See also** **setSampleSize** () and **bytesPerFrame** ().
        """
        ...

    def setSampleSize(self, sampleSize: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#setSampleSize

        **void QAudioFormat::setSampleSize(int sampleSize )**

        Sets the sample size to the **sampleSize** specified, in bits.

        This is typically 8 or 16, but some systems may support higher sample
        sizes.

        **See also** **sampleSize** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudioformat.html#isValid

        **bool QAudioFormat::isValid() const**

        Returns true if all of the parameters are valid.
        """
        ...
