"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAbstractVideoSurface(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qabstractvideosurface.html

    **Detailed Description**

    The QAbstractVideoSurface class defines the standard interface that video
    producers use to inter-operate with video presentation surfaces. You can
    subclass this interface to receive video frames from sources like **decoded
    media**  or **cameras**  to perform your own processing.

    A video surface presents a continuous stream of identically formatted
    **QVideoFrame**  instances, where the format of each frame is compatible
    with a stream format supplied when starting a presentation. Each frame may
    have timestamp information that can be used by the surface to decide when to
    display that frame.

    A list of pixel formats a surface can present is given by the
    **supportedPixelFormats** () function, and the **isFormatSupported** ()
    function will test if a video surface format is supported. If a format is
    not supported the **nearestFormat** () function may be able to suggest a
    similar format. For example, if a surface supports fixed set of resolutions
    it may suggest the smallest supported resolution that contains the proposed
    resolution.

    The **start** () function takes a supported format and enables a video
    surface. Once started a surface will begin displaying the frames it receives
    in the **present** () function. Surfaces may hold a reference to the buffer
    of a presented video frame until a new frame is presented or streaming is
    stopped. In addition, a video surface may hold a reference to a video frame
    until the **end timestamp**  has passed. The **stop** () function will
    disable a surface and release any video buffers it holds references to.

    **Implementing a subclass of QAbstractVideoSurface**

    When implementing a subclass of this interface, there are only a handful of
    functions to implement, broken down into two classes:

    * Format related
      * Presentation related

    For format related functionality, you just have to describe the pixel
    formats that you support (and the **nearestFormat** () function). For
    presentation related functionality, you have to implement the **present** ()
    function, and the **start** () and **stop** () functions.

    **Note:** You must call the base class implementation of **start** () and
    **stop** () in your implementation.
    """

    class Error(int):
        NoError: QAbstractVideoSurface = ...
        UnsupportedFormatError: QAbstractVideoSurface = ...
        IncorrectFormatError: QAbstractVideoSurface = ...
        StoppedError: QAbstractVideoSurface = ...
        ResourceError: QAbstractVideoSurface = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#QAbstractVideoSurface

        **QAbstractVideoSurface::QAbstractVideoSurface(QObject * parent =
        nullptr)**

        Constructs a video surface with the given **parent**.
        """
        ...

    def setNativeResolution(self, resolution: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#setNativeResolution

        **[protected] void QAbstractVideoSurface::setNativeResolution(const
        QSize & resolution )**

        Set the video surface native **resolution**.

        This function can be called by implementors of this interface to specify
        to frame producers what the native resolution of this surface is.

        **See also** **nativeResolution** ().
        """
        ...

    def nativeResolution(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#nativeResolution-prop

        **nativeResolution : const QSize**

        The native resolution of video surface. This is the resolution of video
        frames the surface can render with optimal quality and/or performance.

        The native resolution is not always known and can be changed during
        playback.

        **Access functions:**

        QSize **nativeResolution** () const

        **Notifier signal:**

        void ****nativeResolutionChanged** ** (const QSize & **resolution** )

        **Member Function Documentation**
        """
        ...

    def setError(self, error: "QAbstractVideoSurface.Error") -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#setError

        **[protected] void
        QAbstractVideoSurface::setError(QAbstractVideoSurface::Error error )**

        Sets the value of **error** () to **error**.

        This can be called by implementors of this interface to communicate what
        the most recent error was.

        **See also** **error** ().
        """
        ...

    def error(self) -> "QAbstractVideoSurface.Error":
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#error

        **QAbstractVideoSurface::Error QAbstractVideoSurface::error() const**

        Returns the last error that occurred.

        If a surface fails to **start** (), or stops unexpectedly this function
        can be called to discover what error occurred.

        **See also** **setError** ().
        """
        ...

    def present(self, frame: "QVideoFrame") -> bool:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#present

        **[pure virtual] bool QAbstractVideoSurface::present(const QVideoFrame &
        frame )**

        Presents a video **frame**.

        Returns true if the frame was presented, and false if an error occurred.

        Not all surfaces will block until the presentation of a frame has
        completed. Calling present() on a non-blocking surface may fail if
        called before the presentation of a previous frame has completed. In
        such cases the surface may not return to a ready state until it has had
        an opportunity to process events.

        If present() fails for any other reason the surface should immediately
        enter the stopped state and an **error** () value will be set.

        A video surface must be in the started state for present() to succeed,
        and the format of the video frame must be compatible with the current
        video surface format.

        **See also** **error** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#isActive

        **bool QAbstractVideoSurface::isActive() const**

        Indicates whether a video surface has been started.

        Returns true if the surface has been started, and false otherwise.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#stop

        **[virtual] void QAbstractVideoSurface::stop()**

        Stops a video surface presenting frames and releases any resources
        acquired in **start** ().

        **Note:** You must call the base class implementation of stop() at the
        start of your implementation.

        **See also** **isActive** () and **start** ().
        """
        ...

    def start(self, format: "QVideoSurfaceFormat") -> bool:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#start

        **[virtual] bool QAbstractVideoSurface::start(const QVideoSurfaceFormat
        & format )**

        Starts a video surface presenting **format** frames.

        Returns true if the surface was started, and false if an error occurred.

        **Note:** You must call the base class implementation of start() at the
        end of your implementation.

        **See also** **isActive** () and **stop** ().
        """
        ...

    def surfaceFormat(self) -> "QVideoSurfaceFormat":
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#surfaceFormat

        **QVideoSurfaceFormat QAbstractVideoSurface::surfaceFormat() const**

        Returns the format of a video surface.
        """
        ...

    def nearestFormat(self, format: "QVideoSurfaceFormat") -> "QVideoSurfaceFormat":
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#nearestFormat

        **[virtual] QVideoSurfaceFormat
        QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat & format
        ) const**

        Returns a supported video surface format that is similar to **format**.

        A similar surface format is one that has the same **pixel format**  and
        **handle type**  but may differ in some of the other properties. For
        example, if there are restrictions on the **frame sizes**  a video
        surface can accept it may suggest a format with a larger frame size and
        a **viewport**  the size of the original frame size.

        If the format is already supported it will be returned unchanged, or if
        there is no similar supported format an invalid format will be returned.
        """
        ...

    def isFormatSupported(self, format: "QVideoSurfaceFormat") -> bool:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#isFormatSupported

        **[virtual] bool QAbstractVideoSurface::isFormatSupported(const
        QVideoSurfaceFormat & format ) const**

        Tests a video surface **format** to determine if a surface can accept
        it.

        Returns true if the format is supported by the surface, and false
        otherwise.
        """
        ...

    def supportedPixelFormats(
        self, type: QAbstractVideoBuffer.HandleType = ...
    ) -> typing.List["QVideoFrame.PixelFormat"]:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#supportedPixelFormats

        **[pure virtual] QList<QVideoFrame::PixelFormat> QAbstractVideoSurface::
        supportedPixelFormats(QAbstractVideoBuffer::HandleType type =
        QAbstractVideoBuffer::NoHandle) const**

        Returns a list of pixel formats a video surface can present for a given
        handle **type**.

        The pixel formats returned for the **QAbstractVideoBuffer::NoHandle**
        type are valid for any buffer that can be mapped in read-only mode.

        Types that are first in the list can be assumed to be faster to render.
        """
        ...

    @property
    def activeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#activeChanged

        **[signal] void QAbstractVideoSurface::activeChanged(bool active )**

        Signals that the **active** state of a video surface has changed.

        **See also** **isActive** (), **start** (), and **stop** ().
        """
        ...

    @property
    def nativeResolutionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#nativeResolutionChange
        d

        **[signal] void QAbstractVideoSurface::nativeResolutionChanged(const
        QSize & resolution )**

        Signals the native **resolution** of video surface has changed.

        **Note:** Notifier signal for property **nativeResolution** .
        """
        ...

    @property
    def supportedFormatsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#supportedFormatsChange
        d

        **[signal] void QAbstractVideoSurface::supportedFormatsChanged()**

        Signals that the set of formats supported by a video surface has
        changed.

        **See also** **supportedPixelFormats** () and **isFormatSupported** ().
        """
        ...

    @property
    def surfaceFormatChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractvideosurface.html#surfaceFormatChanged

        **[signal] void QAbstractVideoSurface::surfaceFormatChanged(const
        QVideoSurfaceFormat & format )**

        Signals that the configured **format** of a video surface has changed.

        **See also** **surfaceFormat** () and **start** ().
        """
        ...
