"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QAbstractVideoBuffer(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qabstractvideobuffer.html

    **Detailed Description**

    The **QVideoFrame**  class makes use of a QAbstractVideoBuffer internally to
    reference a buffer of video data. Quite often video data buffers may reside
    in video memory rather than system memory, and this class provides an
    abstraction of the location.

    In addition, creating a subclass of QAbstractVideoBuffer will allow you to
    construct video frames from preallocated or static buffers, in cases where
    the **QVideoFrame**  constructors taking a **QByteArray**  or a **QImage**
    do not suffice. This may be necessary when implementing a new hardware
    accelerated video system, for example.

    The contents of a buffer can be accessed by mapping the buffer to memory
    using the **map** () function, which returns a pointer to memory containing
    the contents of the video buffer. The memory returned by **map** () is
    released by calling the **unmap** () function.

    The **handle** () of a buffer may also be used to manipulate its contents
    using type specific APIs. The type of a buffer's handle is given by the
    **handleType** () function.

    **See also** **QVideoFrame** .
    """

    class MapMode(int):
        NotMapped: QAbstractVideoBuffer = ...
        ReadOnly: QAbstractVideoBuffer = ...
        WriteOnly: QAbstractVideoBuffer = ...
        ReadWrite: QAbstractVideoBuffer = ...

    class HandleType(int):
        NoHandle: QAbstractVideoBuffer = ...
        GLTextureHandle: QAbstractVideoBuffer = ...
        XvShmImageHandle: QAbstractVideoBuffer = ...
        CoreImageHandle: QAbstractVideoBuffer = ...
        QPixmapHandle: QAbstractVideoBuffer = ...
        EGLImageHandle: QAbstractVideoBuffer = ...
        UserHandle: QAbstractVideoBuffer = ...

    def __init__(self, type: "QAbstractVideoBuffer.HandleType") -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#QAbstractVideoBuffer

        **QAbstractVideoBuffer::QAbstractVideoBuffer(QAbstractVideoBuffer::Handl
        eType type )**

        Constructs an abstract video buffer of the given **type**.
        """
        ...

    def release(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#release

        **[virtual] void QAbstractVideoBuffer::release()**

        Releases the video buffer.

        **QVideoFrame**  calls QAbstractVideoBuffer::release when the buffer is
        not used any more and can be destroyed or returned to the buffer pool.

        The default implementation deletes the buffer instance.
        """
        ...

    def handle(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#handle

        **[virtual] QVariant QAbstractVideoBuffer::handle() const**

        Returns a type specific handle to the data buffer.

        The type of the handle is given by **handleType** () function.

        **See also** **handleType** ().
        """
        ...

    def unmap(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#unmap

        **[pure virtual] void QAbstractVideoBuffer::unmap()**

        Releases the memory mapped by the **map** () function.

        If the **MapMode**  included the `QAbstractVideoBuffer::WriteOnly` flag
        this will write the current content of the mapped memory back to the
        video frame.

        **See also** **map** ().
        """
        ...

    def map(
        self, mode: "QAbstractVideoBuffer.MapMode"
    ) -> typing.Tuple[PyQt5.sip.voidptr, int, int]:
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#map

        **[pure virtual] uchar
        *QAbstractVideoBuffer::map(QAbstractVideoBuffer::MapMode mode , int *
        numBytes , int * bytesPerLine )**

        Maps the contents of a video buffer to memory.

        In some cases the video buffer might be stored in video memory or
        otherwise inaccessible memory, so it is necessary to map the buffer
        before accessing the pixel data. This may involve copying the contents
        around, so avoid mapping and unmapping unless required.

        The map **mode** indicates whether the contents of the mapped memory
        should be read from and/or written to the buffer. If the map mode
        includes the `QAbstractVideoBuffer::ReadOnly` flag the mapped memory
        will be populated with the content of the buffer when initially mapped.
        If the map mode includes the `QAbstractVideoBuffer::WriteOnly` flag the
        content of the possibly modified mapped memory will be written back to
        the buffer when unmapped.

        When access to the data is no longer needed be sure to call the
        **unmap** () function to release the mapped memory and possibly update
        the buffer contents.

        Returns a pointer to the mapped memory region, or a null pointer if the
        mapping failed. The size in bytes of the mapped memory region is
        returned in **numBytes** , and the line stride in **bytesPerLine**.

        **Note:** Writing to memory that is mapped as read-only is undefined,
        and may result in changes to shared data or crashes.

        **See also** **unmap** () and **mapMode** ().
        """
        ...

    def mapMode(self) -> "QAbstractVideoBuffer.MapMode":
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#mapMode

        **[pure virtual] QAbstractVideoBuffer::MapMode
        QAbstractVideoBuffer::mapMode() const**

        Returns the mode a video buffer is mapped in.

        **See also** **map** ().
        """
        ...

    def handleType(self) -> "QAbstractVideoBuffer.HandleType":
        """
        https://doc.qt.io/qt-5/qabstractvideobuffer.html#handleType

        **QAbstractVideoBuffer::HandleType QAbstractVideoBuffer::handleType()
        const**

        Returns the type of a video buffer's handle.

        **See also** **handle** ().
        """
        ...
