"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QPlaceRatings(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplaceratings.html

    **Detailed Description**

    Rating information is used to describe how good a place is conceived to be.
    Typically this information is visualized as a number of stars. The
    **average** () function returns an aggregated ratings value out of a
    possible maximum as given by the **maximum** () function.

    **qDebug** () << **QString** ("This place rated ") +
    place.ratings().average()
                    + "out of " +
    place.ratings().maximum() + "stars";
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#QPlaceRatings

        **QPlaceRatings::QPlaceRatings()**

        Constructs a new ratings object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceRatings") -> None:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#QPlaceRatings-1

        **QPlaceRatings::QPlaceRatings(const QPlaceRatings & other )**

        Constructs a copy of **other**.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#isEmpty

        **bool QPlaceRatings::isEmpty() const**

        Returns true if all fields of the place ratings are 0; otherwise returns
        false.
        """
        ...

    def setMaximum(self, max: float) -> None:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#setMaximum

        **void QPlaceRatings::setMaximum(qreal max )**

        Sets the maximum possible rating value to **max**.

        **See also** **maximum** ().
        """
        ...

    def maximum(self) -> float:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#maximum

        **qreal QPlaceRatings::maximum() const**

        Returns the maximum possible rating value.

        **See also** **setMaximum** ().
        """
        ...

    def setCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#setCount

        **void QPlaceRatings::setCount(int count )**

        Sets the total number of individual ratings to **count**.

        **See also** **count** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#count

        **int QPlaceRatings::count() const**

        Returns the total number of individual ratings.

        **See also** **setCount** ().
        """
        ...

    def setAverage(self, average: float) -> None:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#setAverage

        **void QPlaceRatings::setAverage(qreal average )**

        Sets the **average** value of the ratings.

        **See also** **average** ().
        """
        ...

    def average(self) -> float:
        """
        https://doc.qt.io/qt-5/qplaceratings.html#average

        **qreal QPlaceRatings::average() const**

        Returns the average value of individual ratings.

        **See also** **setAverage** ().
        """
        ...
