"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceMatchRequest(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacematchrequest.html

    **Detailed Description**

    Places from another manager that may have corresponding/matching places in
    the current manager are assigned using **setPlaces** () or **setResults**
    (). A set of further parameters are specified which determines the criteria
    for matching.

    The typical key for matching is the **QPlaceMatchRequest::AlternativeId** ,
    the value is an alternative identifier attribute type of the format
    x_id_<provider name> for example x_id_here. The provider name is name
    supplied to the **QGeoServiceProvider**  instance.

    See **Matching places between managers**  for an example on how to use a
    match request.

    **See also** **QPlaceMatchReply**  and **QPlaceManager** .
    """

    AlternativeId: str = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#QPlaceMatchRequest

        **QPlaceMatchRequest::QPlaceMatchRequest()**

        Default constructor. Constructs a new request object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceMatchRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#QPlaceMatchRequest-1

        **QPlaceMatchRequest::QPlaceMatchRequest(const QPlaceMatchRequest &
        other )**

        Constructs a copy of **other**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#clear

        **void QPlaceMatchRequest::clear()**

        Clears the match request.
        """
        ...

    def setParameters(self, parameters: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#setParameters

        **void QPlaceMatchRequest::setParameters(const QVariantMap & parameters
        )**

        Sets the **parameters** for matching places.

        **See also** **parameters** ().
        """
        ...

    def parameters(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#parameters

        **QVariantMap QPlaceMatchRequest::parameters() const**

        Returns the parameters for matching places.

        **See also** **setParameters** ().
        """
        ...

    def setResults(self, results: typing.Iterable["QPlaceSearchResult"]) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#setResults

        **void QPlaceMatchRequest::setResults(const QList<QPlaceSearchResult> &
        results )**

        Convenience function which uses a set of search **results** to set the
        places which should be matched.

        **See also** **setPlaces** ().
        """
        ...

    def setPlaces(self, places: typing.Iterable[QPlace]) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#setPlaces

        **void QPlaceMatchRequest::setPlaces(const QList<QPlace> places )**

        Sets a list of **places** which are to be matched.

        **See also** **places** () and **setResults** ().
        """
        ...

    def places(self) -> typing.List[QPlace]:
        """
        https://doc.qt.io/qt-5/qplacematchrequest.html#places

        **QList<QPlace> QPlaceMatchRequest::places() const**

        Returns a list of places which are to be matched.

        **See also** **setPlaces** ().
        """
        ...
