"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceIdReply(QPlaceReply):
    """
    https://doc.qt.io/qt-5/qplaceidreply.html

    **Detailed Description**

    The QPlaceIdReply can be considered a multipurpose reply in that it can be
    used to save places, save categories, remove places and remove categories.
    In each case it returns an identifier of the place or category that was
    added, modified or removed.

    See **Saving a place**  for an example of how to use an identifier reply.

    **See also** **QPlaceManager** .
    """

    class OperationType(int):
        SavePlace: QPlaceIdReply = ...
        SaveCategory: QPlaceIdReply = ...
        RemovePlace: QPlaceIdReply = ...
        RemoveCategory: QPlaceIdReply = ...

    def __init__(
        self,
        operationType: "QPlaceIdReply.OperationType",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplaceidreply.html#QPlaceIdReply

        **QPlaceIdReply::QPlaceIdReply(QPlaceIdReply::OperationType
        operationType , QObject * parent = nullptr)**

        Constructs a reply which contains the identifier of the object operated
        upon. The reply is for the given **operationType** and with **parent**.
        """
        ...

    def setId(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qplaceidreply.html#setId

        **[protected] void QPlaceIdReply::setId(const QString & identifier )**

        Sets the **identifier** of the reply.

        **See also** **id** ().
        """
        ...

    def id(self) -> str:
        """
        https://doc.qt.io/qt-5/qplaceidreply.html#id

        **QString QPlaceIdReply::id() const**

        Returns the relevant identifier for the operation. For example for a
        save place operation, the identifier is that of the saved place. For a
        category removal operation, it is the identifier of the category that
        was removed.

        **See also** **setId** ().
        """
        ...

    def operationType(self) -> "QPlaceIdReply.OperationType":
        """
        https://doc.qt.io/qt-5/qplaceidreply.html#operationType

        **QPlaceIdReply::OperationType QPlaceIdReply::operationType() const**

        Returns the operation type of the reply. This means whether this
        identifier reply was for a save place operation, remove category
        operation and so on.
        """
        ...

    def type(self) -> QPlaceReply.Type:
        """
        https://doc.qt.io/qt-5/qplaceidreply.html#type

        **[override virtual] QPlaceReply::Type QPlaceIdReply::type() const**

        Reimplements: **QPlaceReply::type** () const.

        Returns the type of reply.
        """
        ...
