"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtLocation import *


class QPlaceEditorial(QPlaceContent):
    """
    https://doc.qt.io/qt-5/qplaceeditorial.html

    **Detailed Description**

    Each QPlaceEditorial has a title, text and language; in addition to those
    properties inherited from **QPlaceContent** .

    Note: The Places API only supports editorials as 'retrieve-only' objects.
    Submitting editorials to a provider is not a supported use case.

    **See also** **QPlaceContent** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#QPlaceEditorial

        **QPlaceEditorial::QPlaceEditorial()**

        Constructs a new editorial object.
        """
        ...

    @typing.overload
    def __init__(self, other: QPlaceContent) -> None:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#QPlaceEditorial-1

        **QPlaceEditorial::QPlaceEditorial(const QPlaceContent & other )**

        Constructs a copy of **other** if possible, otherwise constructs a
        default editorial object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPlaceEditorial") -> None:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#QPlaceEditorial

        **QPlaceEditorial::QPlaceEditorial()**

        Constructs a new editorial object.
        """
        ...

    def setLanguage(self, data: str) -> None:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#setLanguage

        **void QPlaceEditorial::setLanguage(const QString & language )**

        Sets the **language** of the editorial. Typically this would be a
        language code in the 2 letter ISO 639-1 format.

        **See also** **language** ().
        """
        ...

    def language(self) -> str:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#language

        **QString QPlaceEditorial::language() const**

        Returns the language of the editorial. Typically this would be a
        language code in the 2 letter ISO 639-1 format.

        **See also** **setLanguage** ().
        """
        ...

    def setTitle(self, data: str) -> None:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#setTitle

        **void QPlaceEditorial::setTitle(const QString & title )**

        Sets the **title** of the editorial.

        **See also** **title** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#title

        **QString QPlaceEditorial::title() const**

        Returns the title of the editorial.

        **See also** **setTitle** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#setText

        **void QPlaceEditorial::setText(const QString & text )**

        Sets the **text** of the editorial.

        **See also** **text** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qplaceeditorial.html#text

        **QString QPlaceEditorial::text() const**

        Returns a textual description of the place.

        Depending upon the provider, the editorial text could be either
        rich(HTML based) text or plain text.

        **See also** **setText** ().
        """
        ...
