"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceContentReply(QPlaceReply):
    """
    https://doc.qt.io/qt-5/qplacecontentreply.html

    **Detailed Description**

    See **Fetching Rich Content**  for an example on how to use a content reply.

    **See also** **QPlaceContentRequest**  and **QPlaceManager** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#QPlaceContentReply

        **QPlaceContentReply::QPlaceContentReply(QObject * parent = nullptr)**

        Constructs a content reply with a given **parent**.
        """
        ...

    def setNextPageRequest(self, next: "QPlaceContentRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#setNextPageRequest

        **[protected] void QPlaceContentReply::setNextPageRequest(const
        QPlaceContentRequest & next )**

        Sets the place content request that can be used to request the next
        batch of place content results to **next**.

        **See also** **nextPageRequest** ().
        """
        ...

    def setPreviousPageRequest(self, previous: "QPlaceContentRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#setPreviousPageRequest

        **[protected] void QPlaceContentReply::setPreviousPageRequest(const
        QPlaceContentRequest & previous )**

        Sets the place content request that can be used to request the previous
        batch of place content results to **previous**.

        **See also** **previousPageRequest** ().
        """
        ...

    def setRequest(self, request: "QPlaceContentRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#setRequest

        **[protected] void QPlaceContentReply::setRequest(const
        QPlaceContentRequest & request )**

        Sets the content **request** used to generate this this reply.

        **See also** **request** ().
        """
        ...

    def setTotalCount(self, total: int) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#setTotalCount

        **[protected] void QPlaceContentReply::setTotalCount(int total )**

        Sets the **total** number of content objects for a place.

        **See also** **totalCount** ().
        """
        ...

    def setContent(self, content: typing.Dict[int, QPlaceContent]) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#setContent

        **[protected] void QPlaceContentReply::setContent(const
        QPlaceContent::Collection & content )**

        Sets the **content** of the reply.

        **See also** **content** ().
        """
        ...

    def nextPageRequest(self) -> "QPlaceContentRequest":
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#nextPageRequest

        **QPlaceContentRequest QPlaceContentReply::nextPageRequest() const**

        Returns a place content request that can be used to request the next
        batch of place content results.

        **See also** **setNextPageRequest** ().
        """
        ...

    def previousPageRequest(self) -> "QPlaceContentRequest":
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#previousPageRequest

        **QPlaceContentRequest QPlaceContentReply::previousPageRequest() const**

        Returns a place content request that can be used to request the previous
        batch of place content results.

        **See also** **setPreviousPageRequest** ().
        """
        ...

    def request(self) -> "QPlaceContentRequest":
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#request

        **QPlaceContentRequest QPlaceContentReply::request() const**

        Returns the content request that was used to generate this reply.

        **See also** **setRequest** ().
        """
        ...

    def totalCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#totalCount

        **int QPlaceContentReply::totalCount() const**

        Returns the total number of content objects for a place. If the total
        number of content objects cannot be counted, a value of -1 is returned.
        This count only refers to the total count for a single content type,
        that is, the content type that was specified when content was requested
        with the **QPlaceManager** .

        **See also** **setTotalCount** ().
        """
        ...

    def content(self) -> typing.Dict[int, QPlaceContent]:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#content

        **QPlaceContent::Collection QPlaceContentReply::content() const**

        Returns the collection of content retrieved.

        **See also** **setContent** ().
        """
        ...

    def type(self) -> QPlaceReply.Type:
        """
        https://doc.qt.io/qt-5/qplacecontentreply.html#type

        **[override virtual] QPlaceReply::Type QPlaceContentReply::type()
        const**

        Reimplements: **QPlaceReply::type** () const.

        Returns the type of reply.
        """
        ...
