"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceCategory(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacecategory.html

    **Detailed Description**

    Categories are used to search for places based on the categories they are
    associated with. The list/tree of available categories can be obtained from
    **QPlaceManager** . The **QPlaceSearchRequest::setCategories** () function
    can be used to limit the search results to places with the specified
    categories.

    If the **QGeoServiceProvider**  supports it, categories can be created and
    removed. This functionality is available in the **QPlaceManager**  class.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#QPlaceCategory

        **QPlaceCategory::QPlaceCategory()**

        Constructs a category.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceCategory") -> None:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#QPlaceCategory-1

        **QPlaceCategory::QPlaceCategory(const QPlaceCategory & other )**

        Constructs a category which is a copy of **other**.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#isEmpty

        **bool QPlaceCategory::isEmpty() const**

        Returns a boolean indicating whether the all the fields of the place
        category are empty or not.
        """
        ...

    def setIcon(self, icon: "QPlaceIcon") -> None:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#setIcon

        **void QPlaceCategory::setIcon(const QPlaceIcon & icon )**

        Sets the **icon** of the category.

        **See also** **icon** ().
        """
        ...

    def icon(self) -> "QPlaceIcon":
        """
        https://doc.qt.io/qt-5/qplacecategory.html#icon

        **QPlaceIcon QPlaceCategory::icon() const**

        Returns the icon associated with the category.

        **See also** **setIcon** ().
        """
        ...

    def setVisibility(self, visibility: QLocation.Visibility) -> None:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#setVisibility

        **void QPlaceCategory::setVisibility(QLocation::Visibility visibility
        )**

        Sets the **visibility** of the category.

        **See also** **visibility** ().
        """
        ...

    def visibility(self) -> QLocation.Visibility:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#visibility

        **QLocation::Visibility QPlaceCategory::visibility() const**

        Returns the visibility of the category.

        **See also** **setVisibility** ().
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#setName

        **void QPlaceCategory::setName(const QString & name )**

        Sets the **name** of the category.

        **See also** **name** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#name

        **QString QPlaceCategory::name() const**

        Returns the name of category.

        **See also** **setName** ().
        """
        ...

    def setCategoryId(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#setCategoryId

        **void QPlaceCategory::setCategoryId(const QString & identifier )**

        Sets the **identifier** of the category.

        **See also** **categoryId** ().
        """
        ...

    def categoryId(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacecategory.html#categoryId

        **QString QPlaceCategory::categoryId() const**

        Returns the identifier of the category. The category identifier is a
        string which uniquely identifies this category within a particular
        **QPlaceManager** . The identifier is only meaningful to the
        **QPlaceManager**  that generated it and is not transferable between
        managers.

        **See also** **setCategoryId** ().
        """
        ...
