"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtPositioning
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QGeoRoutingManagerEngine(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html

    **Detailed Description**

    Subclasses of QGeoRoutingManagerEngine need to provide an implementation of
    **calculateRoute** ().

    In the default implementation, supportsRouteUpdates() returns false and
    **updateRoute** () returns a **QGeoRouteReply**  object containing a
    **QGeoRouteReply::UnsupportedOptionError** .

    If the routing service supports updating routes as they are being traveled,
    the subclass should provide an implementation of **updateRoute** () and call
    setSupportsRouteUpdates(true) at some point in time before **updateRoute**
    () is called.

    The function setSupportsRouteUpdates() is one of several functions which
    configure the reported capabilities of the engine. If the capabilities of an
    engine differ from the default values these functions should be used so that
    the reported capabilities are accurate.

    It is important that this is done before **calculateRoute** (),
    **updateRoute** () or any of the capability reporting functions are used to
    prevent incorrect or inconsistent behavior.

    A subclass of QGeoRouteManagerEngine will often make use of a subclass fo
    **QGeoRouteReply**  internally, in order to add any engine-specific data
    (such as a **QNetworkReply**  object for network-based services) to the
    **QGeoRouteReply**  instances used by the engine.

    **See also** **QGeoRoutingManager** .
    """

    def __init__(
        self,
        parameters: typing.Dict[str, typing.Any],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#QGeoRoutingManagerE
        ngine

        **QGeoRoutingManagerEngine::QGeoRoutingManagerEngine(const QVariantMap &
        parameters , QObject * parent = nullptr)**

        Constructs a new engine with the specified **parent** , using
        **parameters** to pass any implementation specific data to the engine.
        """
        ...

    def setSupportedManeuverDetails(
        self,
        maneuverDetails: typing.Union[
            QGeoRouteRequest.ManeuverDetails, QGeoRouteRequest.ManeuverDetail
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setSupportedManeuve
        rDetails

        **[protected] void QGeoRoutingManagerEngine::setSupportedManeuverDetails
        (QGeoRouteRequest::ManeuverDetails maneuverDetails )**

        Sets the levels of detail for navigation maneuvers which can be
        requested by this engine to **maneuverDetails**.

        It is important that subclasses use this method to ensure that the
        engine reports its capabilities correctly. If this function is not used
        the engine will report that it supports no maneuver details at all.

        **See also** **supportedManeuverDetails** ().
        """
        ...

    def setSupportedSegmentDetails(
        self,
        segmentDetails: typing.Union[
            QGeoRouteRequest.SegmentDetails, QGeoRouteRequest.SegmentDetail
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setSupportedSegment
        Details

        **[protected] void QGeoRoutingManagerEngine::setSupportedSegmentDetails(
        QGeoRouteRequest::SegmentDetails segmentDetails )**

        Sets the levels of detail for routing segments which can be requested by
        this engine to **segmentDetails**.

        It is important that subclasses use this method to ensure that the
        engine reports its capabilities correctly. If this function is not used
        the engine will report that it supports no segment detail at all.

        **See also** **supportedSegmentDetails** ().
        """
        ...

    def setSupportedRouteOptimizations(
        self,
        optimizations: typing.Union[
            QGeoRouteRequest.RouteOptimizations, QGeoRouteRequest.RouteOptimization
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setSupportedRouteOp
        timizations

        **[protected] void QGeoRoutingManagerEngine::setSupportedRouteOptimizati
        ons(QGeoRouteRequest::RouteOptimizations optimizations )**

        Sets the route optimizations supported by this engine to
        **optimizations**.

        It is important that subclasses use this method to ensure that the
        engine reports its capabilities correctly. If this function is not used
        the engine will report that it supports no route optimizations at all.

        **See also** **supportedRouteOptimizations** ().
        """
        ...

    def setSupportedFeatureWeights(
        self,
        featureWeights: typing.Union[
            QGeoRouteRequest.FeatureWeights, QGeoRouteRequest.FeatureWeight
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setSupportedFeature
        Weights

        **[protected] void QGeoRoutingManagerEngine::setSupportedFeatureWeights(
        QGeoRouteRequest::FeatureWeights featureWeights )**

        Sets the weightings which this engine can apply to different features
        during route planning to **featureWeights**.

        It is important that subclasses use this method to ensure that the
        engine reports its capabilities correctly. If this function is not used
        the engine will report that it supports no feature weights at all.

        **See also** **supportedFeatureWeights** ().
        """
        ...

    def setSupportedFeatureTypes(
        self,
        featureTypes: typing.Union[
            QGeoRouteRequest.FeatureTypes, QGeoRouteRequest.FeatureType
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setSupportedFeature
        Types

        **[protected] void QGeoRoutingManagerEngine::setSupportedFeatureTypes(QG
        eoRouteRequest::FeatureTypes featureTypes )**

        Sets the types of features that this engine can take into account during
        route planning to **featureTypes**.

        It is important that subclasses use this method to ensure that the
        engine reports its capabilities correctly. If this function is not used
        the engine will report that it supports no feature types at all.

        **See also** **supportedFeatureTypes** ().
        """
        ...

    def setSupportedTravelModes(
        self,
        travelModes: typing.Union[
            QGeoRouteRequest.TravelModes, QGeoRouteRequest.TravelMode
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setSupportedTravelM
        odes

        **[protected] void QGeoRoutingManagerEngine::setSupportedTravelModes(QGe
        oRouteRequest::TravelModes travelModes )**

        Sets the travel modes supported by this engine to **travelModes**.

        It is important that subclasses use this method to ensure that the
        engine reports its capabilities correctly. If this function is not used
        the engine will report that it supports no travel modes at all.

        **See also** **supportedTravelModes** ().
        """
        ...

    def measurementSystem(self) -> QtCore.QLocale.MeasurementSystem:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#measurementSystem

        **QLocale::MeasurementSystem
        QGeoRoutingManagerEngine::measurementSystem() const**

        Returns the measurement system used by this manager.

        If **setMeasurementSystem** () has been called then the value returned
        by this function may be different to that returned by **locale**
        ().**measurementSystem()** . In which case the value returned by this
        function is what will be used by the manager.

        **See also** **setMeasurementSystem** () and **setLocale** ().
        """
        ...

    def setMeasurementSystem(self, system: QtCore.QLocale.MeasurementSystem) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setMeasurementSyste
        m

        **void QGeoRoutingManagerEngine::setMeasurementSystem(QLocale::Measureme
        ntSystem system )**

        Sets the measurement system used by this manager to **system**.

        The measurement system can be set independently of the locale. Both
        **setLocale** () and this function set the measurement system. The value
        set by the last function called will be used.

        **See also** **measurementSystem** (), **locale** (), and **setLocale**
        ().
        """
        ...

    def locale(self) -> QtCore.QLocale:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#locale

        **QLocale QGeoRoutingManagerEngine::locale() const**

        Returns the locale used to hint to this routing manager about what
        language to use for addresses and instructions.

        **See also** **setLocale** ().
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#setLocale

        **void QGeoRoutingManagerEngine::setLocale(const QLocale & locale )**

        Sets the locale to be used by this manager to **locale**.

        If this routing manager supports returning addresses and instructions in
        different languages, they will be returned in the language of
        **locale**.

        The locale used defaults to the system locale if this is not set.

        **See also** **locale** ().
        """
        ...

    def supportedManeuverDetails(self) -> QGeoRouteRequest.ManeuverDetails:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#supportedManeuverDe
        tails

        **QGeoRouteRequest::ManeuverDetails
        QGeoRoutingManagerEngine::supportedManeuverDetails() const**

        Returns the levels of detail for navigation maneuvers which can be
        requested by this engine.

        **See also** **setSupportedManeuverDetails** ().
        """
        ...

    def supportedSegmentDetails(self) -> QGeoRouteRequest.SegmentDetails:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#supportedSegmentDet
        ails

        **QGeoRouteRequest::SegmentDetails
        QGeoRoutingManagerEngine::supportedSegmentDetails() const**

        Returns the levels of detail for routing segments which can be requested
        by this engine.

        **See also** **setSupportedSegmentDetails** ().
        """
        ...

    def supportedRouteOptimizations(self) -> QGeoRouteRequest.RouteOptimizations:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#supportedRouteOptim
        izations

        **QGeoRouteRequest::RouteOptimizations
        QGeoRoutingManagerEngine::supportedRouteOptimizations() const**

        Returns the route optimizations supported by this engine.

        **See also** **setSupportedRouteOptimizations** ().
        """
        ...

    def supportedFeatureWeights(self) -> QGeoRouteRequest.FeatureWeights:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#supportedFeatureWei
        ghts

        **QGeoRouteRequest::FeatureWeights
        QGeoRoutingManagerEngine::supportedFeatureWeights() const**

        Returns the weightings which this engine can apply to different features
        during route planning.

        **See also** **setSupportedFeatureWeights** ().
        """
        ...

    def supportedFeatureTypes(self) -> QGeoRouteRequest.FeatureTypes:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#supportedFeatureTyp
        es

        **QGeoRouteRequest::FeatureTypes
        QGeoRoutingManagerEngine::supportedFeatureTypes() const**

        Returns the types of features that this engine can take into account
        during route planning.

        **See also** **setSupportedFeatureTypes** ().
        """
        ...

    def supportedTravelModes(self) -> QGeoRouteRequest.TravelModes:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#supportedTravelMode
        s

        **QGeoRouteRequest::TravelModes
        QGeoRoutingManagerEngine::supportedTravelModes() const**

        Returns the travel modes supported by this engine.

        **See also** **setSupportedTravelModes** ().
        """
        ...

    def updateRoute(
        self, route: QGeoRoute, position: QtPositioning.QGeoCoordinate
    ) -> QGeoRouteReply:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#updateRoute

        **[virtual] QGeoRouteReply *QGeoRoutingManagerEngine::updateRoute(const
        QGeoRoute & route , const QGeoCoordinate & position )**

        Begins the process of updating **route** based on the current position
        **position**.

        A **QGeoRouteReply**  object will be returned, which can be used to
        manage the routing operation and to return the results of the operation.

        This engine and the returned **QGeoRouteReply**  object will emit
        signals indicating if the operation completes or if errors occur.

        If supportsRouteUpdates() returns false an
        **QGeoRouteReply::UnsupportedOptionError**  will occur.

        Once the operation has completed, **QGeoRouteReply::routes**  can be
        used to retrieve the updated route.

        The returned route could be entirely different to the original route,
        especially if **position** is far enough away from the initial route.
        Otherwise the route will be similar, although the remaining time and
        distance will be updated and any segments of the original route which
        have been traversed will be removed.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoRoutingManagerEngine::finished** (),
        **QGeoRoutingManagerEngine::error** (), **QGeoRouteReply::finished** ()
        or **QGeoRouteReply::error** () with **deleteLater** ().
        """
        ...

    def calculateRoute(self, request: QGeoRouteRequest) -> QGeoRouteReply:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#calculateRoute

        **[pure virtual] QGeoRouteReply
        *QGeoRoutingManagerEngine::calculateRoute(const QGeoRouteRequest &
        request )**

        Begins the calculation of the route specified by **request**.

        A **QGeoRouteReply**  object will be returned, which can be used to
        manage the routing operation and to return the results of the operation.

        This engine and the returned **QGeoRouteReply**  object will emit
        signals indicating if the operation completes or if errors occur.

        Once the operation has completed, **QGeoRouteReply::routes**  can be
        used to retrieve the calculated route or routes.

        If **request** includes features which are not supported by this engine,
        as reported by the methods in this engine, then a
        **QGeoRouteReply::UnsupportedOptionError**  will occur.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoRoutingManagerEngine::finished** (),
        **QGeoRoutingManagerEngine::error** (), **QGeoRouteReply::finished** ()
        or **QGeoRouteReply::error** () with **deleteLater** ().
        """
        ...

    def managerVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#managerVersion

        **int QGeoRoutingManagerEngine::managerVersion() const**

        Returns the version of this engine implementation.

        The combination of **managerName** () and managerVersion() should be
        unique amongst plugin implementations.
        """
        ...

    def managerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#managerName

        **QString QGeoRoutingManagerEngine::managerName() const**

        Returns the name which this engine implementation uses to distinguish
        itself from the implementations provided by other plugins.

        The combination of managerName() and **managerVersion** () should be
        unique amongst plugin implementations.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#error

        **[signal] void QGeoRoutingManagerEngine::error(QGeoRouteReply * reply ,
        QGeoRouteReply::Error error , QString errorString = QString())**

        This signal is emitted when an error has been detected in the processing
        of **reply**. The **QGeoRoutingManagerEngine::finished** () signal will
        probably follow.

        The error will be described by the error code **error**. If
        **errorString** is not empty it will contain a textual description of
        the error.

        This signal and **QGeoRouteReply::error** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanagerengine.html#finished

        **[signal] void QGeoRoutingManagerEngine::finished(QGeoRouteReply *
        reply )**

        This signal is emitted when **reply** has finished processing.

        If reply::error() equals **QGeoRouteReply::NoError**  then the
        processing finished successfully.

        This signal and **QGeoRouteReply::finished** () will be emitted at the
        same time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...
