"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QGeoRouteReply(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgeoroutereply.html

    **Detailed Description**

    Instances of QGeoRouteReply manage the state and results of these
    operations.

    The **isFinished** (), **error** () and **errorString** () methods provide
    information on whether the operation has completed and if it completed
    successfully.

    The **finished** () and error(**QGeoRouteReply::Error** ,**QString** )
    signals can be used to monitor the progress of the operation.

    It is possible that a newly created QGeoRouteReply may be in a finished
    state, most commonly because an error has occurred. Since such an instance
    will never emit the **finished** () or error(**QGeoRouteReply::Error**
    ,**QString** ) signals, it is important to check the result of
    **isFinished** () before making the connections to the signals. The
    documentation for **QGeoRoutingManager**  demonstrates how this might be
    carried out.

    If the operation completes successfully the results will be able to be
    accessed with **routes** ().
    """

    class Error(int):
        NoError: QGeoRouteReply = ...
        EngineNotSetError: QGeoRouteReply = ...
        CommunicationError: QGeoRouteReply = ...
        ParseError: QGeoRouteReply = ...
        UnsupportedOptionError: QGeoRouteReply = ...
        UnknownError: QGeoRouteReply = ...

    @typing.overload
    def __init__(
        self,
        error: "QGeoRouteReply.Error",
        errorString: str,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#QGeoRouteReply

        **QGeoRouteReply::QGeoRouteReply(QGeoRouteReply::Error error , const
        QString & errorString , QObject * parent = nullptr)**

        Constructs a route reply with a given **error** and **errorString** and
        the specified **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, request: "QGeoRouteRequest", parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#QGeoRouteReply-1

        **[protected] QGeoRouteReply::QGeoRouteReply(const QGeoRouteRequest &
        request , QObject * parent = nullptr)**

        Constructs a route reply object based on **request** , with the
        specified **parent**.
        """
        ...

    def addRoutes(self, routes: typing.Iterable[QGeoRoute]) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#addRoutes

        **[protected] void QGeoRouteReply::addRoutes(const QList<QGeoRoute> &
        routes )**

        Appends the list of **routes** to the existing list.
        """
        ...

    def setRoutes(self, routes: typing.Iterable[QGeoRoute]) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#setRoutes

        **[protected] void QGeoRouteReply::setRoutes(const QList<QGeoRoute> &
        routes )**

        Sets the list of routes in the reply to **routes**.

        **See also** **routes** ().
        """
        ...

    def setFinished(self, finished: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#setFinished

        **[protected] void QGeoRouteReply::setFinished(bool finished )**

        Sets whether or not this reply has finished to **finished**.

        If **finished** is true, this will cause the **finished** () signal to
        be emitted.

        If the operation completed successfully, **QGeoRouteReply::setRoutes**
        () should be called before this function. If an error occurred,
        **QGeoRouteReply::setError** () should be used instead.

        **See also** **finished** ().
        """
        ...

    def setError(self, error: "QGeoRouteReply.Error", errorString: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#setError

        **[protected] void QGeoRouteReply::setError(QGeoRouteReply::Error error
        , const QString & errorString )**

        Sets the error state of this reply to **error** and the textual
        representation of the error to **errorString**.

        This will also cause **error** () and **finished** () signals to be
        emitted, in that order.

        **See also** **error** ().
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#abort

        **[virtual] void QGeoRouteReply::abort()**

        Cancels the operation immediately.

        This will do nothing if the reply is finished.
        """
        ...

    def routes(self) -> typing.List[QGeoRoute]:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#routes

        **QList<QGeoRoute> QGeoRouteReply::routes() const**

        Returns the list of routes which were requested.

        **See also** **setRoutes** ().
        """
        ...

    def request(self) -> "QGeoRouteRequest":
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#request

        **QGeoRouteRequest QGeoRouteReply::request() const**

        Returns the route request which specified the route.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#errorString

        **QString QGeoRouteReply::errorString() const**

        Returns the textual representation of the error state of this reply.

        If no error has occurred this will return an empty string. It is
        possible that an error occurred which has no associated textual
        representation, in which case this will also return an empty string.

        To determine whether an error has occurred, check to see if
        **QGeoRouteReply::error** () is equal to **QGeoRouteReply::NoError** .
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#isFinished

        **bool QGeoRouteReply::isFinished() const**

        Return true if the operation completed successfully or encountered an
        error which cause the operation to come to a halt.
        """
        ...

    @property
    def aborted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#aborted

        **[signal] void QGeoRouteReply::aborted()**

        This signal is emitted when the operation has been cancelled.

        This function was introduced in Qt 5.9.

        **See also** **abort** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#error

        **QGeoRouteReply::Error QGeoRouteReply::error() const**

        Returns the error state of this reply.

        If the result is **QGeoRouteReply::NoError**  then no error has
        occurred.

        **See also** **setError** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutereply.html#finished

        **[signal] void QGeoRouteReply::finished()**

        This signal is emitted when this reply has finished processing.

        If **error** () equals **QGeoRouteReply::NoError**  then the processing
        finished successfully.

        This signal and **QGeoRoutingManager::finished** () will be emitted at
        the same time.

        **Note:** Do not delete this reply object in the slot connected to this
        signal. Use **deleteLater** () instead.

        **See also** **setFinished** ().
        """
        ...
