"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextOption(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtextoption.html

    **Detailed Description**

    QTextOption is used to encapsulate common rich text properties in a single
    object. It contains information about text alignment, layout direction, word
    wrapping, and other standard properties associated with text rendering and
    layout.

    **See also** **QTextEdit** , **QTextDocument** , and **QTextCursor** .
    """

    class TabType(int):
        LeftTab: QTextOption = ...
        RightTab: QTextOption = ...
        CenterTab: QTextOption = ...
        DelimiterTab: QTextOption = ...

    class Flag(int):
        IncludeTrailingSpaces: QTextOption = ...
        ShowTabsAndSpaces: QTextOption = ...
        ShowLineAndParagraphSeparators: QTextOption = ...
        AddSpaceForLineAndParagraphSeparators: QTextOption = ...
        SuppressColors: QTextOption = ...
        ShowDocumentTerminator: QTextOption = ...

    class WrapMode(int):
        NoWrap: QTextOption = ...
        WordWrap: QTextOption = ...
        ManualWrap: QTextOption = ...
        WrapAnywhere: QTextOption = ...
        WrapAtWordBoundaryOrAnywhere: QTextOption = ...

    class Flags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QTextOption.Flags", "QTextOption.Flag"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextOption.Flags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QTextOption.Flags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class Tab(sip.simplewrapper):
        delimiter: str = ...
        position: float = ...
        type = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, pos: float, tabType: "QTextOption.TabType", delim: str = ...
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextOption.Tab") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#QTextOption

        **QTextOption::QTextOption()**

        Constructs a text option with default properties for text. The text
        alignment property is set to **Qt::AlignLeft** . The word wrap property
        is set to **QTextOption::WordWrap** . The using of design metrics flag
        is set to false.
        """
        ...

    @typing.overload
    def __init__(
        self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#QTextOption-1

        **QTextOption::QTextOption(Qt::Alignment alignment )**

        Constructs a text option with the given **alignment** for text. The word
        wrap property is set to **QTextOption::WordWrap** . The using of design
        metrics flag is set to false.
        """
        ...

    @typing.overload
    def __init__(self, o: "QTextOption") -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#QTextOption-2

        **QTextOption::QTextOption(const QTextOption & other )**

        Construct a copy of the **other** text option.
        """
        ...

    def tabStopDistance(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextoption.html#tabStopDistance

        **qreal QTextOption::tabStopDistance() const**

        Returns the distance in device units between tab stops.

        This function was introduced in Qt 5.10.

        **See also** **setTabStopDistance** (), **tabArray** (), **setTabs** (),
        and **tabs** ().
        """
        ...

    def setTabStopDistance(self, tabStopDistance: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setTabStopDistance

        **void QTextOption::setTabStopDistance(qreal tabStopDistance )**

        Sets the default distance in device units between tab stops to the value
        specified by **tabStopDistance**.

        This function was introduced in Qt 5.10.

        **See also** **tabStopDistance** (), **setTabArray** (), **setTabs** (),
        and **tabs** ().
        """
        ...

    def tabs(self) -> typing.List["QTextOption.Tab"]:
        """
        https://doc.qt.io/qt-5/qtextoption.html#tabs

        **QList<QTextOption::Tab> QTextOption::tabs() const**

        Returns a list of tab positions defined for the text layout.

        This function was introduced in Qt 4.4.

        **See also** **tabStopDistance** (), **setTabs** (), and **setTabStop**
        ().
        """
        ...

    def setTabs(self, tabStops: typing.Iterable["QTextOption.Tab"]) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setTabs

        **void QTextOption::setTabs(const QList<QTextOption::Tab> & tabStops )**

        Sets the tab positions for the text layout to those specified by
        **tabStops**.

        This function was introduced in Qt 4.4.

        **See also** **tabs** () and **tabStop** ().
        """
        ...

    def setTabStop(self, atabStop: float) -> None:
        ...

    def setFlags(
        self, flags: typing.Union["QTextOption.Flags", "QTextOption.Flag"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setFlags

        **void QTextOption::setFlags(QTextOption::Flags flags )**

        Sets the flags associated with the option to the given **flags**.

        **See also** **flags** ().
        """
        ...

    def setAlignment(
        self, aalignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setAlignment

        **void QTextOption::setAlignment(Qt::Alignment alignment )**

        Sets the option's text alignment to the specified **alignment**.

        **See also** **alignment** ().
        """
        ...

    def useDesignMetrics(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextoption.html#useDesignMetrics

        **bool QTextOption::useDesignMetrics() const**

        Returns `true` if the layout uses design rather than device metrics;
        otherwise returns `false`.

        **See also** **setUseDesignMetrics** ().
        """
        ...

    def setUseDesignMetrics(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setUseDesignMetrics

        **void QTextOption::setUseDesignMetrics(bool enable )**

        If **enable** is true then the layout will use design metrics; otherwise
        it will use the metrics of the paint device (which is the default
        behavior).

        **See also** **useDesignMetrics** ().
        """
        ...

    def tabArray(self) -> typing.List[float]:
        """
        https://doc.qt.io/qt-5/qtextoption.html#tabArray

        **QList<qreal> QTextOption::tabArray() const**

        Returns a list of tab positions defined for the text layout.

        **See also** **setTabArray** () and **tabStop** ().
        """
        ...

    def setTabArray(self, tabStops: typing.Iterable[float]) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setTabArray

        **void QTextOption::setTabArray(const QList<qreal> & tabStops )**

        Sets the tab positions for the text layout to those specified by
        **tabStops**.

        **See also** **tabArray** (), **setTabStopDistance** (), and **setTabs**
        ().
        """
        ...

    def tabStop(self) -> float:
        ...

    def flags(self) -> "QTextOption.Flags":
        """
        https://doc.qt.io/qt-5/qtextoption.html#flags

        **QTextOption::Flags QTextOption::flags() const**

        Returns the flags associated with the option.

        **See also** **setFlags** ().
        """
        ...

    def wrapMode(self) -> "QTextOption.WrapMode":
        """
        https://doc.qt.io/qt-5/qtextoption.html#wrapMode

        **QTextOption::WrapMode QTextOption::wrapMode() const**

        Returns the text wrap mode defined by the option.

        **See also** **setWrapMode** ().
        """
        ...

    def setWrapMode(self, wrap: "QTextOption.WrapMode") -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setWrapMode

        **void QTextOption::setWrapMode(QTextOption::WrapMode mode )**

        Sets the option's text wrap mode to the given **mode**.

        **See also** **wrapMode** ().
        """
        ...

    def textDirection(self) -> QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-5/qtextoption.html#textDirection

        **Qt::LayoutDirection QTextOption::textDirection() const**

        Returns the direction of the text layout defined by the option.

        **See also** **setTextDirection** ().
        """
        ...

    def setTextDirection(self, aDirection: QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-5/qtextoption.html#setTextDirection

        **void QTextOption::setTextDirection(Qt::LayoutDirection direction )**

        Sets the direction of the text layout defined by the option to the given
        **direction**.

        **See also** **textDirection** ().
        """
        ...

    def alignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qtextoption.html#alignment

        **Qt::Alignment QTextOption::alignment() const**

        Returns the text alignment defined by the option.

        **See also** **setAlignment** ().
        """
        ...
