"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextDocumentWriter(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtextdocumentwriter.html

    **Detailed Description**

    To write a document, construct a QTextDocumentWriter object with either a
    file name or a device object, and specify the document format to be written.
    You can construct a writer and set the format using **setFormat** () later.

    Call **write** () to write the document to the device. If the document is
    successfully written, this function returns `true`. However, if an error
    occurs when writing the document, it will return false.

    Call **supportedDocumentFormats** () for a list of formats that
    QTextDocumentWriter can write.

    Since the capabilities of the supported output formats vary considerably,
    the writer simply outputs the appropriate subset of objects for each format.
    This typically includes the formatted text and images contained in a
    document.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#QTextDocumentWriter

        **QTextDocumentWriter::QTextDocumentWriter()**

        Constructs an empty QTextDocumentWriter object. Before writing, you must
        call **setFormat** () to set a document format, then **setDevice** () or
        **setFileName** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        device: QtCore.QIODevice,
        format: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#QTextDocumentWriter-1

        **QTextDocumentWriter::QTextDocumentWriter(QIODevice * device , const
        QByteArray & format )**

        Constructs a QTextDocumentWriter object to write to the given **device**
        in the document format specified by **format**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        fileName: str,
        format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#QTextDocumentWriter-2

        **QTextDocumentWriter::QTextDocumentWriter(const QString & fileName ,
        const QByteArray & format = QByteArray())**

        Constructs an QTextDocumentWriter object that will write to a file with
        the name **fileName** , using the document format specified by
        **format**. If **format** is not provided, QTextDocumentWriter will
        detect the document format by inspecting the extension of **fileName**.
        """
        ...

    @staticmethod
    def supportedDocumentFormats() -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#supportedDocumentFormats

        **[static] QList<QByteArray>
        QTextDocumentWriter::supportedDocumentFormats()**

        Returns the list of document formats supported by
        **QTextDocumentWriter** .

        By default, Qt can write the following formats:

        FormatDescription
        plaintextPlain text
        HTMLHyperText Markup Language
        markdownMarkdown (CommonMark or GitHub dialects)
        ODFOpenDocument
        Format

        **See also** **setFormat** ().
        """
        ...

    def codec(self) -> QtCore.QTextCodec:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#codec

        **QTextCodec *QTextDocumentWriter::codec() const**

        Returns the codec that is currently assigned to the writer.

        **See also** **setCodec** ().
        """
        ...

    def setCodec(self, codec: QtCore.QTextCodec) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#setCodec

        **void QTextDocumentWriter::setCodec(QTextCodec * codec )**

        Sets the codec for this stream to **codec**. The codec is used for
        encoding any data that is written. By default, **QTextDocumentWriter**
        uses UTF-8.

        **See also** **codec** ().
        """
        ...

    @typing.overload
    def write(self, document: QTextDocument) -> bool:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#write

        **bool QTextDocumentWriter::write(const QTextDocument * document )**

        Writes the given **document** to the assigned device or file and returns
        `true` if successful; otherwise returns `false`.
        """
        ...

    @typing.overload
    def write(self, fragment: QTextDocumentFragment) -> bool:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#write-1

        **bool QTextDocumentWriter::write(const QTextDocumentFragment & fragment
        )**

        Writes the document fragment specified by **fragment** to the assigned
        device or file and returns `true` if successful; otherwise returns
        `false`.
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#fileName

        **QString QTextDocumentWriter::fileName() const**

        If the currently assigned device is a **QFile** , or if **setFileName**
        () has been called, this function returns the name of the file to be
        written to. In all other cases, it returns an empty string.

        **See also** **setFileName** () and **setDevice** ().
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#setFileName

        **void QTextDocumentWriter::setFileName(const QString & fileName )**

        Sets the name of the file to be written to **fileName**. Internally,
        **QTextDocumentWriter**  will create a **QFile**  and open it in
        **QIODevice::WriteOnly**  mode, and use this file when writing the
        document.

        **See also** **fileName** () and **setDevice** ().
        """
        ...

    def device(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#device

        **QIODevice *QTextDocumentWriter::device() const**

        Returns the device currently assigned, or `nullptr` if no device has
        been assigned.

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#setDevice

        **void QTextDocumentWriter::setDevice(QIODevice * device )**

        Sets the writer's device to the **device** specified. If a device has
        already been set, the old device is removed but otherwise left
        unchanged.

        If the device is not already open, **QTextDocumentWriter**  will attempt
        to open the device in **QIODevice::WriteOnly**  mode by calling open().

        **Note:** This will not work for certain devices, such as **QProcess** ,
        **QTcpSocket**  and **QUdpSocket** , where some configuration is
        required before the device can be opened.

        **See also** **device** () and **setFileName** ().
        """
        ...

    def format(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#format

        **QByteArray QTextDocumentWriter::format() const**

        Returns the format used for writing documents.

        **See also** **setFormat** ().
        """
        ...

    def setFormat(
        self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocumentwriter.html#setFormat

        **void QTextDocumentWriter::setFormat(const QByteArray & format )**

        Sets the format used to write documents to the **format** specified.
        **format** is a case insensitive text string. For example:

        **QTextDocumentWriter**  writer;
                    writer.setFormat("odf"); //
        same as writer.setFormat("ODF");

        You can call **supportedDocumentFormats** () for the full list of
        formats **QTextDocumentWriter**  supports.

        **See also** **format** ().
        """
        ...
