"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextDocument(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qtextdocument.html

    **Detailed Description**

    QTextDocument is a container for structured rich text documents, providing
    support for styled text and various types of document elements, such as
    lists, tables, frames, and images. They can be created for use in a
    **QTextEdit** , or used independently.

    Each document element is described by an associated format object. Each
    format object is treated as a unique object by QTextDocuments, and can be
    passed to **objectForFormat** () to obtain the document element that it is
    applied to.

    A QTextDocument can be edited programmatically using a **QTextCursor** , and
    its contents can be examined by traversing the document structure. The
    entire document structure is stored as a hierarchy of document elements
    beneath the root frame, found with the **rootFrame** () function.
    Alternatively, if you just want to iterate over the textual contents of the
    document you can use **begin** (), **end** (), and **findBlock** () to
    retrieve text blocks that you can examine and iterate over.

    The layout of a document is determined by the **documentLayout** (); you can
    create your own **QAbstractTextDocumentLayout**  subclass and set it using
    **setDocumentLayout** () if you want to use your own layout logic. The
    document's title and other meta-information can be obtained by calling the
    **metaInformation** () function. For documents that are exposed to users
    through the **QTextEdit**  class, the document title is also available via
    the **QTextEdit::documentTitle** () function.

    The **toPlainText** () and **toHtml** () convenience functions allow you to
    retrieve the contents of the document as plain text and HTML. The document's
    text can be searched using the **find** () functions.

    Undo/redo of operations performed on the document can be controlled using
    the **setUndoRedoEnabled** () function. The undo/redo system can be
    controlled by an editor widget through the **undo** () and **redo** ()
    slots; the document also provides **contentsChanged** (), **undoAvailable**
    (), and **redoAvailable** () signals that inform connected editor widgets
    about the state of the undo/redo system. The following are the undo/redo
    operations of a QTextDocument:

    * Insertion or removal of characters. A sequence of insertions or removals
    within the same text block are regarded as a single undo/redo operation.
      *
    Insertion or removal of text blocks. Sequences of insertion or removals in a
    single operation (e.g., by selecting and then deleting text) are regarded as
    a single undo/redo operation.
      * Text character format changes.
      * Text
    block format changes.
      * Text block group format changes.

    **See also** **QTextCursor** , **QTextEdit** , **Rich Text Processing** ,
    and **Text Object Example** .
    """

    class MarkdownFeature(int):
        MarkdownNoHTML: QTextDocument = ...
        MarkdownDialectCommonMark: QTextDocument = ...
        MarkdownDialectGitHub: QTextDocument = ...

    class Stacks(int):
        UndoStack: QTextDocument = ...
        RedoStack: QTextDocument = ...
        UndoAndRedoStacks: QTextDocument = ...

    class ResourceType(int):
        UnknownResource: QTextDocument = ...
        HtmlResource: QTextDocument = ...
        ImageResource: QTextDocument = ...
        StyleSheetResource: QTextDocument = ...
        MarkdownResource: QTextDocument = ...
        UserResource: QTextDocument = ...

    class FindFlag(int):
        FindBackward: QTextDocument = ...
        FindCaseSensitively: QTextDocument = ...
        FindWholeWords: QTextDocument = ...

    class MetaInformation(int):
        DocumentTitle: QTextDocument = ...
        DocumentUrl: QTextDocument = ...

    class FindFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QTextDocument.FindFlags", "QTextDocument.FindFlag"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextDocument.FindFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QTextDocument.FindFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class MarkdownFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QTextDocument.MarkdownFeatures", "QTextDocument.MarkdownFeature"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextDocument.MarkdownFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QTextDocument.MarkdownFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#QTextDocument

        **QTextDocument::QTextDocument(QObject * parent = nullptr)**

        Constructs an empty QTextDocument with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, text: str, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#QTextDocument-1

        **QTextDocument::QTextDocument(const QString & text , QObject * parent =
        nullptr)**

        Constructs a QTextDocument containing the plain (unformatted) **text**
        specified, and with the given **parent**.
        """
        ...

    def setMarkdown(
        self,
        markdown: str,
        features: typing.Union[
            "QTextDocument.MarkdownFeatures", "QTextDocument.MarkdownFeature"
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setMarkdown

        **void QTextDocument::setMarkdown(const QString & markdown ,
        QTextDocument::MarkdownFeatures features = MarkdownDialectGitHub)**

        Replaces the entire contents of the document with the given Markdown-
        formatted text in the **markdown** string, with the given **features**
        supported. By default, all supported GitHub-style Markdown features are
        included; pass `MarkdownDialectCommonMark` for a more basic parse.

        The Markdown formatting is respected as much as possible; for example,
        "*bold* text" will produce text where the first word has a font weight
        that gives it an emphasized appearance.

        Parsing of HTML included in the **markdown** string is handled in the
        same way as in **setHtml** ; however, Markdown formatting inside HTML
        blocks is not supported.

        Some features of the parser can be enabled or disabled via the
        **features** argument:

        ConstantDescription
        `MarkdownNoHTML`Any HTML tags in the Markdown text
        will be discarded
        `MarkdownDialectCommonMark`The parser supports only
        the features standardized by CommonMark
        `MarkdownDialectGitHub`The
        parser supports the GitHub dialect

        The default is `MarkdownDialectGitHub`.

        The undo/redo history is reset when this function is called.

        This function was introduced in Qt 5.14.
        """
        ...

    def toMarkdown(
        self,
        features: typing.Union[
            "QTextDocument.MarkdownFeatures", "QTextDocument.MarkdownFeature"
        ] = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#toMarkdown

        **QString QTextDocument::toMarkdown(QTextDocument::MarkdownFeatures
        features = MarkdownDialectGitHub) const**

        Returns a string containing a Markdown representation of the document
        with the given **features** , or an empty string if writing fails for
        any reason.

        This function was introduced in Qt 5.14.

        **See also** **setMarkdown** .
        """
        ...

    def toRawText(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#toRawText

        **QString QTextDocument::toRawText() const**

        Returns the raw text contained in the document without any formatting
        information. If you want formatting information use a **QTextCursor**
        instead.

        This function was introduced in Qt 5.9.

        **See also** **toPlainText** ().
        """
        ...

    def setBaseUrl(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#baseUrl-prop

        **baseUrl : QUrl**

        This property holds the base URL used to resolve relative resource URLs
        within the document.

        Resource URLs are resolved to be within the same directory as the target
        of the base URL meaning any portion of the path after the last '/' will
        be ignored.

        Base URLRelative URLResolved URL
        file:///path/to/contentimages/logo.pngfile:///path/to/images/logo.png

        file:///path/to/content/images/logo.pngfile:///path/to/content/images/lo
        go.png
        file:///path/to/content/index.htmlimages/logo.pngfile:///path/t
        o/content/images/logo.png
        file:///path/to/content/images/../images/log
        o.pngfile:///path/to/content/images/logo.png

        This property was introduced in Qt 5.3.

        **Access functions:**

        QUrl **baseUrl** () const
        void **setBaseUrl** (const QUrl & **url** )

        **Notifier signal:**

        void **baseUrlChanged** (const QUrl & **url** )
        """
        ...

    def baseUrl(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#baseUrl-prop

        **baseUrl : QUrl**

        This property holds the base URL used to resolve relative resource URLs
        within the document.

        Resource URLs are resolved to be within the same directory as the target
        of the base URL meaning any portion of the path after the last '/' will
        be ignored.

        Base URLRelative URLResolved URL
        file:///path/to/contentimages/logo.pngfile:///path/to/images/logo.png

        file:///path/to/content/images/logo.pngfile:///path/to/content/images/lo
        go.png
        file:///path/to/content/index.htmlimages/logo.pngfile:///path/t
        o/content/images/logo.png
        file:///path/to/content/images/../images/log
        o.pngfile:///path/to/content/images/logo.png

        This property was introduced in Qt 5.3.

        **Access functions:**

        QUrl **baseUrl** () const
        void **setBaseUrl** (const QUrl & **url** )

        **Notifier signal:**

        void **baseUrlChanged** (const QUrl & **url** )
        """
        ...

    def setDefaultCursorMoveStyle(self, style: QtCore.Qt.CursorMoveStyle) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setDefaultCursorMoveStyle

        **void QTextDocument::setDefaultCursorMoveStyle(Qt::CursorMoveStyle
        style )**

        Sets the default cursor movement style to the given **style**.

        This function was introduced in Qt 4.8.

        **See also** **defaultCursorMoveStyle** ().
        """
        ...

    def defaultCursorMoveStyle(self) -> QtCore.Qt.CursorMoveStyle:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#defaultCursorMoveStyle

        **Qt::CursorMoveStyle QTextDocument::defaultCursorMoveStyle() const**

        The default cursor movement style is used by all **QTextCursor**
        objects created from the document. The default is
        **Qt::LogicalMoveStyle** .

        This function was introduced in Qt 4.8.

        **See also** **setDefaultCursorMoveStyle** ().
        """
        ...

    def clearUndoRedoStacks(self, stacks: "QTextDocument.Stacks" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#clearUndoRedoStacks

        **void QTextDocument::clearUndoRedoStacks(QTextDocument::Stacks
        stacksToClear = UndoAndRedoStacks)**

        Clears the stacks specified by **stacksToClear**.

        This method clears any commands on the undo stack, the redo stack, or
        both (the default). If commands are cleared, the appropriate signals are
        emitted, **QTextDocument::undoAvailable** () or
        **QTextDocument::redoAvailable** ().

        This function was introduced in Qt 4.7.

        **See also** **QTextDocument::undoAvailable** () and
        **QTextDocument::redoAvailable** ().
        """
        ...

    def availableRedoSteps(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#availableRedoSteps

        **int QTextDocument::availableRedoSteps() const**

        Returns the number of available redo steps.

        This function was introduced in Qt 4.6.

        **See also** **isRedoAvailable** ().
        """
        ...

    def availableUndoSteps(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#availableUndoSteps

        **int QTextDocument::availableUndoSteps() const**

        Returns the number of available undo steps.

        This function was introduced in Qt 4.6.

        **See also** **isUndoAvailable** ().
        """
        ...

    def characterCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#characterCount

        **int QTextDocument::characterCount() const**

        Returns the number of characters of this document.

        **Note:** As a **QTextDocument**  always contains at least one
        **QChar::ParagraphSeparator** , this method will return at least 1.

        This function was introduced in Qt 4.5.

        **See also** **blockCount** () and **characterAt** ().
        """
        ...

    def lineCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#lineCount

        **int QTextDocument::lineCount() const**

        Returns the number of lines of this document (if the layout supports
        this). Otherwise, this is identical to the number of blocks.

        This function was introduced in Qt 4.5.

        **See also** **blockCount** () and **characterCount** ().
        """
        ...

    def setDocumentMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#documentMargin-prop

        **documentMargin : qreal**

        The margin around the document. The default is 4.

        This property was introduced in Qt 4.5.

        **Access functions:**

        qreal **documentMargin** () const
        void **setDocumentMargin** (qreal
        **margin** )
        """
        ...

    def documentMargin(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#documentMargin-prop

        **documentMargin : qreal**

        The margin around the document. The default is 4.

        This property was introduced in Qt 4.5.

        **Access functions:**

        qreal **documentMargin** () const
        void **setDocumentMargin** (qreal
        **margin** )
        """
        ...

    def characterAt(self, pos: int) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#characterAt

        **QChar QTextDocument::characterAt(int pos ) const**

        Returns the character at position **pos** , or a null character if the
        position is out of range.

        This function was introduced in Qt 4.5.

        **See also** **characterCount** ().
        """
        ...

    def setIndentWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setIndentWidth

        **void QTextDocument::setIndentWidth(qreal width )**

        Sets the **width** used for text list and text block indenting.

        The indent properties of **QTextListFormat**  and **QTextBlockFormat**
        specify multiples of this value. The default indent width is 40 .

        **Note:** Setter function for property **indentWidth** .

        This function was introduced in Qt 4.4.

        **See also** **indentWidth** ().
        """
        ...

    def indentWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#indentWidth-prop

        **indentWidth : qreal**

        Returns the width used for text list and text block indenting.

        The indent properties of **QTextListFormat**  and **QTextBlockFormat**
        specify multiples of this value. The default indent width is 40.

        This property was introduced in Qt 4.4.

        **Access functions:**

        qreal **indentWidth** () const
        void ****setIndentWidth** ** (qreal
        **width** )
        """
        ...

    def lastBlock(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#lastBlock

        **QTextBlock QTextDocument::lastBlock() const**

        Returns the document's last (valid) text block.

        This function was introduced in Qt 4.4.
        """
        ...

    def firstBlock(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#firstBlock

        **QTextBlock QTextDocument::firstBlock() const**

        Returns the document's first text block.

        This function was introduced in Qt 4.4.
        """
        ...

    def findBlockByLineNumber(self, blockNumber: int) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#findBlockByLineNumber

        **QTextBlock QTextDocument::findBlockByLineNumber(int lineNumber )
        const**

        Returns the text block that contains the specified **lineNumber**.

        This function was introduced in Qt 4.5.

        **See also** **QTextBlock::firstLineNumber** ().
        """
        ...

    def findBlockByNumber(self, blockNumber: int) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#findBlockByNumber

        **QTextBlock QTextDocument::findBlockByNumber(int blockNumber ) const**

        Returns the text block with the specified **blockNumber**.

        This function was introduced in Qt 4.4.

        **See also** **QTextBlock::blockNumber** ().
        """
        ...

    def revision(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#revision

        **int QTextDocument::revision() const**

        Returns the document's revision (if undo is enabled).

        The revision is guaranteed to increase when a document that is not
        modified is edited.

        This function was introduced in Qt 4.4.

        **See also** **QTextBlock::revision** () and **isModified** ().
        """
        ...

    def setDefaultTextOption(self, option: "QTextOption") -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setDefaultTextOption

        **void QTextDocument::setDefaultTextOption(const QTextOption & option
        )**

        Sets the default text option to **option**.

        **Note:** Setter function for property **defaultTextOption** .

        This function was introduced in Qt 4.3.

        **See also** **defaultTextOption** ().
        """
        ...

    def defaultTextOption(self) -> "QTextOption":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#defaultTextOption

        **QTextOption QTextDocument::defaultTextOption() const**

        The default text option is used on all **QTextLayout**  objects in the
        document. This allows setting global properties for the document such as
        the default word wrap mode.

        **Note:** Getter function for property defaultTextOption.

        This function was introduced in Qt 4.3.

        **See also** **setDefaultTextOption** ().
        """
        ...

    def setMaximumBlockCount(self, maximum: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#maximumBlockCount-prop

        **maximumBlockCount : int**

        Specifies the limit for blocks in the document.

        Specifies the maximum number of blocks the document may have. If there
        are more blocks in the document that specified with this property blocks
        are removed from the beginning of the document.

        A negative or zero value specifies that the document may contain an
        unlimited amount of blocks.

        The default value is 0.

        Note that setting this property will apply the limit immediately to the
        document contents.

        Setting this property also disables the undo redo history.

        This property is undefined in documents with tables or frames.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **maximumBlockCount** () const
        void **setMaximumBlockCount** (int
        **maximum** )
        """
        ...

    def maximumBlockCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#maximumBlockCount-prop

        **maximumBlockCount : int**

        Specifies the limit for blocks in the document.

        Specifies the maximum number of blocks the document may have. If there
        are more blocks in the document that specified with this property blocks
        are removed from the beginning of the document.

        A negative or zero value specifies that the document may contain an
        unlimited amount of blocks.

        The default value is 0.

        Note that setting this property will apply the limit immediately to the
        document contents.

        Setting this property also disables the undo redo history.

        This property is undefined in documents with tables or frames.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **maximumBlockCount** () const
        void **setMaximumBlockCount** (int
        **maximum** )
        """
        ...

    def defaultStyleSheet(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#defaultStyleSheet-prop

        **defaultStyleSheet : QString**

        The default style sheet is applied to all newly HTML formatted text that
        is inserted into the document, for example using **setHtml** () or
        **QTextCursor::insertHtml** ().

        The style sheet needs to be compliant to CSS 2.1 syntax.

        **Note:** Changing the default style sheet does not have any effect to
        the existing content of the document.

        This property was introduced in Qt 4.2.

        **Access functions:**

        QString **defaultStyleSheet** () const
        void **setDefaultStyleSheet**
        (const QString & **sheet** )

        **See also** **Supported HTML Subset** .
        """
        ...

    def setDefaultStyleSheet(self, sheet: str) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#defaultStyleSheet-prop

        **defaultStyleSheet : QString**

        The default style sheet is applied to all newly HTML formatted text that
        is inserted into the document, for example using **setHtml** () or
        **QTextCursor::insertHtml** ().

        The style sheet needs to be compliant to CSS 2.1 syntax.

        **Note:** Changing the default style sheet does not have any effect to
        the existing content of the document.

        This property was introduced in Qt 4.2.

        **Access functions:**

        QString **defaultStyleSheet** () const
        void **setDefaultStyleSheet**
        (const QString & **sheet** )

        **See also** **Supported HTML Subset** .
        """
        ...

    def blockCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#blockCount-prop

        **blockCount : const int**

        Returns the number of text blocks in the document.

        The value of this property is undefined in documents with tables or
        frames.

        By default, if defined, this property contains a value of 1.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **blockCount** () const

        **See also** **lineCount** () and **characterCount** ().
        """
        ...

    def size(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#size-prop

        **size : const QSizeF**

        Returns the actual size of the document. This is equivalent to
        **documentLayout** ()->documentSize();

        The size of the document can be changed either by setting a text width
        or setting an entire page size.

        Note that the width is always >= **pageSize** ().width().

        By default, for a newly-created, empty document, this property contains
        a configuration-dependent size.

        This property was introduced in Qt 4.2.

        **Access functions:**

        QSizeF **size** () const

        **See also** **setTextWidth** (), **setPageSize** (), and **idealWidth**
        ().
        """
        ...

    def adjustSize(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#adjustSize

        **void QTextDocument::adjustSize()**

        Adjusts the document to a reasonable size.

        This function was introduced in Qt 4.2.

        **See also** **idealWidth** (), **textWidth** , and **size** .
        """
        ...

    def idealWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#idealWidth

        **qreal QTextDocument::idealWidth() const**

        Returns the ideal width of the text document. The ideal width is the
        actually used width of the document without optional alignments taken
        into account. It is always <= **size** ().width().

        This function was introduced in Qt 4.2.

        **See also** **adjustSize** () and **textWidth** .
        """
        ...

    def textWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#textWidth-prop

        **textWidth : qreal**

        The text width specifies the preferred width for text in the document.
        If the text (or content in general) is wider than the specified with it
        is broken into multiple lines and grows vertically. If the text cannot
        be broken into multiple lines to fit into the specified text width it
        will be larger and the **size** () and the **idealWidth** () property
        will reflect that.

        If the text width is set to -1 then the text will not be broken into
        multiple lines unless it is enforced through an explicit line break or a
        new paragraph.

        The default value is -1.

        Setting the text width will also set the page height to -1, causing the
        document to grow or shrink vertically in a continuous way. If you want
        the document layout to break the text into multiple pages then you have
        to set the **pageSize**  property instead.

        This property was introduced in Qt 4.2.

        **Access functions:**

        qreal **textWidth** () const
        void **setTextWidth** (qreal **width** )

        **See also** **size** (), **idealWidth** (), and **pageSize** ().
        """
        ...

    def setTextWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#textWidth-prop

        **textWidth : qreal**

        The text width specifies the preferred width for text in the document.
        If the text (or content in general) is wider than the specified with it
        is broken into multiple lines and grows vertically. If the text cannot
        be broken into multiple lines to fit into the specified text width it
        will be larger and the **size** () and the **idealWidth** () property
        will reflect that.

        If the text width is set to -1 then the text will not be broken into
        multiple lines unless it is enforced through an explicit line break or a
        new paragraph.

        The default value is -1.

        Setting the text width will also set the page height to -1, causing the
        document to grow or shrink vertically in a continuous way. If you want
        the document layout to break the text into multiple pages then you have
        to set the **pageSize**  property instead.

        This property was introduced in Qt 4.2.

        **Access functions:**

        qreal **textWidth** () const
        void **setTextWidth** (qreal **width** )

        **See also** **size** (), **idealWidth** (), and **pageSize** ().
        """
        ...

    def drawContents(self, p: QPainter, rect: QtCore.QRectF = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#drawContents

        **void QTextDocument::drawContents(QPainter * p , const QRectF & rect =
        QRectF())**

        Draws the content of the document with painter **p** , clipped to
        **rect**. If **rect** is a null rectangle (default) then the document is
        painted unclipped.

        This function was introduced in Qt 4.2.
        """
        ...

    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#loadResource

        **[virtual protected] QVariant QTextDocument::loadResource(int type ,
        const QUrl & name )**

        Loads data of the specified **type** from the resource with the given
        **name**.

        This function is called by the rich text engine to request data that
        isn't directly stored by **QTextDocument** , but still associated with
        it. For example, images are referenced indirectly by the name attribute
        of a **QTextImageFormat**  object.

        When called by Qt, **type** is one of the values of
        **QTextDocument::ResourceType** .

        If the **QTextDocument**  is a child object of a **QObject**  that has
        an invokable loadResource method such as **QTextEdit** ,
        **QTextBrowser**  or a **QTextDocument**  itself then the default
        implementation tries to retrieve the data from the parent.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def createObject(self, f: "QTextFormat") -> "QTextObject":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#createObject

        **[virtual protected] QTextObject *QTextDocument::createObject(const
        QTextFormat & format )**

        Creates and returns a new document object (a **QTextObject** ), based on
        the given **format**.

        QTextObjects will always get created through this method, so you must
        reimplement it if you use custom text objects inside your document.
        """
        ...

    def setModified(self, on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#modified-prop

        **modified : bool**

        This property holds whether the document has been modified by the user

        By default, this property is `false`.

        **Access functions:**

        bool **isModified** () const
        void **setModified** (bool **m** = true)

        **See also** **modificationChanged** ().
        """
        ...

    @typing.overload
    def redo(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#redo

        **void QTextDocument::redo(QTextCursor * cursor )**

        Redoes the last editing operation on the document if **redo is
        available** .

        The provided **cursor** is positioned at the end of the location where
        the edition operation was redone.

        This function was introduced in Qt 4.2.
        """
        ...

    @typing.overload
    def redo(self, cursor: QTextCursor) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#redo-1

        **[slot] void QTextDocument::redo()**

        This is an overloaded function.

        Redoes the last editing operation on the document if **redo is
        available** .
        """
        ...

    @typing.overload
    def undo(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#undo

        **void QTextDocument::undo(QTextCursor * cursor )**

        Undoes the last editing operation on the document if undo is available.
        The provided **cursor** is positioned at the end of the location where
        the edition operation was undone.

        See the **Qt Undo Framework**  documentation for details.

        This function was introduced in Qt 4.2.

        **See also** **undoAvailable** () and **isUndoRedoEnabled** ().
        """
        ...

    @typing.overload
    def undo(self, cursor: QTextCursor) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#undo-1

        **[slot] void QTextDocument::undo()**

        This is an overloaded function.
        """
        ...

    def useDesignMetrics(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#useDesignMetrics-prop

        **useDesignMetrics : bool**

        This property holds whether the document uses design metrics of fonts to
        improve the accuracy of text layout

        If this property is set to true, the layout will use design metrics.
        Otherwise, the metrics of the paint device as set on
        **QAbstractTextDocumentLayout::setPaintDevice** () will be used.

        Using design metrics makes a layout have a width that is no longer
        dependent on hinting and pixel-rounding. This means that WYSIWYG text
        layout becomes possible because the width scales much more linearly
        based on paintdevice metrics than it would otherwise.

        By default, this property is `false`.

        This property was introduced in Qt 4.1.

        **Access functions:**

        bool **useDesignMetrics** () const
        void **setUseDesignMetrics** (bool
        **b** )

        **Member Function Documentation**
        """
        ...

    def setUseDesignMetrics(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#useDesignMetrics-prop

        **useDesignMetrics : bool**

        This property holds whether the document uses design metrics of fonts to
        improve the accuracy of text layout

        If this property is set to true, the layout will use design metrics.
        Otherwise, the metrics of the paint device as set on
        **QAbstractTextDocumentLayout::setPaintDevice** () will be used.

        Using design metrics makes a layout have a width that is no longer
        dependent on hinting and pixel-rounding. This means that WYSIWYG text
        layout becomes possible because the width scales much more linearly
        based on paintdevice metrics than it would otherwise.

        By default, this property is `false`.

        This property was introduced in Qt 4.1.

        **Access functions:**

        bool **useDesignMetrics** () const
        void **setUseDesignMetrics** (bool
        **b** )

        **Member Function Documentation**
        """
        ...

    def markContentsDirty(self, from_: int, length: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#markContentsDirty

        **void QTextDocument::markContentsDirty(int position , int length )**

        Marks the contents specified by the given **position** and **length** as
        "dirty", informing the document that it needs to be laid out again.
        """
        ...

    def allFormats(self) -> typing.List["QTextFormat"]:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#allFormats

        **QVector<QTextFormat> QTextDocument::allFormats() const**

        Returns a vector of text formats for all the formats used in the
        document.
        """
        ...

    def addResource(self, type: int, name: QtCore.QUrl, resource: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#addResource

        **void QTextDocument::addResource(int type , const QUrl & name , const
        QVariant & resource )**

        Adds the resource **resource** to the resource cache, using **type** and
        **name** as identifiers. **type** should be a value from
        **QTextDocument::ResourceType** .

        For example, you can add an image as a resource in order to reference it
        from within the document:

        document->addResource(**QTextDocument** ::ImageResource,
        **QUrl** ("mydata://image.png"), **QVariant** (image));

        The image can be inserted into the document using the **QTextCursor**
        API:

        **QTextImageFormat**  imageFormat;
        imageFormat.setName("mydata://image.png");
        cursor.insertImage(imageFormat);

        Alternatively, you can insert images using the HTML `img` tag:

        editor->append("<img src=\\"mydata://image.png\\" />");
        """
        ...

    def resource(self, type: int, name: QtCore.QUrl) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#resource

        **QVariant QTextDocument::resource(int type , const QUrl & name )
        const**

        Returns data of the specified **type** from the resource with the given
        **name**.

        This function is called by the rich text engine to request data that
        isn't directly stored by **QTextDocument** , but still associated with
        it. For example, images are referenced indirectly by the name attribute
        of a **QTextImageFormat**  object.

        Resources are cached internally in the document. If a resource can not
        be found in the cache, **loadResource**  is called to try to load the
        resource. **loadResource**  should then use **addResource**  to add the
        resource to the cache.

        **See also** **QTextDocument::ResourceType** .
        """
        ...

    def print(self, printer: QPagedPaintDevice) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#print

        **void QTextDocument::print(QPagedPaintDevice * printer ) const**

        Prints the document to the given **printer**. The **QPagedPaintDevice**
        must be set up before being used with this function.

        This is only a convenience method to print the whole document to the
        printer.

        If the document is already paginated through a specified height in the
        **pageSize** () property it is printed as-is.

        If the document is not paginated, like for example a document used in a
        **QTextEdit** , then a temporary copy of the document is created and the
        copy is broken into multiple pages according to the size of the paint
        device's paperRect(). By default a 2 cm margin is set around the
        document contents. In addition the current page number is printed at the
        bottom of each page.

        **See also** **QTextEdit::print** ().
        """
        ...

    def print_(self, printer: QPagedPaintDevice) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#print

        **void QTextDocument::print(QPagedPaintDevice * printer ) const**

        Prints the document to the given **printer**. The **QPagedPaintDevice**
        must be set up before being used with this function.

        This is only a convenience method to print the whole document to the
        printer.

        If the document is already paginated through a specified height in the
        **pageSize** () property it is printed as-is.

        If the document is not paginated, like for example a document used in a
        **QTextEdit** , then a temporary copy of the document is created and the
        copy is broken into multiple pages according to the size of the paint
        device's paperRect(). By default a 2 cm margin is set around the
        document contents. In addition the current page number is printed at the
        bottom of each page.

        **See also** **QTextEdit::print** ().
        """
        ...

    def isModified(self) -> bool:
        ...

    def pageCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#pageCount

        **int QTextDocument::pageCount() const**

        returns the number of pages in this document.
        """
        ...

    def defaultFont(self) -> QFont:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#defaultFont

        **QFont QTextDocument::defaultFont() const**

        Returns the default font to be used in the document layout.

        **Note:** Getter function for property defaultFont.

        **See also** **setDefaultFont** ().
        """
        ...

    def setDefaultFont(self, font: QFont) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setDefaultFont

        **void QTextDocument::setDefaultFont(const QFont & font )**

        Sets the default **font** to use in the document layout.

        **Note:** Setter function for property **defaultFont** .

        **See also** **defaultFont** ().
        """
        ...

    def pageSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#pageSize-prop

        **pageSize : QSizeF**

        This property holds the page size that should be used for laying out the
        document

        The units are determined by the underlying paint device. The size is
        measured in logical pixels when painting to the screen, and in points
        (1/72 inch) when painting to a printer.

        By default, for a newly-created, empty document, this property contains
        an undefined size.

        **Access functions:**

        QSizeF **pageSize** () const
        void **setPageSize** (const QSizeF &
        **size** )

        **See also** **modificationChanged** ().
        """
        ...

    def setPageSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#pageSize-prop

        **pageSize : QSizeF**

        This property holds the page size that should be used for laying out the
        document

        The units are determined by the underlying paint device. The size is
        measured in logical pixels when painting to the screen, and in points
        (1/72 inch) when painting to a printer.

        By default, for a newly-created, empty document, this property contains
        an undefined size.

        **Access functions:**

        QSizeF **pageSize** () const
        void **setPageSize** (const QSizeF &
        **size** )

        **See also** **modificationChanged** ().
        """
        ...

    def end(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#end

        **QTextBlock QTextDocument::end() const**

        This function returns a block to test for the end of the document while
        iterating over it.

        for (**QTextBlock**  it = doc->begin(); it != doc->end(); it =
        it.next())
                    cout << it.text().toStdString() << Qt::endl;

        The block returned is invalid and represents the block after the last
        block in the document. You can use **lastBlock** () to retrieve the last
        valid block of the document.

        **See also** **lastBlock** ().
        """
        ...

    def begin(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#begin

        **QTextBlock QTextDocument::begin() const**

        Returns the document's first text block.

        **See also** **firstBlock** ().
        """
        ...

    def findBlock(self, pos: int) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#findBlock

        **QTextBlock QTextDocument::findBlock(int pos ) const**

        Returns the text block that contains the **pos** -th character.
        """
        ...

    def objectForFormat(self, a0: "QTextFormat") -> "QTextObject":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#objectForFormat

        **QTextObject *QTextDocument::objectForFormat(const QTextFormat & f )
        const**

        Returns the text object associated with the format **f**.
        """
        ...

    def object(self, objectIndex: int) -> "QTextObject":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#object

        **QTextObject *QTextDocument::object(int objectIndex ) const**

        Returns the text object associated with the given **objectIndex**.
        """
        ...

    def rootFrame(self) -> "QTextFrame":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#rootFrame

        **QTextFrame *QTextDocument::rootFrame() const**

        Returns the document's root frame.
        """
        ...

    @typing.overload
    def find(
        self,
        subString: str,
        position: int = ...,
        options: "QTextDocument.FindFlags" = ...,
    ) -> QTextCursor:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#find

        **QTextCursor QTextDocument::find(const QString & subString , const
        QTextCursor & cursor , QTextDocument::FindFlags options = FindFlags())
        const**

        Finds the next occurrence of the string, **subString** , in the
        document. The search starts at the position of the given **cursor** ,
        and proceeds forwards through the document unless specified otherwise in
        the search options. The **options** control the type of search
        performed.

        Returns a cursor with the match selected if **subString** was found;
        otherwise returns a null cursor.

        If the given **cursor** has a selection, the search begins after the
        selection; otherwise it begins at the cursor's position.

        By default the search is case insensitive, and can match text anywhere
        in the document.
        """
        ...

    @typing.overload
    def find(
        self,
        expr: QtCore.QRegExp,
        position: int = ...,
        options: "QTextDocument.FindFlags" = ...,
    ) -> QTextCursor:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#find-1

        **QTextCursor QTextDocument::find(const QString & subString , int
        position = 0, QTextDocument::FindFlags options = FindFlags()) const**

        This is an overloaded function.

        Finds the next occurrence of the string, **subString** , in the
        document. The search starts at the given **position** , and proceeds
        forwards through the document unless specified otherwise in the search
        options. The **options** control the type of search performed.

        Returns a cursor with the match selected if **subString** was found;
        otherwise returns a null cursor.

        If the **position** is 0 (the default) the search begins from the
        beginning of the document; otherwise it begins at the specified
        position.
        """
        ...

    @typing.overload
    def find(
        self,
        expr: QtCore.QRegularExpression,
        position: int = ...,
        options: "QTextDocument.FindFlags" = ...,
    ) -> QTextCursor:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#find-2

        **QTextCursor QTextDocument::find(const QRegExp & expr , int from = 0,
        QTextDocument::FindFlags options = FindFlags()) const**

        This is an overloaded function.

        Finds the next occurrence that matches the given regular expression,
        **expr** , within the same paragraph in the document.

        The search starts at the given **from** position, and proceeds forwards
        through the document unless specified otherwise in the search options.
        The **options** control the type of search performed. The
        **FindCaseSensitively**  option is ignored for this overload, use
        **QRegExp::caseSensitivity**  instead.

        Returns a cursor with the match selected if a match was found; otherwise
        returns a null cursor.

        If the **from** position is 0 (the default) the search begins from the
        beginning of the document; otherwise it begins at the specified
        position.
        """
        ...

    @typing.overload
    def find(
        self,
        subString: str,
        cursor: QTextCursor,
        options: "QTextDocument.FindFlags" = ...,
    ) -> QTextCursor:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#find-3

        **QTextCursor QTextDocument::find(const QRegExp & expr , const
        QTextCursor & cursor , QTextDocument::FindFlags options = FindFlags())
        const**

        This is an overloaded function.

        Finds the next occurrence that matches the given regular expression,
        **expr** , within the same paragraph in the document.

        The search starts at the position of the given from **cursor** , and
        proceeds forwards through the document unless specified otherwise in the
        search options. The **options** control the type of search performed.
        The **FindCaseSensitively**  option is ignored for this overload, use
        **QRegExp::caseSensitivity**  instead.

        Returns a cursor with the match selected if a match was found; otherwise
        returns a null cursor.

        If the given **cursor** has a selection, the search begins after the
        selection; otherwise it begins at the cursor's position.

        By default the search is case insensitive, and can match text anywhere
        in the document.
        """
        ...

    @typing.overload
    def find(
        self,
        expr: QtCore.QRegExp,
        cursor: QTextCursor,
        options: "QTextDocument.FindFlags" = ...,
    ) -> QTextCursor:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#find-4

        **QTextCursor QTextDocument::find(const QRegularExpression & expr , int
        from = 0, QTextDocument::FindFlags options = FindFlags()) const**

        Finds the next occurrence that matches the given regular expression,
        **expr** , within the same paragraph in the document.

        The search starts at the given **from** position, and proceeds forwards
        through the document unless specified otherwise in the search options.
        The **options** control the type of search performed.

        Returns a cursor with the match selected if a match was found; otherwise
        returns a null cursor.

        If the **from** position is 0 (the default) the search begins from the
        beginning of the document; otherwise it begins at the specified
        position.

        This function was introduced in Qt 5.5.
        """
        ...

    @typing.overload
    def find(
        self,
        expr: QtCore.QRegularExpression,
        cursor: QTextCursor,
        options: "QTextDocument.FindFlags" = ...,
    ) -> QTextCursor:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#find-5

        **QTextCursor QTextDocument::find(const QRegularExpression & expr ,
        const QTextCursor & cursor , QTextDocument::FindFlags options =
        FindFlags()) const**

        Finds the next occurrence that matches the given regular expression,
        **expr** , within the same paragraph in the document.

        The search starts at the position of the given **cursor** , and proceeds
        forwards through the document unless specified otherwise in the search
        options. The **options** control the type of search performed.

        Returns a cursor with the match selected if a match was found; otherwise
        returns a null cursor.

        If the given **cursor** has a selection, the search begins after the
        selection; otherwise it begins at the cursor's position.

        By default the search is case insensitive, and can match text anywhere
        in the document.

        This function was introduced in Qt 5.5.
        """
        ...

    def setPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setPlainText

        **void QTextDocument::setPlainText(const QString & text )**

        Replaces the entire contents of the document with the given plain
        **text**. The undo/redo history is reset when this function is called.

        **See also** **setHtml** ().
        """
        ...

    def toPlainText(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#toPlainText

        **QString QTextDocument::toPlainText() const**

        Returns the plain text contained in the document. If you want formatting
        information use a **QTextCursor**  instead.

        This function returns the same as **toRawText** (), but will replace
        some unicode characters with ASCII alternatives. In particular, no-break
        space (U+00A0) is replaced by a regular space (U+0020), and both
        paragraph (U+2029) and line (U+2028) separators are replaced by line
        feed (U+000A). If you need the precise contents of the document, use
        **toRawText** () instead.

        **Note:** Embedded objects, such as images, are represented by a Unicode
        value U+FFFC (OBJECT REPLACEMENT CHARACTER).

        **See also** **toHtml** ().
        """
        ...

    def setHtml(self, html: str) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setHtml

        **void QTextDocument::setHtml(const QString & html )**

        Replaces the entire contents of the document with the given HTML-
        formatted text in the **html** string. The undo/redo history is reset
        when this function is called.

        The HTML formatting is respected as much as possible; for example,
        "<b>bold</b> text" will produce text where the first word has a font
        weight that gives it a bold appearance: " **bold** text".

        **Note:** It is the responsibility of the caller to make sure that the
        text is correctly decoded when a **QString**  containing HTML is created
        and passed to setHtml().

        **See also** **setPlainText** () and **Supported HTML Subset** .
        """
        ...

    def toHtml(
        self, encoding: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#toHtml

        **QString QTextDocument::toHtml(const QByteArray & encoding =
        QByteArray()) const**

        Returns a string containing an HTML representation of the document.

        The **encoding** parameter specifies the value for the charset attribute
        in the html header. For example if 'utf-8' is specified then the
        beginning of the generated html will look like this:

        <html><head><meta http-equiv="Content-Type" content="text/html;
        charset=utf-8"></head><body>...

        If no encoding is specified then no such meta information is generated.

        If you later on convert the returned html string into a byte array for
        transmission over a network or when saving to disk you should specify
        the encoding you're going to use for the conversion to a byte array
        here.

        **See also** **Supported HTML Subset** .
        """
        ...

    def metaInformation(self, info: "QTextDocument.MetaInformation") -> str:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#metaInformation

        **QString QTextDocument::metaInformation(QTextDocument::MetaInformation
        info ) const**

        Returns meta information about the document of the type specified by
        **info**.

        **See also** **setMetaInformation** ().
        """
        ...

    def setMetaInformation(
        self, info: "QTextDocument.MetaInformation", a1: str
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setMetaInformation

        **void QTextDocument::setMetaInformation(QTextDocument::MetaInformation
        info , const QString & string )**

        Sets the document's meta information of the type specified by **info**
        to the given **string**.

        **See also** **metaInformation** ().
        """
        ...

    def documentLayout(self) -> QAbstractTextDocumentLayout:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#documentLayout

        **QAbstractTextDocumentLayout *QTextDocument::documentLayout() const**

        Returns the document layout for this document.

        **See also** **setDocumentLayout** ().
        """
        ...

    def setDocumentLayout(self, layout: QAbstractTextDocumentLayout) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#setDocumentLayout

        **void QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout *
        layout )**

        Sets the document to use the given **layout**. The previous layout is
        deleted.

        **See also** **documentLayoutChanged** ().
        """
        ...

    def isRedoAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#isRedoAvailable

        **bool QTextDocument::isRedoAvailable() const**

        Returns `true` if redo is available; otherwise returns `false`.

        **See also** **isUndoAvailable** () and **availableRedoSteps** ().
        """
        ...

    def isUndoAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#isUndoAvailable

        **bool QTextDocument::isUndoAvailable() const**

        Returns `true` if undo is available; otherwise returns `false`.

        **See also** **isRedoAvailable** () and **availableUndoSteps** ().
        """
        ...

    def isUndoRedoEnabled(self) -> bool:
        ...

    def setUndoRedoEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#undoRedoEnabled-prop

        **undoRedoEnabled : bool**

        This property holds whether undo/redo are enabled for this document

        This defaults to true. If disabled, the undo stack is cleared and no
        items will be added to it.

        **Access functions:**

        bool **isUndoRedoEnabled** () const
        void **setUndoRedoEnabled** (bool
        **enable** )
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#clear

        **[virtual] void QTextDocument::clear()**

        Clears the document.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#isEmpty

        **bool QTextDocument::isEmpty() const**

        Returns `true` if the document is empty; otherwise returns `false`.
        """
        ...

    def clone(self, parent: typing.Optional[QtCore.QObject] = ...) -> "QTextDocument":
        """
        https://doc.qt.io/qt-5/qtextdocument.html#clone

        **QTextDocument *QTextDocument::clone(QObject * parent = nullptr)
        const**

        Creates a new **QTextDocument**  that is a copy of this text document.
        **parent** is the parent of the returned text document.
        """
        ...

    @property
    def baseUrlChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def blockCountChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#blockCountChanged

        **[signal] void QTextDocument::blockCountChanged(int newBlockCount )**

        This signal is emitted when the total number of text blocks in the
        document changes. The value passed in **newBlockCount** is the new
        total.

        This function was introduced in Qt 4.3.
        """
        ...

    @property
    def contentsChange(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#contentsChange

        **[signal] void QTextDocument::contentsChange(int position , int
        charsRemoved , int charsAdded )**

        This signal is emitted whenever the document's content changes; for
        example, when text is inserted or deleted, or when formatting is
        applied.

        Information is provided about the **position** of the character in the
        document where the change occurred, the number of characters removed (
        **charsRemoved** ), and the number of characters added ( **charsAdded**
        ).

        The signal is emitted before the document's layout manager is notified
        about the change. This hook allows you to implement syntax highlighting
        for the document.

        **See also** **QAbstractTextDocumentLayout::documentChanged** () and
        **contentsChanged** ().
        """
        ...

    @property
    def contentsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#contentsChanged

        **[signal] void QTextDocument::contentsChanged()**

        This signal is emitted whenever the document's content changes; for
        example, when text is inserted or deleted, or when formatting is
        applied.

        **See also** **contentsChange** ().
        """
        ...

    @property
    def cursorPositionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#cursorPositionChanged

        **[signal] void QTextDocument::cursorPositionChanged(const QTextCursor &
        cursor )**

        This signal is emitted whenever the position of a cursor changed due to
        an editing operation. The cursor that changed is passed in **cursor**.
        If the document is used with the **QTextEdit**  class and you need a
        signal when the cursor is moved with the arrow keys you can use the
        **cursorPositionChanged()**  signal in **QTextEdit** .
        """
        ...

    @property
    def documentLayoutChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#documentLayoutChanged

        **[signal] void QTextDocument::documentLayoutChanged()**

        This signal is emitted when a new document layout is set.

        This function was introduced in Qt 4.4.

        **See also** **setDocumentLayout** ().
        """
        ...

    @property
    def modificationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#modificationChanged

        **[signal] void QTextDocument::modificationChanged(bool changed )**

        This signal is emitted whenever the content of the document changes in a
        way that affects the modification state. If **changed** is true, the
        document has been modified; otherwise it is false.

        For example, calling **setModified** (false) on a document and then
        inserting text causes the signal to get emitted. If you undo that
        operation, causing the document to return to its original unmodified
        state, the signal will get emitted again.
        """
        ...

    @property
    def redoAvailable(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#redoAvailable

        **[signal] void QTextDocument::redoAvailable(bool available )**

        This signal is emitted whenever redo operations become available (
        **available** is true) or unavailable ( **available** is false).
        """
        ...

    @property
    def undoAvailable(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#undoAvailable

        **[signal] void QTextDocument::undoAvailable(bool available )**

        This signal is emitted whenever undo operations become available (
        **available** is true) or unavailable ( **available** is false).

        See the **Qt Undo Framework**  documentation for details.

        **See also** **undo** () and **isUndoRedoEnabled** ().
        """
        ...

    @property
    def undoCommandAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtextdocument.html#undoCommandAdded

        **[signal] void QTextDocument::undoCommandAdded()**

        This signal is emitted every time a new level of undo is added to the
        **QTextDocument** .

        This function was introduced in Qt 4.4.
        """
        ...
