"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QRgba64(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qrgba64.html

    **Detailed Description**

    QRgba64 is a 64-bit data-structure containing four 16-bit color channels:
    Red, green, blue and alpha.

    QRgba64 can be used as a replacement for **QRgb**  when higher precision is
    needed. In particular a premultiplied QRgba64 can operate on unpremultiplied
    **QRgb**  without loss of precision except for alpha 0.

    **See also** **QRgb**  and **QColor** .
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QRgba64") -> None:
        ...

    def __int__(self) -> int:
        ...

    def unpremultiplied(self) -> "QRgba64":
        """
        https://doc.qt.io/qt-5/qrgba64.html#unpremultiplied

        **QRgba64 QRgba64::unpremultiplied() const**

        Returns the color with the alpha unpremultiplied.

        **See also** **premultiplied** ().
        """
        ...

    def premultiplied(self) -> "QRgba64":
        """
        https://doc.qt.io/qt-5/qrgba64.html#premultiplied

        **QRgba64 QRgba64::premultiplied() const**

        Returns the color with the alpha premultiplied.

        **See also** **unpremultiplied** ().
        """
        ...

    def toRgb16(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#toRgb16

        **ushort QRgba64::toRgb16() const**

        Returns the color as a 16-bit RGB value.

        **See also** **toArgb32** ().
        """
        ...

    def toArgb32(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#toArgb32

        **uint QRgba64::toArgb32() const**

        Returns the color as a 32-bit ARGB value.

        **See also** **fromArgb32** ().
        """
        ...

    def alpha8(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#alpha8

        **quint8 QRgba64::alpha8() const**

        Returns the alpha channel as an 8-bit.
        """
        ...

    def blue8(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#blue8

        **quint8 QRgba64::blue8() const**

        Returns the blue color component as an 8-bit.
        """
        ...

    def green8(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#green8

        **quint8 QRgba64::green8() const**

        Returns the green color component as an 8-bit.
        """
        ...

    def red8(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#red8

        **quint8 QRgba64::red8() const**

        Returns the red color component as an 8-bit.
        """
        ...

    def setAlpha(self, _alpha: int) -> None:
        """
        https://doc.qt.io/qt-5/qrgba64.html#setAlpha

        **void QRgba64::setAlpha(quint16 alpha )**

        Sets the alpha of this color to **alpha**.

        **See also** **alpha** ().
        """
        ...

    def setBlue(self, _blue: int) -> None:
        """
        https://doc.qt.io/qt-5/qrgba64.html#setBlue

        **void QRgba64::setBlue(quint16 blue )**

        Sets the blue color component of this color to **blue**.

        **See also** **blue** ().
        """
        ...

    def setGreen(self, _green: int) -> None:
        """
        https://doc.qt.io/qt-5/qrgba64.html#setGreen

        **void QRgba64::setGreen(quint16 green )**

        Sets the green color component of this color to **green**.

        **See also** **green** ().
        """
        ...

    def setRed(self, _red: int) -> None:
        """
        https://doc.qt.io/qt-5/qrgba64.html#setRed

        **void QRgba64::setRed(quint16 red )**

        Sets the red color component of this color to **red**.

        **See also** **red** ().
        """
        ...

    def alpha(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#alpha

        **quint16 QRgba64::alpha() const**

        Returns the 16-bit alpha channel.

        **See also** **setAlpha** ().
        """
        ...

    def blue(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#blue

        **quint16 QRgba64::blue() const**

        Returns the 16-bit blue color component.

        **See also** **setBlue** ().
        """
        ...

    def green(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#green

        **quint16 QRgba64::green() const**

        Returns the 16-bit green color component.

        **See also** **setGreen** ().
        """
        ...

    def red(self) -> int:
        """
        https://doc.qt.io/qt-5/qrgba64.html#red

        **quint16 QRgba64::red() const**

        Returns the 16-bit red color component.

        **See also** **setRed** ().
        """
        ...

    def isTransparent(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrgba64.html#isTransparent

        **bool QRgba64::isTransparent() const**

        Returns whether the color is transparent.

        **See also** **isOpaque** () and **alpha** ().
        """
        ...

    def isOpaque(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrgba64.html#isOpaque

        **bool QRgba64::isOpaque() const**

        Returns whether the color is fully opaque.

        **See also** **isTransparent** () and **alpha** ().
        """
        ...

    @staticmethod
    def fromArgb32(rgb: int) -> "QRgba64":
        """
        https://doc.qt.io/qt-5/qrgba64.html#fromArgb32

        **[static] QRgba64 QRgba64::fromArgb32(uint rgb )**

        Constructs a **QRgba64**  value from the 32bit ARGB value **rgb**.

        **See also** **fromRgba** ().
        """
        ...

    @staticmethod
    def fromRgba(red: int, green: int, blue: int, alpha: int) -> "QRgba64":
        """
        https://doc.qt.io/qt-5/qrgba64.html#fromRgba

        **[static] QRgba64 QRgba64::fromRgba(quint8 red , quint8 green , quint8
        blue , quint8 alpha )**

        Constructs a **QRgba64**  value from the four 8-bit color channels
        **red** , **green** , **blue** and **alpha**.

        **See also** **fromArgb32** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromRgba64(c: int) -> "QRgba64":
        """
        https://doc.qt.io/qt-5/qrgba64.html#fromRgba64

        **[static] QRgba64 QRgba64::fromRgba64(quint64 c )**

        Returns **c** as a **QRgba64**  struct.

        **See also** **fromArgb32** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromRgba64(red: int, green: int, blue: int, alpha: int) -> "QRgba64":
        """
        https://doc.qt.io/qt-5/qrgba64.html#fromRgba64-1

        **[static] QRgba64 QRgba64::fromRgba64(quint16 r , quint16 g , quint16 b
        , quint16 a )**

        Returns the **QRgba64**  quadruplet ( **r** , **g** , **b** , **a** ).

        **See also** **fromRgba** ().
        """
        ...
