"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QPlatformSurfaceEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qplatformsurfaceevent.html

    **Detailed Description**

    Platform window events are synchronously sent to windows and offscreen
    surfaces when their underlying native surfaces are created or are about to
    be destroyed.

    Applications can respond to these events to know when the underlying
    platform surface exists.
    """

    class SurfaceEventType(int):
        SurfaceCreated: QPlatformSurfaceEvent = ...
        SurfaceAboutToBeDestroyed: QPlatformSurfaceEvent = ...

    @typing.overload
    def __init__(
        self, surfaceEventType: "QPlatformSurfaceEvent.SurfaceEventType"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplatformsurfaceevent.html#QPlatformSurfaceEvent

        **QPlatformSurfaceEvent::QPlatformSurfaceEvent(QPlatformSurfaceEvent::Su
        rfaceEventType surfaceEventType )**

        Constructs a platform surface event for the given **surfaceEventType**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPlatformSurfaceEvent") -> None:
        """
        https://doc.qt.io/qt-5/qplatformsurfaceevent.html#QPlatformSurfaceEvent

        **QPlatformSurfaceEvent::QPlatformSurfaceEvent(QPlatformSurfaceEvent::Su
        rfaceEventType surfaceEventType )**

        Constructs a platform surface event for the given **surfaceEventType**.
        """
        ...

    def surfaceEventType(self) -> "QPlatformSurfaceEvent.SurfaceEventType":
        """
        https://doc.qt.io/qt-5/qplatformsurfaceevent.html#surfaceEventType

        **QPlatformSurfaceEvent::SurfaceEventType
        QPlatformSurfaceEvent::surfaceEventType() const**

        Returns the specific type of platform surface event.
        """
        ...
