"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QPicture(QPaintDevice):
    """
    https://doc.qt.io/qt-5/qpicture.html

    **Detailed Description**

    A picture serializes painter commands to an IO device in a platform-
    independent format. They are sometimes referred to as meta-files.

    Qt pictures use a proprietary binary format. Unlike native picture (meta-
    file) formats on many window systems, Qt pictures have no limitations
    regarding their contents. Everything that can be painted on a widget or
    pixmap (e.g., fonts, pixmaps, regions, transformed graphics, etc.) can also
    be stored in a picture.

    QPicture is resolution independent, i.e. a QPicture can be displayed on
    different devices (for example svg, pdf, ps, printer and screen) looking the
    same. This is, for instance, needed for WYSIWYG print preview. QPicture runs
    in the default system dpi, and scales the painter to match differences in
    resolution depending on the window system.

    Example of how to record a picture:

    **QPicture**  picture;
                **QPainter**  painter;
    painter.begin(&picture);           // paint in picture
    painter.drawEllipse(10,20, 80,70); // draw an ellipse
    painter.end();                     // painting done
    picture.save("drawing.pic");       // save picture

    Note that the list of painter commands is reset on each call to the
    **QPainter::begin** () function.

    Example of how to replay a picture:

    **QPicture**  picture;
                picture.load("drawing.pic");           //
    load picture
                **QPainter**  painter;
    painter.begin(&myImage);               // paint in myImage
    painter.drawPicture(0, 0, picture);    // draw the picture at (0,0)
    painter.end();                         // painting done

    Pictures can also be drawn using **play** (). Some basic data about a
    picture is available, for example, **size** (), **isNull** () and
    **boundingRect** ().

    **See also** **QMovie** .
    """

    @typing.overload
    def __init__(self, formatVersion: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qpicture.html#QPicture

        **QPicture::QPicture(int formatVersion = -1)**

        Constructs an empty picture.

        The **formatVersion** parameter may be used to **create** a QPicture
        that can be read by applications that are compiled with earlier versions
        of Qt.

        Note that the default formatVersion is -1 which signifies the current
        release, i.e. for Qt 4.0 a formatVersion of 7 is the same as the default
        formatVersion of -1.

        Reading pictures generated by earlier versions of Qt is not supported in
        Qt 4.0.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPicture") -> None:
        """
        https://doc.qt.io/qt-5/qpicture.html#QPicture-1

        **QPicture::QPicture(const QPicture & pic )**

        Constructs a copy of **pic**.

        This constructor is fast thanks to **implicit sharing** .
        """
        ...

    def swap(self, other: "QPicture") -> None:
        """
        https://doc.qt.io/qt-5/qpicture.html#swap

        **void QPicture::swap(QPicture & other )**

        Swaps picture **other** with this picture. This operation is very fast
        and never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    def metric(self, m: QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def paintEngine(self) -> QPaintEngine:
        ...

    def isDetached(self) -> bool:
        ...

    def detach(self) -> None:
        ...

    def setBoundingRect(self, r: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qpicture.html#setBoundingRect

        **void QPicture::setBoundingRect(const QRect & r )**

        Sets the picture's bounding rectangle to **r**. The automatically
        calculated value is overridden.

        **See also** **boundingRect** ().
        """
        ...

    def boundingRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qpicture.html#boundingRect

        **QRect QPicture::boundingRect() const**

        Returns the picture's bounding rectangle or an invalid rectangle if the
        picture contains no data.

        **See also** **setBoundingRect** ().
        """
        ...

    @typing.overload
    def save(self, dev: QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qpicture.html#save

        **bool QPicture::save(const QString & fileName , const char * format =
        nullptr)**

        Saves a picture to the file specified by **fileName** and returns true
        if successful; otherwise returns `false`.

        Please note that the **format** parameter has been deprecated and will
        have no effect.

        **See also** **load** ().
        """
        ...

    @typing.overload
    def save(self, fileName: str, format: typing.Optional[str] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qpicture.html#save-1

        **bool QPicture::save(QIODevice * dev , const char * format = nullptr)**

        This is an overloaded function.

        **dev** is the device to use for saving.
        """
        ...

    @typing.overload
    def load(self, dev: QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qpicture.html#load

        **bool QPicture::load(const QString & fileName , const char * format =
        nullptr)**

        Loads a picture from the file specified by **fileName** and returns true
        if successful; otherwise invalidates the picture and returns `false`.

        Please note that the **format** parameter has been deprecated and will
        have no effect.

        **See also** **save** ().
        """
        ...

    @typing.overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qpicture.html#load-1

        **bool QPicture::load(QIODevice * dev , const char * format = nullptr)**

        This is an overloaded function.

        **dev** is the device to use for loading.
        """
        ...

    def play(self, p: QPainter) -> bool:
        """
        https://doc.qt.io/qt-5/qpicture.html#play

        **bool QPicture::play(QPainter * painter )**

        Replays the picture using **painter** , and returns `true` if
        successful; otherwise returns `false`.

        This function does exactly the same as **QPainter::drawPicture** () with
        (x, y) = (0, 0).
        """
        ...

    def setData(self, data: bytes) -> None:
        """
        https://doc.qt.io/qt-5/qpicture.html#setData

        **[virtual] void QPicture::setData(const char * data , uint size )**

        Sets the picture data directly from **data** and **size**. This function
        copies the input data.

        **See also** **data** () and **size** ().
        """
        ...

    def data(self) -> bytes:
        """
        https://doc.qt.io/qt-5/qpicture.html#data

        **const char *QPicture::data() const**

        Returns a pointer to the picture data. The pointer is only valid until
        the next non-const function is called on this picture. The returned
        pointer is 0 if the picture contains no data.

        **See also** **setData** (), **size** (), and **isNull** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qpicture.html#size

        **uint QPicture::size() const**

        Returns the size of the picture data.

        **See also** **data** ().
        """
        ...

    def devType(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpicture.html#isNull

        **bool QPicture::isNull() const**

        Returns `true` if the picture contains no data; otherwise returns false.
        """
        ...
