"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5.QtGui import *
from PyQt5 import sip


class QPaintDevice(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpaintdevice.html

    **Detailed Description**

    A paint device is an abstraction of a two-dimensional space that can be
    drawn on using a **QPainter** . Its default coordinate system has its origin
    located at the top-left position. X increases to the right and Y increases
    downwards. The unit is one pixel.

    The drawing capabilities of QPaintDevice are currently implemented by the
    **QWidget** , **QImage** , **QPixmap** , QGLPixelBuffer, **QPicture** , and
    **QPrinter**  subclasses.

    To implement support for a new backend, you must derive from QPaintDevice
    and reimplement the virtual **paintEngine** () function to tell **QPainter**
    which paint engine should be used to draw on this particular device. Note
    that you also must create a corresponding paint engine to be able to draw on
    the device, i.e derive from **QPaintEngine**  and reimplement its virtual
    functions.

    **Warning:** Qt requires that a **QGuiApplication**  object exists before
    any paint devices can be created. Paint devices access window system
    resources, and these resources are not initialized before an application
    object is created.

    The QPaintDevice class provides several functions returning the various
    device metrics: The **depth** () function returns its bit depth (number of
    bit planes). The **height** () function returns its height in default
    coordinate system units (e.g. pixels for **QPixmap**  and **QWidget** )
    while **heightMM** () returns the height of the device in millimeters.
    Similiarily, the **width** () and **widthMM** () functions return the width
    of the device in default coordinate system units and in millimeters,
    respectively. Alternatively, the protected **metric** () function can be
    used to retrieve the metric information by specifying the desired
    **PaintDeviceMetric**  as argument.

    The **logicalDpiX** () and **logicalDpiY** () functions return the
    horizontal and vertical resolution of the device in dots per inch. The
    **physicalDpiX** () and **physicalDpiY** () functions also return the
    resolution of the device in dots per inch, but note that if the logical and
    physical resolution differ, the corresponding **QPaintEngine**  must handle
    the mapping. Finally, the **colorCount** () function returns the number of
    different colors available for the paint device.

    **See also** **QPaintEngine** , **QPainter** , **Coordinate System** , and
    **Paint System** .
    """

    class PaintDeviceMetric(int):
        PdmWidth: QPaintDevice = ...
        PdmHeight: QPaintDevice = ...
        PdmWidthMM: QPaintDevice = ...
        PdmHeightMM: QPaintDevice = ...
        PdmNumColors: QPaintDevice = ...
        PdmDepth: QPaintDevice = ...
        PdmDpiX: QPaintDevice = ...
        PdmDpiY: QPaintDevice = ...
        PdmPhysicalDpiX: QPaintDevice = ...
        PdmPhysicalDpiY: QPaintDevice = ...
        PdmDevicePixelRatio: QPaintDevice = ...
        PdmDevicePixelRatioScaled: QPaintDevice = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#QPaintDevice

        **[protected] QPaintDevice::QPaintDevice()**

        Constructs a paint device. This constructor can be invoked only from
        subclasses of QPaintDevice.
        """
        ...

    @staticmethod
    def devicePixelRatioFScale() -> float:
        ...

    def devicePixelRatioF(self) -> float:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatioF

        **qreal QPaintDevice::devicePixelRatioF() const**

        Returns the device pixel ratio for the device as a floating point
        number.

        This function was introduced in Qt 5.6.
        """
        ...

    def metric(self, metric: "QPaintDevice.PaintDeviceMetric") -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#metric

        **[virtual protected] int
        QPaintDevice::metric(QPaintDevice::PaintDeviceMetric metric ) const**

        Returns the metric information for the given paint device **metric**.

        **See also** **PaintDeviceMetric** .
        """
        ...

    def devicePixelRatio(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatio

        **int QPaintDevice::devicePixelRatio() const**

        Returns the device pixel ratio for device.

        Common values are 1 for normal-dpi displays and 2 for high-dpi "retina"
        displays.
        """
        ...

    def colorCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#colorCount

        **int QPaintDevice::colorCount() const**

        Returns the number of different colors available for the paint device.
        If the number of colors available is too great to be represented by the
        int data type, then INT_MAX will be returned instead.
        """
        ...

    def paintingActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#paintingActive

        **bool QPaintDevice::paintingActive() const**

        Returns `true` if the device is currently being painted on, i.e. someone
        has called **QPainter::begin** () but not yet called **QPainter::end**
        () for this device; otherwise returns `false`.

        **See also** **QPainter::isActive** ().
        """
        ...

    def depth(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#depth

        **int QPaintDevice::depth() const**

        Returns the bit depth (number of bit planes) of the paint device.
        """
        ...

    def physicalDpiY(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiY

        **int QPaintDevice::physicalDpiY() const**

        Returns the horizontal resolution of the device in dots per inch. For
        example, when printing, this resolution refers to the physical printer's
        resolution. The logical DPI on the other hand, refers to the resolution
        used by the actual paint engine.

        Note that if the physicalDpiY() doesn't equal the **logicalDpiY** (),
        the corresponding **QPaintEngine**  must handle the resolution mapping.

        **See also** **physicalDpiX** () and **logicalDpiY** ().
        """
        ...

    def physicalDpiX(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiX

        **int QPaintDevice::physicalDpiX() const**

        Returns the horizontal resolution of the device in dots per inch. For
        example, when printing, this resolution refers to the physical printer's
        resolution. The logical DPI on the other hand, refers to the resolution
        used by the actual paint engine.

        Note that if the physicalDpiX() doesn't equal the **logicalDpiX** (),
        the corresponding **QPaintEngine**  must handle the resolution mapping.

        **See also** **physicalDpiY** () and **logicalDpiX** ().
        """
        ...

    def logicalDpiY(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiY

        **int QPaintDevice::logicalDpiY() const**

        Returns the vertical resolution of the device in dots per inch, which is
        used when computing font sizes. For X11, this is usually the same as
        could be computed from **heightMM** ().

        Note that if the logicalDpiY() doesn't equal the **physicalDpiY** (),
        the corresponding **QPaintEngine**  must handle the resolution mapping.

        **See also** **logicalDpiX** () and **physicalDpiY** ().
        """
        ...

    def logicalDpiX(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiX

        **int QPaintDevice::logicalDpiX() const**

        Returns the horizontal resolution of the device in dots per inch, which
        is used when computing font sizes. For X11, this is usually the same as
        could be computed from **widthMM** ().

        Note that if the logicalDpiX() doesn't equal the **physicalDpiX** (),
        the corresponding **QPaintEngine**  must handle the resolution mapping.

        **See also** **logicalDpiY** () and **physicalDpiX** ().
        """
        ...

    def heightMM(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#heightMM

        **int QPaintDevice::heightMM() const**

        Returns the height of the paint device in millimeters. Due to platform
        limitations it may not be possible to use this function to determine the
        actual physical size of a widget on the screen.

        **See also** **height** ().
        """
        ...

    def widthMM(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#widthMM

        **int QPaintDevice::widthMM() const**

        Returns the width of the paint device in millimeters. Due to platform
        limitations it may not be possible to use this function to determine the
        actual physical size of a widget on the screen.

        **See also** **width** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#height

        **int QPaintDevice::height() const**

        Returns the height of the paint device in default coordinate system
        units (e.g. pixels for **QPixmap**  and **QWidget** ).

        **See also** **heightMM** ().
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#width

        **int QPaintDevice::width() const**

        Returns the width of the paint device in default coordinate system units
        (e.g. pixels for **QPixmap**  and **QWidget** ).

        **See also** **widthMM** ().
        """
        ...

    def paintEngine(self) -> "QPaintEngine":
        """
        https://doc.qt.io/qt-5/qpaintdevice.html#paintEngine

        **[pure virtual] QPaintEngine *QPaintDevice::paintEngine() const**

        Returns a pointer to the paint engine used for drawing on the device.
        """
        ...
