"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtGui import *
from PyQt5 import sip


class QOpenGLBuffer(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qopenglbuffer.html

    **Detailed Description**

    Buffer objects are created in the OpenGL server so that the client
    application can avoid uploading vertices, indices, texture image data, etc
    every time they are needed.

    QOpenGLBuffer objects can be copied around as a reference to the underlying
    OpenGL buffer object:

    **QOpenGLBuffer**  buffer1(**QOpenGLBuffer** ::IndexBuffer);
    buffer1.create();

            **QOpenGLBuffer**  buffer2 = buffer1;

    QOpenGLBuffer performs a shallow copy when objects are copied in this
    manner, but does not implement copy-on-write semantics. The original object
    will be affected whenever the copy is modified.
    """

    class RangeAccessFlag(int):
        RangeRead: QOpenGLBuffer = ...
        RangeWrite: QOpenGLBuffer = ...
        RangeInvalidate: QOpenGLBuffer = ...
        RangeInvalidateBuffer: QOpenGLBuffer = ...
        RangeFlushExplicit: QOpenGLBuffer = ...
        RangeUnsynchronized: QOpenGLBuffer = ...

    class Access(int):
        ReadOnly: QOpenGLBuffer = ...
        WriteOnly: QOpenGLBuffer = ...
        ReadWrite: QOpenGLBuffer = ...

    class UsagePattern(int):
        StreamDraw: QOpenGLBuffer = ...
        StreamRead: QOpenGLBuffer = ...
        StreamCopy: QOpenGLBuffer = ...
        StaticDraw: QOpenGLBuffer = ...
        StaticRead: QOpenGLBuffer = ...
        StaticCopy: QOpenGLBuffer = ...
        DynamicDraw: QOpenGLBuffer = ...
        DynamicRead: QOpenGLBuffer = ...
        DynamicCopy: QOpenGLBuffer = ...

    class Type(int):
        VertexBuffer: QOpenGLBuffer = ...
        IndexBuffer: QOpenGLBuffer = ...
        PixelPackBuffer: QOpenGLBuffer = ...
        PixelUnpackBuffer: QOpenGLBuffer = ...

    class RangeAccessFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QOpenGLBuffer.RangeAccessFlags", "QOpenGLBuffer.RangeAccessFlag"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QOpenGLBuffer.RangeAccessFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QOpenGLBuffer.RangeAccessFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#QOpenGLBuffer

        **QOpenGLBuffer::QOpenGLBuffer()**

        Constructs a new buffer object of type **QOpenGLBuffer::VertexBuffer** .

        Note: this constructor just creates the QOpenGLBuffer instance. The
        actual buffer object in the OpenGL server is not created until
        **create** () is called.

        **See also** **create** ().
        """
        ...

    @typing.overload
    def __init__(self, type: "QOpenGLBuffer.Type") -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#QOpenGLBuffer-1

        **QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer::Type type )**

        Constructs a new buffer object of **type**.

        Note: this constructor just creates the QOpenGLBuffer instance. The
        actual buffer object in the OpenGL server is not created until
        **create** () is called.

        **See also** **create** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QOpenGLBuffer") -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#QOpenGLBuffer-2

        **QOpenGLBuffer::QOpenGLBuffer(const QOpenGLBuffer & other )**

        Constructs a shallow copy of **other**.

        Note: QOpenGLBuffer does not implement copy-on-write semantics, so
        **other** will be affected whenever the copy is modified.
        """
        ...

    def mapRange(
        self,
        offset: int,
        count: int,
        access: typing.Union[
            "QOpenGLBuffer.RangeAccessFlags", "QOpenGLBuffer.RangeAccessFlag"
        ],
    ) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#mapRange

        **void *QOpenGLBuffer::mapRange(int offset , int count ,
        QOpenGLBuffer::RangeAccessFlags access )**

        Maps the range specified by **offset** and **count** of the contents of
        this buffer into the application's memory space and returns a pointer to
        it. Returns null if memory mapping is not possible. The **access**
        parameter specifies a combination of access flags.

        It is assumed that **create** () has been called on this buffer and that
        it has been bound to the current context.

        **Note:** This function is not available on OpenGL ES 2.0 and earlier.

        **See also** **unmap** (), **create** (), and **bind** ().
        """
        ...

    def unmap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#unmap

        **bool QOpenGLBuffer::unmap()**

        Unmaps the buffer after it was mapped into the application's memory
        space with a previous call to **map** (). Returns `true` if the unmap
        succeeded; false otherwise.

        It is assumed that this buffer has been bound to the current context,
        and that it was previously mapped with **map** ().

        **Note:** This function is only supported under OpenGL ES 2.0 and
        earlier if the `GL_OES_mapbuffer` extension is present.

        **See also** **map** ().
        """
        ...

    def map(self, access: "QOpenGLBuffer.Access") -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#map

        **void *QOpenGLBuffer::map(QOpenGLBuffer::Access access )**

        Maps the contents of this buffer into the application's memory space and
        returns a pointer to it. Returns null if memory mapping is not possible.
        The **access** parameter indicates the type of access to be performed.

        It is assumed that **create** () has been called on this buffer and that
        it has been bound to the current context.

        **Note:** This function is only supported under OpenGL ES 2.0 or earlier
        if the `GL_OES_mapbuffer` extension is present.

        **Note:** On OpenGL ES 3.0 and newer, or, in case if desktop OpenGL, if
        `GL_ARB_map_buffer_range` is supported, this function uses
        `glMapBufferRange` instead of `glMapBuffer`.

        **See also** **unmap** (), **create** (), **bind** (), and **mapRange**
        ().
        """
        ...

    @typing.overload
    def allocate(self, data: PyQt5.sip.voidptr, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#allocate

        **void QOpenGLBuffer::allocate(const void * data , int count )**

        Allocates **count** bytes of space to the buffer, initialized to the
        contents of **data**. Any previous contents will be removed.

        It is assumed that **create** () has been called on this buffer and that
        it has been bound to the current context.

        **See also** **create** (), **read** (), and **write** ().
        """
        ...

    @typing.overload
    def allocate(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#allocate-1

        **void QOpenGLBuffer::allocate(int count )**

        This is an overloaded function.

        Allocates **count** bytes of space to the buffer. Any previous contents
        will be removed.

        It is assumed that **create** () has been called on this buffer and that
        it has been bound to the current context.

        **See also** **create** () and **write** ().
        """
        ...

    def write(self, offset: int, data: PyQt5.sip.voidptr, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#write

        **void QOpenGLBuffer::write(int offset , const void * data , int count
        )**

        Replaces the **count** bytes of this buffer starting at **offset** with
        the contents of **data**. Any other bytes in the buffer will be left
        unmodified.

        It is assumed that **create** () has been called on this buffer and that
        it has been bound to the current context.

        **See also** **create** (), **read** (), and **allocate** ().
        """
        ...

    def read(self, offset: int, data: PyQt5.sip.voidptr, count: int) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#read

        **bool QOpenGLBuffer::read(int offset , void * data , int count )**

        Reads the **count** bytes in this buffer starting at **offset** into
        **data**. Returns `true` on success; false if reading from the buffer is
        not supported. Buffer reading is not supported under OpenGL/ES.

        It is assumed that this buffer has been bound to the current context.

        **See also** **write** () and **bind** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#size

        **int QOpenGLBuffer::size() const**

        Returns the size of the data in this buffer, for reading operations.
        Returns -1 if fetching the buffer size is not supported, or the buffer
        has not been created.

        It is assumed that this buffer has been bound to the current context.

        **See also** **isCreated** () and **bind** ().
        """
        ...

    def bufferId(self) -> int:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#bufferId

        **GLuint QOpenGLBuffer::bufferId() const**

        Returns the OpenGL identifier associated with this buffer; zero if the
        buffer has not been created.

        **See also** **isCreated** ().
        """
        ...

    @typing.overload
    def release(self) -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#release

        **void QOpenGLBuffer::release()**

        Releases the buffer associated with this object from the current OpenGL
        context.

        This function must be called with the same **QOpenGLContext**  current
        as when **bind** () was called on the buffer.

        **See also** **bind** ().
        """
        ...

    @typing.overload
    @staticmethod
    def release(type: "QOpenGLBuffer.Type") -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#release-1

        **[static] void QOpenGLBuffer::release(QOpenGLBuffer::Type type )**

        Releases the buffer associated with **type** in the current
        **QOpenGLContext** .

        This function is a direct call to `glBindBuffer(type, 0)` for use when
        the caller does not know which **QOpenGLBuffer**  has been bound to the
        context but wants to make sure that it is released.

        **QOpenGLBuffer** ::release(**QOpenGLBuffer** ::VertexBuffer);
        """
        ...

    def bind(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#bind

        **bool QOpenGLBuffer::bind()**

        Binds the buffer associated with this object to the current OpenGL
        context. Returns `false` if binding was not possible, usually because
        **type** () is not supported on this OpenGL implementation.

        The buffer must be bound to the same **QOpenGLContext**  current when
        **create** () was called, or to another **QOpenGLContext**  that is
        sharing with it. Otherwise, false will be returned from this function.

        **See also** **release** () and **create** ().
        """
        ...

    def destroy(self) -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#destroy

        **void QOpenGLBuffer::destroy()**

        Destroys this buffer object, including the storage being used in the
        OpenGL server. All references to the buffer will become invalid.
        """
        ...

    def isCreated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#isCreated

        **bool QOpenGLBuffer::isCreated() const**

        Returns `true` if this buffer has been created; false otherwise.

        **See also** **create** () and **destroy** ().
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#create

        **bool QOpenGLBuffer::create()**

        Creates the buffer object in the OpenGL server. Returns `true` if the
        object was created; false otherwise.

        This function must be called with a current **QOpenGLContext** . The
        buffer will be bound to and can only be used in that context (or any
        other context that is shared with it).

        This function will return false if the OpenGL implementation does not
        support buffers, or there is no current **QOpenGLContext** .

        **See also** **isCreated** (), **allocate** (), **write** (), and
        **destroy** ().
        """
        ...

    def setUsagePattern(self, value: "QOpenGLBuffer.UsagePattern") -> None:
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#setUsagePattern

        **void QOpenGLBuffer::setUsagePattern(QOpenGLBuffer::UsagePattern value
        )**

        Sets the usage pattern for this buffer object to **value**. This
        function must be called before **allocate** () or **write** ().

        **See also** **usagePattern** (), **allocate** (), and **write** ().
        """
        ...

    def usagePattern(self) -> "QOpenGLBuffer.UsagePattern":
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#usagePattern

        **QOpenGLBuffer::UsagePattern QOpenGLBuffer::usagePattern() const**

        Returns the usage pattern for this buffer object. The default value is
        **StaticDraw** .

        **See also** **setUsagePattern** ().
        """
        ...

    def type(self) -> "QOpenGLBuffer.Type":
        """
        https://doc.qt.io/qt-5/qopenglbuffer.html#type

        **QOpenGLBuffer::Type QOpenGLBuffer::type() const**

        Returns the type of buffer represented by this object.
        """
        ...
