"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QMouseEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qmouseevent.html

    **Detailed Description**

    Mouse events occur when a mouse button is pressed or released inside a
    widget, or when the mouse cursor is moved.

    Mouse move events will occur only when a mouse button is pressed down,
    unless mouse tracking has been enabled with **QWidget::setMouseTracking**
    ().

    Qt automatically grabs the mouse when a mouse button is pressed inside a
    widget; the widget will continue to receive mouse events until the last
    mouse button is released.

    A mouse event contains a special accept flag that indicates whether the
    receiver wants the event. You should call **ignore** () if the mouse event
    is not handled by your widget. A mouse event is propagated up the parent
    widget chain until a widget accepts it with **accept** (), or an event
    filter consumes it.

    **Note:** If a mouse event is propagated to a **widget**  for which
    **Qt::WA_NoMousePropagation**  has been set, that mouse event will not be
    propagated further up the parent widget chain.

    The state of the keyboard modifier keys can be found by calling the
    **modifiers()**  function, inherited from **QInputEvent** .

    The functions **pos** (), **x** (), and **y** () give the cursor position
    relative to the widget that receives the mouse event. If you move the widget
    as a result of the mouse event, use the global position returned by
    **globalPos** () to avoid a shaking motion.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse and keyboard events for a widget.

    Reimplement the **QWidget**  event handlers, **QWidget::mousePressEvent**
    (), **QWidget::mouseReleaseEvent** (), **QWidget::mouseDoubleClickEvent**
    (), and **QWidget::mouseMoveEvent** () to receive mouse events in your own
    widgets.

    **See also** **QWidget::setMouseTracking** (), **QWidget::grabMouse** (),
    and **QCursor::pos** ().
    """

    @typing.overload
    def __init__(
        self,
        type: QtCore.QEvent.Type,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        button: QtCore.Qt.MouseButton,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#QMouseEvent

        **QMouseEvent::QMouseEvent(QEvent::Type type , const QPointF & localPos
        , Qt::MouseButton button , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers )**

        Constructs a mouse event object.

        The **type** parameter must be one of **QEvent::MouseButtonPress** ,
        **QEvent::MouseButtonRelease** , **QEvent::MouseButtonDblClick** , or
        **QEvent::MouseMove** .

        The **localPos** is the mouse cursor's position relative to the
        receiving widget or item. The window position is set to the same value
        as **localPos**. The **button** that caused the event is given as a
        value from the **Qt::MouseButton**  enum. If the event **type** is
        **MouseMove** , the appropriate button for this event is
        **Qt::NoButton** . The mouse and keyboard states at the time of the
        event are specified by **buttons** and **modifiers**.

        The **screenPos** () is initialized to **QCursor::pos** (), which may
        not be appropriate. Use the other constructor to specify the global
        position explicitly.
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: QtCore.QEvent.Type,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        button: QtCore.Qt.MouseButton,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#QMouseEvent-1

        **QMouseEvent::QMouseEvent(QEvent::Type type , const QPointF & localPos
        , const QPointF & screenPos , Qt::MouseButton button , Qt::MouseButtons
        buttons , Qt::KeyboardModifiers modifiers )**

        Constructs a mouse event object.

        The **type** parameter must be **QEvent::MouseButtonPress** ,
        **QEvent::MouseButtonRelease** , **QEvent::MouseButtonDblClick** , or
        **QEvent::MouseMove** .

        The **localPos** is the mouse cursor's position relative to the
        receiving widget or item. The cursor's position in screen coordinates is
        specified by **screenPos**. The window position is set to the same value
        as **localPos**. The **button** that caused the event is given as a
        value from the **Qt::MouseButton**  enum. If the event **type** is
        **MouseMove** , the appropriate button for this event is
        **Qt::NoButton** . **buttons** is the state of all buttons at the time
        of the event, **modifiers** the state of all keyboard modifiers.
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: QtCore.QEvent.Type,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        button: QtCore.Qt.MouseButton,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#QMouseEvent-2

        **QMouseEvent::QMouseEvent(QEvent::Type type , const QPointF & localPos
        , const QPointF & windowPos , const QPointF & screenPos ,
        Qt::MouseButton button , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers )**

        Constructs a mouse event object.

        The **type** parameter must be **QEvent::MouseButtonPress** ,
        **QEvent::MouseButtonRelease** , **QEvent::MouseButtonDblClick** , or
        **QEvent::MouseMove** .

        The points **localPos** , **windowPos** and **screenPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen, respectively.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is **MouseMove** , the
        appropriate button for this event is **Qt::NoButton** . **buttons** is
        the state of all buttons at the time of the event, **modifiers** the
        state of all keyboard modifiers.
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: QtCore.QEvent.Type,
        localPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        button: QtCore.Qt.MouseButton,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        source: QtCore.Qt.MouseEventSource,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#QMouseEvent-3

        **QMouseEvent::QMouseEvent(QEvent::Type type , const QPointF & localPos
        , const QPointF & windowPos , const QPointF & screenPos ,
        Qt::MouseButton button , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::MouseEventSource source )**

        Constructs a mouse event object.

        The **type** parameter must be **QEvent::MouseButtonPress** ,
        **QEvent::MouseButtonRelease** , **QEvent::MouseButtonDblClick** , or
        **QEvent::MouseMove** .

        The points **localPos** , **windowPos** and **screenPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen, respectively.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is **MouseMove** , the
        appropriate button for this event is **Qt::NoButton** . **buttons** is
        the state of all buttons at the time of the event, **modifiers** is the
        state of all keyboard modifiers.

        The source of the event is specified by **source**.

        This function was introduced in Qt 5.6.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#QMouseEvent

        **QMouseEvent::QMouseEvent(QEvent::Type type , const QPointF & localPos
        , Qt::MouseButton button , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers )**

        Constructs a mouse event object.

        The **type** parameter must be one of **QEvent::MouseButtonPress** ,
        **QEvent::MouseButtonRelease** , **QEvent::MouseButtonDblClick** , or
        **QEvent::MouseMove** .

        The **localPos** is the mouse cursor's position relative to the
        receiving widget or item. The window position is set to the same value
        as **localPos**. The **button** that caused the event is given as a
        value from the **Qt::MouseButton**  enum. If the event **type** is
        **MouseMove** , the appropriate button for this event is
        **Qt::NoButton** . The mouse and keyboard states at the time of the
        event are specified by **buttons** and **modifiers**.

        The **screenPos** () is initialized to **QCursor::pos** (), which may
        not be appropriate. Use the other constructor to specify the global
        position explicitly.
        """
        ...

    def flags(self) -> QtCore.Qt.MouseEventFlags:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#flags

        **Qt::MouseEventFlags QMouseEvent::flags() const**

        Returns the mouse event flags.

        The mouse event flags provide additional information about a mouse
        event.

        This function was introduced in Qt 5.3.

        **See also** **Qt::MouseEventFlag**  and
        **QGraphicsSceneMouseEvent::flags** ().
        """
        ...

    def source(self) -> QtCore.Qt.MouseEventSource:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#source

        **Qt::MouseEventSource QMouseEvent::source() const**

        Returns information about the mouse event source.

        The mouse event source can be used to distinguish between genuine and
        artificial mouse events. The latter are events that are synthesized from
        touch events by the operating system or Qt itself.

        **Note:** Many platforms provide no such information. On such platforms
        **Qt::MouseEventNotSynthesized**  is returned always.

        This function was introduced in Qt 5.3.

        **See also** **Qt::MouseEventSource**  and
        **QGraphicsSceneMouseEvent::source** ().
        """
        ...

    def screenPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#screenPos

        **const QPointF &QMouseEvent::screenPos() const**

        Returns the position of the mouse cursor as a **QPointF** , relative to
        the screen that received the event.

        This function was introduced in Qt 5.0.

        **See also** **x** (), **y** (), **pos** (), **localPos** (), and
        **windowPos** ().
        """
        ...

    def windowPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#windowPos

        **const QPointF &QMouseEvent::windowPos() const**

        Returns the position of the mouse cursor as a **QPointF** , relative to
        the window that received the event.

        If you move the widget as a result of the mouse event, use the global
        position returned by **globalPos** () to avoid a shaking motion.

        This function was introduced in Qt 5.0.

        **See also** **x** (), **y** (), **pos** (), **localPos** (), and
        **screenPos** ().
        """
        ...

    def localPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#localPos

        **const QPointF &QMouseEvent::localPos() const**

        Returns the position of the mouse cursor as a **QPointF** , relative to
        the widget or item that received the event.

        If you move the widget as a result of the mouse event, use the screen
        position returned by **screenPos** () to avoid a shaking motion.

        This function was introduced in Qt 5.0.

        **See also** **x** (), **y** (), **windowPos** (), and **screenPos** ().
        """
        ...

    def buttons(self) -> QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#buttons

        **Qt::MouseButtons QMouseEvent::buttons() const**

        Returns the button state when the event was generated. The button state
        is a combination of **Qt::LeftButton** , **Qt::RightButton** ,
        **Qt::MiddleButton**  using the OR operator. For mouse move events, this
        is all buttons that are pressed down. For mouse press and double click
        events this includes the button that caused the event. For mouse release
        events this excludes the button that caused the event.

        **See also** **button** () and **Qt::MouseButton** .
        """
        ...

    def button(self) -> QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#button

        **Qt::MouseButton QMouseEvent::button() const**

        Returns the button that caused the event.

        Note that the returned value is always **Qt::NoButton**  for mouse move
        events.

        **See also** **buttons** () and **Qt::MouseButton** .
        """
        ...

    def globalY(self) -> int:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#globalY

        **int QMouseEvent::globalY() const**

        Returns the global y position of the mouse cursor at the time of the
        event.

        **See also** **globalX** () and **globalPos** ().
        """
        ...

    def globalX(self) -> int:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#globalX

        **int QMouseEvent::globalX() const**

        Returns the global x position of the mouse cursor at the time of the
        event.

        **See also** **globalY** () and **globalPos** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#y

        **int QMouseEvent::y() const**

        Returns the y position of the mouse cursor, relative to the widget that
        received the event.

        **See also** **x** () and **pos** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#x

        **int QMouseEvent::x() const**

        Returns the x position of the mouse cursor, relative to the widget that
        received the event.

        **See also** **y** () and **pos** ().
        """
        ...

    def globalPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#globalPos

        **QPoint QMouseEvent::globalPos() const**

        Returns the global position of the mouse cursor **at the time of the
        event**. This is important on asynchronous window systems like X11.
        Whenever you move your widgets around in response to mouse events,
        globalPos() may differ a lot from the current pointer position
        **QCursor::pos** (), and from **QWidget::mapToGlobal** (**pos** ()).

        **See also** **globalX** () and **globalY** ().
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qmouseevent.html#pos

        **QPoint QMouseEvent::pos() const**

        Returns the position of the mouse cursor, relative to the widget that
        received the event.

        If you move the widget as a result of the mouse event, use the global
        position returned by **globalPos** () to avoid a shaking motion.

        **See also** **x** (), **y** (), and **globalPos** ().
        """
        ...
