"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore


class QHelpEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qhelpevent.html

    **Detailed Description**

    This event can be intercepted in applications to provide tooltips or "What's
    This?" help for custom widgets. The **type** () can be either
    **QEvent::ToolTip**  or **QEvent::WhatsThis** .

    **See also** **QToolTip** , **QWhatsThis** , **QStatusTipEvent** , and
    **QWhatsThisClickedEvent** .
    """

    @typing.overload
    def __init__(
        self, type: QtCore.QEvent.Type, pos: QtCore.QPoint, globalPos: QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#QHelpEvent

        **QHelpEvent::QHelpEvent(QEvent::Type type , const QPoint & pos , const
        QPoint & globalPos )**

        Constructs a help event with the given **type** corresponding to the
        widget-relative position specified by **pos** and the global position
        specified by **globalPos**.

        **type** must be either **QEvent::ToolTip**  or **QEvent::WhatsThis** .

        **See also** **pos** () and **globalPos** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QHelpEvent") -> None:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#QHelpEvent

        **QHelpEvent::QHelpEvent(QEvent::Type type , const QPoint & pos , const
        QPoint & globalPos )**

        Constructs a help event with the given **type** corresponding to the
        widget-relative position specified by **pos** and the global position
        specified by **globalPos**.

        **type** must be either **QEvent::ToolTip**  or **QEvent::WhatsThis** .

        **See also** **pos** () and **globalPos** ().
        """
        ...

    def globalPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#globalPos

        **const QPoint &QHelpEvent::globalPos() const**

        Returns the mouse cursor position when the event was generated in global
        coordinates.

        **See also** **pos** (), **globalX** (), and **globalY** ().
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#pos

        **const QPoint &QHelpEvent::pos() const**

        Returns the mouse cursor position when the event was generated, relative
        to the widget to which the event is dispatched.

        **See also** **globalPos** (), **x** (), and **y** ().
        """
        ...

    def globalY(self) -> int:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#globalY

        **int QHelpEvent::globalY() const**

        Same as **globalPos** ().**y** ().

        **See also** **y** (), **globalX** (), and **globalPos** ().
        """
        ...

    def globalX(self) -> int:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#globalX

        **int QHelpEvent::globalX() const**

        Same as **globalPos** ().**x** ().

        **See also** **x** (), **globalY** (), and **globalPos** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#y

        **int QHelpEvent::y() const**

        Same as **pos** ().y().

        **See also** **x** (), **pos** (), and **globalPos** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-5/qhelpevent.html#x

        **int QHelpEvent::x() const**

        Same as **pos** ().x().

        **See also** **y** (), **pos** (), and **globalPos** ().
        """
        ...
