"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QDragMoveEvent(QDropEvent):
    """
    https://doc.qt.io/qt-5/qdragmoveevent.html

    **Detailed Description**

    A widget will receive drag move events repeatedly while the drag is within
    its boundaries, if it accepts **drop events**  and **enter events** . The
    widget should examine the event to see what kind of **data**  it provides,
    and call the **accept** () function to accept the drop if appropriate.

    The rectangle supplied by the **answerRect** () function can be used to
    restrict drops to certain parts of the widget. For example, we can check
    whether the rectangle intersects with the geometry of a certain child widget
    and only call **acceptProposedAction()**  if that is the case.

    Note that this class inherits most of its functionality from **QDropEvent**
    .

    **See also** **QDragEnterEvent** , **QDragLeaveEvent** , and **QDropEvent**
    .
    """

    @typing.overload
    def __init__(
        self,
        pos: QtCore.QPoint,
        actions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction],
        data: QtCore.QMimeData,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        type: QtCore.QEvent.Type = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#QDragMoveEvent

        **QDragMoveEvent::QDragMoveEvent(const QPoint & pos , Qt::DropActions
        actions , const QMimeData * data , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , QEvent::Type type = DragMove)**

        Creates a QDragMoveEvent of the required **type** indicating that the
        mouse is at position **pos** given within a widget.

        The mouse and keyboard states are specified by **buttons** and
        **modifiers** , and the **actions** describe the types of drag and drop
        operation that are possible. The drag data is passed as MIME-encoded
        information in **data**.

        **Warning:** Do not attempt to create a QDragMoveEvent yourself. These
        objects rely on Qt's internal state.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QDragMoveEvent") -> None:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#QDragMoveEvent

        **QDragMoveEvent::QDragMoveEvent(const QPoint & pos , Qt::DropActions
        actions , const QMimeData * data , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , QEvent::Type type = DragMove)**

        Creates a QDragMoveEvent of the required **type** indicating that the
        mouse is at position **pos** given within a widget.

        The mouse and keyboard states are specified by **buttons** and
        **modifiers** , and the **actions** describe the types of drag and drop
        operation that are possible. The drag data is passed as MIME-encoded
        information in **data**.

        **Warning:** Do not attempt to create a QDragMoveEvent yourself. These
        objects rely on Qt's internal state.
        """
        ...

    @typing.overload
    def ignore(self) -> None:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#ignore

        **void QDragMoveEvent::ignore(const QRect & rectangle )**

        The opposite of the accept(const **QRect** &) function. Moves within the
        **rectangle** are not acceptable, and will be ignored.
        """
        ...

    @typing.overload
    def ignore(self, r: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#ignore-1

        **void QDragMoveEvent::ignore()**

        This is an overloaded function.

        Calls **QDropEvent::ignore** ().
        """
        ...

    @typing.overload
    def accept(self) -> None:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#accept

        **void QDragMoveEvent::accept(const QRect & rectangle )**

        The same as accept(), but also notifies that future moves will also be
        acceptable if they remain within the **rectangle** given on the widget.
        This can improve performance, but may also be ignored by the underlying
        system.

        If the rectangle is empty, drag move events will be sent continuously.
        This is useful if the source is scrolling in a timer event.
        """
        ...

    @typing.overload
    def accept(self, r: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#accept-1

        **void QDragMoveEvent::accept()**

        This is an overloaded function.

        Calls **QDropEvent::accept** ().
        """
        ...

    def answerRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qdragmoveevent.html#answerRect

        **QRect QDragMoveEvent::answerRect() const**

        Returns the rectangle in the widget where the drop will occur if
        accepted. You can use this information to restrict drops to certain
        places on the widget.
        """
        ...
