"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QDBusArgument(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdbusargument.html

    **Detailed Description**

    The class is used to send arguments over D-Bus to remote applications and to
    receive them back. D-Bus offers an extensible type system, based on a few
    primitive types and associations of them. See the **Qt D-Bus Type System**
    page for more information on the type system.

    QDBusArgument is the central class in the Qt D-Bus type system, providing
    functions to marshall and demarshall the primitive types. The compound types
    are then created by association of one or more of the primitive types in
    arrays, dictionaries or structures.

    The following example illustrates how a structure containing an integer and
    a string can be constructed using the **Qt D-Bus type system** :

    struct MyStructure
        {
            int count;
            **QString**  name;
    };
        Q_DECLARE_METATYPE(MyStructure)

        // Marshall the MyStructure
    data into a D-Bus argument
        **QDBusArgument**
    &operator<<(**QDBusArgument**  &argument, const MyStructure &mystruct)
        {
    argument.beginStructure();
            argument << mystruct.count <<
    mystruct.name;
            argument.endStructure();
            return argument;
    }

        // Retrieve the MyStructure data from the D-Bus argument
    const **QDBusArgument**  &operator>>(const **QDBusArgument**  &argument,
    MyStructure &mystruct)
        {
            argument.beginStructure();
    argument >> mystruct.count >> mystruct.name;
    argument.endStructure();
            return argument;
        }

    The type has to be registered with **qDBusRegisterMetaType** () before it
    can be used with QDBusArgument. Therefore, somewhere in your program, you
    should add the following code:

    qDBusRegisterMetaType<MyStructure>();

    Once registered, a type can be used in outgoing method calls (placed with
    **QDBusAbstractInterface::call** ()), signal emissions from registered
    objects or in incoming calls from remote applications.

    It is important to note that the `operator<<` and `operator>>` streaming
    functions must always produce the same number of entries in case of
    structures, both in reading and in writing (marshalling and demarshalling),
    otherwise calls and signals may start to silently fail.

    The following example illustrates this wrong usage in context of a class
    that may contain invalid data:

    //bad code
            // Wrongly marshall the MyTime data into a D-Bus argument
    **QDBusArgument**  &operator<<(**QDBusArgument**  &argument, const MyTime
    &mytime)
            {
                argument.beginStructure();
                if
    (mytime.isValid)
                    argument << true << mytime.hour
    << mytime.minute << mytime.second;
                else
                    argument
    << false;
                argument.endStructure();
                return argument;
    }

    In this example, both the `operator<<` and the `operator>>` functions may
    produce a different number of reads/writes. This can confuse the Qt D-Bus
    type system and should be avoided.

    **See also** **QDBusAbstractInterface** , **The Qt D-Bus type system** ,
    **Using Adaptors** , and **qdbus_cast** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#QDBusArgument

        **QDBusArgument::QDBusArgument()**

        Constructs an empty QDBusArgument argument.

        An empty QDBusArgument object does not allow either reading or writing
        to be performed.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDBusArgument") -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#QDBusArgument-1

        **QDBusArgument::QDBusArgument(const QDBusArgument & other )**

        Constructs a copy of the **other** QDBusArgument object.

        Both objects will therefore contain the same state from this point
        forward. QDBusArguments are explicitly shared and, therefore, any
        modification to either copy will affect the other one too.
        """
        ...

    @typing.overload
    def __init__(self, arg: typing.Any, id: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#QDBusArgument

        **QDBusArgument::QDBusArgument()**

        Constructs an empty QDBusArgument argument.

        An empty QDBusArgument object does not allow either reading or writing
        to be performed.
        """
        ...

    def swap(self, other: "QDBusArgument") -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#swap

        **void QDBusArgument::swap(QDBusArgument & other )**

        Swaps this **QDBusArgument**  instance with **other**.
        """
        ...

    def endMapEntry(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#endMapEntry

        **void QDBusArgument::endMapEntry()**

        Closes a D-Bus map entry opened with **beginMapEntry** (). This function
        must be called same number of times that **beginMapEntry** () is called.

        **See also** **beginMapEntry** ().
        """
        ...

    def beginMapEntry(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#beginMapEntry

        **void QDBusArgument::beginMapEntry()**

        Opens a D-Bus map entry suitable for appending the key and value
        entries. This function is only valid when a map has been opened with
        **beginMap** ().

        See **beginMap** () for an example of usage of this function.

        **See also** **endMapEntry** () and **beginMap** ().
        """
        ...

    def endMap(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#endMap

        **void QDBusArgument::endMap()**

        Closes a D-Bus map opened with **beginMap** (). This function must be
        called same number of times that **beginMap** () is called.

        **See also** **beginMap** (), **endStructure** (), and **endArray** ().
        """
        ...

    def beginMap(self, kid: int, vid: int) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#beginMap

        **void QDBusArgument::beginMap(int kid , int vid )**

        Opens a new D-Bus map suitable for appending elements. Maps are
        containers that associate one entry (the key) to another (the value),
        such as Qt's **QMap**  or **QHash** . The ids of the map's key and value
        meta types must be passed in **kid** and **vid** respectively.

        This function is used usually in `operator<<` streaming operators, as in
        the following example:

        // append a dictionary that associates ints to MyValue types
        **QDBusArgument**  &operator<<(**QDBusArgument**  &argument, const
        MyDictionary &mydict)
            {
                argument.beginMap( **QVariant**
        ::Int, **qMetaTypeId** <MyValue>() );
                for ( int i = 0; i <
        mydict.length; ++i ) {
                    argument.beginMapEntry();
        argument << mydict.data[i].key << mydict.data[i].value;
        argument.endMapEntry();
                }
                argument.endMap();
        return argument;
            }

        If the type you want to marshall is a **QMap**  or **QHash** , you need
        not declare an `operator<<` function for it, since Qt D-Bus provides
        generic templates to do the job of marshalling the data.

        **See also** **endMap** (), **beginStructure** (), **beginArray** (),
        and **beginMapEntry** ().
        """
        ...

    def endArray(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#endArray

        **void QDBusArgument::endArray()**

        Closes a D-Bus array opened with **beginArray** (). This function must
        be called same number of times that **beginArray** () is called.

        **See also** **beginArray** (), **endStructure** (), and **endMap** ().
        """
        ...

    def beginArray(self, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#beginArray

        **void QDBusArgument::beginArray(int id )**

        Opens a new D-Bus array suitable for appending elements of meta-type
        **id**.

        This function is used usually in `operator<<` streaming operators, as in
        the following example:

        // append an array of MyElement types
            **QDBusArgument**
        &operator<<(**QDBusArgument**  &argument, const MyArray &myarray)
            {
        argument.beginArray( **qMetaTypeId** <MyElement>() );
                for ( int
        i = 0; i < myarray.length; ++i )
                    argument <<
        myarray.elements[i];
                argument.endArray();
                return
        argument;
            }

        If the type you want to marshall is a **QList** , **QVector**  or any of
        the Qt's **Container Classes**  that take one template parameter, you
        need not declare an `operator<<` function for it, since Qt D-Bus
        provides generic templates to do the job of marshalling the data. The
        same applies for STL's sequence containers, such as `std::list`,
        `std::vector`, etc.

        **See also** **endArray** (), **beginStructure** (), and **beginMap**
        ().
        """
        ...

    def endStructure(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#endStructure

        **void QDBusArgument::endStructure()**

        Closes a D-Bus structure opened with **beginStructure** (). This
        function must be called same number of times that **beginStructure** ()
        is called.

        **See also** **beginStructure** (), **endArray** (), and **endMap** ().
        """
        ...

    def beginStructure(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusargument.html#beginStructure

        **void QDBusArgument::beginStructure()**

        Opens a new D-Bus structure suitable for appending new arguments.

        This function is used usually in `operator<<` streaming operators, as in
        the following example:

        **QDBusArgument**  &operator<<(**QDBusArgument**  &argument, const
        MyStructure &mystruct)
            {
                argument.beginStructure();
        argument << mystruct.member1 << mystruct.member2 << ... ;
        argument.endStructure();
                return argument;
            }

        Structures can contain other structures, so the following code is also
        valid:

        **QDBusArgument**  &operator<<(**QDBusArgument**  &argument, const
        MyStructure &mystruct)
            {
                argument.beginStructure();
        argument << mystruct.member1 << mystruct.member2;
        argument.beginStructure();
                argument <<
        mystruct.member3.subMember1 << mystruct.member3.subMember2;
        argument.endStructure();

                argument << mystruct.member4;
        argument.endStructure();
                return argument;
            }

        **See also** **endStructure** (), **beginArray** (), and **beginMap**
        ().
        """
        ...

    def add(self, arg: typing.Any, id: int = ...) -> None:
        ...
