"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QWriteLocker(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qwritelocker.html

    **Detailed Description**

    The purpose of QWriteLocker (and **QReadLocker** ) is to simplify
    **QReadWriteLock**  locking and unlocking. Locking and unlocking statements
    or in exception handling code is error-prone and difficult to debug.
    QWriteLocker can be used in such situations to ensure that the state of the
    lock is always well-defined.

    Here's an example that uses QWriteLocker to lock and unlock a read-write
    lock for writing:

    **QReadWriteLock**  lock;

        void writeData(const **QByteArray**
    &data)
        {
            **QWriteLocker**  locker(&lock);
            ...
        }

    It is equivalent to the following code:

    **QReadWriteLock**  lock;

        void writeData(const **QByteArray**
    &data)
        {
            lock.lockForWrite();
            ...
            lock.unlock();
    }

    The **QMutexLocker**  documentation shows examples where the use of a locker
    object greatly simplifies programming.

    **See also** **QReadLocker**  and **QReadWriteLock** .
    """

    def __init__(self, areadWriteLock: QReadWriteLock) -> None:
        """
        https://doc.qt.io/qt-5/qwritelocker.html#QWriteLocker

        **QWriteLocker::QWriteLocker(QReadWriteLock * lock )**

        Constructs a QWriteLocker and locks **lock** for writing. The lock will
        be unlocked when the QWriteLocker is destroyed. If `lock` is zero,
        QWriteLocker does nothing.

        **See also** **QReadWriteLock::lockForWrite** ().
        """
        ...

    def __exit__(
        self, type: typing.Any, value: typing.Any, traceback: typing.Any
    ) -> None:
        ...

    def __enter__(self) -> typing.Any:
        ...

    def readWriteLock(self) -> QReadWriteLock:
        """
        https://doc.qt.io/qt-5/qwritelocker.html#readWriteLock

        **QReadWriteLock *QWriteLocker::readWriteLock() const**

        Returns a pointer to the read-write lock that was passed to the
        constructor.
        """
        ...

    def relock(self) -> None:
        """
        https://doc.qt.io/qt-5/qwritelocker.html#relock

        **void QWriteLocker::relock()**

        Relocks an unlocked lock.

        **See also** **unlock** ().
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-5/qwritelocker.html#unlock

        **void QWriteLocker::unlock()**

        Unlocks the lock associated with this locker.

        **See also** **QReadWriteLock::unlock** ().
        """
        ...
