"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QTimeLine(QObject):
    """
    https://doc.qt.io/qt-5/qtimeline.html

    **Detailed Description**

    It's most commonly used to animate a GUI control by calling a slot
    periodically. You can construct a timeline by passing its duration in
    milliseconds to QTimeLine's constructor. The timeline's duration describes
    for how long the animation will run. Then you set a suitable frame range by
    calling **setFrameRange** (). Finally connect the **frameChanged** () signal
    to a suitable slot in the widget you wish to animate (for example,
    **setValue()**  in **QProgressBar** ). When you proceed to calling **start**
    (), QTimeLine will enter Running state, and start emitting **frameChanged**
    () at regular intervals, causing your widget's connected property's value to
    grow from the lower end to the upper and of your frame range, at a steady
    rate. You can specify the update interval by calling **setUpdateInterval**
    (). When done, QTimeLine enters **NotRunning**  state, and emits
    **finished** ().

    Example:

    ...
        progressBar = new **QProgressBar** (this);
    progressBar->setRange(0, 100);

        // Construct a 1-second timeline
    with a frame range of 0 - 100
        **QTimeLine**  *timeLine = new
    **QTimeLine** (1000, this);
        timeLine->setFrameRange(0, 100);
    connect(timeLine, &**QTimeLine** ::frameChanged, progressBar,
    &**QProgressBar** ::setValue);

        // Clicking the push button will
    start the progress bar animation
        pushButton = new **QPushButton**
    (tr("Start animation"), this);
        connect(pushButton, &**QPushButton**
    ::clicked, timeLine, &**QTimeLine** ::start);
        ...

    By default the timeline runs once, from its beginning to its end, upon which
    you must call **start** () again to restart from the beginning. To make the
    timeline loop, you can call **setLoopCount** (), passing the number of times
    the timeline should run before finishing. The direction can also be changed,
    causing the timeline to run backward, by calling **setDirection** (). You
    can also pause and unpause the timeline while it's running by calling
    **setPaused** (). For interactive control, the **setCurrentTime** ()
    function is provided, which sets the time position of the time line
    directly. Although most useful in **NotRunning**  state (e.g., connected to
    a **valueChanged** () signal in a **QSlider** ), this function can be called
    at any time.

    The frame interface is useful for standard widgets, but QTimeLine can be
    used to control any type of animation. The heart of QTimeLine lies in the
    **valueForTime** () function, which generates a **value** between 0 and 1
    for a given time. This value is typically used to describe the steps of an
    animation, where 0 is the first step of an animation, and 1 is the last
    step. When running, QTimeLine generates values between 0 and 1 by calling
    **valueForTime** () and emitting **valueChanged** (). By default,
    **valueForTime** () applies an interpolation algorithm to generate these
    value. You can choose from a set of predefined timeline algorithms by
    calling **setEasingCurve** ().

    Note that, by default, QTimeLine uses **QEasingCurve::InOutSine** , which
    provides a value that grows slowly, then grows steadily, and finally grows
    slowly. For a custom timeline, you can reimplement **valueForTime** (), in
    which case QTimeLine's **easingCurve**  property is ignored.

    **See also** **QProgressBar**  and **QProgressDialog** .
    """

    class State(int):
        NotRunning: QTimeLine = ...
        Paused: QTimeLine = ...
        Running: QTimeLine = ...

    class Direction(int):
        Forward: QTimeLine = ...
        Backward: QTimeLine = ...

    class CurveShape(int):
        EaseInCurve: QTimeLine = ...
        EaseOutCurve: QTimeLine = ...
        EaseInOutCurve: QTimeLine = ...
        LinearCurve: QTimeLine = ...
        SineCurve: QTimeLine = ...
        CosineCurve: QTimeLine = ...

    def __init__(
        self, duration: int = ..., parent: typing.Optional[QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#QTimeLine

        **QTimeLine::QTimeLine(int duration = 1000, QObject * parent =
        nullptr)**

        Constructs a timeline with a duration of **duration** milliseconds.
        **parent** is passed to **QObject** 's constructor. The default duration
        is 1000 milliseconds.
        """
        ...

    def setEasingCurve(
        self, curve: typing.Union[QEasingCurve, QEasingCurve.Type]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#easingCurve-prop

        **easingCurve : QEasingCurve**

        Specifies the easing curve that the timeline will use. If
        **valueForTime** () is reimplemented, this value is ignored. If both
        easingCurve and curveShape are set, the last property set will override
        the previous one.

        This property was introduced in Qt 4.6.

        **Access functions:**

        QEasingCurve **easingCurve** () const
        void **setEasingCurve** (const
        QEasingCurve & **curve** )

        **See also** **valueForTime** ().
        """
        ...

    def easingCurve(self) -> QEasingCurve:
        """
        https://doc.qt.io/qt-5/qtimeline.html#easingCurve-prop

        **easingCurve : QEasingCurve**

        Specifies the easing curve that the timeline will use. If
        **valueForTime** () is reimplemented, this value is ignored. If both
        easingCurve and curveShape are set, the last property set will override
        the previous one.

        This property was introduced in Qt 4.6.

        **Access functions:**

        QEasingCurve **easingCurve** () const
        void **setEasingCurve** (const
        QEasingCurve & **curve** )

        **See also** **valueForTime** ().
        """
        ...

    def timerEvent(self, event: QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#timerEvent

        **[override virtual protected] void QTimeLine::timerEvent(QTimerEvent *
        event )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def toggleDirection(self) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#toggleDirection

        **[slot] void QTimeLine::toggleDirection()**

        Toggles the direction of the timeline. If the direction was Forward, it
        becomes Backward, and vice verca.

        **See also** **setDirection** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#stop

        **[slot] void QTimeLine::stop()**

        Stops the timeline, causing **QTimeLine**  to enter **NotRunning**
        state.

        **See also** **start** ().
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#start

        **[slot] void QTimeLine::start()**

        Starts the timeline. **QTimeLine**  will enter Running state, and once
        it enters the event loop, it will update its current time, frame and
        value at regular intervals. The default interval is 40 ms (i.e., 25
        times per second). You can change the update interval by calling
        **setUpdateInterval** ().

        The timeline will start from position 0, or the end if going backward.
        If you want to resume a stopped timeline without restarting, you can
        call **resume** () instead.

        **See also** **resume** (), **updateInterval** (), **frameChanged** (),
        and **valueChanged** ().
        """
        ...

    def setPaused(self, paused: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#setPaused

        **[slot] void QTimeLine::setPaused(bool paused )**

        If **paused** is true, the timeline is paused, causing **QTimeLine**  to
        enter Paused state. No updates will be signaled until either **start**
        () or setPaused(false) is called. If **paused** is false, the timeline
        is resumed and continues where it left.

        **See also** **state** () and **start** ().
        """
        ...

    def setCurrentTime(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#currentTime-prop

        **currentTime : int**

        This property holds the current time of the time line.

        When **QTimeLine**  is in Running state, this value is updated
        continuously as a function of the duration and direction of the
        timeline. Otherwise, it is value that was current when **stop** () was
        called last, or the value set by setCurrentTime().

        By default, this property contains a value of 0.

        **Access functions:**

        int **currentTime** () const
        void **setCurrentTime** (int **msec** )
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#resume

        **[slot] void QTimeLine::resume()**

        Resumes the timeline from the current time. **QTimeLine**  will reenter
        Running state, and once it enters the event loop, it will update its
        current time, frame and value at regular intervals.

        In contrast to **start** (), this function does not restart the timeline
        before it resumes.

        **See also** **start** (), **updateInterval** (), **frameChanged** (),
        and **valueChanged** ().
        """
        ...

    def valueForTime(self, msec: int) -> float:
        """
        https://doc.qt.io/qt-5/qtimeline.html#valueForTime

        **[virtual] qreal QTimeLine::valueForTime(int msec ) const**

        Returns the timeline value for the time **msec**. The returned value,
        which varies depending on the curve shape, is always between 0 and 1. If
        **msec** is 0, the default implementation always returns 0.

        Reimplement this function to provide a custom curve shape for your
        timeline.

        **See also** **CurveShape**  and **frameForTime** ().
        """
        ...

    def frameForTime(self, msec: int) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#frameForTime

        **int QTimeLine::frameForTime(int msec ) const**

        Returns the frame corresponding to the time **msec**. This value is
        calculated using a linear interpolation of the start and end frame,
        based on the value returned by **valueForTime** ().

        **See also** **valueForTime** () and **setFrameRange** ().
        """
        ...

    def currentValue(self) -> float:
        """
        https://doc.qt.io/qt-5/qtimeline.html#currentValue

        **qreal QTimeLine::currentValue() const**

        Returns the value corresponding to the current time.

        **See also** **valueForTime** () and **currentFrame** ().
        """
        ...

    def currentFrame(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#currentFrame

        **int QTimeLine::currentFrame() const**

        Returns the frame corresponding to the current time.

        **See also** **currentTime** (), **frameForTime** (), and
        **setFrameRange** ().
        """
        ...

    def currentTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#currentTime-prop

        **currentTime : int**

        This property holds the current time of the time line.

        When **QTimeLine**  is in Running state, this value is updated
        continuously as a function of the duration and direction of the
        timeline. Otherwise, it is value that was current when **stop** () was
        called last, or the value set by setCurrentTime().

        By default, this property contains a value of 0.

        **Access functions:**

        int **currentTime** () const
        void **setCurrentTime** (int **msec** )
        """
        ...

    def setCurveShape(self, shape: "QTimeLine.CurveShape") -> None:
        ...

    def curveShape(self) -> "QTimeLine.CurveShape":
        ...

    def setUpdateInterval(self, interval: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#updateInterval-prop

        **updateInterval : int**

        This property holds the time in milliseconds between each time
        **QTimeLine**  updates its current time.

        When updating the current time, **QTimeLine**  will emit
        **valueChanged** () if the current value changed, and **frameChanged**
        () if the frame changed.

        By default, the interval is 40 ms, which corresponds to a rate of 25
        updates per second.

        **Access functions:**

        int **updateInterval** () const
        void **setUpdateInterval** (int
        **interval** )

        **Member Function Documentation**
        """
        ...

    def updateInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#updateInterval-prop

        **updateInterval : int**

        This property holds the time in milliseconds between each time
        **QTimeLine**  updates its current time.

        When updating the current time, **QTimeLine**  will emit
        **valueChanged** () if the current value changed, and **frameChanged**
        () if the frame changed.

        By default, the interval is 40 ms, which corresponds to a rate of 25
        updates per second.

        **Access functions:**

        int **updateInterval** () const
        void **setUpdateInterval** (int
        **interval** )

        **Member Function Documentation**
        """
        ...

    def setFrameRange(self, startFrame: int, endFrame: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#setFrameRange

        **void QTimeLine::setFrameRange(int startFrame , int endFrame )**

        Sets the timeline's frame counter to start at **startFrame** , and end
        and **endFrame**. For each time value, **QTimeLine**  will find the
        corresponding frame when you call **currentFrame** () or
        **frameForTime** () by interpolating, using the return value of
        **valueForTime** ().

        When in Running state, **QTimeLine**  also emits the **frameChanged** ()
        signal when the frame changes.

        **See also** **startFrame** (), **endFrame** (), **start** (), and
        **currentFrame** ().
        """
        ...

    def setEndFrame(self, frame: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#setEndFrame

        **void QTimeLine::setEndFrame(int frame )**

        Sets the end frame, which is the frame corresponding to the end of the
        timeline (i.e., the frame for which the current value is 1), to
        **frame**.

        **See also** **endFrame** (), **startFrame** (), and **setFrameRange**
        ().
        """
        ...

    def endFrame(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#endFrame

        **int QTimeLine::endFrame() const**

        Returns the end frame, which is the frame corresponding to the end of
        the timeline (i.e., the frame for which the current value is 1).

        **See also** **setEndFrame** () and **setFrameRange** ().
        """
        ...

    def setStartFrame(self, frame: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#setStartFrame

        **void QTimeLine::setStartFrame(int frame )**

        Sets the start frame, which is the frame corresponding to the start of
        the timeline (i.e., the frame for which the current value is 0), to
        **frame**.

        **See also** **startFrame** (), **endFrame** (), and **setFrameRange**
        ().
        """
        ...

    def startFrame(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#startFrame

        **int QTimeLine::startFrame() const**

        Returns the start frame, which is the frame corresponding to the start
        of the timeline (i.e., the frame for which the current value is 0).

        **See also** **setStartFrame** () and **setFrameRange** ().
        """
        ...

    def setDuration(self, duration: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#duration-prop

        **duration : int**

        This property holds the total duration of the timeline in milliseconds.

        By default, this value is 1000 (i.e., 1 second), but you can change this
        by either passing a duration to **QTimeLine** 's constructor, or by
        calling setDuration(). The duration must be larger than 0.

        **Note:** Changing the duration does not cause the current time to be
        reset to zero or the new duration. You also need to call
        **setCurrentTime** () with the desired value.

        **Access functions:**

        int **duration** () const
        void **setDuration** (int **duration** )
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#duration-prop

        **duration : int**

        This property holds the total duration of the timeline in milliseconds.

        By default, this value is 1000 (i.e., 1 second), but you can change this
        by either passing a duration to **QTimeLine** 's constructor, or by
        calling setDuration(). The duration must be larger than 0.

        **Note:** Changing the duration does not cause the current time to be
        reset to zero or the new duration. You also need to call
        **setCurrentTime** () with the desired value.

        **Access functions:**

        int **duration** () const
        void **setDuration** (int **duration** )
        """
        ...

    def setDirection(self, direction: "QTimeLine.Direction") -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#direction-prop

        **direction : Direction**

        This property holds the direction of the timeline when **QTimeLine**  is
        in **Running**  state.

        This direction indicates whether the time moves from 0 towards the
        timeline duration, or from the value of the duration and towards 0 after
        **start** () has been called.

        By default, this property is set to **Forward** .

        **Access functions:**

        QTimeLine::Direction **direction** () const
        void **setDirection**
        (QTimeLine::Direction **direction** )
        """
        ...

    def direction(self) -> "QTimeLine.Direction":
        """
        https://doc.qt.io/qt-5/qtimeline.html#direction-prop

        **direction : Direction**

        This property holds the direction of the timeline when **QTimeLine**  is
        in **Running**  state.

        This direction indicates whether the time moves from 0 towards the
        timeline duration, or from the value of the duration and towards 0 after
        **start** () has been called.

        By default, this property is set to **Forward** .

        **Access functions:**

        QTimeLine::Direction **direction** () const
        void **setDirection**
        (QTimeLine::Direction **direction** )
        """
        ...

    def setLoopCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimeline.html#loopCount-prop

        **loopCount : int**

        This property holds the number of times the timeline should loop before
        it's finished.

        A loop count of of 0 means that the timeline will loop forever.

        By default, this property contains a value of 1.

        **Access functions:**

        int **loopCount** () const
        void **setLoopCount** (int **count** )
        """
        ...

    def loopCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtimeline.html#loopCount-prop

        **loopCount : int**

        This property holds the number of times the timeline should loop before
        it's finished.

        A loop count of of 0 means that the timeline will loop forever.

        By default, this property contains a value of 1.

        **Access functions:**

        int **loopCount** () const
        void **setLoopCount** (int **count** )
        """
        ...

    def state(self) -> "QTimeLine.State":
        """
        https://doc.qt.io/qt-5/qtimeline.html#state

        **QTimeLine::State QTimeLine::state() const**

        Returns the state of the timeline.

        **See also** **start** (), **setPaused** (), and **stop** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtimeline.html#finished

        **[signal] void QTimeLine::finished()**

        This signal is emitted when **QTimeLine**  finishes (i.e., reaches the
        end of its time line), and does not loop.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.
        """
        ...

    @property
    def frameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtimeline.html#frameChanged

        **[signal] void QTimeLine::frameChanged(int frame )**

        **QTimeLine**  emits this signal at regular intervals when in
        **Running**  state, but only if the current frame changes. **frame** is
        the current frame number.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **QTimeLine::setFrameRange** () and
        **QTimeLine::updateInterval** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtimeline.html#stateChanged

        **[signal] void QTimeLine::stateChanged(QTimeLine::State newState )**

        This signal is emitted whenever **QTimeLine** 's state changes. The new
        state is **newState**.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.
        """
        ...

    @property
    def valueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtimeline.html#valueChanged

        **[signal] void QTimeLine::valueChanged(qreal value )**

        **QTimeLine**  emits this signal at regular intervals when in
        **Running**  state, but only if the current value changes. **value** is
        the current value. **value** is a number between 0.0 and 1.0

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **QTimeLine::setDuration** (), **QTimeLine::valueForTime**
        (), and **QTimeLine::updateInterval** .
        """
        ...
