"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QRegularExpressionMatchIterator(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html

    **Detailed Description**

    A QRegularExpressionMatchIterator object is a forward only Java-like
    iterator; it can be obtained by calling the
    **QRegularExpression::globalMatch** () function. A new
    QRegularExpressionMatchIterator will be positioned before the first result.
    You can then call the **hasNext** () function to check if there are more
    results available; if so, the **next** () function will return the next
    result and advance the iterator.

    Each result is a **QRegularExpressionMatch**  object holding all the
    information for that result (including captured substrings).

    For instance:

    // extracts the words
        **QRegularExpression**  re("(\\\\w+)");
    **QString**  subject("the quick fox");
    **QRegularExpressionMatchIterator**  i = re.globalMatch(subject);
        while
    (i.hasNext()) {
            **QRegularExpressionMatch**  match = i.next();
    // ...
        }

    Moreover, QRegularExpressionMatchIterator offers a **peekNext** () function
    to get the next result **without** advancing the iterator.

    You can retrieve the **QRegularExpression**  object the subject string was
    matched against by calling the **regularExpression** () function; the match
    type and the match options are available as well by calling the
    **matchType** () and the **matchOptions** () respectively.

    Please refer to the **QRegularExpression**  documentation for more
    information about the Qt regular expression classes.

    **See also** **QRegularExpression**  and **QRegularExpressionMatch** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#QRegularExpr
        essionMatchIterator

        **QRegularExpressionMatchIterator::QRegularExpressionMatchIterator()**

        Constructs an empty, valid QRegularExpressionMatchIterator object. The
        regular expression is set to a default-constructed one; the match type
        to **QRegularExpression::NoMatch**  and the match options to
        **QRegularExpression::NoMatchOption** .

        Invoking the **hasNext** () member function on the constructed object
        will return false, as the iterator is not iterating on a valid sequence
        of matches.

        This function was introduced in Qt 5.1.
        """
        ...

    @typing.overload
    def __init__(self, iterator: "QRegularExpressionMatchIterator") -> None:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#QRegularExpr
        essionMatchIterator-1

        **QRegularExpressionMatchIterator::QRegularExpressionMatchIterator(const
        QRegularExpressionMatchIterator & iterator )**

        Constructs a QRegularExpressionMatchIterator object as a copy of
        **iterator**.

        **See also** **operator=** ().
        """
        ...

    def matchOptions(self) -> QRegularExpression.MatchOptions:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#matchOptions

        **QRegularExpression::MatchOptions
        QRegularExpressionMatchIterator::matchOptions() const**

        Returns the match options that were used to get this
        **QRegularExpressionMatchIterator**  object, that is, the match options
        that were passed to **QRegularExpression::globalMatch** ().

        **See also** **QRegularExpression::globalMatch** (),
        **regularExpression** (), and **matchType** ().
        """
        ...

    def matchType(self) -> QRegularExpression.MatchType:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#matchType

        **QRegularExpression::MatchType
        QRegularExpressionMatchIterator::matchType() const**

        Returns the match type that was used to get this
        **QRegularExpressionMatchIterator**  object, that is, the match type
        that was passed to **QRegularExpression::globalMatch** ().

        **See also** **QRegularExpression::globalMatch** (),
        **regularExpression** (), and **matchOptions** ().
        """
        ...

    def regularExpression(self) -> QRegularExpression:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#regularExpre
        ssion

        **QRegularExpression
        QRegularExpressionMatchIterator::regularExpression() const**

        Returns the **QRegularExpression**  object whose globalMatch() function
        returned this object.

        **See also** **QRegularExpression::globalMatch** (), **matchType** (),
        and **matchOptions** ().
        """
        ...

    def peekNext(self) -> QRegularExpressionMatch:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#peekNext

        **QRegularExpressionMatch QRegularExpressionMatchIterator::peekNext()
        const**

        Returns the next match result without moving the iterator.

        **Note:** Calling this function when the iterator is at the end of the
        result set leads to undefined results.
        """
        ...

    def next(self) -> QRegularExpressionMatch:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#next

        **QRegularExpressionMatch QRegularExpressionMatchIterator::next()**

        Returns the next match result and advances the iterator by one position.

        **Note:** Calling this function when the iterator is at the end of the
        result set leads to undefined results.
        """
        ...

    def hasNext(self) -> bool:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#hasNext

        **bool QRegularExpressionMatchIterator::hasNext() const**

        Returns `true` if there is at least one match result ahead of the
        iterator; otherwise it returns `false`.

        **See also** **next** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#isValid

        **bool QRegularExpressionMatchIterator::isValid() const**

        Returns `true` if the iterator object was obtained as a result from the
        **QRegularExpression::globalMatch** () function invoked on a valid
        **QRegularExpression**  object; returns `false` if the
        **QRegularExpression**  was invalid.

        **See also** **QRegularExpression::globalMatch** () and
        **QRegularExpression::isValid** ().
        """
        ...

    def swap(self, iterator: "QRegularExpressionMatchIterator") -> None:
        """
        https://doc.qt.io/qt-5/qregularexpressionmatchiterator.html#swap

        **void
        QRegularExpressionMatchIterator::swap(QRegularExpressionMatchIterator &
        other )**

        Swaps the iterator **other** with this iterator object. This operation
        is very fast and never fails.
        """
        ...
