"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QDir(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdir.html

    **Detailed Description**

    A QDir is used to manipulate path names, access information regarding paths
    and files, and manipulate the underlying file system. It can also be used to
    access Qt's **resource system** .

    Qt uses "/" as a universal directory separator in the same way that "/" is
    used as a path separator in URLs. If you always use "/" as a directory
    separator, Qt will translate your paths to conform to the underlying
    operating system.

    A QDir can point to a file using either a relative or an absolute path.
    Absolute paths begin with the directory separator (optionally preceded by a
    drive specification under Windows). Relative file names begin with a
    directory name or a file name and specify a path relative to the current
    directory.

    Examples of absolute paths:

    **QDir** ("/home/user/Documents")
        **QDir** ("C:/Documents and Settings")

    On Windows, the second example above will be translated to `C:\\Documents and
    Settings` when used to access files.

    Examples of relative paths:

    **QDir** ("images/landscape.png")

    You can use the **isRelative** () or **isAbsolute** () functions to check if
    a QDir is using a relative or an absolute file path. Call **makeAbsolute**
    () to convert a relative QDir to an absolute one.

    **Navigation and Directory Operations**

    A directory's path can be obtained with the **path** () function, and a new
    path set with the **setPath** () function. The absolute path to a directory
    is found by calling **absolutePath** ().

    The name of a directory is found using the **dirName** () function. This
    typically returns the last element in the absolute path that specifies the
    location of the directory. However, it can also return "." if the QDir
    represents the current directory.

    **QDir** ("Documents/Letters/Applications").dirName() // "Applications"
    **QDir** ().dirName()                                 // "."

    The path for a directory can also be changed with the **cd** () and **cdUp**
    () functions, both of which operate like familiar shell commands. When
    **cd** () is called with the name of an existing directory, the QDir object
    changes directory so that it represents that directory instead. The **cdUp**
    () function changes the directory of the QDir object so that it refers to
    its parent directory; i.e. cd("..") is equivalent to **cdUp** ().

    Directories can be created with **mkdir** (), renamed with **rename** (),
    and removed with **rmdir** ().

    You can test for the presence of a directory with a given name by using
    **exists** (), and the properties of a directory can be tested with
    **isReadable** (), **isAbsolute** (), **isRelative** (), and **isRoot** ().

    The **refresh** () function re-reads the directory's data from disk.

    **Files and Directory Contents**

    Directories contain a number of entries, representing files, directories,
    and symbolic links. The number of entries in a directory is returned by
    **count** (). A string list of the names of all the entries in a directory
    can be obtained with **entryList** (). If you need information about each
    entry, use **entryInfoList** () to obtain a list of **QFileInfo**  objects.

    Paths to files and directories within a directory can be constructed using
    **filePath** () and **absoluteFilePath** (). The **filePath** () function
    returns a path to the specified file or directory relative to the path of
    the QDir object; **absoluteFilePath** () returns an absolute path to the
    specified file or directory. Neither of these functions checks for the
    existence of files or directory; they only construct paths.

    **QDir**  directory("Documents/Letters");
        **QString**  path =
    directory.filePath("contents.txt");
        **QString**  absolutePath =
    directory.absoluteFilePath("contents.txt");

    Files can be removed by using the **remove** () function. Directories cannot
    be removed in the same way as files; use **rmdir** () to remove them
    instead.

    It is possible to reduce the number of entries returned by **entryList** ()
    and **entryInfoList** () by applying filters to a QDir object. You can apply
    a name filter to specify a pattern with wildcards that file names need to
    match, an attribute filter that selects properties of entries and can
    distinguish between files and directories, and a sort order.

    Name filters are lists of strings that are passed to **setNameFilters** ().
    Attribute filters consist of a bitwise OR combination of Filters, and these
    are specified when calling **setFilter** (). The sort order is specified
    using **setSorting** () with a bitwise OR combination of **SortFlags** .

    You can test to see if a filename matches a filter using the **match** ()
    function.

    Filter and sort order flags may also be specified when calling **entryList**
    () and **entryInfoList** () in order to override previously defined
    behavior.

    **The Current Directory and Other Special Paths**

    Access to some common directories is provided with a number of static
    functions that return QDir objects. There are also corresponding functions
    for these that return strings:

    QDir**QString** Return Value
    **current** ()**currentPath** ()The
    application's working directory
    **home** ()**homePath** ()The user's home
    directory
    **root** ()**rootPath** ()The root directory
    **temp**
    ()**tempPath** ()The system's temporary directory

    The **setCurrent** () static function can also be used to set the
    application's working directory.

    If you want to find the directory containing the application's executable,
    see **QCoreApplication::applicationDirPath** ().

    The **drives** () static function provides a list of root directories for
    each device that contains a filing system. On Unix systems this returns a
    list containing a single root directory "/"; on Windows the list will
    usually contain `C:/`, and possibly other drive letters such as `D:/`,
    depending on the configuration of the user's system.

    **Path Manipulation and Strings**

    Paths containing "." elements that reference the current directory at that
    point in the path, ".." elements that reference the parent directory, and
    symbolic links can be reduced to a canonical form using the
    **canonicalPath** () function.

    Paths can also be simplified by using **cleanPath** () to remove redundant
    "/" and ".." elements.

    It is sometimes necessary to be able to show a path in the native
    representation for the user's platform. The static **toNativeSeparators** ()
    function returns a copy of the specified path in which each directory
    separator is replaced by the appropriate separator for the underlying
    operating system.

    **Examples**

    Check if a directory exists:

    **QDir**  dir("example");
        if (!dir.exists())
            **qWarning**
    ("Cannot find the example directory");

    (We could also use the static convenience function **QFile::exists** ().)

    Traversing directories and reading a file:

    **QDir**  dir = **QDir** ::root();                 // "/"
        if
    (!dir.cd("tmp")) {                    // "/tmp"
            **qWarning**
    ("Cannot find the \\"/tmp\\" directory");
        } else {
            **QFile**
    file(dir.filePath("ex1.txt")); // "/tmp/ex1.txt"
            if
    (!file.open(**QIODevice** ::ReadWrite))
                **qWarning** ("Cannot
    create the file %s", file.name());
        }

    A program that lists all the files in the current directory (excluding
    symbolic links), sorted by size, smallest first:

    #include <QDir>
        #include <iostream>

        int main(int argc, char
    *argv[])
        {
            **QCoreApplication**  app(argc, argv);
    **QDir**  dir;
            dir.setFilter(**QDir** ::Files | **QDir** ::Hidden |
    **QDir** ::NoSymLinks);
            dir.setSorting(**QDir** ::Size | **QDir**
    ::Reversed);

            **QFileInfoList**  list = dir.entryInfoList();
    std::cout << "     Bytes Filename" << std::endl;
            for (int i = 0; i <
    list.size(); ++i) {
                **QFileInfo**  fileInfo = list.at(i);
    std::cout << **qPrintable** (**QString** ("%1 %2").arg(fileInfo.size(), 10)
    .arg(fileInfo.fileName()));
                std::cout << std::endl;
            }
    return 0;
        }

    **See also** **QFileInfo** , **QFile** , **QFileDialog** ,
    **QCoreApplication::applicationDirPath** (), and **Find Files Example** .
    """

    class SortFlag(int):
        Name: QDir = ...
        Time: QDir = ...
        Size: QDir = ...
        Unsorted: QDir = ...
        SortByMask: QDir = ...
        DirsFirst: QDir = ...
        Reversed: QDir = ...
        IgnoreCase: QDir = ...
        DirsLast: QDir = ...
        LocaleAware: QDir = ...
        Type: QDir = ...
        NoSort: QDir = ...

    class Filter(int):
        Dirs: QDir = ...
        Files: QDir = ...
        Drives: QDir = ...
        NoSymLinks: QDir = ...
        AllEntries: QDir = ...
        TypeMask: QDir = ...
        Readable: QDir = ...
        Writable: QDir = ...
        Executable: QDir = ...
        PermissionMask: QDir = ...
        Modified: QDir = ...
        Hidden: QDir = ...
        System: QDir = ...
        AccessMask: QDir = ...
        AllDirs: QDir = ...
        CaseSensitive: QDir = ...
        NoDotAndDotDot: QDir = ...
        NoFilter: QDir = ...
        NoDot: QDir = ...
        NoDotDot: QDir = ...

    class Filters(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, f: typing.Union["QDir.Filters", "QDir.Filter"]) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QDir.Filters") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QDir.Filters":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class SortFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, f: typing.Union["QDir.SortFlags", "QDir.SortFlag"]) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QDir.SortFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QDir.SortFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, a0: "QDir") -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#QDir

        **QDir::QDir(const QDir & dir )**

        Constructs a QDir object that is a copy of the QDir object for directory
        **dir**.

        **See also** **operator=** ().
        """
        ...

    @typing.overload
    def __init__(self, path: str = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#QDir-1

        **QDir::QDir(const QString & path = QString())**

        Constructs a QDir pointing to the given directory **path**. If path is
        empty the program's working directory, ("."), is used.

        **See also** **currentPath** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        path: str,
        nameFilter: str,
        sort: "QDir.SortFlags" = ...,
        filters: "QDir.Filters" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#QDir-2

        **QDir::QDir(const QString & path , const QString & nameFilter ,
        QDir::SortFlags sort = SortFlags(Name | IgnoreCase), QDir::Filters
        filters = AllEntries)**

        Constructs a QDir with path **path** , that filters its entries by name
        using **nameFilter** and by attributes using **filters**. It also sorts
        the names using **sort**.

        The default **nameFilter** is an empty string, which excludes nothing;
        the default **filters** is **AllEntries** , which also means exclude
        nothing. The default **sort** is **Name**  | **IgnoreCase** , i.e. sort
        by name case-insensitively.

        If **path** is an empty string, QDir uses "." (the current directory).
        If **nameFilter** is an empty string, QDir uses the name filter "*" (all
        files).

        Note that **path** need not exist.

        **See also** **exists** (), **setPath** (), **setNameFilters** (),
        **setFilter** (), and **setSorting** ().
        """
        ...

    def isEmpty(
        self, filters: typing.Union["QDir.Filters", "QDir.Filter"] = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isEmpty

        **bool QDir::isEmpty(QDir::Filters filters = Filters(AllEntries |
        NoDotAndDotDot)) const**

        Returns whether the directory is empty.

        Equivalent to `count() == 0` with filters `QDir::AllEntries |
        QDir::NoDotAndDotDot`, but faster as it just checks whether the
        directory contains at least one entry.

        **Note:** Unless you set the **filters** flags to include
        `QDir::NoDotAndDotDot` (as the default value does), no directory is
        empty.

        This function was introduced in Qt 5.9.

        **See also** **count** (), **entryList** (), and **setFilter** ().
        """
        ...

    @staticmethod
    def listSeparator() -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#listSeparator

        **[static] QChar QDir::listSeparator()**

        Returns the native path list separator: ':' under Unix and ';' under
        Windows.

        This function was introduced in Qt 5.6.

        **See also** **separator** ().
        """
        ...

    def swap(self, other: "QDir") -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#swap

        **void QDir::swap(QDir & other )**

        Swaps this **QDir**  instance with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def removeRecursively(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#removeRecursively

        **bool QDir::removeRecursively()**

        Removes the directory, including all its contents.

        Returns `true` if successful, otherwise false.

        If a file or directory cannot be removed, removeRecursively() keeps
        going and attempts to delete as many files and sub-directories as
        possible, then returns `false`.

        If the directory was already removed, the method returns `true`
        (expected result already reached).

        Note: this function is meant for removing a small application-internal
        directory (such as a temporary directory), but not user-visible
        directories. For user-visible operations, it is rather recommended to
        report errors more precisely to the user, to offer solutions in case of
        errors, to show progress during the deletion since it could take several
        minutes, etc.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def searchPaths(prefix: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdir.html#searchPaths

        **[static] QStringList QDir::searchPaths(const QString & prefix )**

        Returns the search paths for **prefix**.

        This function was introduced in Qt 4.3.

        **See also** **setSearchPaths** () and **addSearchPath** ().
        """
        ...

    @staticmethod
    def addSearchPath(prefix: str, path: str) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#addSearchPath

        **[static] void QDir::addSearchPath(const QString & prefix , const
        QString & path )**

        Adds **path** to the search path for **prefix**.

        This function was introduced in Qt 4.3.

        **See also** **setSearchPaths** ().
        """
        ...

    @staticmethod
    def setSearchPaths(prefix: str, searchPaths: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#setSearchPaths

        **[static] void QDir::setSearchPaths(const QString & prefix , const
        QStringList & searchPaths )**

        Sets or replaces Qt's search paths for file names with the prefix
        **prefix** to **searchPaths**.

        To specify a prefix for a file name, prepend the prefix followed by a
        single colon (e.g., "images:undo.png", "xmldocs:books.xml"). **prefix**
        can only contain letters or numbers (e.g., it cannot contain a colon,
        nor a slash).

        Qt uses this search path to locate files with a known prefix. The search
        path entries are tested in order, starting with the first entry.

        **QDir** ::setSearchPaths("icons", **QStringList** (**QDir**
        ::homePath() + "/images"));
            **QDir** ::setSearchPaths("docs",
        **QStringList** (":/embeddedDocuments"));
            ...
            **QPixmap**
        pixmap("icons:undo.png"); // will look for undo.png in QDir::homePath()
        + "/images"
            **QFile**  file("docs:design.odf"); // will look in the
        :/embeddedDocuments resource path

        File name prefix must be at least 2 characters long to avoid conflicts
        with Windows drive letters.

        Search paths may contain paths to **The Qt Resource System** .

        This function was introduced in Qt 4.3.

        **See also** **searchPaths** ().
        """
        ...

    @staticmethod
    def fromNativeSeparators(pathName: str) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#fromNativeSeparators

        **[static] QString QDir::fromNativeSeparators(const QString & pathName
        )**

        Returns **pathName** using '/' as file separator. On Windows, for
        instance, fromNativeSeparators("`c:\\\\winnt\\\\system32`") returns
        "c:/winnt/system32".

        The returned string may be the same as the argument on some operating
        systems, for example on Unix.

        This function was introduced in Qt 4.2.

        **See also** **toNativeSeparators** () and **separator** ().
        """
        ...

    @staticmethod
    def toNativeSeparators(pathName: str) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#toNativeSeparators

        **[static] QString QDir::toNativeSeparators(const QString & pathName )**

        Returns **pathName** with the '/' separators converted to separators
        that are appropriate for the underlying operating system.

        On Windows, toNativeSeparators("c:/winnt/system32") returns
        "c:\\winnt\\system32".

        The returned string may be the same as the argument on some operating
        systems, for example on Unix.

        This function was introduced in Qt 4.2.

        **See also** **fromNativeSeparators** () and **separator** ().
        """
        ...

    @staticmethod
    def cleanPath(path: str) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#cleanPath

        **[static] QString QDir::cleanPath(const QString & path )**

        Returns **path** with directory separators normalized (that is,
        platform-native separators converted to "/") and redundant ones removed,
        and "."s and ".."s resolved (as far as possible).

        Symbolic links are kept. This function does not return the canonical
        path, but rather the simplest version of the input. For example,
        "./local" becomes "local", "local/../bin" becomes "bin" and
        "/local/usr/../bin" becomes "/local/bin".

        **See also** **absolutePath** () and **canonicalPath** ().
        """
        ...

    @typing.overload
    @staticmethod
    def match(filters: typing.Iterable[str], fileName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#match

        **[static] bool QDir::match(const QString & filter , const QString &
        fileName )**

        Returns `true` if the **fileName** matches the wildcard (glob) pattern
        **filter** ; otherwise returns `false`. The **filter** may contain
        multiple patterns separated by spaces or semicolons. The matching is
        case insensitive.

        **See also** **QRegularExpression Wildcard Matching** , **entryList**
        (), and **entryInfoList** ().
        """
        ...

    @typing.overload
    @staticmethod
    def match(filter: str, fileName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#match-1

        **[static] bool QDir::match(const QStringList & filters , const QString
        & fileName )**

        This is an overloaded function.

        Returns `true` if the **fileName** matches any of the wildcard (glob)
        patterns in the list of **filters** ; otherwise returns `false`. The
        matching is case insensitive.

        **See also** **QRegularExpression Wildcard Matching** , **entryList**
        (), and **entryInfoList** ().
        """
        ...

    @staticmethod
    def tempPath() -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#tempPath

        **[static] QString QDir::tempPath()**

        Returns the absolute canonical path of the system's temporary directory.

        On Unix/Linux systems this is the path in the `TMPDIR` environment
        variable or `/tmp` if `TMPDIR` is not defined. On Windows this is
        usually the path in the `TEMP` or `TMP` environment variable. The path
        returned by this method doesn't end with a directory separator unless it
        is the root directory (of a drive).

        **See also** **temp** (), **currentPath** (), **homePath** (), and
        **rootPath** ().
        """
        ...

    @staticmethod
    def temp() -> "QDir":
        """
        https://doc.qt.io/qt-5/qdir.html#temp

        **[static] QDir QDir::temp()**

        Returns the system's temporary directory.

        The directory is constructed using the absolute canonical path of the
        temporary directory, ensuring that its **path** () will be the same as
        its **absolutePath** ().

        See **tempPath** () for details.

        **See also** **drives** (), **current** (), **home** (), and **root**
        ().
        """
        ...

    @staticmethod
    def rootPath() -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#rootPath

        **[static] QString QDir::rootPath()**

        Returns the absolute path of the root directory.

        For Unix operating systems this returns "/". For Windows file systems
        this normally returns "c:/".

        **See also** **root** (), **drives** (), **currentPath** (),
        **homePath** (), and **tempPath** ().
        """
        ...

    @staticmethod
    def root() -> "QDir":
        """
        https://doc.qt.io/qt-5/qdir.html#root

        **[static] QDir QDir::root()**

        Returns the root directory.

        The directory is constructed using the absolute path of the root
        directory, ensuring that its **path** () will be the same as its
        **absolutePath** ().

        See **rootPath** () for details.

        **See also** **drives** (), **current** (), **home** (), and **temp**
        ().
        """
        ...

    @staticmethod
    def homePath() -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#homePath

        **[static] QString QDir::homePath()**

        Returns the absolute path of the user's home directory.

        Under Windows this function will return the directory of the current
        user's profile. Typically, this is:

        C:/Documents and Settings/Username

        Use the **toNativeSeparators** () function to convert the separators to
        the ones that are appropriate for the underlying operating system.

        If the directory of the current user's profile does not exist or cannot
        be retrieved, the following alternatives will be checked (in the given
        order) until an existing and available path is found:

        1. The path specified by the `USERPROFILE` environment variable.
          2.
        The path formed by concatenating the `HOMEDRIVE` and `HOMEPATH`
        environment variables.
          3. The path specified by the `HOME` environment
        variable.
          4. The path returned by the **rootPath** () function (which
        uses the `SystemDrive` environment variable)
          5. The `C:/` directory.

        Under non-Windows operating systems the `HOME` environment variable is
        used if it exists, otherwise the path returned by the **rootPath** ().

        **See also** **home** (), **currentPath** (), **rootPath** (), and
        **tempPath** ().
        """
        ...

    @staticmethod
    def home() -> "QDir":
        """
        https://doc.qt.io/qt-5/qdir.html#home

        **[static] QDir QDir::home()**

        Returns the user's home directory.

        The directory is constructed using the absolute path of the home
        directory, ensuring that its **path** () will be the same as its
        **absolutePath** ().

        See **homePath** () for details.

        **See also** **drives** (), **current** (), **root** (), and **temp**
        ().
        """
        ...

    @staticmethod
    def currentPath() -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#currentPath

        **[static] QString QDir::currentPath()**

        Returns the absolute path of the application's current directory. The
        current directory is the last directory set with **QDir::setCurrent** ()
        or, if that was never called, the directory at which this application
        was started at by the parent process.

        **See also** **current** (), **setCurrent** (), **homePath** (),
        **rootPath** (), **tempPath** (), and
        **QCoreApplication::applicationDirPath** ().
        """
        ...

    @staticmethod
    def current() -> "QDir":
        """
        https://doc.qt.io/qt-5/qdir.html#current

        **[static] QDir QDir::current()**

        Returns the application's current directory.

        The directory is constructed using the absolute path of the current
        directory, ensuring that its **path** () will be the same as its
        **absolutePath** ().

        **See also** **currentPath** (), **setCurrent** (), **home** (),
        **root** (), and **temp** ().
        """
        ...

    @staticmethod
    def setCurrent(path: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#setCurrent

        **[static] bool QDir::setCurrent(const QString & path )**

        Sets the application's current working directory to **path**. Returns
        `true` if the directory was successfully changed; otherwise returns
        `false`.

        **See also** **current** (), **currentPath** (), **home** (), **root**
        (), and **temp** ().
        """
        ...

    @staticmethod
    def separator() -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#separator

        **[static] QChar QDir::separator()**

        Returns the native directory separator: "/" under Unix and "\\" under
        Windows.

        You do not need to use this function to build file paths. If you always
        use "/", Qt will translate your paths to conform to the underlying
        operating system. If you want to display paths to the user using their
        operating system's separator use **toNativeSeparators** ().

        **See also** **listSeparator** ().
        """
        ...

    @staticmethod
    def drives() -> typing.List["QFileInfo"]:
        """
        https://doc.qt.io/qt-5/qdir.html#drives

        **[static] QFileInfoList QDir::drives()**

        Returns a list of the root directories on this system.

        On Windows this returns a list of **QFileInfo**  objects containing
        "C:/", "D:/", etc. On other operating systems, it returns a list
        containing just one root directory (i.e. "/").

        **See also** **root** () and **rootPath** ().
        """
        ...

    def refresh(self) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#refresh

        **void QDir::refresh() const**

        Refreshes the directory information.
        """
        ...

    def rename(self, oldName: str, newName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#rename

        **bool QDir::rename(const QString & oldName , const QString & newName
        )**

        Renames a file or directory from **oldName** to **newName** , and
        returns true if successful; otherwise returns `false`.

        On most file systems, rename() fails only if **oldName** does not exist,
        or if a file with the new name already exists. However, there are also
        other reasons why rename() can fail. For example, on at least one file
        system rename() fails if **newName** points to an open file.

        If **oldName** is a file (not a directory) that can't be renamed right
        away, Qt will try to copy **oldName** to **newName** and remove
        **oldName**.

        **See also** **QFile::rename** ().
        """
        ...

    def remove(self, fileName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#remove

        **bool QDir::remove(const QString & fileName )**

        Removes the file, **fileName**.

        Returns `true` if the file is removed successfully; otherwise returns
        `false`.
        """
        ...

    def makeAbsolute(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#makeAbsolute

        **bool QDir::makeAbsolute()**

        Converts the directory path to an absolute path. If it is already
        absolute nothing happens. Returns `true` if the conversion succeeded;
        otherwise returns `false`.

        **See also** **isAbsolute** (), **isAbsolutePath** (), **isRelative**
        (), and **cleanPath** ().
        """
        ...

    def isAbsolute(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isAbsolute

        **bool QDir::isAbsolute() const**

        Returns `true` if the directory's path is absolute; otherwise returns
        `false`. See **isAbsolutePath** ().

        **See also** **isRelative** (), **makeAbsolute** (), and **cleanPath**
        ().
        """
        ...

    def isRelative(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isRelative

        **bool QDir::isRelative() const**

        Returns `true` if the directory path is relative; otherwise returns
        false. (Under Unix a path is relative if it does not start with a "/").

        **See also** **makeAbsolute** (), **isAbsolute** (), **isAbsolutePath**
        (), and **cleanPath** ().
        """
        ...

    @staticmethod
    def isAbsolutePath(path: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isAbsolutePath

        **[static] bool QDir::isAbsolutePath(const QString & path )**

        Returns `true` if **path** is absolute; returns `false` if it is
        relative.

        **Note:** If **path** starts with ':', this function will return `true`
        because paths starting with ':' are treated specially as they denote a
        **QResource** .

        **See also** **isAbsolute** (), **isRelativePath** (), **makeAbsolute**
        (), **cleanPath** (), and **QResource** .
        """
        ...

    @staticmethod
    def isRelativePath(path: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isRelativePath

        **[static] bool QDir::isRelativePath(const QString & path )**

        Returns `true` if **path** is relative; returns `false` if it is
        absolute.

        **See also** **isRelative** (), **isAbsolutePath** (), and
        **makeAbsolute** ().
        """
        ...

    def isRoot(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isRoot

        **bool QDir::isRoot() const**

        Returns `true` if the directory is the root directory; otherwise returns
        `false`.

        Note: If the directory is a symbolic link to the root directory this
        function returns `false`. If you want to test for this use
        **canonicalPath** (), e.g.

        **QDir**  dir("/tmp/root_link");
            dir = dir.canonicalPath();
            if
        (dir.isRoot())
                **qWarning** ("It is a root link");

        **See also** **root** () and **rootPath** ().
        """
        ...

    @typing.overload
    def exists(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#exists

        **bool QDir::exists(const QString & name ) const**

        Returns `true` if the file called **name** exists; otherwise returns
        false.

        Unless **name** contains an absolute file path, the file name is assumed
        to be relative to the directory itself, so this function is typically
        used to check for the presence of files within a directory.

        **See also** **QFileInfo::exists** () and **QFile::exists** ().
        """
        ...

    @typing.overload
    def exists(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#exists-1

        **bool QDir::exists() const**

        This is an overloaded function.

        Returns `true` if the directory exists; otherwise returns `false`. (If a
        file with the same name is found this function will return false).

        The overload of this function that accepts an argument is used to test
        for the presence of files and directories within a directory.

        **See also** **QFileInfo::exists** () and **QFile::exists** ().
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#isReadable

        **bool QDir::isReadable() const**

        Returns `true` if the directory is readable **and** we can open files by
        name; otherwise returns `false`.

        **Warning:** A false value from this function is not a guarantee that
        files in the directory are not accessible.

        **See also** **QFileInfo::isReadable** ().
        """
        ...

    def rmpath(self, dirPath: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#rmpath

        **bool QDir::rmpath(const QString & dirPath ) const**

        Removes the directory path **dirPath**.

        The function will remove all parent directories in **dirPath** ,
        provided that they are empty. This is the opposite of mkpath(dirPath).

        Returns `true` if successful; otherwise returns `false`.

        **See also** **mkpath** ().
        """
        ...

    def mkpath(self, dirPath: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#mkpath

        **bool QDir::mkpath(const QString & dirPath ) const**

        Creates the directory path **dirPath**.

        The function will create all parent directories necessary to create the
        directory.

        Returns `true` if successful; otherwise returns `false`.

        If the path already exists when this function is called, it will return
        true.

        **See also** **rmpath** ().
        """
        ...

    def rmdir(self, dirName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#rmdir

        **bool QDir::rmdir(const QString & dirName ) const**

        Removes the directory specified by **dirName**.

        The directory must be empty for rmdir() to succeed.

        Returns `true` if successful; otherwise returns `false`.

        **See also** **mkdir** ().
        """
        ...

    def mkdir(self, dirName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#mkdir

        **bool QDir::mkdir(const QString & dirName ) const**

        Creates a sub-directory called **dirName**.

        Returns `true` on success; otherwise returns `false`.

        If the directory already exists when this function is called, it will
        return false.

        **See also** **rmdir** ().
        """
        ...

    @typing.overload
    def entryInfoList(
        self,
        filters: typing.Union["QDir.Filters", "QDir.Filter"] = ...,
        sort: typing.Union["QDir.SortFlags", "QDir.SortFlag"] = ...,
    ) -> typing.List["QFileInfo"]:
        """
        https://doc.qt.io/qt-5/qdir.html#entryInfoList

        **QFileInfoList QDir::entryInfoList(const QStringList & nameFilters ,
        QDir::Filters filters = NoFilter, QDir::SortFlags sort = NoSort) const**

        Returns a list of **QFileInfo**  objects for all the files and
        directories in the directory, ordered according to the name and
        attribute filters previously set with **setNameFilters** () and
        **setFilter** (), and sorted according to the flags set with
        **setSorting** ().

        The name filter, file attribute filter, and sorting specification can be
        overridden using the **nameFilters** , **filters** , and **sort**
        arguments.

        Returns an empty list if the directory is unreadable, does not exist, or
        if nothing matches the specification.

        **See also** **entryList** (), **setNameFilters** (), **setSorting** (),
        **setFilter** (), **isReadable** (), and **exists** ().
        """
        ...

    @typing.overload
    def entryInfoList(
        self,
        nameFilters: typing.Iterable[str],
        filters: typing.Union["QDir.Filters", "QDir.Filter"] = ...,
        sort: typing.Union["QDir.SortFlags", "QDir.SortFlag"] = ...,
    ) -> typing.List["QFileInfo"]:
        """
        https://doc.qt.io/qt-5/qdir.html#entryInfoList-1

        **QFileInfoList QDir::entryInfoList(QDir::Filters filters = NoFilter,
        QDir::SortFlags sort = NoSort) const**

        This is an overloaded function.

        Returns a list of **QFileInfo**  objects for all the files and
        directories in the directory, ordered according to the name and
        attribute filters previously set with **setNameFilters** () and
        **setFilter** (), and sorted according to the flags set with
        **setSorting** ().

        The attribute filter and sorting specifications can be overridden using
        the **filters** and **sort** arguments.

        Returns an empty list if the directory is unreadable, does not exist, or
        if nothing matches the specification.

        **See also** **entryList** (), **setNameFilters** (), **setSorting** (),
        **setFilter** (), **isReadable** (), and **exists** ().
        """
        ...

    @typing.overload
    def entryList(
        self,
        filters: typing.Union["QDir.Filters", "QDir.Filter"] = ...,
        sort: typing.Union["QDir.SortFlags", "QDir.SortFlag"] = ...,
    ) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdir.html#entryList

        **QStringList QDir::entryList(const QStringList & nameFilters ,
        QDir::Filters filters = NoFilter, QDir::SortFlags sort = NoSort) const**

        Returns a list of the names of all the files and directories in the
        directory, ordered according to the name and attribute filters
        previously set with **setNameFilters** () and **setFilter** (), and
        sorted according to the flags set with **setSorting** ().

        The name filter, file attribute filter, and sorting specification can be
        overridden using the **nameFilters** , **filters** , and **sort**
        arguments.

        Returns an empty list if the directory is unreadable, does not exist, or
        if nothing matches the specification.

        **See also** **entryInfoList** (), **setNameFilters** (), **setSorting**
        (), and **setFilter** ().
        """
        ...

    @typing.overload
    def entryList(
        self,
        nameFilters: typing.Iterable[str],
        filters: typing.Union["QDir.Filters", "QDir.Filter"] = ...,
        sort: typing.Union["QDir.SortFlags", "QDir.SortFlag"] = ...,
    ) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdir.html#entryList-1

        **QStringList QDir::entryList(QDir::Filters filters = NoFilter,
        QDir::SortFlags sort = NoSort) const**

        This is an overloaded function.

        Returns a list of the names of all the files and directories in the
        directory, ordered according to the name and attribute filters
        previously set with **setNameFilters** () and **setFilter** (), and
        sorted according to the flags set with **setSorting** ().

        The attribute filter and sorting specifications can be overridden using
        the **filters** and **sort** arguments.

        Returns an empty list if the directory is unreadable, does not exist, or
        if nothing matches the specification.

        **Note:** To list symlinks that point to non existing files, **System**
        must be passed to the filter.

        **See also** **entryInfoList** (), **setNameFilters** (), **setSorting**
        (), and **setFilter** ().
        """
        ...

    @staticmethod
    def nameFiltersFromString(nameFilter: str) -> typing.List[str]:
        ...

    def __contains__(self, a0: str) -> int:
        ...

    @typing.overload
    def __getitem__(self, a0: int) -> str:
        ...

    @typing.overload
    def __getitem__(self, a0: slice) -> typing.List[str]:
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qdir.html#count

        **uint QDir::count() const**

        Returns the total number of directories and files in the directory.

        Equivalent to **entryList** ().count().

        **See also** **operator[]** () and **entryList** ().
        """
        ...

    def setSorting(self, sort: typing.Union["QDir.SortFlags", "QDir.SortFlag"]) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#setSorting

        **void QDir::setSorting(QDir::SortFlags sort )**

        Sets the sort order used by **entryList** () and **entryInfoList** ().

        The **sort** is specified by OR-ing values from the enum
        **QDir::SortFlag** .

        **See also** **sorting** () and **SortFlag** .
        """
        ...

    def sorting(self) -> "QDir.SortFlags":
        """
        https://doc.qt.io/qt-5/qdir.html#sorting

        **QDir::SortFlags QDir::sorting() const**

        Returns the value set by **setSorting** ()

        **See also** **setSorting** () and **SortFlag** .
        """
        ...

    def setFilter(self, filter: typing.Union["QDir.Filters", "QDir.Filter"]) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#setFilter

        **void QDir::setFilter(QDir::Filters filters )**

        Sets the filter used by **entryList** () and **entryInfoList** () to
        **filters**. The filter is used to specify the kind of files that should
        be returned by **entryList** () and **entryInfoList** (). See
        **QDir::Filter** .

        **See also** **filter** () and **setNameFilters** ().
        """
        ...

    def filter(self) -> "QDir.Filters":
        """
        https://doc.qt.io/qt-5/qdir.html#filter

        **QDir::Filters QDir::filter() const**

        Returns the value set by **setFilter** ()

        **See also** **setFilter** ().
        """
        ...

    def setNameFilters(self, nameFilters: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#setNameFilters

        **void QDir::setNameFilters(const QStringList & nameFilters )**

        Sets the name filters used by **entryList** () and **entryInfoList** ()
        to the list of filters specified by **nameFilters**.

        Each name filter is a wildcard (globbing) filter that understands `*`
        and `?` wildcards. See **QRegularExpression Wildcard Matching** .

        For example, the following code sets three name filters on a **QDir**
        to ensure that only files with extensions typically used for C++ source
        files are listed:

        **QStringList**  filters;
                filters << "*.cpp" << "*.cxx" <<
        "*.cc";
                dir.setNameFilters(filters);

        **See also** **nameFilters** () and **setFilter** ().
        """
        ...

    def nameFilters(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdir.html#nameFilters

        **QStringList QDir::nameFilters() const**

        Returns the string list set by **setNameFilters** ()

        **See also** **setNameFilters** ().
        """
        ...

    def cdUp(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#cdUp

        **bool QDir::cdUp()**

        Changes directory by moving one directory up from the **QDir** 's
        current directory.

        Returns `true` if the new directory exists; otherwise returns `false`.
        Note that the logical cdUp() operation is not performed if the new
        directory does not exist.

        **See also** **cd** (), **isReadable** (), **exists** (), and **path**
        ().
        """
        ...

    def cd(self, dirName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdir.html#cd

        **bool QDir::cd(const QString & dirName )**

        Changes the **QDir** 's directory to **dirName**.

        Returns `true` if the new directory exists; otherwise returns `false`.
        Note that the logical cd() operation is not performed if the new
        directory does not exist.

        Calling cd("..") is equivalent to calling **cdUp** ().

        **See also** **cdUp** (), **isReadable** (), **exists** (), and **path**
        ().
        """
        ...

    def relativeFilePath(self, fileName: str) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#relativeFilePath

        **QString QDir::relativeFilePath(const QString & fileName ) const**

        Returns the path to **fileName** relative to the directory.

        **QDir**  dir("/home/bob");
            **QString**  s;

            s =
        dir.relativeFilePath("images/file.jpg");     // s is "images/file.jpg"
        s = dir.relativeFilePath("/home/mary/file.txt"); // s is
        "../mary/file.txt"

        **See also** **absoluteFilePath** (), **filePath** (), and
        **canonicalPath** ().
        """
        ...

    def absoluteFilePath(self, fileName: str) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#absoluteFilePath

        **QString QDir::absoluteFilePath(const QString & fileName ) const**

        Returns the absolute path name of a file in the directory. Does **not**
        check if the file actually exists in the directory; but see **exists**
        (). Redundant multiple separators or "." and ".." directories in
        **fileName** are not removed (see **cleanPath** ()).

        **See also** **relativeFilePath** (), **filePath** (), and
        **canonicalPath** ().
        """
        ...

    def filePath(self, fileName: str) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#filePath

        **QString QDir::filePath(const QString & fileName ) const**

        Returns the path name of a file in the directory. Does **not** check if
        the file actually exists in the directory; but see **exists** (). If the
        **QDir**  is relative the returned path name will also be relative.
        Redundant multiple separators or "." and ".." directories in
        **fileName** are not removed (see **cleanPath** ()).

        **See also** **dirName** (), **absoluteFilePath** (), **isRelative** (),
        and **canonicalPath** ().
        """
        ...

    def dirName(self) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#dirName

        **QString QDir::dirName() const**

        Returns the name of the directory; this is **not** the same as the path,
        e.g. a directory with the name "mail", might have the path
        "/var/spool/mail". If the directory has no name (e.g. it is the root
        directory) an empty string is returned.

        No check is made to ensure that a directory with this name actually
        exists; but see **exists** ().

        **See also** **path** (), **filePath** (), **absolutePath** (), and
        **absoluteFilePath** ().
        """
        ...

    def canonicalPath(self) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#canonicalPath

        **QString QDir::canonicalPath() const**

        Returns the canonical path, i.e. a path without symbolic links or
        redundant "." or ".." elements.

        On systems that do not have symbolic links this function will always
        return the same string that **absolutePath** () returns. If the
        canonical path does not exist (normally due to dangling symbolic links)
        canonicalPath() returns an empty string.

        Example:

        **QString**  bin = "/local/bin";         // where /local/bin is a
        symlink to /usr/bin
            **QDir**  binDir(bin);
            **QString**
        canonicalBin = binDir.canonicalPath();
            // canonicalBin now equals
        "/usr/bin"

            **QString**  ls = "/local/bin/ls";       // where ls
        is the executable "ls"
            **QDir**  lsDir(ls);
            **QString**
        canonicalLs = lsDir.canonicalPath();
            // canonicalLS now equals
        "/usr/bin/ls".

        **See also** **path** (), **absolutePath** (), **exists** (),
        **cleanPath** (), **dirName** (), and **absoluteFilePath** ().
        """
        ...

    def absolutePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#absolutePath

        **QString QDir::absolutePath() const**

        Returns the absolute path (a path that starts with "/" or with a drive
        specification), which may contain symbolic links, but never contains
        redundant ".", ".." or multiple separators.

        **See also** **setPath** (), **canonicalPath** (), **exists** (),
        **cleanPath** (), **dirName** (), and **absoluteFilePath** ().
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-5/qdir.html#path

        **QString QDir::path() const**

        Returns the path. This may contain symbolic links, but never contains
        redundant ".", ".." or multiple separators.

        The returned path can be either absolute or relative (see **setPath**
        ()).

        **See also** **setPath** (), **absolutePath** (), **exists** (),
        **cleanPath** (), **dirName** (), **absoluteFilePath** (),
        **toNativeSeparators** (), and **makeAbsolute** ().
        """
        ...

    def setPath(self, path: str) -> None:
        """
        https://doc.qt.io/qt-5/qdir.html#setPath

        **void QDir::setPath(const QString & path )**

        Sets the path of the directory to **path**. The path is cleaned of
        redundant ".", ".." and of multiple separators. No check is made to see
        whether a directory with this path actually exists; but you can check
        for yourself using **exists** ().

        The path can be either absolute or relative. Absolute paths begin with
        the directory separator "/" (optionally preceded by a drive
        specification under Windows). Relative file names begin with a directory
        name or a file name and specify a path relative to the current
        directory. An example of an absolute path is the string "/tmp/quartz", a
        relative path might look like "src/fatlib".

        **See also** **path** (), **absolutePath** (), **exists** (),
        **cleanPath** (), **dirName** (), **absoluteFilePath** (),
        **isRelative** (), and **makeAbsolute** ().
        """
        ...
