"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QCollator(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcollator.html

    **Detailed Description**

    QCollator is initialized with a **QLocale**  and an optional collation
    strategy. It tries to initialize the collator with the specified values. The
    collator can then be used to compare and sort strings in a locale dependent
    fashion.

    A QCollator object can be used together with template based sorting
    algorithms such as std::sort to sort a list of QStrings.

    In addition to the locale and collation strategy, several optional flags can
    be set that influence the result of the collation.
    """

    @typing.overload
    def __init__(self, locale: "QLocale" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#QCollator

        **QCollator::QCollator()**

        Constructs a QCollator using the system's default collation locale.

        This function was introduced in Qt 5.13.

        **See also** **setLocale** () and **QLocale::collation** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QCollator") -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#QCollator-1

        **QCollator::QCollator(const QLocale & locale )**

        Constructs a QCollator from **locale**.

        **See also** **setLocale** ().
        """
        ...

    def sortKey(self, string: str) -> QCollatorSortKey:
        """
        https://doc.qt.io/qt-5/qcollator.html#sortKey

        **QCollatorSortKey QCollator::sortKey(const QString & string ) const**

        Returns a sortKey for **string**.

        Creating the sort key is usually somewhat slower, than using the
        **compare** () methods directly. But if the string is compared
        repeatedly (e.g. when sorting a whole list of strings), it's usually
        faster to create the sort keys for each string and then sort using the
        keys.

        **Note:** Not supported with the C (a.k.a. POSIX) locale on Darwin.
        """
        ...

    def compare(self, s1: str, s2: str) -> int:
        """
        https://doc.qt.io/qt-5/qcollator.html#compare

        **int QCollator::compare(QStringView s1 , QStringView s2 ) const**

        Compares **s1** with **s2**.

        Returns an integer less than, equal to, or greater than zero depending
        on whether **s1** sorts before, with or after **s2**.

        This function was introduced in Qt 5.13.
        """
        ...

    def ignorePunctuation(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcollator.html#ignorePunctuation

        **bool QCollator::ignorePunctuation() const**

        Returns `true` if punctuation characters and symbols are ignored when
        determining sort order.

        **See also** **setIgnorePunctuation** ().
        """
        ...

    def setIgnorePunctuation(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#setIgnorePunctuation

        **void QCollator::setIgnorePunctuation(bool on )**

        If **on** is set to true, punctuation characters and symbols are ignored
        when determining sort order.

        The default is locale dependent.

        **Note:** This method is not currently supported if Qt is configured to
        not use ICU on Linux.

        **See also** **ignorePunctuation** ().
        """
        ...

    def numericMode(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcollator.html#numericMode

        **bool QCollator::numericMode() const**

        Returns `true` if numeric sorting is enabled, false otherwise.

        **See also** **setNumericMode** ().
        """
        ...

    def setNumericMode(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#setNumericMode

        **void QCollator::setNumericMode(bool on )**

        Enables numeric sorting mode when **on** is set to true.

        This will enable proper sorting of numeric digits, so that e.g. 100
        sorts after 99.

        By default this mode is off.

        **See also** **numericMode** ().
        """
        ...

    def setCaseSensitivity(self, cs: Qt.CaseSensitivity) -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#setCaseSensitivity

        **void QCollator::setCaseSensitivity(Qt::CaseSensitivity sensitivity )**

        Sets the case **sensitivity** of the collator.

        **See also** **caseSensitivity** ().
        """
        ...

    def caseSensitivity(self) -> Qt.CaseSensitivity:
        """
        https://doc.qt.io/qt-5/qcollator.html#caseSensitivity

        **Qt::CaseSensitivity QCollator::caseSensitivity() const**

        Returns case sensitivity of the collator.

        **See also** **setCaseSensitivity** ().
        """
        ...

    def locale(self) -> "QLocale":
        """
        https://doc.qt.io/qt-5/qcollator.html#locale

        **QLocale QCollator::locale() const**

        Returns the locale of the collator.

        **See also** **setLocale** ().
        """
        ...

    def setLocale(self, locale: "QLocale") -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#setLocale

        **void QCollator::setLocale(const QLocale & locale )**

        Sets the locale of the collator to **locale**.

        **See also** **locale** ().
        """
        ...

    def swap(self, other: "QCollator") -> None:
        """
        https://doc.qt.io/qt-5/qcollator.html#swap

        **void QCollator::swap(QCollator & other )**

        Swaps this collator with **other**. This function is very fast and never
        fails.
        """
        ...
