"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *


class QBuffer(QIODevice):
    """
    https://doc.qt.io/qt-5/qbuffer.html

    **Detailed Description**

    QBuffer allows you to access a **QByteArray**  using the **QIODevice**
    interface. The **QByteArray**  is treated just as a standard random-accessed
    file. Example:

    **QBuffer**  buffer;
            char ch;

            buffer.open(**QBuffer**
    ::ReadWrite);
            buffer.write("Qt rocks!");
            buffer.seek(0);
    buffer.getChar(&ch);  // ch == 'Q'
            buffer.getChar(&ch);  // ch ==
    't'
            buffer.getChar(&ch);  // ch == ' '
            buffer.getChar(&ch);
    // ch == 'r'

    By default, an internal **QByteArray**  buffer is created for you when you
    create a QBuffer. You can access this buffer directly by calling **buffer**
    (). You can also use QBuffer with an existing **QByteArray**  by calling
    **setBuffer** (), or by passing your array to QBuffer's constructor.

    Call **open** () to open the buffer. Then call **write** () or **putChar**
    () to write to the buffer, and **read** (), **readLine** (), **readAll** (),
    or **getChar** () to read from it. **size** () returns the current size of
    the buffer, and you can seek to arbitrary positions in the buffer by calling
    **seek** (). When you are done with accessing the buffer, call **close** ().

    The following code snippet shows how to write data to a **QByteArray**
    using **QDataStream**  and QBuffer:

    **QByteArray**  byteArray;
            **QBuffer**  buffer(&byteArray);
    buffer.open(**QIODevice** ::WriteOnly);

            **QDataStream**
    out(&buffer);
            out << **QApplication** ::palette();

    Effectively, we convert the application's **QPalette**  into a byte array.
    Here's how to read the data from the **QByteArray** :

    **QPalette**  palette;
            **QBuffer**  buffer(&byteArray);
    buffer.open(**QIODevice** ::ReadOnly);

            **QDataStream**
    in(&buffer);
            in >> palette;

    **QTextStream**  and **QDataStream**  also provide convenience constructors
    that take a **QByteArray**  and that create a QBuffer behind the scenes.

    QBuffer emits **readyRead** () when new data has arrived in the buffer. By
    connecting to this signal, you can use QBuffer to store temporary data
    before processing it. QBuffer also emits **bytesWritten** () every time new
    data has been written to the buffer.

    **See also** **QFile** , **QDataStream** , **QTextStream** , and
    **QByteArray** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbuffer.html#QBuffer

        **QBuffer::QBuffer(QObject * parent = nullptr)**

        Constructs an empty buffer with the given **parent**. You can call
        **setData** () to fill the buffer with data, or you can open it in write
        mode and use **write** ().

        **See also** **open** ().
        """
        ...

    @typing.overload
    def __init__(
        self, byteArray: "QByteArray", parent: typing.Optional[QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbuffer.html#QBuffer-1

        **QBuffer::QBuffer(QByteArray * byteArray , QObject * parent =
        nullptr)**

        Constructs a QBuffer that uses the **QByteArray**  pointed to by
        **byteArray** as its internal buffer, and with the given **parent**. The
        caller is responsible for ensuring that **byteArray** remains valid
        until the QBuffer is destroyed, or until **setBuffer** () is called to
        change the buffer. QBuffer doesn't take ownership of the **QByteArray**
        .

        If you open the buffer in write-only mode or read-write mode and write
        something into the QBuffer, **byteArray** will be modified.

        Example:

        **QByteArray**  byteArray("abc");
                **QBuffer**
        buffer(&byteArray);
                buffer.open(**QIODevice** ::WriteOnly);
        buffer.seek(3);
                buffer.write("def", 3);
                buffer.close();
        // byteArray == "abcdef"

        **See also** **open** (), **setBuffer** (), and **setData** ().
        """
        ...

    def disconnectNotify(self, a0: "QMetaMethod") -> None:
        ...

    def connectNotify(self, a0: "QMetaMethod") -> None:
        ...

    def writeData(self, data: bytes) -> int:
        """
        https://doc.qt.io/qt-5/qbuffer.html#writeData

        **[override virtual protected] qint64 QBuffer::writeData(const char *
        data , qint64 len )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...

    def readData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qbuffer.html#readData

        **[override virtual protected] qint64 QBuffer::readData(char * data ,
        qint64 len )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def canReadLine(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbuffer.html#canReadLine

        **[override virtual] bool QBuffer::canReadLine() const**

        Reimplements: **QIODevice::canReadLine** () const.
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbuffer.html#atEnd

        **[override virtual] bool QBuffer::atEnd() const**

        Reimplements: **QIODevice::atEnd** () const.
        """
        ...

    def seek(self, off: int) -> bool:
        """
        https://doc.qt.io/qt-5/qbuffer.html#seek

        **[override virtual] bool QBuffer::seek(qint64 pos )**

        Reimplements: **QIODevice::seek** (qint64 pos).
        """
        ...

    def pos(self) -> int:
        """
        https://doc.qt.io/qt-5/qbuffer.html#pos

        **[override virtual] qint64 QBuffer::pos() const**

        Reimplements: **QIODevice::pos** () const.
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qbuffer.html#size

        **[override virtual] qint64 QBuffer::size() const**

        Reimplements: **QIODevice::size** () const.
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-5/qbuffer.html#close

        **[override virtual] void QBuffer::close()**

        Reimplements: **QIODevice::close** ().
        """
        ...

    def open(
        self, openMode: typing.Union[QIODevice.OpenMode, QIODevice.OpenModeFlag]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qbuffer.html#open

        **[override virtual] bool QBuffer::open(QIODevice::OpenMode flags )**

        Reimplements: **QIODevice::open** (QIODevice::OpenMode mode).
        """
        ...

    @typing.overload
    def setData(self, data: typing.Union["QByteArray", bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qbuffer.html#setData

        **void QBuffer::setData(const QByteArray & data )**

        Sets the contents of the internal buffer to be **data**. This is the
        same as assigning **data** to **buffer** ().

        Does nothing if **isOpen** () is true.

        **See also** **data** () and **setBuffer** ().
        """
        ...

    @typing.overload
    def setData(self, adata: bytes) -> None:
        """
        https://doc.qt.io/qt-5/qbuffer.html#setData-1

        **void QBuffer::setData(const char * data , int size )**

        This is an overloaded function.

        Sets the contents of the internal buffer to be the first **size** bytes
        of **data**.
        """
        ...

    def setBuffer(self, a: "QByteArray") -> None:
        """
        https://doc.qt.io/qt-5/qbuffer.html#setBuffer

        **void QBuffer::setBuffer(QByteArray * byteArray )**

        Makes **QBuffer**  uses the **QByteArray**  pointed to by **byteArray**
        as its internal buffer. The caller is responsible for ensuring that
        **byteArray** remains valid until the **QBuffer**  is destroyed, or
        until setBuffer() is called to change the buffer. **QBuffer**  doesn't
        take ownership of the **QByteArray** .

        Does nothing if **isOpen** () is true.

        If you open the buffer in write-only mode or read-write mode and write
        something into the **QBuffer** , **byteArray** will be modified.

        Example:

        **QByteArray**  byteArray("abc");
                **QBuffer**  buffer;
        buffer.setBuffer(&byteArray);
                buffer.open(**QIODevice**
        ::WriteOnly);
                buffer.seek(3);
                buffer.write("def", 3);
        buffer.close();
                // byteArray == "abcdef"

        If **byteArray** is `nullptr`, the buffer creates its own internal
        **QByteArray**  to work on. This byte array is initially empty.

        **See also** **buffer** (), **setData** (), and **open** ().
        """
        ...

    def data(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbuffer.html#data

        **const QByteArray &QBuffer::data() const**

        Returns the data contained in the buffer.

        This is the same as **buffer** ().

        **See also** **setData** () and **setBuffer** ().
        """
        ...

    def buffer(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbuffer.html#buffer

        **QByteArray &QBuffer::buffer()**

        Returns a reference to the **QBuffer** 's internal buffer. You can use
        it to modify the **QByteArray**  behind the **QBuffer** 's back.

        **See also** **setBuffer** () and **data** ().
        """
        ...
