"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QLowEnergyService(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qlowenergyservice.html

    **Detailed Description**

    QLowEnergyService provides access to the details of Bluetooth Low Energy
    services. The class facilitates the discovery and publification of service
    details, permits reading and writing of the contained data and notifies
    about data changes.

    **Service Structure**

    A Bluetooth Low Energy peripheral device can contain multiple services. In
    turn each service may include further services. This class represents a
    single service of the peripheral device and is created via
    **QLowEnergyController::createServiceObject** (). The **type** () indicates
    whether this service is a primary (top-level) service or whether the service
    is part of another service. Each service may contain one or more
    characteristics and each characteristic may contain descriptors. The
    resulting structure may look like the following diagram:

    ![Structure of a generic peripheral](images/peripheral-structure.png)

    A characteristic is the principal information carrier. It has a **value()**
    and **properties()**  describing the access permissions for the value. The
    general purpose of the contained descriptor is to further define the nature
    of the characteristic. For example, it might specify how the value is meant
    to be interpreted or whether it can notify the value consumer about value
    changes.

    **Service Interaction**

    Once a service object was created for the first time, its details are yet to
    be discovered. This is indicated by its current **state** () being
    **DiscoveryRequired** . It is only possible to retrieve the **serviceUuid**
    () and **serviceName** ().

    The discovery of its included services, characteristics and descriptors is
    triggered when calling **discoverDetails** (). During the discovery the
    **state** () transitions from **DiscoveryRequired**  via
    **DiscoveringServices**  to its final **ServiceDiscovered**  state. This
    transition is advertised via the **stateChanged** () signal. Once the
    details are known, all of the contained characteristics, descriptors and
    included services are known and can be read or written.

    The values of characteristics and descriptors can be retrieved via
    **QLowEnergyCharacteristic**  and **QLowEnergyDescriptor** , respectively.
    However, direct reading or writing of these attributes requires the service
    object. The **readCharacteristic** () function attempts to re-read the value
    of a characteristic. Although the initial service discovery may have
    obtained a value already this call may be required in cases where the
    characteristic value constantly changes without any notifications being
    provided. An example might be a time characteristic that provides a
    continuous value. If the read attempt is successful, the
    **characteristicRead** () signal is emitted. A failure to read the value
    triggers the **CharacteristicReadError** . The **writeCharacteristic** ()
    function attempts to write a new value to the given characteristic. If the
    write attempt is successful, the **characteristicWritten** () signal is
    emitted. A failure to write triggers the **CharacteristicWriteError** .
    Reading and writing of descriptors follows the same pattern.

    Every attempt is made to read or write the value of a descriptor or
    characteristic on the hardware. This means that meta information such as
    **QLowEnergyCharacteristic::properties** () is generally ignored when
    reading and writing. As an example, it is possible to call
    **writeCharacteristic** () despite the characteristic being read-only based
    on its meta data description. The resulting write request is forwarded to
    the connected device and it is up to the device to respond to the
    potentially invalid request. In this case the result is the emission of the
    **CharacteristicWriteError**  in response to the returned device error. This
    behavior simplifies interaction with devices which report wrong meta
    information. If it was not possible to forward the request to the remote
    device the **OperationError**  is set. A potential reason could be that the
    to-be-written characteristic object does not even belong the current
    service. In summary, the two types of errors permit a quick distinction of
    local and remote error cases.

    All requests are serialised based on First-In First-Out principle. For
    example, issuing a second write request, before the previous write request
    has finished, is delayed until the first write request has finished.

    **Note:** Currently, it is not possible to send signed write or reliable
    write requests.

    In some cases the peripheral generates value updates which the central is
    interested in receiving. In order for a characteristic to support such
    notifications it must have the **QLowEnergyCharacteristic::Notify**  or
    **QLowEnergyCharacteristic::Indicate**  property and a descriptor of type
    **QBluetoothUuid::ClientCharacteristicConfiguration** . Provided those
    conditions are fulfilled notifications can be enabled as shown in the
    following code segment:

    //PreCondition: service details already discovered
    **QLowEnergyCharacteristic**  batteryLevel = service->characteristic(
    **QBluetoothUuid** ::BatteryLevel);
            if (!batteryLevel.isValid())
    return;

            **QLowEnergyDescriptor**  notification =
    batteryLevel.descriptor(
                        **QBluetoothUuid**
    ::ClientCharacteristicConfiguration);
            if (!notification.isValid())
    return;

            // establish hook into notifications
    connect(service, SIGNAL(characteristicChanged(**QLowEnergyCharacteristic**
    ,**QByteArray** )),
                    this,
    SLOT(characteristicChanged(**QLowEnergyCharacteristic** ,**QByteArray** )));
    // enable notification
            service->writeDescriptor(notification,
    **QByteArray** ::fromHex("0100"));

            // disable notification
    //service->writeDescriptor(notification, QByteArray::fromHex("0000"));
    // wait until descriptorWritten() signal is emitted
            // to confirm
    successful write

    The example shows a battery level characteristic which updates the central
    on every value change. The notifications are provided via the
    **characteristicChanged** () signal. More details about this mechanism are
    provided by the **Bluetooth Specification** .

    **Service Data Sharing**

    Each QLowEnergyService instance shares its internal states and information
    with other QLowEnergyService instance of the same service. If one instance
    initiates the discovery of the service details, all remaining instances
    automatically follow. Therefore the following snippet always works:

    QLowEnergyService *first, *second;
            **QLowEnergyController**
    control(remoteDevice);
            control.connectToDevice();

            //
    waiting for connection

            first =
    control.createServiceObject(**QBluetoothUuid** ::BatteryService);
    second = control.createServiceObject(**QBluetoothUuid** ::BatteryService);
    Q_ASSERT(first->state() == QLowEnergyService::DiscoveryRequired);
    Q_ASSERT(first->state() == second->state());
    first->discoverDetails();

            Q_ASSERT(first->state() ==
    QLowEnergyService::DiscoveringServices);
            Q_ASSERT(first->state() ==
    second->state());

    Other operations such as calls to **readCharacteristic** (),
    **readDescriptor** (), **writeCharacteristic** (), **writeDescriptor** () or
    the invalidation of the service due to the related **QLowEnergyController**
    disconnecting from the device are shared the same way.

    **See also** **QLowEnergyController** , **QLowEnergyCharacteristic** , and
    **QLowEnergyDescriptor** .
    """

    class WriteMode(int):
        WriteWithResponse: QLowEnergyService = ...
        WriteWithoutResponse: QLowEnergyService = ...
        WriteSigned: QLowEnergyService = ...

    class ServiceState(int):
        InvalidService: QLowEnergyService = ...
        DiscoveryRequired: QLowEnergyService = ...
        DiscoveringServices: QLowEnergyService = ...
        ServiceDiscovered: QLowEnergyService = ...
        LocalService: QLowEnergyService = ...

    class ServiceError(int):
        NoError: QLowEnergyService = ...
        OperationError: QLowEnergyService = ...
        CharacteristicWriteError: QLowEnergyService = ...
        DescriptorWriteError: QLowEnergyService = ...
        CharacteristicReadError: QLowEnergyService = ...
        DescriptorReadError: QLowEnergyService = ...
        UnknownError: QLowEnergyService = ...

    class ServiceType(int):
        PrimaryService: QLowEnergyService = ...
        IncludedService: QLowEnergyService = ...

    class ServiceTypes(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QLowEnergyService.ServiceTypes", "QLowEnergyService.ServiceType"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QLowEnergyService.ServiceTypes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QLowEnergyService.ServiceTypes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def readDescriptor(self, descriptor: QLowEnergyDescriptor) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#readDescriptor

        **void QLowEnergyService::readDescriptor(const QLowEnergyDescriptor &
        descriptor )**

        Reads the value of **descriptor**. If the operation is successful, the
        **descriptorRead** () signal is emitted; otherwise the
        **DescriptorReadError**  is set.

        All descriptor and characteristic requests towards the same remote
        device are serialised. A queue is employed when issuing multiple
        requests at the same time. The queue does not eliminate duplicated read
        requests for the same descriptor.

        A descriptor can only be read if the service is in the
        **ServiceDiscovered**  state and the descriptor belongs to the service.
        If one of these conditions is not true the
        **QLowEnergyService::OperationError**  is set.

        This function was introduced in Qt 5.5.

        **See also** **descriptorRead** () and **writeDescriptor** ().
        """
        ...

    def readCharacteristic(self, characteristic: QLowEnergyCharacteristic) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#readCharacteristic

        **void QLowEnergyService::readCharacteristic(const
        QLowEnergyCharacteristic & characteristic )**

        Reads the value of **characteristic**. If the operation is successful,
        the **characteristicRead** () signal is emitted; otherwise the
        **CharacteristicReadError**  is set. In general, a **characteristic** is
        readable, if its **QLowEnergyCharacteristic::Read**  property is set.

        All descriptor and characteristic requests towards the same remote
        device are serialised. A queue is employed when issuing multiple
        requests at the same time. The queue does not eliminate duplicated read
        requests for the same characteristic.

        A characteristic can only be read if the service is in the
        **ServiceDiscovered**  state and belongs to the service. If one of these
        conditions is not true the **QLowEnergyService::OperationError**  is
        set.

        **Note:** Calling this function despite
        **QLowEnergyCharacteristic::properties** () reporting a non-readable
        property always attempts to read the characteristic's value on the
        hardware. If the hardware returns with an error the
        **CharacteristicReadError**  is set.

        This function was introduced in Qt 5.5.

        **See also** **characteristicRead** () and **writeCharacteristic** ().
        """
        ...

    def writeDescriptor(
        self,
        descriptor: QLowEnergyDescriptor,
        newValue: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#writeDescriptor

        **void QLowEnergyService::writeDescriptor(const QLowEnergyDescriptor &
        descriptor , const QByteArray & newValue )**

        Writes **newValue** as value for **descriptor**. The exact semantics
        depend on the role that the associated controller object is in.

        **Central role**

        A call to this function results in a write request to the remote device.
        If the operation is successful, the **descriptorWritten** () signal is
        emitted; otherwise the **DescriptorWriteError**  is emitted.

        All descriptor and characteristic requests towards the same remote
        device are serialised. A queue is employed when issuing multiple write
        requests at the same time. The queue does not eliminate duplicated write
        requests for the same descriptor. For example, if the same descriptor is
        set to the value A and immediately afterwards to B, the two write
        request are executed in the given order.

        A descriptor can only be written if this service is in the
        **ServiceDiscovered**  state, belongs to the service. If one of these
        conditions is not true the **QLowEnergyService::OperationError**  is
        set.

        **Peripheral Role**

        The value is written to the local service database. If the contents of
        **newValue** are not valid for **descriptor** , the behavior is
        unspecified.

        **See also** **descriptorWritten** () and **readDescriptor** ().
        """
        ...

    def writeCharacteristic(
        self,
        characteristic: QLowEnergyCharacteristic,
        newValue: typing.Union[QtCore.QByteArray, bytes, bytearray],
        mode: "QLowEnergyService.WriteMode" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#writeCharacteristic

        **void QLowEnergyService::writeCharacteristic(const
        QLowEnergyCharacteristic & characteristic , const QByteArray & newValue
        , QLowEnergyService::WriteMode mode = WriteWithResponse)**

        Writes **newValue** as value for the **characteristic**. The exact
        semantics depend on the role that the associated controller object is
        in.

        **Central role**

        The call results in a write request or command to a remote peripheral.
        If the operation is successful, the **characteristicWritten** () signal
        is emitted; otherwise the **CharacteristicWriteError**  is set. Calling
        this function does not trigger the a **characteristicChanged** () signal
        unless the peripheral itself changes the value again after the current
        write request.

        The **mode** parameter determines whether the remote device should send
        a write confirmation. The to-be-written **characteristic** must support
        the relevant write mode. The characteristic's supported write modes are
        indicated by its **QLowEnergyCharacteristic::Write**  and
        **QLowEnergyCharacteristic::WriteNoResponse**  properties.

        All descriptor and characteristic write requests towards the same remote
        device are serialised. A queue is employed when issuing multiple write
        requests at the same time. The queue does not eliminate duplicated write
        requests for the same characteristic. For example, if the same
        descriptor is set to the value A and immediately afterwards to B, the
        two write request are executed in the given order.

        **Note:** Currently, it is not possible to use signed or reliable writes
        as defined by the Bluetooth specification.

        A characteristic can only be written if this service is in the
        **ServiceDiscovered**  state and belongs to the service. If one of these
        conditions is not true the **QLowEnergyService::OperationError**  is
        set.

        **Note:** Calling this function despite
        **QLowEnergyCharacteristic::properties** () reporting a non-writable
        property always attempts to write to the hardware. Similarly, a
        **WriteWithoutResponse**  is sent to the hardware too although the
        characteristic may only support **WriteWithResponse** . If the hardware
        returns with an error the **CharacteristicWriteError**  is set.

        **Peripheral role**

        The call results in the value of the characteristic getting updated in
        the local database.

        If a client is currently connected and it has enabled notifications or
        indications for the characteristic, the respective information will be
        sent. If a device has enabled notifications or indications for the
        characteristic and that device is currently not connected, but a bond
        exists between it and the local device, then the notification or
        indication will be sent on the next reconnection.

        If there is a constraint on the length of the characteristic value and
        **newValue** does not adhere to that constraint, the behavior is
        unspecified.

        **Note:** The **mode** argument is ignored in peripheral mode.

        **See also** **QLowEnergyService::characteristicWritten** () and
        **QLowEnergyService::readCharacteristic** ().
        """
        ...

    @typing.overload
    def contains(self, characteristic: QLowEnergyCharacteristic) -> bool:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#contains

        **bool QLowEnergyService::contains(const QLowEnergyCharacteristic &
        characteristic ) const**

        Returns `true` if **characteristic** belongs to this service; otherwise
        `false`.

        A characteristic belongs to a service if **characteristics** () contains
        the **characteristic**.
        """
        ...

    @typing.overload
    def contains(self, descriptor: QLowEnergyDescriptor) -> bool:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#contains-1

        **bool QLowEnergyService::contains(const QLowEnergyDescriptor &
        descriptor ) const**

        Returns `true` if **descriptor** belongs to this service; otherwise
        `false`.
        """
        ...

    def discoverDetails(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#discoverDetails

        **void QLowEnergyService::discoverDetails()**

        Initiates the discovery of the services, characteristics and descriptors
        contained by the service. The discovery process is indicated via the
        **stateChanged** () signal.

        **See also** **state** ().
        """
        ...

    def serviceName(self) -> str:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#serviceName

        **QString QLowEnergyService::serviceName() const**

        Returns the name of the service; otherwise an empty string.

        The returned name can only be retrieved if **serviceUuid** () is a
        **well-known UUID** .
        """
        ...

    def serviceUuid(self) -> QBluetoothUuid:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#serviceUuid

        **QBluetoothUuid QLowEnergyService::serviceUuid() const**

        Returns the UUID of the service; otherwise a null UUID.
        """
        ...

    def characteristics(self) -> typing.List[QLowEnergyCharacteristic]:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#characteristics

        **QList<QLowEnergyCharacteristic> QLowEnergyService::characteristics()
        const**

        Returns all characteristics associated with this `QLowEnergyService`
        instance.

        The returned list is empty if this service instance's
        **discoverDetails** () was not yet called or there are no known
        characteristics.

        **See also** **characteristic** (), **state** (), and
        **discoverDetails** ().
        """
        ...

    def characteristic(self, uuid: QBluetoothUuid) -> QLowEnergyCharacteristic:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#characteristic

        **QLowEnergyCharacteristic QLowEnergyService::characteristic(const
        QBluetoothUuid & uuid ) const**

        Returns the matching characteristic for **uuid** ; otherwise an invalid
        characteristic.

        The returned characteristic is invalid if this service instance's
        **discoverDetails** () was not yet called or there are no
        characteristics with a matching **uuid**.

        **See also** **characteristics** ().
        """
        ...

    def state(self) -> "QLowEnergyService.ServiceState":
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#state

        **QLowEnergyService::ServiceState QLowEnergyService::state() const**

        Returns the current state of the service.

        If the device's service was instantiated for the first time, the
        object's state is **DiscoveryRequired** . The state of all service
        objects which point to the same service on the peripheral device are
        always equal. This is caused by the shared nature of the internal object
        data. Therefore any service object instance created after the first one
        has a state equal to already existing instances.

        A service becomes invalid if the **QLowEnergyController**  disconnects
        from the remote device. An invalid service retains its internal state at
        the time of the disconnect event. This implies that once the service
        details are discovered they can even be retrieved from an invalid
        service. This permits scenarios where the device connection is
        established, the service details are retrieved and the device
        immediately disconnected to permit the next device to connect to the
        peripheral device.

        However, under normal circumstances the connection should remain to
        avoid repeated discovery of services and their details. The discovery
        may take a while and the client can subscribe to ongoing change
        notifications.

        **See also** **stateChanged** ().
        """
        ...

    def type(self) -> "QLowEnergyService.ServiceTypes":
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#type

        **QLowEnergyService::ServiceTypes QLowEnergyService::type() const**

        Returns the type of the service.

        **Note:** The type attribute cannot be relied upon until the service has
        reached the **ServiceDiscovered**  state. This field is initialised with
        **PrimaryService** .

        **Note:** On Android, it is not possible to determine whether a service
        is a primary or secondary service. Therefore all services have the
        **PrimaryService**  flag set.
        """
        ...

    def includedServices(self) -> typing.List[QBluetoothUuid]:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#includedServices

        **QList<QBluetoothUuid> QLowEnergyService::includedServices() const**

        Returns the UUIDs of all services which are included by the current
        service.

        The returned list is empty if this service instance's
        **discoverDetails** () was not yet called or there are no known
        characteristics.

        It is possible that an included service contains yet another service.
        Such second level includes have to be obtained via their relevant first
        level **QLowEnergyService**  instance. Technically, this could create a
        circular dependency.

        **QLowEnergyController::createServiceObject** () should be used to
        obtain service instances for each of the UUIDs.

        **See also** **createServiceObject** ().
        """
        ...

    @property
    def characteristicChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#characteristicChanged

        **[signal] void QLowEnergyService::characteristicChanged(const
        QLowEnergyCharacteristic & characteristic , const QByteArray & newValue
        )**

        If the associated controller object is in the **central**  role, this
        signal is emitted when the value of **characteristic** is changed by an
        event on the peripheral/device side. In that case, the signal emission
        implies that change notifications must have been activated via the
        characteristic's **ClientCharacteristicConfiguration**  descriptor prior
        to the change event on the peripheral. More details on how this might be
        done can be found further **above** .

        If the controller is in the **peripheral**  role, that is, the service
        object was created via **QLowEnergyController::addService** , the signal
        is emitted when a GATT client has written the value of the
        characteristic using a write request or command.

        The **newValue** parameter contains the updated value of the
        **characteristic**.
        """
        ...

    @property
    def characteristicRead(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#characteristicRead

        **[signal] void QLowEnergyService::characteristicRead(const
        QLowEnergyCharacteristic & characteristic , const QByteArray & value )**

        This signal is emitted when the read request for **characteristic**
        successfully returned its **value**. The signal might be triggered by
        calling characteristicRead(). If the read operation is not successful,
        the **error** () signal is emitted using the **CharacteristicReadError**
        flag.

        **Note:** This signal is only emitted for Central Role related use
        cases.

        This function was introduced in Qt 5.5.

        **See also** **readCharacteristic** ().
        """
        ...

    @property
    def characteristicWritten(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#characteristicWritten

        **[signal] void QLowEnergyService::characteristicWritten(const
        QLowEnergyCharacteristic & characteristic , const QByteArray & newValue
        )**

        This signal is emitted when the value of **characteristic** is
        successfully changed to **newValue**. The change must have been
        triggered by calling **writeCharacteristic** (). If the write operation
        is not successful, the **error** () signal is emitted using the
        **CharacteristicWriteError**  flag.

        The reception of the written signal can be considered as a sign that the
        target device received the to-be-written value and reports back the
        status of write request.

        **Note:** If **writeCharacteristic** () is called using the
        **WriteWithoutResponse**  mode, this signal and the **error** () are
        never emitted.

        **Note:** This signal is only emitted for Central Role related use
        cases.

        **See also** **writeCharacteristic** ().
        """
        ...

    @property
    def descriptorRead(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#descriptorRead

        **[signal] void QLowEnergyService::descriptorRead(const
        QLowEnergyDescriptor & descriptor , const QByteArray & value )**

        This signal is emitted when the read request for **descriptor**
        successfully returned its **value**. The signal might be triggered by
        calling descriptorRead(). If the read operation is not successful, the
        **error** () signal is emitted using the **DescriptorReadError**  flag.

        **Note:** This signal is only emitted for Central Role related use
        cases.

        This function was introduced in Qt 5.5.

        **See also** **readDescriptor** ().
        """
        ...

    @property
    def descriptorWritten(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#descriptorWritten

        **[signal] void QLowEnergyService::descriptorWritten(const
        QLowEnergyDescriptor & descriptor , const QByteArray & newValue )**

        This signal is emitted when the value of **descriptor** is successfully
        changed to **newValue**. If the associated controller object is in the
        **central**  role, the change must have been caused by calling
        **writeDescriptor** (). Otherwise, the signal is the result of a write
        request or command from a GATT client to the respective descriptor.

        **See also** **writeDescriptor** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#error

        **QLowEnergyService::ServiceError QLowEnergyService::error() const**

        Returns the last occurred error or **NoError** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergyservice.html#stateChanged

        **[signal] void
        QLowEnergyService::stateChanged(QLowEnergyService::ServiceState newState
        )**

        This signal is emitted when the service's state changes. The
        **newState** can also be retrieved via **state** ().

        **See also** **state** ().
        """
        ...
