"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QLowEnergyController(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qlowenergycontroller.html

    **Detailed Description**

    QLowEnergyController acts as the entry point for Bluetooth Low Energy
    development.

    Bluetooth Low Energy defines two types of devices; the peripheral and the
    central. Each role performs a different task. The peripheral device provides
    data which is utilized by central devices. An example might be a humidity
    sensor which measures the moisture in a winter garden. A device such as a
    mobile phone might read the sensor's value and display it to the user in the
    greater context of all sensors in the same environment. In this case the
    sensor is the peripheral device and the mobile phone acts as the central
    device.

    A controller in the central role is created via the **createCentral** ()
    factory method. Such an object essentially acts as a placeholder towards a
    remote Low Energy peripheral device, enabling features such as service
    discovery and state tracking.

    After having created a controller object in the central role, the first step
    is to establish a connection via **connectToDevice** (). Once the connection
    has been established, the controller's **state** () changes to
    **QLowEnergyController::ConnectedState**  and the **connected** () signal is
    emitted. It is important to mention that some platforms such as a **BlueZ**
    based Linux cannot maintain two connected instances of
    **QLowEnergyController**  to the same remote device. In such cases the
    second call to **connectToDevice** () may fail. This limitation may
    disappear at some stage in the future. The **disconnectFromDevice** ()
    function is used to break the existing connection.

    The second step after establishing the connection is to discover the
    services offered by the remote peripheral device. This process is started
    via **discoverServices** () and has finished once the **discoveryFinished**
    () signal has been emitted. The discovered services can be enumerated via
    **services** ().

    The last step is to create service objects. The **createServiceObject** ()
    function acts as factory for each service object and expects the service
    UUID as parameter. The calling context should take ownership of the returned
    **QLowEnergyService**  instance.

    Any **QLowEnergyService** , **QLowEnergyCharacteristic**  or
    **QLowEnergyDescriptor**  instance which is later created from this
    controller's connection becomes invalid as soon as the controller
    disconnects from the remote Bluetooth Low Energy device.

    A controller in the peripheral role is created via the **createPeripheral**
    () factory method. Such an object acts as a peripheral device itself,
    enabling features such as advertising services and allowing clients to get
    notified about changes to characteristic values.

    After having created a controller object in the peripheral role, the first
    step is to populate the set of GATT services offered to client devices via
    calls to **addService** (). Afterwards, one would call **startAdvertising**
    () to let the device broadcast some data and, depending on the type of
    advertising being done, also listen for incoming connections from GATT
    clients.

    **See also** **QLowEnergyService** , **QLowEnergyCharacteristic** ,
    **QLowEnergyDescriptor** , **QLowEnergyAdvertisingParameters** , and
    **QLowEnergyAdvertisingData** .
    """

    class Role(int):
        CentralRole: QLowEnergyController = ...
        PeripheralRole: QLowEnergyController = ...

    class RemoteAddressType(int):
        PublicAddress: QLowEnergyController = ...
        RandomAddress: QLowEnergyController = ...

    class ControllerState(int):
        UnconnectedState: QLowEnergyController = ...
        ConnectingState: QLowEnergyController = ...
        ConnectedState: QLowEnergyController = ...
        DiscoveringState: QLowEnergyController = ...
        DiscoveredState: QLowEnergyController = ...
        ClosingState: QLowEnergyController = ...
        AdvertisingState: QLowEnergyController = ...

    class Error(int):
        NoError: QLowEnergyController = ...
        UnknownError: QLowEnergyController = ...
        UnknownRemoteDeviceError: QLowEnergyController = ...
        NetworkError: QLowEnergyController = ...
        InvalidBluetoothAdapterError: QLowEnergyController = ...
        ConnectionError: QLowEnergyController = ...
        AdvertisingError: QLowEnergyController = ...
        RemoteHostClosedError: QLowEnergyController = ...
        AuthorizationError: QLowEnergyController = ...

    @typing.overload
    def __init__(
        self,
        remoteDevice: QBluetoothDeviceInfo,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        ...

    @typing.overload
    def __init__(
        self,
        remoteDevice: QBluetoothAddress,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        ...

    @typing.overload
    def __init__(
        self,
        remoteDevice: QBluetoothAddress,
        localDevice: QBluetoothAddress,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        ...

    def remoteDeviceUuid(self) -> QBluetoothUuid:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#remoteDeviceUuid

        **QBluetoothUuid QLowEnergyController::remoteDeviceUuid() const**

        Returns the unique identifier of the remote Bluetooth Low Energy device.

        On macOS/iOS/tvOS CoreBluetooth does not expose/accept hardware
        addresses for LE devices; instead developers are supposed to use unique
        128-bit UUIDs, generated by CoreBluetooth. These UUIDS will stay
        constant for the same central <-> peripheral pair and we use them when
        connecting to a remote device. For a controller in the **CentralRole** ,
        this value will always be the one passed in when the controller object
        was created. For a controller in the **PeripheralRole** , this value is
        invalid.

        This function was introduced in Qt 5.8.
        """
        ...

    def role(self) -> "QLowEnergyController.Role":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#role

        **QLowEnergyController::Role QLowEnergyController::role() const**

        Returns the role that this controller object is in.

        The role is determined when constructing a **QLowEnergyController**
        instance using **createCentral** () or **createPeripheral** ().

        This function was introduced in Qt 5.7.
        """
        ...

    def requestConnectionUpdate(
        self, parameters: QLowEnergyConnectionParameters
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#requestConnectionUpdate

        **void QLowEnergyController::requestConnectionUpdate(const
        QLowEnergyConnectionParameters & parameters )**

        Requests the controller to update the connection according to
        **parameters**. If the request is successful, the **connectionUpdated**
        () signal will be emitted with the actual new parameters. See the
        **QLowEnergyConnectionParameters**  class for more information on
        connection parameters.

        Android only indirectly permits the adjustment of this parameter set.
        The connection parameters are separated into three categories (high, low
        & balanced priority). Each category implies a pre-configured set of
        values for **QLowEnergyConnectionParameters::minimumInterval** (),
        **QLowEnergyConnectionParameters::maximumInterval** () and
        **QLowEnergyConnectionParameters::latency** (). Although the connection
        request is an asynchronous operation, Android does not provide a
        callback stating the result of the request. This is an acknowledged
        Android bug. Due to this bug Android does not emit the
        **connectionUpdated** () signal.

        **Note:** Currently, this functionality is only implemented on Linux and
        Android.

        This function was introduced in Qt 5.7.

        **See also** **connectionUpdated** ().
        """
        ...

    def addService(
        self,
        service: "QLowEnergyServiceData",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> "QLowEnergyService":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#addService

        **QLowEnergyService *QLowEnergyController::addService(const
        QLowEnergyServiceData & service , QObject * parent = nullptr)**

        Constructs and returns a **QLowEnergyService**  object with **parent**
        from **service**. The controller must be in the **PeripheralRole**  and
        in the **UnconnectedState** . The **service** object must be valid.

        **Note:** Once the peripheral instance is disconnected from the remote
        central device or if **disconnectFromDevice** () is manually called,
        every service definition that was previously added via this function is
        removed from the peripheral. Therefore this function must be called
        again before re-advertising this peripheral controller instance. The
        described behavior is connection specific and therefore not dependent on
        whether **stopAdvertising** () was called.

        This function was introduced in Qt 5.7.

        **See also** **stopAdvertising** (), **disconnectFromDevice** (), and
        **QLowEnergyServiceData::addIncludedService** .
        """
        ...

    def stopAdvertising(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#stopAdvertising

        **void QLowEnergyController::stopAdvertising()**

        Stops advertising, if this object is currently in the advertising state.

        The controller has to be in the **PeripheralRole**  for this function to
        work. It does not invalidate services which have previously been added
        via **addService** ().

        This function was introduced in Qt 5.7.

        **See also** **startAdvertising** ().
        """
        ...

    def startAdvertising(
        self,
        parameters: QLowEnergyAdvertisingParameters,
        advertisingData: QLowEnergyAdvertisingData,
        scanResponseData: QLowEnergyAdvertisingData = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#startAdvertising

        **void QLowEnergyController::startAdvertising(const
        QLowEnergyAdvertisingParameters & parameters , const
        QLowEnergyAdvertisingData & advertisingData , const
        QLowEnergyAdvertisingData & scanResponseData =
        QLowEnergyAdvertisingData())**

        Starts advertising the data given in **advertisingData** and
        **scanResponseData** , using the parameters set in **parameters**. The
        controller has to be in the **PeripheralRole** . If **parameters**
        indicates that the advertisement should be connectable, then this
        function also starts listening for incoming client connections.

        Providing **scanResponseData** is not required, as it is not applicable
        for certain configurations of `parameters`. **advertisingData** and
        **scanResponseData** are limited to 31 byte user data. If, for example,
        several 128bit uuids are added to **advertisingData** , the advertised
        packets may not contain all uuids. The existing limit may have caused
        the truncation of uuids. In such cases **scanResponseData** may be used
        for additional information.

        If this object is currently not in the **UnconnectedState** , nothing
        happens.

        **Note:** Advertising will stop automatically once a client connects to
        the local device.

        This function was introduced in Qt 5.7.

        **See also** **stopAdvertising** ().
        """
        ...

    @staticmethod
    def createPeripheral(
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> "QLowEnergyController":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#createPeripheral

        **[static] QLowEnergyController
        *QLowEnergyController::createPeripheral(QObject * parent = nullptr)**

        Returns a new object of this class that is in the **PeripheralRole**
        and has the parent object **parent**. Typically, the next step is to
        call **startAdvertising** () on the returned object.

        The controller uses the local default Bluetooth adapter for the
        connection management.

        This function was introduced in Qt 5.7.

        **See also** **QLowEnergyController::PeripheralRole** .
        """
        ...

    @typing.overload
    @staticmethod
    def createCentral(
        remoteDevice: QBluetoothDeviceInfo,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> "QLowEnergyController":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#createCentral

        **[static] QLowEnergyController
        *QLowEnergyController::createCentral(const QBluetoothDeviceInfo &
        remoteDevice , QObject * parent = nullptr)**

        Returns a new object of this class that is in the **CentralRole**  and
        has the parent object **parent**. The **remoteDevice** refers to the
        device that a connection will be established to later.

        The controller uses the local default Bluetooth adapter for the
        connection management.

        This function was introduced in Qt 5.7.

        **See also** **QLowEnergyController::CentralRole** .
        """
        ...

    @typing.overload
    @staticmethod
    def createCentral(
        remoteDevice: QBluetoothAddress,
        localDevice: QBluetoothAddress,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> "QLowEnergyController":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#createCentral-1

        **[static] QLowEnergyController
        *QLowEnergyController::createCentral(const QBluetoothAddress &
        remoteDevice , const QBluetoothAddress & localDevice , QObject * parent
        = nullptr)**

        Returns a new instance of this class with **parent**.

        The **remoteDevice** must contain the address of the remote Bluetooth
        Low Energy device to which this object should attempt to connect later
        on.

        The connection is established via **localDevice**. If **localDevice** is
        invalid, the local default device is automatically selected. If
        **localDevice** specifies a local device that is not a local Bluetooth
        adapter, **error** () is set to **InvalidBluetoothAdapterError**  once
        **connectToDevice** () is called.

        Note that specifying the local device to be used for the connection is
        only possible when using **BlueZ** . All other platforms do not support
        this feature.

        This function was introduced in Qt 5.14.
        """
        ...

    def remoteName(self) -> str:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#remoteName

        **QString QLowEnergyController::remoteName() const**

        Returns the name of the remote Bluetooth Low Energy device, if the
        controller is in the **CentralRole** . Otherwise the result is
        unspecified.

        This function was introduced in Qt 5.5.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#errorString

        **QString QLowEnergyController::errorString() const**

        Returns a textual representation of the last occurred error. The string
        is translated.
        """
        ...

    def createServiceObject(
        self, service: QBluetoothUuid, parent: typing.Optional[QtCore.QObject] = ...
    ) -> "QLowEnergyService":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#createServiceObject

        **QLowEnergyService *QLowEnergyController::createServiceObject(const
        QBluetoothUuid & serviceUuid , QObject * parent = nullptr)**

        Creates an instance of the service represented by **serviceUuid**. The
        **serviceUuid** parameter must have been obtained via **services** ().

        The caller takes ownership of the returned pointer and may pass a
        **parent** parameter as default owner.

        This function returns a null pointer if no service with **serviceUuid**
        can be found on the remote device or the controller is disconnected.

        This function can return instances for secondary services too. The
        include relationships between services can be expressed via
        **QLowEnergyService::includedServices** ().

        If this function is called multiple times using the same service UUID,
        the returned **QLowEnergyService**  instances share their internal data.
        Therefore if one of the instances initiates the discovery of the service
        details, the other instances automatically transition into the discovery
        state too.

        **See also** **services** ().
        """
        ...

    def services(self) -> typing.List[QBluetoothUuid]:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#services

        **QList<QBluetoothUuid> QLowEnergyController::services() const**

        Returns the list of services offered by the remote device, if the
        controller is in the **CentralRole** . Otherwise, the result is
        unspecified.

        The list contains all primary and secondary services.

        **See also** **createServiceObject** ().
        """
        ...

    def discoverServices(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#discoverServices

        **void QLowEnergyController::discoverServices()**

        Initiates the service discovery process.

        The discovery progress is indicated via the **serviceDiscovered** ()
        signal. The **discoveryFinished** () signal is emitted when the process
        has finished.

        If the controller instance is not connected or the controller has
        performed the service discovery already this function will do nothing.

        **Note:** Some platforms internally cache the service list of a device
        which was discovered in the past. This can be problematic if the remote
        device changed its list of services or their inclusion tree. If this
        behavior is a problem, the best workaround is to temporarily turn
        Bluetooth off. This causes a reset of the cache data. Currently Android
        exhibits such a cache behavior.
        """
        ...

    def disconnectFromDevice(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#disconnectFromDevice

        **void QLowEnergyController::disconnectFromDevice()**

        Disconnects from the remote device.

        Any **QLowEnergyService** , **QLowEnergyCharacteristic**  or
        **QLowEnergyDescriptor**  instance that resulted from the current
        connection is automatically invalidated. Once any of those objects
        become invalid they remain invalid even if this controller object
        reconnects.

        This function does nothing if the controller is in the
        **UnconnectedState** .

        If the controller is in the peripheral role, it stops advertising and
        removes all services which have previously been added via **addService**
        (). To reuse the **QLowEnergyController**  instance the application must
        re-add services and restart the advertising mode by calling
        **startAdvertising** ().

        **See also** **connectToDevice** ().
        """
        ...

    def connectToDevice(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#connectToDevice

        **void QLowEnergyController::connectToDevice()**

        Connects to the remote Bluetooth Low Energy device.

        This function does nothing if the controller's **state** () is not equal
        to **UnconnectedState** . The **connected** () signal is emitted once
        the connection is successfully established.

        On Linux/**BlueZ**  systems, it is not possible to connect to the same
        remote device using two instances of this class. The second call to this
        function may fail with an error. This limitation may be removed in
        future releases.

        **See also** **disconnectFromDevice** ().
        """
        ...

    def setRemoteAddressType(
        self, type: "QLowEnergyController.RemoteAddressType"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#setRemoteAddressType

        **void QLowEnergyController::setRemoteAddressType(QLowEnergyController::
        RemoteAddressType type )**

        Sets the remote address **type**. The type is required to connect to the
        remote Bluetooth Low Energy device.

        This attribute is only required to be set on Linux/**BlueZ**  systems
        with older Linux kernels (v3.3 or lower), or if CAP_NET_ADMIN is not set
        for the executable. The default value of the attribute is
        **RandomAddress** .

        **Note:** All other platforms handle this flag transparently and
        therefore applications can ignore it entirely. On Linux, the address
        type flag is not directly exposed by **BlueZ**  although some use cases
        do require this information. The only way to detect the flag is via the
        Linux kernel's Bluetooth Management API (kernel version 3.4+ required).
        This API requires CAP_NET_ADMIN capabilities though. If the local
        **QtBluetooth**  process has this capability set **QtBluetooth**  will
        use the API. This assumes that **QBluetoothDeviceDiscoveryAgent**  was
        used prior to calling **QLowEnergyController::connectToDevice** ().

        **See also** **remoteAddressType** ().
        """
        ...

    def remoteAddressType(self) -> "QLowEnergyController.RemoteAddressType":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#remoteAddressType

        **QLowEnergyController::RemoteAddressType
        QLowEnergyController::remoteAddressType() const**

        Returns the type of **remoteAddress** (). By default, this value is
        initialized to **PublicAddress** .

        **See also** **setRemoteAddressType** ().
        """
        ...

    def state(self) -> "QLowEnergyController.ControllerState":
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#state

        **QLowEnergyController::ControllerState QLowEnergyController::state()
        const**

        Returns the current state of the controller.

        **See also** **stateChanged** ().
        """
        ...

    def remoteAddress(self) -> QBluetoothAddress:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#remoteAddress

        **QBluetoothAddress QLowEnergyController::remoteAddress() const**

        Returns the address of the remote Bluetooth Low Energy device.

        For a controller in the **CentralRole** , this value will always be the
        one passed in when the controller object was created. For a controller
        in the **PeripheralRole** , this value is the address of the currently
        connected client device. In particular, this address will be invalid if
        the controller is not currently in the **ConnectedState** .
        """
        ...

    def localAddress(self) -> QBluetoothAddress:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#localAddress

        **QBluetoothAddress QLowEnergyController::localAddress() const**

        Returns the address of the local Bluetooth adapter being used for the
        communication.

        If this class instance was requested to use the default adapter but
        there was no default adapter when creating this class instance, the
        returned **QBluetoothAddress**  will be null.

        **See also** **QBluetoothAddress::isNull** ().
        """
        ...

    @property
    def connected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#connected

        **[signal] void QLowEnergyController::connected()**

        This signal is emitted when the controller successfully connects to the
        remote Low Energy device (if the controller is in the **CentralRole** )
        or if a remote Low Energy device connected to the controller (if the
        controller is in the **PeripheralRole** ). On iOS and OS X this signal
        is not reliable if the controller is in the **PeripheralRole**  \\- the
        controller only guesses that some central connected to our peripheral as
        soon as this central tries to write/read a characteristic/descriptor.
        """
        ...

    @property
    def connectionUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#connectionUpdated

        **[signal] void QLowEnergyController::connectionUpdated(const
        QLowEnergyConnectionParameters & newParameters )**

        This signal is emitted when the connection parameters change. This can
        happen as a result of calling **requestConnectionUpdate** () or due to
        other reasons, for instance because the other side of the connection
        requested new parameters. The new values can be retrieved from
        **newParameters**.

        This function was introduced in Qt 5.7.

        **See also** **requestConnectionUpdate** ().
        """
        ...

    @property
    def disconnected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#disconnected

        **[signal] void QLowEnergyController::disconnected()**

        This signal is emitted when the controller disconnects from the remote
        Low Energy device or vice versa. On iOS and OS X this signal is
        unreliable if the controller is in the **PeripheralRole** .
        """
        ...

    @property
    def discoveryFinished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#discoveryFinished

        **[signal] void QLowEnergyController::discoveryFinished()**

        This signal is emitted when the running service discovery finishes. The
        signal is not emitted if the discovery process finishes with an error.

        This signal can only be emitted if the controller is in the
        **CentralRole** .

        **See also** **discoverServices** () and **error** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#error

        **QLowEnergyController::Error QLowEnergyController::error() const**

        Returns the last occurred error or **NoError** .
        """
        ...

    @property
    def serviceDiscovered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#serviceDiscovered

        **[signal] void QLowEnergyController::serviceDiscovered(const
        QBluetoothUuid & newService )**

        This signal is emitted each time a new service is discovered. The
        **newService** parameter contains the UUID of the found service.

        This signal can only be emitted if the controller is in the
        `CentralRole`.

        **See also** **discoverServices** () and **discoveryFinished** ().
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlowenergycontroller.html#stateChanged

        **[signal] void
        QLowEnergyController::stateChanged(QLowEnergyController::ControllerState
        state )**

        This signal is emitted when the controller's state changes. The new
        **state** can also be retrieved via **state** ().

        **See also** **state** ().
        """
        ...
