"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtBluetooth import *


class QBluetoothTransferRequest(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qbluetoothtransferrequest.html

    **Detailed Description**

    QBluetoothTransferRequest is part of the Bluetooth Transfer API and is the
    class holding the information necessary to initiate a transfer over
    Bluetooth.

    **See also** **QBluetoothTransferReply**  and **QBluetoothTransferManager**
    .
    """

    class Attribute(int):
        DescriptionAttribute: QBluetoothTransferRequest = ...
        TimeAttribute: QBluetoothTransferRequest = ...
        TypeAttribute: QBluetoothTransferRequest = ...
        LengthAttribute: QBluetoothTransferRequest = ...
        NameAttribute: QBluetoothTransferRequest = ...

    @typing.overload
    def __init__(self, address: QBluetoothAddress = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferrequest.html#QBluetoothTransfer
        Request

        **QBluetoothTransferRequest::QBluetoothTransferRequest(const
        QBluetoothAddress & address = QBluetoothAddress())**

        Constructs a new Bluetooth transfer request to the device with
        **address**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QBluetoothTransferRequest") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferrequest.html#QBluetoothTransfer
        Request-1

        **QBluetoothTransferRequest::QBluetoothTransferRequest(const
        QBluetoothTransferRequest & other )**

        Constructs a new Bluetooth transfer request that is a copy of **other**.
        """
        ...

    def address(self) -> QBluetoothAddress:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferrequest.html#address

        **QBluetoothAddress QBluetoothTransferRequest::address() const**

        Returns the address associated with the Bluetooth transfer request.
        """
        ...

    def setAttribute(
        self, code: "QBluetoothTransferRequest.Attribute", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferrequest.html#setAttribute

        **void QBluetoothTransferRequest::setAttribute(QBluetoothTransferRequest
        ::Attribute code , const QVariant & value )**

        Sets the attribute associated with **code** to **value**. If the
        attribute is already set, the previous value is discarded. If **value**
        is an invalid **QVariant** , the attribute is unset.

        **See also** **attribute** () and
        **QBluetoothTransferRequest::Attribute** .
        """
        ...

    def attribute(
        self,
        code: "QBluetoothTransferRequest.Attribute",
        defaultValue: typing.Any = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferrequest.html#attribute

        **QVariant QBluetoothTransferRequest::attribute(QBluetoothTransferReques
        t::Attribute code , const QVariant & defaultValue = QVariant()) const**

        Returns the attribute associated with **code**. If the attribute has not
        been set, it returns **defaultValue**.

        **See also** **setAttribute** () and
        **QBluetoothTransferRequest::Attribute** .
        """
        ...
