"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip


class QBluetoothAddress(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qbluetoothaddress.html

    **Detailed Description**

    This class holds a Bluetooth address in a platform- and protocol-independent
    manner.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#QBluetoothAddress

        **QBluetoothAddress::QBluetoothAddress()**

        Constructs an null Bluetooth address.
        """
        ...

    @typing.overload
    def __init__(self, address: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#QBluetoothAddress-1

        **QBluetoothAddress::QBluetoothAddress(quint64 address )**

        Constructs a new Bluetooth address and assigns **address** to it.
        """
        ...

    @typing.overload
    def __init__(self, address: str) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#QBluetoothAddress-2

        **QBluetoothAddress::QBluetoothAddress(const QString & address )**

        Constructs a new Bluetooth address and assigns **address** to it.

        The format of **address** can be either XX:XX:XX:XX:XX:XX or
        XXXXXXXXXXXX, where X is a hexadecimal digit. Case is not important.
        """
        ...

    @typing.overload
    def __init__(self, other: "QBluetoothAddress") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#QBluetoothAddress-3

        **QBluetoothAddress::QBluetoothAddress(const QBluetoothAddress & other
        )**

        Constructs a new Bluetooth address which is a copy of **other**.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#toString

        **QString QBluetoothAddress::toString() const**

        Returns the Bluetooth address as a string of the form,
        XX:XX:XX:XX:XX:XX.
        """
        ...

    def toUInt64(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#toUInt64

        **quint64 QBluetoothAddress::toUInt64() const**

        Returns this Bluetooth address as a quint64.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#clear

        **void QBluetoothAddress::clear()**

        Sets the Bluetooth address to 00:00:00:00:00:00.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothaddress.html#isNull

        **bool QBluetoothAddress::isNull() const**

        Returns true if the Bluetooth address is null, otherwise returns false.
        """
        ...
