# pyots (PYthon OT Sanitizer)
Python wrapper for [OpenType Sanitizer](https://github.com/khaledhosny/ots).
Similar to and partially based on
[ots-python](https://github.com/googlefonts/ots-python), but builds OTS as a
Python C Extension (instead of as an executable and calling through
`subprocess` as ots-python does).

**NOTE:** Although this package is similar to
**ots-python**, it is _not_ a drop-in replacement for it, as the Python API is
different.

# Requirements
 - Python 3.6 or later is recommended. It is possible this will build with
other/older Pythons, but that has not been tested.
 - Use of a virtual environment is recommended:
```
python3 -m venv my_virtual_environment
source my_virtual_environment/bin/activate
```
 - Install dependencies needed for building OTS and testing:
```
pip install -r requirements.txt
```

## Installation (local build)
`python setup.py install`. This will trigger downloading of
the OTS source, then building as a Python C Extension (using `meson` and
`ninja`).
**NOTE:** It is also possible to build and install with pip using `pip install
.`; however this will use a temporary directory for building and the `ots`
source folder will not be stored under `src`, so tests will not work correctly.

## Installation (pip/wheel)
TODO: update this section when built wheels are available

## Using a different backend OTS version
To use a different version of OTS, modify the `version` and
`sha256` keys in the `[download]` section of `setup.cfg`. You can obtain the
value for `sha256` by running `shasum` on the tar.xz package, e.g. `shasum -a
256 ots-X.X.X.tar.xz`.
**Note:** this has some limitations: OTS source older than 7.1.7
might not build correctly since it used a different build system. Also, versions
newer than the current specified in this repo might require minor adjustments in
order to build correctly.

## Testing
There is a test suite defined, to exercise the Python extension. It makes use
(and assumes the presence of) the downloaded OTS library source's test font data
in `src/ots`. Invoke as:
```
python -m pytest tests
```
 -- OR --
```
pytest tests
```

## Use
Simplest case:
```python
import pyots
result = pyots.sanitize('/path/to/font/file.ttf')
```

`result` is an `OTSResult` ([`namedtuple`](https://docs.python.org/3/library/collections.html#collections.namedtuple)/lightweight
object)
with 3 attributes:
 - `sanitized` (bool)
 - `modified` (bool)*
 - `messages` (tuple of message strings generated by OTS)

**Note:** currently the back-end OTS code _always_ modifies fonts that are successfully
sanitized. Thus `modified` will be True for all cases where `sanitized` is True.
Usually the modification is only to the modification date and related checksums.
Thus, it might be possible to devise a better detection of modification, i.e.
ignoring `head.modified` and other inconsequential modifications, but that was
out-of-scope for this work.

## Options
 - Specify `output=<path_to_output_file>` to the `sanitize()` command and the
   sanitized file will be saved to that location.
 - Use the `quiet` command to suppress messages
 - Specify `font_index=<index_in_TTC>` when sanitizing a Collection (OTC/TTC)
   file if you want to sanitize only a particular index within the Collection.
