import opcodetools.cpu.base_cpu


OPCODES = [
    {"mnemonic": "BRK",              "code": "00",               "use": ""             },
    {"mnemonic": "ORA (p,X)",        "code": "01pp",             "use": "p=data_r"     },
    {"mnemonic": "ORA p",            "code": "05pp",             "use": "p=data_r"     },
    {"mnemonic": "ASL p",            "code": "06pp",             "use": "p=data_rw"    },
    {"mnemonic": "PHP",              "code": "08",               "use": ""             },
    {"mnemonic": "ORA #b",           "code": "09bb",             "use": "b=const"      },
    {"mnemonic": "ASL A",            "code": "0A",               "use": ""             },
    {"mnemonic": "ORA t",            "code": "0Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "ASL t",            "code": "0Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "BPL r",            "code": "10rr",             "use": "r=code_pcr"   },
    {"mnemonic": "ORA (p),Y",        "code": "11pp",             "use": "p=data_r"     },
    {"mnemonic": "ORA p,X",          "code": "15pp",             "use": "p=data_r"     },
    {"mnemonic": "ASL p,X",          "code": "16pp",             "use": "p=data_rw"    },
    {"mnemonic": "CLC",              "code": "18",               "use": ""             },
    {"mnemonic": "ORA t,Y",          "code": "19t0t1",           "use": "t=data_r"     },
    {"mnemonic": "ORA t,X",          "code": "1Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "ASL t,X",          "code": "1Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "JSR t",            "code": "20t0t1",           "use": "t=code"       },
    {"mnemonic": "AND (p,X)",        "code": "21pp",             "use": "p=data_r"     },
    {"mnemonic": "BIT p",            "code": "24pp",             "use": "p=data_r"     },
    {"mnemonic": "AND p",            "code": "25pp",             "use": "p=data_r"     },
    {"mnemonic": "ROL p",            "code": "26pp",             "use": "p=data_rw"    },
    {"mnemonic": "PLP",              "code": "28",               "use": ""             },
    {"mnemonic": "AND #b",           "code": "29bb",             "use": "b=const"      },
    {"mnemonic": "ROL A",            "code": "2A",               "use": "",             },
    {"mnemonic": "BIT t",            "code": "2Ct0t1",           "use": "t=data_r"     },
    {"mnemonic": "AND t",            "code": "2Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "ROL t",            "code": "2Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "BMI r",            "code": "30rr",             "use": "r=code_pcr"   },
    {"mnemonic": "AND (p),Y",        "code": "31pp",             "use": "p=data_r"     },
    {"mnemonic": "AND p,X",          "code": "35pp",             "use": "p=data_r"     },
    {"mnemonic": "ROL p,X",          "code": "36pp",             "use": "p=data_rw"    },
    {"mnemonic": "SEC",              "code": "38",               "use": ""             },
    {"mnemonic": "AND t,Y",          "code": "39t0t1",           "use": "t=data_r"     },
    {"mnemonic": "AND t,X",          "code": "3Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "ROL t,X",          "code": "3Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "RTI",              "code": "40",               "use": ""             },
    {"mnemonic": "EOR (p,X)",        "code": "41pp",             "use": "p=data_r"     },
    {"mnemonic": "EOR p",            "code": "45pp",             "use": "p=data_r"     },
    {"mnemonic": "LSR p",            "code": "46pp",             "use": "p=data_rw"    },
    {"mnemonic": "PHA",              "code": "48",               "use": ""             },
    {"mnemonic": "EOR #b",           "code": "49bb",             "use": "b=const"      },
    {"mnemonic": "LSR A",            "code": "4A",               "use": ""             },
    {"mnemonic": "JMP t",            "code": "4Ct0t1",           "use": "t=code"       },
    {"mnemonic": "EOR t",            "code": "4Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "LSR t",            "code": "4Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "BVC r",            "code": "50rr",             "use": "r=code_pcr"   },
    {"mnemonic": "EOR (p),Y",        "code": "51pp",             "use": "p=data_r"     },
    {"mnemonic": "EOR p,X",          "code": "55pp",             "use": "p=data_r"     },
    {"mnemonic": "LSR p,X",          "code": "56pp",             "use": "p=data_r"     },
    {"mnemonic": "CLI",              "code": "58",               "use": ""             },
    {"mnemonic": "EOR t,Y",          "code": "59t0t1",           "use": "t=data_r"     },
    {"mnemonic": "EOR t,X",          "code": "5Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "LSR t,X",          "code": "5Et0t1",           "use": "t=data_r"     },
    {"mnemonic": "RTS",              "code": "60",               "use": ""             },
    {"mnemonic": "ADC (p,X)",        "code": "61pp",             "use": "p=data_r"     },
    {"mnemonic": "ADC p",            "code": "65pp",             "use": "p=data_r"     },
    {"mnemonic": "ROR p",            "code": "66pp",             "use": "p=data_rw"    },
    {"mnemonic": "PLA",              "code": "68",               "use": ""             },
    {"mnemonic": "ADC #b",           "code": "69bb",             "use": "b=const"      },
    {"mnemonic": "ROR A",            "code": "6A",               "use": ""             },
    {"mnemonic": "JMP (t)",          "code": "6Ct0t1",           "use": "t=code"       },
    {"mnemonic": "ADC t",            "code": "6Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "ROR t",            "code": "6Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "BVS r",            "code": "70rr",             "use": "r=code_pcr"   },
    {"mnemonic": "ADC (p),Y",        "code": "71pp",             "use": "p=data_r"     },
    {"mnemonic": "ADC p,X",          "code": "75pp",             "use": "p=data_r"     },
    {"mnemonic": "ROR p,X",          "code": "76pp",             "use": "p=data_r"     },
    {"mnemonic": "SEI",              "code": "78",               "use": ""             },
    {"mnemonic": "ADC t,Y",          "code": "79t0t1",           "use": "t=data_r"     },
    {"mnemonic": "ADC t,X",          "code": "7Dt0t1",           "use": "t=data_r"     },
    {"mnemonic": "ROR t,X",          "code": "7Et0t1",           "use": "t=data_rw"    },
    {"mnemonic": "STA (p,X)",        "code": "81pp",             "use": "p=data_w"     },
    {"mnemonic": "STY p",            "code": "84pp",             "use": "p=data_w"     },
    {"mnemonic": "STA p",            "code": "85pp",             "use": "p=data_w"     },
    {"mnemonic": "STX p",            "code": "86pp",             "use": "p=data_w"     },
    {"mnemonic": "DEY",              "code": "88",               "use": ""             },
    {"mnemonic": "TXA",              "code": "8A",               "use": ""             },
    {"mnemonic": "STY t",            "code": "8Ct0t1",           "use": "t=data_w"     },
    {"mnemonic": "STA t",            "code": "8Dt0t1",           "use": "t=data_w"     },
    {"mnemonic": "STX t",            "code": "8Et0t1",           "use": "t=data_w"     },
    {"mnemonic": "BCC r",            "code": "90rr",             "use": "r=code_pcr"   },
    {"mnemonic": "STA (p),Y",        "code": "91pp",             "use": "p=data_w"     },
    {"mnemonic": "STY p,X",          "code": "94pp",             "use": "p=data_w"     },
    {"mnemonic": "STA p,X",          "code": "95pp",             "use": "p=data_w"     },
    {"mnemonic": "STX p,Y",          "code": "96pp",             "use": "p=data_w"     },
    {"mnemonic": "TYA",              "code": "98",               "use": ""             },
    {"mnemonic": "STA t,Y",          "code": "99t0t1",           "use": "t=data_w"     },
    {"mnemonic": "TXS",              "code": "9A",               "use": ""             },
    {"mnemonic": "STA t,X",          "code": "9Dt0t1",           "use": "t=data_w"     },
    {"mnemonic": "LDY #b",           "code": "A0bb",             "use": "b=const"      },
    {"mnemonic": "LDA (p,X)",        "code": "A1pp",             "use": "p=data_r"     },
    {"mnemonic": "LDX #b",           "code": "A2bb",             "use": "b=const"      },
    {"mnemonic": "LDY p",            "code": "A4pp",             "use": "p=data_r"     },
    {"mnemonic": "LDA p",            "code": "A5pp",             "use": "p=data_r"     },
    {"mnemonic": "LDX p",            "code": "A6pp",             "use": "p=data_r"     },
    {"mnemonic": "TAY",              "code": "A8",               "use": ""             },
    {"mnemonic": "LDA #b",           "code": "A9bb",             "use": "b=const"      },
    {"mnemonic": "TAX",              "code": "AA",               "use": ""             },
    {"mnemonic": "LDY t",            "code": "ACt0t1",           "use": "t=data_r"     },
    {"mnemonic": "LDA t",            "code": "ADt0t1",           "use": "t=data_r"     },
    {"mnemonic": "LDX t",            "code": "AEt0t1",           "use": "t=data_r"     },
    {"mnemonic": "BCS r",            "code": "B0rr",             "use": "r=code_pcr"   },
    {"mnemonic": "LDA (p),Y",        "code": "B1pp",             "use": "p=data_r"     },
    {"mnemonic": "LDY p,X",          "code": "B4pp",             "use": "p=data_r"     },
    {"mnemonic": "LDA p,X",          "code": "B5pp",             "use": "p=data_r"     },
    {"mnemonic": "LDX p,Y",          "code": "B6pp",             "use": "p=data_r"     },
    {"mnemonic": "CLV",              "code": "B8",               "use": ""             },
    {"mnemonic": "LDA t,Y",          "code": "B9t0t1",           "use": "t=data_r"     },
    {"mnemonic": "TSX",              "code": "BA",               "use": ""             },
    {"mnemonic": "LDY t,X",          "code": "BCt0t1",           "use": "t=data_r"     },
    {"mnemonic": "LDA t,X",          "code": "BDt0t1",           "use": "t=data_r"     },
    {"mnemonic": "LDX t,Y",          "code": "BEt0t1",           "use": "t=data_r"     },
    {"mnemonic": "CPY #b",           "code": "C0bb",             "use": "b=const"      },
    {"mnemonic": "CMP (p,X)",        "code": "C1pp",             "use": "p=data_r"     },
    {"mnemonic": "CPY p",            "code": "C4pp",             "use": "p=data_r"     },
    {"mnemonic": "CMP p",            "code": "C5pp",             "use": "p=data_r"     },
    {"mnemonic": "DEC p",            "code": "C6pp",             "use": "p=data_rw"    },
    {"mnemonic": "INY",              "code": "C8",               "use": ""             },
    {"mnemonic": "CMP #b",           "code": "C9bb",             "use": "b=const"      },
    {"mnemonic": "DEX",              "code": "CA",               "use": ""             },
    {"mnemonic": "CPY t",            "code": "CCt0t1",           "use": "t=data_r"     },
    {"mnemonic": "CMP t",            "code": "CDt0t1",           "use": "t=data_r"     },
    {"mnemonic": "DEC t",            "code": "CEt0t1",           "use": "t=data_rw"    },
    {"mnemonic": "BNE r",            "code": "D0rr",             "use": "r=code_pcr"   },
    {"mnemonic": "CMP (p),Y",        "code": "D1pp",             "use": "p=data_r"     },
    {"mnemonic": "CMP p,X",          "code": "D5pp",             "use": "p=data_r"     },
    {"mnemonic": "DEC p,X",          "code": "D6pp",             "use": "p=data_rw"    },
    {"mnemonic": "CLD",              "code": "D8",               "use": ""             },
    {"mnemonic": "CMP t,Y",          "code": "D9t0t1",           "use": "t=data_r"     },
    {"mnemonic": "CMP t,X",          "code": "DDt0t1",           "use": "t=data_r"     },
    {"mnemonic": "DEC t,X",          "code": "DEt0t1",           "use": "t=data_rw"    },
    {"mnemonic": "CPX #b",           "code": "E0bb",             "use": "b=const"      },
    {"mnemonic": "SBC (p,X)",        "code": "E1pp",             "use": "p=data_r"     },
    {"mnemonic": "CPX p",            "code": "E4pp",             "use": "p=data_r"     },
    {"mnemonic": "SBC p",            "code": "E5pp",             "use": "p=data_r"     },
    {"mnemonic": "INC p",            "code": "E6pp",             "use": "p=data_rw"    },
    {"mnemonic": "INX",              "code": "E8",               "use": ""             },
    {"mnemonic": "SBC #b",           "code": "E9bb",             "use": "b=const"      },
    {"mnemonic": "NOP",              "code": "EA",               "use": ""             },
    {"mnemonic": "CPX t",            "code": "ECt0t1",           "use": "t=data_r"     },
    {"mnemonic": "SBC t",            "code": "EDt0t1",           "use": "t=data_r"     },
    {"mnemonic": "INC t",            "code": "EEt0t1",           "use": "t=data_rw"    },
    {"mnemonic": "BEQ r",            "code": "F0rr",             "use": "r=code_pcr"   },
    {"mnemonic": "SBC (p),Y",        "code": "F1pp",             "use": "p=data_r"     },
    {"mnemonic": "SBC p,X",          "code": "F5pp",             "use": "p=data_r"     },
    {"mnemonic": "INC p,X",          "code": "F6pp",             "use": "p=data_rw"    },
    {"mnemonic": "SED",              "code": "F8",               "use": ""             },
    {"mnemonic": "SBC t,Y",          "code": "F9t0t1",           "use": "t=data_r"     },
    {"mnemonic": "SBC t,X",          "code": "FDt0t1",           "use": "t=data_r"     },
    {"mnemonic": "INC t,X",          "code": "FEt0t1",           "use": "t=data_rw"    },
]


class CPU_6502(opcodetools.cpu.base_cpu.CPU):

    def __init__(self):
        super().__init__(OPCODES)
