# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['netbox_proxbox',
 'netbox_proxbox.api',
 'netbox_proxbox.migrations',
 'netbox_proxbox.proxbox_api',
 'netbox_proxbox.proxbox_api.create',
 'netbox_proxbox.proxbox_api.updates']

package_data = \
{'': ['*'], 'netbox_proxbox': ['templates/netbox_proxbox/*']}

setup_kwargs = {
    'name': 'netbox-proxbox',
    'version': '0.0.4',
    'description': 'Netbox Plugin - Integrate Proxmox and Netbox',
    'long_description': '<div align="center">\n\t<a href="https://docs.netbox.dev.br/en/netbox/plugins/netbox-proxbox">\n\t\t<img width="532" src="https://github.com/N-Multifibra/proxbox/blob/main/etc/img/proxbox-full-logo.png" alt="Proxbox logo">\n\t</a>\n\t<br>\n\t\n<div>\n\t\n### [New Documentation available!](https://docs.netbox.dev.br/en/netbox/plugins/netbox-proxbox)\n</div>\n<br>\n</div>\n\n\n\n\n## Netbox Plugin which integrates [Proxmox](https://www.proxmox.com/) and [Netbox](https://netbox.readthedocs.io/)!\n\n> **NOTE:** Although the Proxbox plugin is in development, it only use **GET requests** and there is **no risk to harm your Proxmox environment** by changing things incorrectly.\n\n<br>\n\nProxbox is currently able to get the following information from Proxmox:\n\n- **Cluster name**\n- **Nodes:**\n  - Status (online / offline)\n  - Name\n- **Virtual Machines and Containers:**\n  - Status (online / offline)\n  - Name\n  - ID\n  - CPU\n  - Disk\n  - Memory\n  - Node (Server)\n\n---\n\n<div align="center">\n\t\n### Versions\n\n\nThe following table shows the Netbox and Proxmox versions compatible (tested) with Proxbox plugin.\n\n| netbox version        | proxmox version          | proxbox version\n| ------------- |-------------|-------------|\n| >= v3.2.0 | >= v6.2.0 | =v0.0.4\n| >= v3.0.0 < v3.2| >= v6.2.0 | =v0.0.3\n\n\n</div>\n\n---\n\n### Summary\n[1. Installation](#1-installation)\n- [1.1. Install package](#11-install-package)\n  - [1.1.1. Using pip (production use)](#111-using-pip-production-use---not-working-yet)\n  - [1.1.2. Using git (development use)](#112-using-git-development-use)\n- [1.2. Enable the Plugin](#12-enable-the-plugin)\n- [1.3. Configure Plugin](#13-configure-plugin)\n  - [1.3.1. Change Netbox \'configuration.py\' to add PLUGIN parameters](#131-change-netbox-configurationpy-to-add-plugin-parameters)\n  - [1.3.2. Change Netbox \'settings.py\' to include Proxbox Template directory](#132-change-netbox-settingspy-to-include-proxbox-template-directory)\n- [1.4. Run Database Migrations](#14-run-database-migrations)\n- [1.5 Restart WSGI Service](#15-restart-wsgi-service)\n\n[2. Configuration Parameters](#2-configuration-parameters)\n\n[3. Custom Fields](#3-custom-fields)\n- [3.1. Custom Field Configuration](#31-custom-field-configuration)\n\t- [3.1.1. Proxmox ID](#311-proxmox-id)\n\t- [3.1.2. Proxmox Node](#312-proxmox-node)\n\t- [3.1.3. Proxmox Type](#313-proxmox-type-qemu-or-lxc)\n- [3.2. Custom Field Example](#32-custom-field-example)\n\n[4. Usage](#4-usage)\n\n[5. Contributing](#5-contributing)\n\n[6. Roadmap](#6-roadmap)\n\n---\n\n## 1. Installation\n\nThe instructions below detail the process for installing and enabling Proxbox plugin.\nThe plugin is available as a Python package in pypi and can be installed with pip.\n\n### 1.1. Install package\n\n#### 1.1.1. Using pip (production use)\n\nEnter Netbox\'s virtual environment.\n```\nsource /opt/netbox/venv/bin/activate\n```\n\nInstall the plugin package.\n```\n(venv) $ pip install netbox-proxbox\n```\n\n#### 1.1.2. Using git (development use)\n**OBS:** This method is recommend for testing and development purposes and is not for production use.\n\nMove to netbox main folder\n```\ncd /opt/netbox/netbox\n```\n\nClone netbox-proxbox repository\n```\ngit clone https://github.com/netdevopsbr/netbox-proxbox.git\n```\n\nInstall netbox-proxbox\n```\ncd netbox-proxbox\nsource /opt/netbox/venv/bin/activate\npython3 setup.py develop\n```\n\n---\n\n### 1.2. Enable the Plugin\n\nEnable the plugin in **/opt/netbox/netbox/netbox/configuration.py**:\n```python\nPLUGINS = [\'netbox_proxbox\']\n```\n\n---\n\n### 1.3. Configure Plugin\n\n#### 1.3.1. Change Netbox \'**[configuration.py](https://github.com/netbox-community/netbox/blob/develop/netbox/netbox/configuration.example.py)**\' to add PLUGIN parameters\nThe plugin\'s configuration is also located in **/opt/netbox/netbox/netbox/configuration.py**:\n\nReplace the values with your own following the [Configuration Parameters](#configuration-parameters) section.\n\n**OBS:** You do not need to configure all the parameters, only the one\'s different from the default values. It means that if you have some value equal to the one below, you can skip its configuration.\n```python\nPLUGINS_CONFIG = {\n    \'netbox_proxbox\': {\n        \'proxmox\': {\n            \'domain\': \'proxbox.example.com\',    # May also be IP address\n            \'http_port\': 8006,\n            \'user\': \'root@pam\',   # always required\n            \'password\': \'Strong@P4ssword\', # only required, if you don\'t want to use token based authentication\n            \'token\': {\n                \'name\': \'tokenID\',\t# Only type the token name and not the \'user@pam:tokenID\' format\n                \'value\': \'039az154-23b2-4be0-8d20-b66abc8c4686\'\n            },\n            \'ssl\': False\n        },\n        \'netbox\': {\n            \'domain\': \'netbox.example.com\',     # May also be IP address\n            \'http_port\': 80,\n            \'token\': \'0dd7cddfaee3b38bbffbd2937d44c4a03f9c9d38\',\n            \'ssl\': False,\t# There is no support to SSL on Netbox yet, so let it always False.\n            \'settings\': {\n                \'virtualmachine_role_id\' : 0,\n                \'node_role_id\' : 0,\n                \'site_id\': 0\n            }\n        }\n    }\n```\n\n<br>\n\n#### 1.3.2. Change Netbox \'**[settings.py](https://github.com/netbox-community/netbox/blob/develop/netbox/netbox/settings.py)**\' to include Proxbox Template directory\n\n> Probably on the next release of Netbox, it will not be necessary to make the configuration below! As the [Pull Request #8733](https://github.com/netbox-community/netbox/pull/8734) got merged to develop branch\n\nEdit **/opt/netbox/netbox/netbox** and find TEMPLATE_DIR section\n\n<div align=center>\n\t\n### How it is configured by default (Netbox >= v3.2.0):\n</div>\n\t\n```python\nTEMPLATES_DIR = BASE_DIR + \'/templates\'\nTEMPLATES = [\n    {\n        \'BACKEND\': \'django.template.backends.django.DjangoTemplates\',\n        \'DIRS\': [TEMPLATES_DIR],\n        \'APP_DIRS\': True,\n        \'OPTIONS\': {\n            \'builtins\': [\n                \'utilities.templatetags.builtins.filters\',\n                \'utilities.templatetags.builtins.tags\',\n            ],\n            \'context_processors\': [\n                \'django.template.context_processors.debug\',\n                \'django.template.context_processors.request\',\n                \'django.template.context_processors.media\',\n                \'django.contrib.auth.context_processors.auth\',\n                \'django.contrib.messages.context_processors.messages\',\n                \'netbox.context_processors.settings_and_registry\',\n            ],\n        },\n    },\n]\n```\n\n<br>\n\n<div align=center>\n\t\n### How it MUST be configured to Proxbox work:\n</div>\n\t\n```python\nTEMPLATES_DIR = BASE_DIR + \'/templates\'\n\n# PROXBOX CUSTOM TEMPLATE\nPROXBOX_TEMPLATE_DIR = BASE_DIR + \'/netbox-proxbox/netbox_proxbox/templates/netbox_proxbox\'\n\nTEMPLATES = [\n    {\n        \'BACKEND\': \'django.template.backends.django.DjangoTemplates\',\n        \'DIRS\': [TEMPLATES_DIR, PROXBOX_TEMPLATE_DIR],  # <--- IMPORTANT\n\t# The Parameters below is equal to default Netbox config\t\t\t\t\t\t       \n        \'APP_DIRS\': True,\n        \'OPTIONS\': {\n            \'builtins\': [\n                \'utilities.templatetags.builtins.filters\',\n                \'utilities.templatetags.builtins.tags\',\n            ],\n            \'context_processors\': [\n                \'django.template.context_processors.debug\',\n                \'django.template.context_processors.request\',\n                \'django.template.context_processors.media\',\n                \'django.contrib.auth.context_processors.auth\',\n                \'django.contrib.messages.context_processors.messages\',\n                \'netbox.context_processors.settings_and_registry\',\n            ],\n        },\n    },\n]\n```\n\n### Example of error if not configuring the code above on `settings.py`\n![image](https://user-images.githubusercontent.com/24397251/167919319-00c67a81-0679-4114-a66d-3e294b3ae28c.png)\n\nI did it because I had to change the **base/layout.html** from Netbox, since there is no **Jinja2 block** to fill with custom information into the **footer HTML tag**\n\n---\n\n### 1.4. Run Database Migrations\n\n```\n(venv) $ cd /opt/netbox/netbox/\n(venv) $ python3 manage.py migrate\n```\n\n---\n\n### 1.5. Restart WSGI Service\n\nRestart the WSGI service to load the new plugin:\n```\n# sudo systemctl restart netbox\n```\n\n---\n\n## 2. Configuration Parameters\n\nThe following options are available:\n\n* `proxmox`: (Dict) Proxmox related configuration to use proxmoxer.\n* `proxmox.domain`: (String) Domain or IP address of Proxmox.\n* `proxmox.http_port`: (Integer) Proxmox HTTP port (default: 8006).\n* `proxmox.user`: (String) Proxmox Username.\n* `proxmox.password`: (String) Proxmox Password.\n* `proxmox.token`: (Dict) Contains Proxmox TokenID (name) and Token Value (value).\n* `proxmox.token.name`: (String) Proxmox TokenID.\n* `proxmox.token.value`: (String) Proxmox Token Value.\n* `proxmox.ssl`: (Bool) Defines the use of SSL (default: False).\n\n* `netbox`: (Dict) Netbox related configuration to use pynetbox.\n* `netbox.domain`: (String) Domain or IP address of Netbox.\n* `netbox.http_port`: (Integer) Netbox HTTP PORT (default: 80).\n* `netbox.token`: (String) Netbox Token Value.\n* `netbox.ssl`: (Bool) Defines the use of SSL (default: False). - Proxbox doesn\'t support SSL on Netbox yet.\n* `netbox.settings`: (Dict) Default items of Netbox to be used by Proxbox. \n  - If not configured, Proxbox will automatically create a basic configuration to make it work.\n  - The ID of each item can be easily found on the URL of the item you want to use.\n* `netbox.settings.virtualmachine_role_id`: (Integer) Role ID to be used by Proxbox when creating Virtual Machines\n* `netbox.settings.node_role_id`: (Integer) Role ID to be used by Proxbox when creating Nodes (Devices)\n* `netbox.settings.site_id` (Integer) Site ID to be used by Proxbox when creating Nodes (Devices)\n\n---\n\n## 3. Custom Fields\n\nTo get Proxmox ID, Node and Type information, is necessary to configure Custom Fields.\nBelow the parameters needed to make it work:\n\n<br>\n\n### 3.1. Custom Field Configuration\n\n#### 3.1.1. Proxmox ID\n\nRequired values (must be equal)\n- [Custom Field] **Type:** Integer\n- [Custom Field] **Name:** proxmox_id\n- [Assignment] **Content-type:** Virtualization > virtual machine\n- [Validation Rules] **Minimum value:** 0\n\nOptional values (may be different)\n- [Custom Field] **Label:** [Proxmox] ID\n- [Custom Field] **Description:** Proxmox VM/CT ID\n\n<br>\n\n#### 3.1.2. Proxmox Node\n\nRequired values (must be equal)\n- [Custom Field] **Type:** Text\n- [Custom Field] **Name:** proxmox_node\n- [Assignment] **Content-type:** Virtualization > virtual machine\n\nOptional values (may be different)\n- [Custom Field] **Label:** [Proxmox] Node\n- [Custom Field] **Description:** Proxmox Node (Server)\n\n<br>\n\n#### 3.1.3. Proxmox Type (qemu or lxc)\n\nRequired values (must be equal)\n- [Custom Field] **Type:** Selection\n- [Custom Field] **Name:** proxmox_type\n- [Assignment] **Content-type:** Virtualization > virtual machine\n- [Choices] **Choices:** qemu,lxc\n\nOptional values (may be different)\n- [Custom Field] **Label:** [Proxmox] Type\n- [Custom Field] **Description:** Proxmox type (VM or CT)\n\n<br>\n\n### 3.2. Custom Field Example\n\n![custom field image](etc/img/custom_field_example.png?raw=true "preview")\n\n---\n\n## 4. Usage\n\nIf everything is working correctly, you should see in Netbox\'s navigation the **Proxmox VM/CT** button in **Plugins** dropdown list.\n\nOn **Proxmox VM/CT** page, click button ![full update button](etc/img/proxbox_full_update_button.png?raw=true "preview")\n\nIt will redirect you to a new page and you just have to wait until the plugin runs through all Proxmox Cluster and create the VMs and CTs in Netbox.\n\n**OBS:** Due the time it takes to full update the information, your web brouse might show a timeout page (like HTTP Code 504) even though it actually worked.\n\n---\n\n## 5. Contributing\nDeveloping tools for this project based on [ntc-netbox-plugin-onboarding](https://github.com/networktocode/ntc-netbox-plugin-onboarding) repo.\n\nIssues and pull requests are welcomed.\n\n---\n\n## 6. Roadmap\n- Start using custom models to optimize the use of the Plugin and stop using \'Custom Fields\'\n- Automatically remove Nodes on Netbox when removed on Promox (as it already happens with Virtual Machines and Containers)\n- Add individual update of VM/CT\'s and Nodes (currently is only possible to update all at once)\n- Add periodic update of the whole environment so that the user does not need to manually click the update button.\n- Create virtual machines and containers directly on Netbox, having no need to access Proxmox.\n- Add \'Console\' button to enable console access to virtual machines\n',
    'author': 'Emerson Felipe',
    'author_email': 'emerson.felipe@nmultifibra.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
