"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const stepfunctions = require("@aws-cdk/aws-stepfunctions");
const s3 = require("@aws-cdk/aws-s3");
const core_2 = require("@aws-solutions-constructs/core");
const core_3 = require("@aws-solutions-constructs/core");
const app = new core_1.App();
const stack = new core_1.Stack(app, core_3.generateIntegStackName(__filename));
const existingBucket = core_2.CreateScrapBucket(stack, {});
const mybucket = s3.Bucket.fromBucketName(stack, 'mybucket', existingBucket.bucketName);
const startState = new stepfunctions.Pass(stack, 'StartState');
const props = {
    existingBucketObj: mybucket,
    stateMachineProps: {
        definition: startState
    },
    logGroupProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY
    },
};
new lib_1.S3ToStepfunctions(stack, 'test-s3-stepfunctions-pre-existing-bucket-construct', props);
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucHJlLWV4aXN0aW5nLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLnByZS1leGlzdGluZy1idWNrZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOztBQUVILGdCQUFnQjtBQUNoQix3Q0FBMEQ7QUFDMUQsZ0NBQW1FO0FBQ25FLDREQUE0RDtBQUM1RCxzQ0FBc0M7QUFDdEMseURBQW1FO0FBQ25FLHlEQUF3RTtBQUV4RSxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSw2QkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0FBRWpFLE1BQU0sY0FBYyxHQUFHLHdCQUFpQixDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztBQUVwRCxNQUFNLFFBQVEsR0FBZSxFQUFFLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLGNBQWMsQ0FBQyxVQUFVLENBQUMsQ0FBQztBQUNwRyxNQUFNLFVBQVUsR0FBRyxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBRS9ELE1BQU0sS0FBSyxHQUEyQjtJQUNwQyxpQkFBaUIsRUFBRSxRQUFRO0lBQzNCLGlCQUFpQixFQUFFO1FBQ2pCLFVBQVUsRUFBRSxVQUFVO0tBQ3ZCO0lBQ0QsYUFBYSxFQUFFO1FBQ2IsYUFBYSxFQUFFLG9CQUFhLENBQUMsT0FBTztLQUNyQztDQUNGLENBQUM7QUFFRixJQUFJLHVCQUFpQixDQUFDLEtBQUssRUFBRSxxREFBcUQsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRixHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbi8vLyAhY2RrLWludGVnICpcbmltcG9ydCB7IEFwcCwgU3RhY2ssIFJlbW92YWxQb2xpY3kgfSBmcm9tIFwiQGF3cy1jZGsvY29yZVwiO1xuaW1wb3J0IHsgUzNUb1N0ZXBmdW5jdGlvbnMsIFMzVG9TdGVwZnVuY3Rpb25zUHJvcHMgfSBmcm9tIFwiLi4vbGliXCI7XG5pbXBvcnQgKiBhcyBzdGVwZnVuY3Rpb25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCAqIGFzIHMzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQgeyBDcmVhdGVTY3JhcEJ1Y2tldCB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgeyBnZW5lcmF0ZUludGVnU3RhY2tOYW1lIH0gZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBnZW5lcmF0ZUludGVnU3RhY2tOYW1lKF9fZmlsZW5hbWUpKTtcblxuY29uc3QgZXhpc3RpbmdCdWNrZXQgPSBDcmVhdGVTY3JhcEJ1Y2tldChzdGFjaywge30pO1xuXG5jb25zdCBteWJ1Y2tldDogczMuSUJ1Y2tldCA9IHMzLkJ1Y2tldC5mcm9tQnVja2V0TmFtZShzdGFjaywgJ215YnVja2V0JywgZXhpc3RpbmdCdWNrZXQuYnVja2V0TmFtZSk7XG5jb25zdCBzdGFydFN0YXRlID0gbmV3IHN0ZXBmdW5jdGlvbnMuUGFzcyhzdGFjaywgJ1N0YXJ0U3RhdGUnKTtcblxuY29uc3QgcHJvcHM6IFMzVG9TdGVwZnVuY3Rpb25zUHJvcHMgPSB7XG4gIGV4aXN0aW5nQnVja2V0T2JqOiBteWJ1Y2tldCxcbiAgc3RhdGVNYWNoaW5lUHJvcHM6IHtcbiAgICBkZWZpbml0aW9uOiBzdGFydFN0YXRlXG4gIH0sXG4gIGxvZ0dyb3VwUHJvcHM6IHtcbiAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1lcbiAgfSxcbn07XG5cbm5ldyBTM1RvU3RlcGZ1bmN0aW9ucyhzdGFjaywgJ3Rlc3QtczMtc3RlcGZ1bmN0aW9ucy1wcmUtZXhpc3RpbmctYnVja2V0LWNvbnN0cnVjdCcsIHByb3BzKTtcbmFwcC5zeW50aCgpO1xuIl19