/*============================================================================*/
/*! \file palette.h
 *  \brief Look-up tables (palettes) for inclusion in ppm images written by
 *   output_ppm(). 
 *
 * PURPOSE: Look-up tables (palettes) for inclusion in ppm images written by
 *   output_ppm().  Images of the 7 tables included here can be found in the
 *   documentation; they are named:
 *   - rainbow   - red-blue-black.
 *   - jh_colors - John Hawley's "famous" color table.  Red-gray-blue.
 *   - idl1      - red-blue-black
 *   - idl2      - black-blue-red-black
 *   - step8     - rainbow in 8 steps
 *   - step32    - rainbow in 32 steps
 *   - heat      - white to black through shades of red
 *   The tables are stored in a structure RGB, and accessed by the above names
 *   No grayscale color table is provided; use pgm format for grayscale!      */
/*============================================================================*/

/*! \var  static float jh_colors[256*3]
 *  \brief Color table due to John Hawley, added manually -- TAG -- 2/17/2005 */
static float jh_colors[256*3] = {
   0.000000e+00 , 0.000000e+00 , 5.000000e-01 ,
   0.000000e+00 , 0.000000e+00 , 5.156863e-01 ,
   0.000000e+00 , 0.000000e+00 , 5.313725e-01 ,
   0.000000e+00 , 0.000000e+00 , 5.470588e-01 ,
   0.000000e+00 , 0.000000e+00 , 5.627451e-01 ,
   0.000000e+00 , 0.000000e+00 , 5.784314e-01 ,
   0.000000e+00 , 0.000000e+00 , 5.941176e-01 ,
   0.000000e+00 , 0.000000e+00 , 6.098039e-01 ,
   0.000000e+00 , 0.000000e+00 , 6.254902e-01 ,
   0.000000e+00 , 0.000000e+00 , 6.411765e-01 ,
   0.000000e+00 , 0.000000e+00 , 6.568627e-01 ,
   0.000000e+00 , 0.000000e+00 , 6.725490e-01 ,
   0.000000e+00 , 0.000000e+00 , 6.882353e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.039216e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.196078e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.352941e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.509804e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.666667e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.823529e-01 ,
   0.000000e+00 , 0.000000e+00 , 7.980392e-01 ,
   0.000000e+00 , 0.000000e+00 , 8.137255e-01 ,
   0.000000e+00 , 0.000000e+00 , 8.294118e-01 ,
   0.000000e+00 , 0.000000e+00 , 8.450980e-01 ,
   0.000000e+00 , 0.000000e+00 , 8.607843e-01 ,
   0.000000e+00 , 0.000000e+00 , 8.764706e-01 ,
   0.000000e+00 , 0.000000e+00 , 8.921569e-01 ,
   0.000000e+00 , 0.000000e+00 , 9.078431e-01 ,
   0.000000e+00 , 0.000000e+00 , 9.235294e-01 ,
   0.000000e+00 , 0.000000e+00 , 9.392157e-01 ,
   0.000000e+00 , 0.000000e+00 , 9.549020e-01 ,
   0.000000e+00 , 0.000000e+00 , 9.705882e-01 ,
   0.000000e+00 , 0.000000e+00 , 9.862745e-01 ,
   0.000000e+00 , 1.960784e-03 , 9.960938e-01 ,
   0.000000e+00 , 1.764706e-02 , 9.960938e-01 ,
   0.000000e+00 , 3.333333e-02 , 9.960938e-01 ,
   0.000000e+00 , 4.901961e-02 , 9.960938e-01 ,
   0.000000e+00 , 6.470588e-02 , 9.960938e-01 ,
   0.000000e+00 , 8.039216e-02 , 9.960938e-01 ,
   0.000000e+00 , 9.607843e-02 , 9.960938e-01 ,
   0.000000e+00 , 1.117647e-01 , 9.960938e-01 ,
   0.000000e+00 , 1.274510e-01 , 9.960938e-01 ,
   0.000000e+00 , 1.431373e-01 , 9.960938e-01 ,
   0.000000e+00 , 1.588235e-01 , 9.960938e-01 ,
   0.000000e+00 , 1.745098e-01 , 9.960938e-01 ,
   0.000000e+00 , 1.901961e-01 , 9.960938e-01 ,
   0.000000e+00 , 2.058824e-01 , 9.960938e-01 ,
   0.000000e+00 , 2.215686e-01 , 9.960938e-01 ,
   0.000000e+00 , 2.372549e-01 , 9.960938e-01 ,
   0.000000e+00 , 2.529412e-01 , 9.960938e-01 ,
   0.000000e+00 , 2.686275e-01 , 9.960938e-01 ,
   0.000000e+00 , 2.843137e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.000000e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.156863e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.313725e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.470588e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.627451e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.784314e-01 , 9.960938e-01 ,
   0.000000e+00 , 3.941176e-01 , 9.960938e-01 ,
   0.000000e+00 , 4.098039e-01 , 9.960938e-01 ,
   0.000000e+00 , 4.254902e-01 , 9.960938e-01 ,
   0.000000e+00 , 4.411765e-01 , 9.960938e-01 ,
   0.000000e+00 , 4.568627e-01 , 9.960938e-01 ,
   0.000000e+00 , 4.725490e-01 , 9.960938e-01 ,
   0.000000e+00 , 4.882353e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.039216e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.196078e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.352941e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.509804e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.666667e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.823529e-01 , 9.960938e-01 ,
   0.000000e+00 , 5.980392e-01 , 9.960938e-01 ,
   0.000000e+00 , 6.137255e-01 , 9.960938e-01 ,
   0.000000e+00 , 6.294118e-01 , 9.960938e-01 ,
   0.000000e+00 , 6.450980e-01 , 9.960938e-01 ,
   0.000000e+00 , 6.607843e-01 , 9.960938e-01 ,
   0.000000e+00 , 6.764706e-01 , 9.960938e-01 ,
   0.000000e+00 , 6.921569e-01 , 9.960938e-01 ,
   0.000000e+00 , 7.078431e-01 , 9.960938e-01 ,
   0.000000e+00 , 7.235294e-01 , 9.960938e-01 ,
   0.000000e+00 , 7.392157e-01 , 9.960938e-01 ,
   0.000000e+00 , 7.549020e-01 , 9.960938e-01 ,
   0.000000e+00 , 7.705882e-01 , 9.960938e-01 ,
   0.000000e+00 , 7.862745e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.019608e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.176471e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.333333e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.490196e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.647059e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.803922e-01 , 9.960938e-01 ,
   0.000000e+00 , 8.960784e-01 , 9.960938e-01 ,
   0.000000e+00 , 9.117647e-01 , 9.960938e-01 ,
   0.000000e+00 , 9.274510e-01 , 9.960938e-01 ,
   0.000000e+00 , 9.431373e-01 , 9.960938e-01 ,
   0.000000e+00 , 9.588235e-01 , 9.960938e-01 ,
   0.000000e+00 , 9.745098e-01 , 9.960938e-01 ,
   0.000000e+00 , 9.901961e-01 , 9.960938e-01 ,
   5.882353e-03 , 9.941176e-01 , 9.941176e-01 ,
   2.156863e-02 , 9.784314e-01 , 9.784314e-01 ,
   3.725490e-02 , 9.627451e-01 , 9.627451e-01 ,
   5.294118e-02 , 9.470588e-01 , 9.470588e-01 ,
   6.862745e-02 , 9.313725e-01 , 9.313725e-01 ,
   8.431373e-02 , 9.156863e-01 , 9.156863e-01 ,
   1.000000e-01 , 9.000000e-01 , 9.000000e-01 ,
   1.156863e-01 , 8.843137e-01 , 8.843137e-01 ,
   1.313725e-01 , 8.686275e-01 , 8.686275e-01 ,
   1.470588e-01 , 8.529412e-01 , 8.529412e-01 ,
   1.627451e-01 , 8.372549e-01 , 8.372549e-01 ,
   1.784314e-01 , 8.215686e-01 , 8.215686e-01 ,
   1.941176e-01 , 8.058824e-01 , 8.058824e-01 ,
   2.098039e-01 , 7.901961e-01 , 7.901961e-01 ,
   2.254902e-01 , 7.745098e-01 , 7.745098e-01 ,
   2.411765e-01 , 7.588235e-01 , 7.588235e-01 ,
   2.568627e-01 , 7.431373e-01 , 7.431373e-01 ,
   2.725490e-01 , 7.274510e-01 , 7.274510e-01 ,
   2.882353e-01 , 7.117647e-01 , 7.117647e-01 ,
   3.039216e-01 , 6.960784e-01 , 6.960784e-01 ,
   3.196078e-01 , 6.803922e-01 , 6.803922e-01 ,
   3.352941e-01 , 6.647059e-01 , 6.647059e-01 ,
   3.509804e-01 , 6.490196e-01 , 6.490196e-01 ,
   3.666667e-01 , 6.333333e-01 , 6.333333e-01 ,
   3.823529e-01 , 6.176471e-01 , 6.176471e-01 ,
   3.980392e-01 , 6.019608e-01 , 6.019608e-01 ,
   4.137255e-01 , 5.862745e-01 , 5.862745e-01 ,
   4.294118e-01 , 5.705882e-01 , 5.705882e-01 ,
   4.450980e-01 , 5.549020e-01 , 5.549020e-01 ,
   4.607843e-01 , 5.392157e-01 , 5.392157e-01 ,
   4.764706e-01 , 5.235294e-01 , 5.235294e-01 ,
   4.921569e-01 , 5.078431e-01 , 5.078431e-01 ,
   5.078431e-01 , 5.078431e-01 , 4.921569e-01 ,
   5.235294e-01 , 5.235294e-01 , 4.764706e-01 ,
   5.392157e-01 , 5.392157e-01 , 4.607843e-01 ,
   5.549020e-01 , 5.549020e-01 , 4.450980e-01 ,
   5.705882e-01 , 5.705882e-01 , 4.294118e-01 ,
   5.862745e-01 , 5.862745e-01 , 4.137255e-01 ,
   6.019608e-01 , 6.019608e-01 , 3.980392e-01 ,
   6.176471e-01 , 6.176471e-01 , 3.823529e-01 ,
   6.333333e-01 , 6.333333e-01 , 3.666667e-01 ,
   6.490196e-01 , 6.490196e-01 , 3.509804e-01 ,
   6.647059e-01 , 6.647059e-01 , 3.352941e-01 ,
   6.803922e-01 , 6.803922e-01 , 3.196078e-01 ,
   6.960784e-01 , 6.960784e-01 , 3.039216e-01 ,
   7.117647e-01 , 7.117647e-01 , 2.882353e-01 ,
   7.274510e-01 , 7.274510e-01 , 2.725490e-01 ,
   7.431373e-01 , 7.431373e-01 , 2.568627e-01 ,
   7.588235e-01 , 7.588235e-01 , 2.411765e-01 ,
   7.745098e-01 , 7.745098e-01 , 2.254902e-01 ,
   7.901961e-01 , 7.901961e-01 , 2.098039e-01 ,
   8.058824e-01 , 8.058824e-01 , 1.941176e-01 ,
   8.215686e-01 , 8.215686e-01 , 1.784314e-01 ,
   8.372549e-01 , 8.372549e-01 , 1.627451e-01 ,
   8.529412e-01 , 8.529412e-01 , 1.470588e-01 ,
   8.686275e-01 , 8.686275e-01 , 1.313725e-01 ,
   8.843137e-01 , 8.843137e-01 , 1.156863e-01 ,
   9.000000e-01 , 9.000000e-01 , 1.000000e-01 ,
   9.156863e-01 , 9.156863e-01 , 8.431373e-02 ,
   9.313725e-01 , 9.313725e-01 , 6.862745e-02 ,
   9.470588e-01 , 9.470588e-01 , 5.294118e-02 ,
   9.627451e-01 , 9.627451e-01 , 3.725490e-02 ,
   9.784314e-01 , 9.784314e-01 , 2.156863e-02 ,
   9.941176e-01 , 9.941176e-01 , 5.882353e-03 ,
   9.960938e-01 , 9.901961e-01 , 0.000000e+00 ,
   9.960938e-01 , 9.745098e-01 , 0.000000e+00 ,
   9.960938e-01 , 9.588235e-01 , 0.000000e+00 ,
   9.960938e-01 , 9.431373e-01 , 0.000000e+00 ,
   9.960938e-01 , 9.274510e-01 , 0.000000e+00 ,
   9.960938e-01 , 9.117647e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.960784e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.803922e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.647059e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.490196e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.333333e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.176471e-01 , 0.000000e+00 ,
   9.960938e-01 , 8.019608e-01 , 0.000000e+00 ,
   9.960938e-01 , 7.862745e-01 , 0.000000e+00 ,
   9.960938e-01 , 7.705882e-01 , 0.000000e+00 ,
   9.960938e-01 , 7.549020e-01 , 0.000000e+00 ,
   9.960938e-01 , 7.392157e-01 , 0.000000e+00 ,
   9.960938e-01 , 7.235294e-01 , 0.000000e+00 ,
   9.960938e-01 , 7.078431e-01 , 0.000000e+00 ,
   9.960938e-01 , 6.921569e-01 , 0.000000e+00 ,
   9.960938e-01 , 6.764706e-01 , 0.000000e+00 ,
   9.960938e-01 , 6.607843e-01 , 0.000000e+00 ,
   9.960938e-01 , 6.450980e-01 , 0.000000e+00 ,
   9.960938e-01 , 6.294118e-01 , 0.000000e+00 ,
   9.960938e-01 , 6.137255e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.980392e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.823529e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.666667e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.509804e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.352941e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.196078e-01 , 0.000000e+00 ,
   9.960938e-01 , 5.039216e-01 , 0.000000e+00 ,
   9.960938e-01 , 4.882353e-01 , 0.000000e+00 ,
   9.960938e-01 , 4.725490e-01 , 0.000000e+00 ,
   9.960938e-01 , 4.568627e-01 , 0.000000e+00 ,
   9.960938e-01 , 4.411765e-01 , 0.000000e+00 ,
   9.960938e-01 , 4.254902e-01 , 0.000000e+00 ,
   9.960938e-01 , 4.098039e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.941176e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.784314e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.627451e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.470588e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.313725e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.156863e-01 , 0.000000e+00 ,
   9.960938e-01 , 3.000000e-01 , 0.000000e+00 ,
   9.960938e-01 , 2.843137e-01 , 0.000000e+00 ,
   9.960938e-01 , 2.686275e-01 , 0.000000e+00 ,
   9.960938e-01 , 2.529412e-01 , 0.000000e+00 ,
   9.960938e-01 , 2.372549e-01 , 0.000000e+00 ,
   9.960938e-01 , 2.215686e-01 , 0.000000e+00 ,
   9.960938e-01 , 2.058824e-01 , 0.000000e+00 ,
   9.960938e-01 , 1.901961e-01 , 0.000000e+00 ,
   9.960938e-01 , 1.745098e-01 , 0.000000e+00 ,
   9.960938e-01 , 1.588235e-01 , 0.000000e+00 ,
   9.960938e-01 , 1.431373e-01 , 0.000000e+00 ,
   9.960938e-01 , 1.274510e-01 , 0.000000e+00 ,
   9.960938e-01 , 1.117647e-01 , 0.000000e+00 ,
   9.960938e-01 , 9.607843e-02 , 0.000000e+00 ,
   9.960938e-01 , 8.039216e-02 , 0.000000e+00 ,
   9.960938e-01 , 6.470588e-02 , 0.000000e+00 ,
   9.960938e-01 , 4.901961e-02 , 0.000000e+00 ,
   9.960938e-01 , 3.333333e-02 , 0.000000e+00 ,
   9.960938e-01 , 1.764706e-02 , 0.000000e+00 ,
   9.960938e-01 , 1.960784e-03 , 0.000000e+00 ,
   9.862745e-01 , 0.000000e+00 , 0.000000e+00 ,
   9.705882e-01 , 0.000000e+00 , 0.000000e+00 ,
   9.549020e-01 , 0.000000e+00 , 0.000000e+00 ,
   9.392157e-01 , 0.000000e+00 , 0.000000e+00 ,
   9.235294e-01 , 0.000000e+00 , 0.000000e+00 ,
   9.078431e-01 , 0.000000e+00 , 0.000000e+00 ,
   8.921569e-01 , 0.000000e+00 , 0.000000e+00 ,
   8.764706e-01 , 0.000000e+00 , 0.000000e+00 ,
   8.607843e-01 , 0.000000e+00 , 0.000000e+00 ,
   8.450980e-01 , 0.000000e+00 , 0.000000e+00 ,
   8.294118e-01 , 0.000000e+00 , 0.000000e+00 ,
   8.137255e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.980392e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.823529e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.666667e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.509804e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.352941e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.196078e-01 , 0.000000e+00 , 0.000000e+00 ,
   7.039216e-01 , 0.000000e+00 , 0.000000e+00 ,
   6.882353e-01 , 0.000000e+00 , 0.000000e+00 ,
   6.725490e-01 , 0.000000e+00 , 0.000000e+00 ,
   6.568627e-01 , 0.000000e+00 , 0.000000e+00 ,
   6.411765e-01 , 0.000000e+00 , 0.000000e+00 ,
   6.254902e-01 , 0.000000e+00 , 0.000000e+00 ,
   6.098039e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.941176e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.784314e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.627451e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.470588e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.313725e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.156863e-01 , 0.000000e+00 , 0.000000e+00 ,
   5.000000e-01 , 0.000000e+00 , 0.000000e+00 
};
/*! \var static float step8[256*3]
 *  \brief Rainbow in 8 steps.
 *  Automatically generated from NEMO's lut2c script - do not edit */
static float step8[256*3] = { 
   0.00000 , 0.00000 , 0.00000 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.19608 , 0.19608 , 0.19608 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.47451 , 0.00000 , 0.60784 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.00000 , 0.00000 , 0.78431 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.37255 , 0.65490 , 0.92549 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.56863 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   0.00000 , 0.96471 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.69412 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
};
/*! \var static float heat[256*3]
 *  \brief White to black through shades of red.
 *   Automatically generated from NEMO's lut2c script - do not edit */
static float heat[256*3] = { 
   0.00000 , 0.00000 , 0.00000 ,
   0.01176 , 0.00392 , 0.00000 ,
   0.02353 , 0.00784 , 0.00000 ,
   0.03529 , 0.01176 , 0.00000 ,
   0.04706 , 0.01569 , 0.00000 ,
   0.05882 , 0.01961 , 0.00000 ,
   0.07059 , 0.02353 , 0.00000 ,
   0.08235 , 0.02745 , 0.00000 ,
   0.09412 , 0.03137 , 0.00000 ,
   0.10588 , 0.03529 , 0.00000 ,
   0.11765 , 0.03922 , 0.00000 ,
   0.12941 , 0.04314 , 0.00000 ,
   0.14118 , 0.04706 , 0.00000 ,
   0.15294 , 0.05098 , 0.00000 ,
   0.16471 , 0.05490 , 0.00000 ,
   0.17647 , 0.05882 , 0.00000 ,
   0.18824 , 0.06275 , 0.00000 ,
   0.20000 , 0.06667 , 0.00000 ,
   0.21176 , 0.07059 , 0.00000 ,
   0.22353 , 0.07451 , 0.00000 ,
   0.23529 , 0.07843 , 0.00000 ,
   0.24706 , 0.08235 , 0.00000 ,
   0.25882 , 0.08627 , 0.00000 ,
   0.27059 , 0.09020 , 0.00000 ,
   0.28235 , 0.09412 , 0.00000 ,
   0.29412 , 0.09804 , 0.00000 ,
   0.30588 , 0.10196 , 0.00000 ,
   0.31765 , 0.10588 , 0.00000 ,
   0.32941 , 0.10980 , 0.00000 ,
   0.34118 , 0.11373 , 0.00000 ,
   0.35294 , 0.11765 , 0.00000 ,
   0.36471 , 0.12157 , 0.00000 ,
   0.37647 , 0.12549 , 0.00000 ,
   0.38824 , 0.12941 , 0.00000 ,
   0.40000 , 0.13333 , 0.00000 ,
   0.41176 , 0.13725 , 0.00000 ,
   0.42353 , 0.14118 , 0.00000 ,
   0.43529 , 0.14510 , 0.00000 ,
   0.44706 , 0.14902 , 0.00000 ,
   0.45882 , 0.15294 , 0.00000 ,
   0.47059 , 0.15686 , 0.00000 ,
   0.48235 , 0.16078 , 0.00000 ,
   0.49412 , 0.16471 , 0.00000 ,
   0.50588 , 0.16863 , 0.00000 ,
   0.51765 , 0.17255 , 0.00000 ,
   0.52941 , 0.17647 , 0.00000 ,
   0.54118 , 0.18039 , 0.00000 ,
   0.55294 , 0.18431 , 0.00000 ,
   0.56471 , 0.18824 , 0.00000 ,
   0.57647 , 0.19216 , 0.00000 ,
   0.58824 , 0.19608 , 0.00000 ,
   0.60000 , 0.20000 , 0.00000 ,
   0.61176 , 0.20392 , 0.00000 ,
   0.62353 , 0.20784 , 0.00000 ,
   0.63529 , 0.21176 , 0.00000 ,
   0.64706 , 0.21569 , 0.00000 ,
   0.65882 , 0.21961 , 0.00000 ,
   0.67059 , 0.22353 , 0.00000 ,
   0.68235 , 0.22745 , 0.00000 ,
   0.69412 , 0.23137 , 0.00000 ,
   0.70588 , 0.23529 , 0.00000 ,
   0.71765 , 0.23922 , 0.00000 ,
   0.72941 , 0.24314 , 0.00000 ,
   0.74118 , 0.24706 , 0.00000 ,
   0.75294 , 0.25098 , 0.00000 ,
   0.76471 , 0.25490 , 0.00000 ,
   0.77647 , 0.25882 , 0.00000 ,
   0.78824 , 0.26275 , 0.00000 ,
   0.80000 , 0.26667 , 0.00000 ,
   0.81176 , 0.27059 , 0.00000 ,
   0.82353 , 0.27451 , 0.00000 ,
   0.83529 , 0.27843 , 0.00000 ,
   0.84706 , 0.28235 , 0.00000 ,
   0.85882 , 0.28627 , 0.00000 ,
   0.87059 , 0.29020 , 0.00000 ,
   0.88235 , 0.29412 , 0.00000 ,
   0.89412 , 0.29804 , 0.00000 ,
   0.90588 , 0.30196 , 0.00000 ,
   0.91765 , 0.30588 , 0.00000 ,
   0.92941 , 0.30980 , 0.00000 ,
   0.94118 , 0.31373 , 0.00000 ,
   0.95294 , 0.31765 , 0.00000 ,
   0.96471 , 0.32157 , 0.00000 ,
   0.97647 , 0.32549 , 0.00000 ,
   0.98824 , 0.32941 , 0.00000 ,
   1.00000 , 0.33333 , 0.00000 ,
   1.00000 , 0.33725 , 0.00000 ,
   1.00000 , 0.34118 , 0.00000 ,
   1.00000 , 0.34510 , 0.00000 ,
   1.00000 , 0.34902 , 0.00000 ,
   1.00000 , 0.35294 , 0.00000 ,
   1.00000 , 0.35686 , 0.00000 ,
   1.00000 , 0.36078 , 0.00000 ,
   1.00000 , 0.36471 , 0.00000 ,
   1.00000 , 0.36863 , 0.00000 ,
   1.00000 , 0.37255 , 0.00000 ,
   1.00000 , 0.37647 , 0.00000 ,
   1.00000 , 0.38039 , 0.00000 ,
   1.00000 , 0.38431 , 0.00000 ,
   1.00000 , 0.38824 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39608 , 0.00000 ,
   1.00000 , 0.40000 , 0.00000 ,
   1.00000 , 0.40392 , 0.00000 ,
   1.00000 , 0.40784 , 0.00000 ,
   1.00000 , 0.41176 , 0.00000 ,
   1.00000 , 0.41569 , 0.00000 ,
   1.00000 , 0.41961 , 0.00000 ,
   1.00000 , 0.42353 , 0.00000 ,
   1.00000 , 0.42745 , 0.00000 ,
   1.00000 , 0.43137 , 0.00000 ,
   1.00000 , 0.43529 , 0.00000 ,
   1.00000 , 0.43922 , 0.00000 ,
   1.00000 , 0.44314 , 0.00000 ,
   1.00000 , 0.44706 , 0.00000 ,
   1.00000 , 0.45098 , 0.00000 ,
   1.00000 , 0.45490 , 0.00000 ,
   1.00000 , 0.45882 , 0.00000 ,
   1.00000 , 0.46275 , 0.00000 ,
   1.00000 , 0.46667 , 0.00000 ,
   1.00000 , 0.47059 , 0.00000 ,
   1.00000 , 0.47451 , 0.00000 ,
   1.00000 , 0.47843 , 0.00000 ,
   1.00000 , 0.48235 , 0.00000 ,
   1.00000 , 0.48627 , 0.00000 ,
   1.00000 , 0.49020 , 0.00000 ,
   1.00000 , 0.49412 , 0.00000 ,
   1.00000 , 0.49804 , 0.00000 ,
   1.00000 , 0.50196 , 0.00000 ,
   1.00000 , 0.50588 , 0.00000 ,
   1.00000 , 0.50980 , 0.00000 ,
   1.00000 , 0.51373 , 0.00000 ,
   1.00000 , 0.51765 , 0.00000 ,
   1.00000 , 0.52157 , 0.00000 ,
   1.00000 , 0.52549 , 0.00000 ,
   1.00000 , 0.52941 , 0.00000 ,
   1.00000 , 0.53333 , 0.00000 ,
   1.00000 , 0.53725 , 0.00000 ,
   1.00000 , 0.54118 , 0.00000 ,
   1.00000 , 0.54510 , 0.00000 ,
   1.00000 , 0.54902 , 0.00000 ,
   1.00000 , 0.55294 , 0.00000 ,
   1.00000 , 0.55686 , 0.00000 ,
   1.00000 , 0.56078 , 0.00000 ,
   1.00000 , 0.56471 , 0.00000 ,
   1.00000 , 0.56863 , 0.00000 ,
   1.00000 , 0.57255 , 0.00000 ,
   1.00000 , 0.57647 , 0.00000 ,
   1.00000 , 0.58039 , 0.00000 ,
   1.00000 , 0.58431 , 0.00000 ,
   1.00000 , 0.58824 , 0.00000 ,
   1.00000 , 0.59216 , 0.00000 ,
   1.00000 , 0.59608 , 0.00000 ,
   1.00000 , 0.60000 , 0.00000 ,
   1.00000 , 0.60392 , 0.00000 ,
   1.00000 , 0.60784 , 0.00000 ,
   1.00000 , 0.61176 , 0.00000 ,
   1.00000 , 0.61569 , 0.00000 ,
   1.00000 , 0.61961 , 0.00000 ,
   1.00000 , 0.62353 , 0.00000 ,
   1.00000 , 0.62745 , 0.00000 ,
   1.00000 , 0.63137 , 0.00000 ,
   1.00000 , 0.63529 , 0.00000 ,
   1.00000 , 0.63922 , 0.00000 ,
   1.00000 , 0.64314 , 0.00000 ,
   1.00000 , 0.64706 , 0.00000 ,
   1.00000 , 0.65098 , 0.01176 ,
   1.00000 , 0.65490 , 0.02353 ,
   1.00000 , 0.65882 , 0.03529 ,
   1.00000 , 0.66275 , 0.04706 ,
   1.00000 , 0.66667 , 0.05882 ,
   1.00000 , 0.67059 , 0.07059 ,
   1.00000 , 0.67451 , 0.08235 ,
   1.00000 , 0.67843 , 0.09412 ,
   1.00000 , 0.68235 , 0.10588 ,
   1.00000 , 0.68627 , 0.11765 ,
   1.00000 , 0.69020 , 0.12941 ,
   1.00000 , 0.69412 , 0.14118 ,
   1.00000 , 0.69804 , 0.15294 ,
   1.00000 , 0.70196 , 0.16471 ,
   1.00000 , 0.70588 , 0.17647 ,
   1.00000 , 0.70980 , 0.18824 ,
   1.00000 , 0.71373 , 0.20000 ,
   1.00000 , 0.71765 , 0.21176 ,
   1.00000 , 0.72157 , 0.22353 ,
   1.00000 , 0.72549 , 0.23529 ,
   1.00000 , 0.72941 , 0.24706 ,
   1.00000 , 0.73333 , 0.25882 ,
   1.00000 , 0.73725 , 0.27059 ,
   1.00000 , 0.74118 , 0.28235 ,
   1.00000 , 0.74510 , 0.29412 ,
   1.00000 , 0.74902 , 0.30588 ,
   1.00000 , 0.75294 , 0.31765 ,
   1.00000 , 0.75686 , 0.32941 ,
   1.00000 , 0.76078 , 0.34118 ,
   1.00000 , 0.76471 , 0.35294 ,
   1.00000 , 0.76863 , 0.36471 ,
   1.00000 , 0.77255 , 0.37647 ,
   1.00000 , 0.77647 , 0.38824 ,
   1.00000 , 0.78039 , 0.40000 ,
   1.00000 , 0.78431 , 0.41176 ,
   1.00000 , 0.78824 , 0.42353 ,
   1.00000 , 0.79216 , 0.43529 ,
   1.00000 , 0.79608 , 0.44706 ,
   1.00000 , 0.80000 , 0.45882 ,
   1.00000 , 0.80392 , 0.47059 ,
   1.00000 , 0.80784 , 0.48235 ,
   1.00000 , 0.81176 , 0.49412 ,
   1.00000 , 0.81569 , 0.50588 ,
   1.00000 , 0.81961 , 0.51765 ,
   1.00000 , 0.82353 , 0.52941 ,
   1.00000 , 0.82745 , 0.54118 ,
   1.00000 , 0.83137 , 0.55294 ,
   1.00000 , 0.83529 , 0.56471 ,
   1.00000 , 0.83922 , 0.57647 ,
   1.00000 , 0.84314 , 0.58824 ,
   1.00000 , 0.84706 , 0.60000 ,
   1.00000 , 0.85098 , 0.61176 ,
   1.00000 , 0.85490 , 0.62353 ,
   1.00000 , 0.85882 , 0.63529 ,
   1.00000 , 0.86275 , 0.64706 ,
   1.00000 , 0.86667 , 0.65882 ,
   1.00000 , 0.87059 , 0.67059 ,
   1.00000 , 0.87451 , 0.68235 ,
   1.00000 , 0.87843 , 0.69412 ,
   1.00000 , 0.88235 , 0.70588 ,
   1.00000 , 0.88627 , 0.71765 ,
   1.00000 , 0.89020 , 0.72941 ,
   1.00000 , 0.89412 , 0.74118 ,
   1.00000 , 0.89804 , 0.75294 ,
   1.00000 , 0.90196 , 0.76471 ,
   1.00000 , 0.90588 , 0.77647 ,
   1.00000 , 0.90980 , 0.78824 ,
   1.00000 , 0.91373 , 0.80000 ,
   1.00000 , 0.91765 , 0.81176 ,
   1.00000 , 0.92157 , 0.82353 ,
   1.00000 , 0.92549 , 0.83529 ,
   1.00000 , 0.92941 , 0.84706 ,
   1.00000 , 0.93333 , 0.85882 ,
   1.00000 , 0.93725 , 0.87059 ,
   1.00000 , 0.94118 , 0.88235 ,
   1.00000 , 0.94510 , 0.89412 ,
   1.00000 , 0.94902 , 0.90588 ,
   1.00000 , 0.95294 , 0.91765 ,
   1.00000 , 0.95686 , 0.92941 ,
   1.00000 , 0.96078 , 0.94118 ,
   1.00000 , 0.96471 , 0.95294 ,
   1.00000 , 0.96863 , 0.96471 ,
   1.00000 , 0.97255 , 0.97647 ,
   1.00000 , 0.97647 , 0.98824 ,
   1.00000 , 0.98039 , 1.00000 ,
   1.00000 , 0.98431 , 1.00000 ,
   1.00000 , 0.98824 , 1.00000 ,
   1.00000 , 0.99216 , 1.00000 ,
   1.00000 , 0.99608 , 1.00000 ,
   1.00000 , 1.00000 , 1.00000 ,
};
/*! \var static float idl1[256*3] 
 *  \brief Red-Blue-Black
 *   Automatically generated from NEMO's lut2c script - do not edit */
static float idl1[256*3] = { 
   0.00000 , 0.00000 , 0.00000 ,
   0.00000 , 0.00392 , 0.00392 ,
   0.00000 , 0.00784 , 0.00784 ,
   0.00000 , 0.01176 , 0.01176 ,
   0.00000 , 0.01569 , 0.01569 ,
   0.00000 , 0.03137 , 0.03137 ,
   0.00000 , 0.04706 , 0.04706 ,
   0.00000 , 0.06275 , 0.06275 ,
   0.00000 , 0.08235 , 0.08235 ,
   0.00000 , 0.09804 , 0.09804 ,
   0.00000 , 0.11373 , 0.11373 ,
   0.00000 , 0.12941 , 0.12941 ,
   0.00000 , 0.14902 , 0.14902 ,
   0.00000 , 0.16471 , 0.16471 ,
   0.00000 , 0.18039 , 0.18039 ,
   0.00000 , 0.19608 , 0.19608 ,
   0.00000 , 0.21569 , 0.21569 ,
   0.00000 , 0.23137 , 0.23137 ,
   0.00000 , 0.24706 , 0.24706 ,
   0.00000 , 0.26275 , 0.26275 ,
   0.00000 , 0.28235 , 0.28235 ,
   0.00000 , 0.29804 , 0.29804 ,
   0.00000 , 0.31373 , 0.31373 ,
   0.00000 , 0.32941 , 0.32941 ,
   0.00000 , 0.34902 , 0.34902 ,
   0.00000 , 0.36471 , 0.36471 ,
   0.00000 , 0.38039 , 0.38039 ,
   0.00000 , 0.39608 , 0.39608 ,
   0.00000 , 0.41569 , 0.41569 ,
   0.00000 , 0.43137 , 0.43137 ,
   0.00000 , 0.44706 , 0.44706 ,
   0.00000 , 0.46275 , 0.46275 ,
   0.00000 , 0.48235 , 0.48235 ,
   0.00000 , 0.49804 , 0.49804 ,
   0.00000 , 0.51373 , 0.51373 ,
   0.00000 , 0.52941 , 0.52941 ,
   0.00000 , 0.54902 , 0.54902 ,
   0.00000 , 0.56471 , 0.56471 ,
   0.00000 , 0.58039 , 0.58039 ,
   0.00000 , 0.59608 , 0.59608 ,
   0.00000 , 0.61569 , 0.61569 ,
   0.00000 , 0.63137 , 0.63137 ,
   0.00000 , 0.64706 , 0.64706 ,
   0.00000 , 0.66275 , 0.66275 ,
   0.00000 , 0.68235 , 0.68235 ,
   0.00000 , 0.69804 , 0.69804 ,
   0.00000 , 0.71373 , 0.71373 ,
   0.00000 , 0.72941 , 0.72941 ,
   0.00000 , 0.74902 , 0.74902 ,
   0.00000 , 0.76471 , 0.76471 ,
   0.00000 , 0.78039 , 0.78039 ,
   0.00000 , 0.79608 , 0.79608 ,
   0.00000 , 0.81569 , 0.81569 ,
   0.00000 , 0.83137 , 0.83137 ,
   0.00000 , 0.84706 , 0.84706 ,
   0.00000 , 0.86275 , 0.86275 ,
   0.00000 , 0.88235 , 0.88235 ,
   0.00000 , 0.89804 , 0.89804 ,
   0.00000 , 0.91373 , 0.91373 ,
   0.00000 , 0.92941 , 0.92941 ,
   0.00000 , 0.94902 , 0.94902 ,
   0.00000 , 0.96471 , 0.96471 ,
   0.00000 , 0.98039 , 0.98039 ,
   0.00000 , 1.00000 , 1.00000 ,
   0.00000 , 1.00000 , 1.00000 ,
   0.00000 , 0.98431 , 1.00000 ,
   0.00000 , 0.96863 , 1.00000 ,
   0.00000 , 0.95294 , 1.00000 ,
   0.00000 , 0.93725 , 1.00000 ,
   0.00000 , 0.92157 , 1.00000 ,
   0.00000 , 0.90588 , 1.00000 ,
   0.00000 , 0.89020 , 1.00000 ,
   0.00000 , 0.87451 , 1.00000 ,
   0.00000 , 0.85882 , 1.00000 ,
   0.00000 , 0.84314 , 1.00000 ,
   0.00000 , 0.82745 , 1.00000 ,
   0.00000 , 0.81176 , 1.00000 ,
   0.00000 , 0.79608 , 1.00000 ,
   0.00000 , 0.78039 , 1.00000 ,
   0.00000 , 0.76471 , 1.00000 ,
   0.00000 , 0.74902 , 1.00000 ,
   0.00000 , 0.73333 , 1.00000 ,
   0.00000 , 0.71765 , 1.00000 ,
   0.00000 , 0.70196 , 1.00000 ,
   0.00000 , 0.68627 , 1.00000 ,
   0.00000 , 0.66667 , 1.00000 ,
   0.00000 , 0.65098 , 1.00000 ,
   0.00000 , 0.63529 , 1.00000 ,
   0.00000 , 0.61961 , 1.00000 ,
   0.00000 , 0.60392 , 1.00000 ,
   0.00000 , 0.58824 , 1.00000 ,
   0.00000 , 0.57255 , 1.00000 ,
   0.00000 , 0.55686 , 1.00000 ,
   0.00000 , 0.54118 , 1.00000 ,
   0.00000 , 0.52549 , 1.00000 ,
   0.00000 , 0.50980 , 1.00000 ,
   0.00000 , 0.49412 , 1.00000 ,
   0.00000 , 0.47843 , 1.00000 ,
   0.00000 , 0.46275 , 1.00000 ,
   0.00000 , 0.44706 , 1.00000 ,
   0.00000 , 0.43137 , 1.00000 ,
   0.00000 , 0.41569 , 1.00000 ,
   0.00000 , 0.40000 , 1.00000 ,
   0.00000 , 0.38431 , 1.00000 ,
   0.00000 , 0.36863 , 1.00000 ,
   0.00000 , 0.35294 , 1.00000 ,
   0.00000 , 0.33333 , 1.00000 ,
   0.00000 , 0.31765 , 1.00000 ,
   0.00000 , 0.30196 , 1.00000 ,
   0.00000 , 0.28627 , 1.00000 ,
   0.00000 , 0.27059 , 1.00000 ,
   0.00000 , 0.25490 , 1.00000 ,
   0.00000 , 0.23922 , 1.00000 ,
   0.00000 , 0.22353 , 1.00000 ,
   0.00000 , 0.20784 , 1.00000 ,
   0.00000 , 0.19216 , 1.00000 ,
   0.00000 , 0.17647 , 1.00000 ,
   0.00000 , 0.16078 , 1.00000 ,
   0.00000 , 0.14510 , 1.00000 ,
   0.00000 , 0.12941 , 1.00000 ,
   0.00000 , 0.11373 , 1.00000 ,
   0.00000 , 0.09804 , 1.00000 ,
   0.00000 , 0.08235 , 1.00000 ,
   0.00000 , 0.06667 , 1.00000 ,
   0.00000 , 0.05098 , 1.00000 ,
   0.00000 , 0.03529 , 1.00000 ,
   0.00000 , 0.01961 , 1.00000 ,
   0.00000 , 0.00000 , 1.00000 ,
   0.00000 , 0.00000 , 1.00000 ,
   0.01569 , 0.00000 , 1.00000 ,
   0.03137 , 0.00000 , 1.00000 ,
   0.04706 , 0.00000 , 1.00000 ,
   0.06275 , 0.00000 , 1.00000 ,
   0.07843 , 0.00000 , 1.00000 ,
   0.09412 , 0.00000 , 1.00000 ,
   0.10980 , 0.00000 , 1.00000 ,
   0.12549 , 0.00000 , 1.00000 ,
   0.14118 , 0.00000 , 1.00000 ,
   0.15686 , 0.00000 , 1.00000 ,
   0.17255 , 0.00000 , 1.00000 ,
   0.18824 , 0.00000 , 1.00000 ,
   0.20392 , 0.00000 , 1.00000 ,
   0.21961 , 0.00000 , 1.00000 ,
   0.23529 , 0.00000 , 1.00000 ,
   0.25098 , 0.00000 , 1.00000 ,
   0.26667 , 0.00000 , 1.00000 ,
   0.28235 , 0.00000 , 1.00000 ,
   0.29804 , 0.00000 , 1.00000 ,
   0.31373 , 0.00000 , 1.00000 ,
   0.33333 , 0.00000 , 1.00000 ,
   0.34902 , 0.00000 , 1.00000 ,
   0.36471 , 0.00000 , 1.00000 ,
   0.38039 , 0.00000 , 1.00000 ,
   0.39608 , 0.00000 , 1.00000 ,
   0.41176 , 0.00000 , 1.00000 ,
   0.42745 , 0.00000 , 1.00000 ,
   0.44314 , 0.00000 , 1.00000 ,
   0.45882 , 0.00000 , 1.00000 ,
   0.47451 , 0.00000 , 1.00000 ,
   0.49020 , 0.00000 , 1.00000 ,
   0.50588 , 0.00000 , 1.00000 ,
   0.52157 , 0.00000 , 1.00000 ,
   0.53725 , 0.00000 , 1.00000 ,
   0.55294 , 0.00000 , 1.00000 ,
   0.56863 , 0.00000 , 1.00000 ,
   0.58431 , 0.00000 , 1.00000 ,
   0.60000 , 0.00000 , 1.00000 ,
   0.61569 , 0.00000 , 1.00000 ,
   0.63137 , 0.00000 , 1.00000 ,
   0.64706 , 0.00000 , 1.00000 ,
   0.66667 , 0.00000 , 1.00000 ,
   0.68235 , 0.00000 , 1.00000 ,
   0.69804 , 0.00000 , 1.00000 ,
   0.71373 , 0.00000 , 1.00000 ,
   0.72941 , 0.00000 , 1.00000 ,
   0.74510 , 0.00000 , 1.00000 ,
   0.76078 , 0.00000 , 1.00000 ,
   0.77647 , 0.00000 , 1.00000 ,
   0.79216 , 0.00000 , 1.00000 ,
   0.80784 , 0.00000 , 1.00000 ,
   0.82353 , 0.00000 , 1.00000 ,
   0.83922 , 0.00000 , 1.00000 ,
   0.85490 , 0.00000 , 1.00000 ,
   0.87059 , 0.00000 , 1.00000 ,
   0.88627 , 0.00000 , 1.00000 ,
   0.90196 , 0.00000 , 1.00000 ,
   0.91765 , 0.00000 , 1.00000 ,
   0.93333 , 0.00000 , 1.00000 ,
   0.94902 , 0.00000 , 1.00000 ,
   0.96471 , 0.00000 , 1.00000 ,
   0.98039 , 0.00000 , 1.00000 ,
   1.00000 , 0.00000 , 1.00000 ,
   1.00000 , 0.00000 , 1.00000 ,
   1.00000 , 0.00000 , 0.98431 ,
   1.00000 , 0.00000 , 0.96863 ,
   1.00000 , 0.00000 , 0.95294 ,
   1.00000 , 0.00000 , 0.93725 ,
   1.00000 , 0.00000 , 0.92157 ,
   1.00000 , 0.00000 , 0.90588 ,
   1.00000 , 0.00000 , 0.89020 ,
   1.00000 , 0.00000 , 0.87451 ,
   1.00000 , 0.00000 , 0.85490 ,
   1.00000 , 0.00000 , 0.83922 ,
   1.00000 , 0.00000 , 0.82353 ,
   1.00000 , 0.00000 , 0.80784 ,
   1.00000 , 0.00000 , 0.79216 ,
   1.00000 , 0.00000 , 0.77647 ,
   1.00000 , 0.00000 , 0.76078 ,
   1.00000 , 0.00000 , 0.74510 ,
   1.00000 , 0.00000 , 0.72941 ,
   1.00000 , 0.00000 , 0.70980 ,
   1.00000 , 0.00000 , 0.69412 ,
   1.00000 , 0.00000 , 0.67843 ,
   1.00000 , 0.00000 , 0.66275 ,
   1.00000 , 0.00000 , 0.64706 ,
   1.00000 , 0.00000 , 0.63137 ,
   1.00000 , 0.00000 , 0.61569 ,
   1.00000 , 0.00000 , 0.60000 ,
   1.00000 , 0.00000 , 0.58431 ,
   1.00000 , 0.00000 , 0.56471 ,
   1.00000 , 0.00000 , 0.54902 ,
   1.00000 , 0.00000 , 0.53333 ,
   1.00000 , 0.00000 , 0.51765 ,
   1.00000 , 0.00000 , 0.50196 ,
   1.00000 , 0.00000 , 0.48627 ,
   1.00000 , 0.00000 , 0.47059 ,
   1.00000 , 0.00000 , 0.45490 ,
   1.00000 , 0.00000 , 0.43922 ,
   1.00000 , 0.00000 , 0.41961 ,
   1.00000 , 0.00000 , 0.40392 ,
   1.00000 , 0.00000 , 0.38824 ,
   1.00000 , 0.00000 , 0.37255 ,
   1.00000 , 0.00000 , 0.35686 ,
   1.00000 , 0.00000 , 0.34118 ,
   1.00000 , 0.00000 , 0.32549 ,
   1.00000 , 0.00000 , 0.30980 ,
   1.00000 , 0.00000 , 0.29412 ,
   1.00000 , 0.00000 , 0.27451 ,
   1.00000 , 0.00000 , 0.25882 ,
   1.00000 , 0.00000 , 0.24314 ,
   1.00000 , 0.00000 , 0.22745 ,
   1.00000 , 0.00000 , 0.21176 ,
   1.00000 , 0.00000 , 0.19608 ,
   1.00000 , 0.00000 , 0.18039 ,
   1.00000 , 0.00000 , 0.16471 ,
   1.00000 , 0.00000 , 0.14902 ,
   1.00000 , 0.00000 , 0.12941 ,
   1.00000 , 0.00000 , 0.11373 ,
   1.00000 , 0.00000 , 0.09804 ,
   1.00000 , 0.00000 , 0.08235 ,
   1.00000 , 0.00000 , 0.06667 ,
   1.00000 , 0.00000 , 0.05098 ,
   1.00000 , 0.00000 , 0.03529 ,
   1.00000 , 0.00000 , 0.01961 ,
   1.00000 , 0.00000 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
};
/*! \var static float idl2[256*3]
 *  \brief Black-Blue-Red-Black
 *  Automatically generated from NEMO's lut2c script - do not edit */
static float idl2[256*3] = { 
   0.00000 , 0.00000 , 0.00000 ,
   0.01176 , 0.00000 , 0.00000 ,
   0.02745 , 0.00000 , 0.00000 ,
   0.04314 , 0.00000 , 0.00000 ,
   0.05882 , 0.00000 , 0.00000 ,
   0.07451 , 0.00000 , 0.00000 ,
   0.08627 , 0.00000 , 0.00000 ,
   0.10196 , 0.00000 , 0.00000 ,
   0.11765 , 0.00000 , 0.00000 ,
   0.13333 , 0.00000 , 0.00000 ,
   0.14902 , 0.00000 , 0.00000 ,
   0.16078 , 0.00000 , 0.00000 ,
   0.17647 , 0.00000 , 0.00000 ,
   0.19216 , 0.00000 , 0.00000 ,
   0.20784 , 0.00000 , 0.00000 ,
   0.22353 , 0.00000 , 0.00000 ,
   0.23529 , 0.00000 , 0.00000 ,
   0.25098 , 0.00000 , 0.00000 ,
   0.26667 , 0.00000 , 0.00000 ,
   0.28235 , 0.00000 , 0.00000 ,
   0.29804 , 0.00000 , 0.00000 ,
   0.30980 , 0.00000 , 0.00000 ,
   0.32549 , 0.00000 , 0.00000 ,
   0.34118 , 0.00000 , 0.00000 ,
   0.35686 , 0.00000 , 0.00000 ,
   0.37255 , 0.00000 , 0.00000 ,
   0.38431 , 0.00000 , 0.00000 ,
   0.40000 , 0.00000 , 0.00000 ,
   0.41569 , 0.00000 , 0.00000 ,
   0.43137 , 0.00000 , 0.00000 ,
   0.44706 , 0.00000 , 0.00000 ,
   0.45882 , 0.00000 , 0.00000 ,
   0.47451 , 0.00000 , 0.00000 ,
   0.49020 , 0.00000 , 0.00000 ,
   0.50588 , 0.00000 , 0.00000 ,
   0.52157 , 0.00000 , 0.00000 ,
   0.53725 , 0.00000 , 0.00000 ,
   0.54902 , 0.00000 , 0.00000 ,
   0.56471 , 0.00000 , 0.00000 ,
   0.58039 , 0.00000 , 0.00000 ,
   0.59608 , 0.00000 , 0.00000 ,
   0.61176 , 0.00000 , 0.00000 ,
   0.62353 , 0.00000 , 0.00000 ,
   0.63922 , 0.00000 , 0.00000 ,
   0.65490 , 0.00000 , 0.00000 ,
   0.67059 , 0.00000 , 0.00000 ,
   0.68627 , 0.00000 , 0.00000 ,
   0.69804 , 0.00000 , 0.00000 ,
   0.71373 , 0.00000 , 0.00000 ,
   0.72941 , 0.00000 , 0.00000 ,
   0.74510 , 0.00000 , 0.00000 ,
   0.76078 , 0.00000 , 0.00000 ,
   0.77255 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.80392 , 0.00000 , 0.00000 ,
   0.81961 , 0.00000 , 0.00000 ,
   0.83529 , 0.00000 , 0.00000 ,
   0.84706 , 0.00000 , 0.00000 ,
   0.86275 , 0.00000 , 0.00000 ,
   0.87843 , 0.00000 , 0.00000 ,
   0.89412 , 0.00000 , 0.00000 ,
   0.90980 , 0.00000 , 0.00000 ,
   0.92157 , 0.00000 , 0.00000 ,
   0.93725 , 0.00000 , 0.00000 ,
   0.95294 , 0.00000 , 0.00000 ,
   0.96863 , 0.01176 , 0.00000 ,
   0.98431 , 0.02745 , 0.00000 ,
   1.00000 , 0.04314 , 0.00000 ,
   0.98431 , 0.05882 , 0.00000 ,
   0.96863 , 0.07451 , 0.00000 ,
   0.95294 , 0.09020 , 0.00000 ,
   0.93725 , 0.10588 , 0.00000 ,
   0.92157 , 0.12157 , 0.00000 ,
   0.90196 , 0.13725 , 0.00000 ,
   0.88627 , 0.15294 , 0.00000 ,
   0.87059 , 0.16863 , 0.00000 ,
   0.85490 , 0.18431 , 0.00000 ,
   0.83922 , 0.20000 , 0.00000 ,
   0.82353 , 0.21569 , 0.00000 ,
   0.80392 , 0.23137 , 0.00000 ,
   0.78824 , 0.24706 , 0.00000 ,
   0.77255 , 0.26275 , 0.00000 ,
   0.75686 , 0.27843 , 0.00000 ,
   0.74118 , 0.29412 , 0.00000 ,
   0.72157 , 0.30980 , 0.00000 ,
   0.70588 , 0.32549 , 0.00000 ,
   0.69020 , 0.34118 , 0.00000 ,
   0.67451 , 0.35686 , 0.00000 ,
   0.65882 , 0.37255 , 0.00000 ,
   0.64314 , 0.38824 , 0.00000 ,
   0.62353 , 0.40392 , 0.00000 ,
   0.60784 , 0.41961 , 0.00000 ,
   0.59216 , 0.43529 , 0.00000 ,
   0.57647 , 0.45098 , 0.00000 ,
   0.56078 , 0.46667 , 0.00000 ,
   0.54118 , 0.48235 , 0.00000 ,
   0.52549 , 0.49804 , 0.00000 ,
   0.50980 , 0.51373 , 0.00000 ,
   0.49412 , 0.52941 , 0.00000 ,
   0.47843 , 0.54510 , 0.00000 ,
   0.46275 , 0.56078 , 0.00000 ,
   0.44314 , 0.57647 , 0.00000 ,
   0.42745 , 0.59216 , 0.00000 ,
   0.41176 , 0.60784 , 0.00000 ,
   0.39608 , 0.62353 , 0.00000 ,
   0.38039 , 0.63922 , 0.00000 ,
   0.36078 , 0.65490 , 0.00000 ,
   0.34510 , 0.67059 , 0.00000 ,
   0.32941 , 0.68627 , 0.00000 ,
   0.31373 , 0.70196 , 0.00000 ,
   0.29804 , 0.71765 , 0.00000 ,
   0.28235 , 0.73333 , 0.00000 ,
   0.26275 , 0.74902 , 0.00000 ,
   0.24706 , 0.76471 , 0.00000 ,
   0.23137 , 0.78039 , 0.00000 ,
   0.21569 , 0.79608 , 0.00000 ,
   0.20000 , 0.81176 , 0.00000 ,
   0.18039 , 0.82745 , 0.00000 ,
   0.16471 , 0.84314 , 0.00000 ,
   0.14902 , 0.85882 , 0.00000 ,
   0.13333 , 0.87451 , 0.00000 ,
   0.11765 , 0.89020 , 0.00000 ,
   0.10196 , 0.90588 , 0.00000 ,
   0.08235 , 0.92157 , 0.00000 ,
   0.06667 , 0.93725 , 0.00000 ,
   0.05098 , 0.95294 , 0.00000 ,
   0.03529 , 0.96863 , 0.00000 ,
   0.01961 , 0.98431 , 0.01176 ,
   0.00000 , 1.00000 , 0.02745 ,
   0.00000 , 0.98431 , 0.04314 ,
   0.00000 , 0.96863 , 0.05882 ,
   0.00000 , 0.95294 , 0.07451 ,
   0.00000 , 0.93725 , 0.09020 ,
   0.00000 , 0.92157 , 0.10588 ,
   0.00000 , 0.90588 , 0.11765 ,
   0.00000 , 0.89020 , 0.13333 ,
   0.00000 , 0.87451 , 0.14902 ,
   0.00000 , 0.85882 , 0.16471 ,
   0.00000 , 0.84314 , 0.18039 ,
   0.00000 , 0.82745 , 0.19608 ,
   0.00000 , 0.81176 , 0.21176 ,
   0.00000 , 0.79608 , 0.22353 ,
   0.00000 , 0.78039 , 0.23922 ,
   0.00000 , 0.76471 , 0.25490 ,
   0.00000 , 0.74902 , 0.27059 ,
   0.00000 , 0.73333 , 0.28627 ,
   0.00000 , 0.71765 , 0.30196 ,
   0.00000 , 0.70196 , 0.31765 ,
   0.00000 , 0.68627 , 0.33333 ,
   0.00000 , 0.66667 , 0.34510 ,
   0.00000 , 0.65098 , 0.36078 ,
   0.00000 , 0.63529 , 0.37647 ,
   0.00000 , 0.61961 , 0.39216 ,
   0.00000 , 0.60392 , 0.40784 ,
   0.00000 , 0.58824 , 0.42353 ,
   0.00000 , 0.57255 , 0.43922 ,
   0.00000 , 0.55686 , 0.45098 ,
   0.00000 , 0.54118 , 0.46667 ,
   0.00000 , 0.52549 , 0.48235 ,
   0.00000 , 0.50980 , 0.49804 ,
   0.00000 , 0.49412 , 0.51373 ,
   0.00000 , 0.47843 , 0.52941 ,
   0.00000 , 0.46275 , 0.54510 ,
   0.00000 , 0.44706 , 0.55686 ,
   0.00000 , 0.43137 , 0.57255 ,
   0.00000 , 0.41569 , 0.58824 ,
   0.00000 , 0.40000 , 0.60392 ,
   0.00000 , 0.38431 , 0.61961 ,
   0.00000 , 0.36863 , 0.63529 ,
   0.00000 , 0.35294 , 0.65098 ,
   0.00000 , 0.33333 , 0.66667 ,
   0.00000 , 0.31765 , 0.67843 ,
   0.00000 , 0.30196 , 0.69412 ,
   0.00000 , 0.28627 , 0.70980 ,
   0.00000 , 0.27059 , 0.72549 ,
   0.00000 , 0.25490 , 0.74118 ,
   0.00000 , 0.23922 , 0.75686 ,
   0.00000 , 0.22353 , 0.77255 ,
   0.00000 , 0.20784 , 0.78431 ,
   0.00000 , 0.19216 , 0.80000 ,
   0.00000 , 0.17647 , 0.81569 ,
   0.00000 , 0.16078 , 0.83137 ,
   0.00000 , 0.14510 , 0.84706 ,
   0.00000 , 0.12941 , 0.86275 ,
   0.00000 , 0.11373 , 0.87843 ,
   0.00000 , 0.09804 , 0.89020 ,
   0.00000 , 0.08235 , 0.90588 ,
   0.00000 , 0.06667 , 0.92157 ,
   0.00000 , 0.05098 , 0.93725 ,
   0.00000 , 0.03529 , 0.95294 ,
   0.00000 , 0.01961 , 0.96863 ,
   0.00000 , 0.00000 , 0.98431 ,
   0.00000 , 0.00000 , 1.00000 ,
   0.00000 , 0.00000 , 0.98431 ,
   0.00000 , 0.00000 , 0.96863 ,
   0.00000 , 0.00000 , 0.95294 ,
   0.00000 , 0.00000 , 0.93725 ,
   0.00000 , 0.00000 , 0.92157 ,
   0.00000 , 0.00000 , 0.90588 ,
   0.00000 , 0.00000 , 0.89020 ,
   0.00000 , 0.00000 , 0.87451 ,
   0.00000 , 0.00000 , 0.85882 ,
   0.00000 , 0.00000 , 0.84314 ,
   0.00000 , 0.00000 , 0.82745 ,
   0.00000 , 0.00000 , 0.81176 ,
   0.00000 , 0.00000 , 0.79608 ,
   0.00000 , 0.00000 , 0.78039 ,
   0.00000 , 0.00000 , 0.76471 ,
   0.00000 , 0.00000 , 0.74902 ,
   0.00000 , 0.00000 , 0.73333 ,
   0.00000 , 0.00000 , 0.71765 ,
   0.00000 , 0.00000 , 0.70196 ,
   0.00000 , 0.00000 , 0.68627 ,
   0.00000 , 0.00000 , 0.66667 ,
   0.00000 , 0.00000 , 0.65098 ,
   0.00000 , 0.00000 , 0.63529 ,
   0.00000 , 0.00000 , 0.61961 ,
   0.00000 , 0.00000 , 0.60392 ,
   0.00000 , 0.00000 , 0.58824 ,
   0.00000 , 0.00000 , 0.57255 ,
   0.00000 , 0.00000 , 0.55686 ,
   0.00000 , 0.00000 , 0.54118 ,
   0.00000 , 0.00000 , 0.52549 ,
   0.00000 , 0.00000 , 0.50980 ,
   0.00000 , 0.00000 , 0.49412 ,
   0.00000 , 0.00000 , 0.47843 ,
   0.00000 , 0.00000 , 0.46275 ,
   0.00000 , 0.00000 , 0.44706 ,
   0.00000 , 0.00000 , 0.43137 ,
   0.00000 , 0.00000 , 0.41569 ,
   0.00000 , 0.00000 , 0.40000 ,
   0.00000 , 0.00000 , 0.38431 ,
   0.00000 , 0.00000 , 0.36863 ,
   0.00000 , 0.00000 , 0.35294 ,
   0.00000 , 0.00000 , 0.33333 ,
   0.00000 , 0.00000 , 0.31765 ,
   0.00000 , 0.00000 , 0.30196 ,
   0.00000 , 0.00000 , 0.28627 ,
   0.00000 , 0.00000 , 0.27059 ,
   0.00000 , 0.00000 , 0.25490 ,
   0.00000 , 0.00000 , 0.23922 ,
   0.00000 , 0.00000 , 0.22353 ,
   0.00000 , 0.00000 , 0.20784 ,
   0.00000 , 0.00000 , 0.19216 ,
   0.00000 , 0.00000 , 0.17647 ,
   0.00000 , 0.00000 , 0.16078 ,
   0.00000 , 0.00000 , 0.14510 ,
   0.00000 , 0.00000 , 0.12941 ,
   0.00000 , 0.00000 , 0.11373 ,
   0.00000 , 0.00000 , 0.09804 ,
   0.00000 , 0.00000 , 0.08235 ,
   0.00000 , 0.00000 , 0.06667 ,
   0.00000 , 0.00000 , 0.05098 ,
   0.00000 , 0.00000 , 0.03529 ,
   0.00000 , 0.00000 , 0.01961 ,
   0.00000 , 0.00000 , 0.00000 ,
};
/*! \var static float rainbow[256*3] 
 *  \brief Red-Blue-Black
 *   Automatically generated from NEMO's lut2c script - do not edit */
static float rainbow[256*3] = { 
   0.00000 , 0.00000 , 0.16471 ,
   0.02745 , 0.00000 , 0.18431 ,
   0.05882 , 0.00000 , 0.20000 ,
   0.08627 , 0.00000 , 0.21961 ,
   0.11373 , 0.00000 , 0.23922 ,
   0.14510 , 0.00000 , 0.25882 ,
   0.17647 , 0.00000 , 0.27843 ,
   0.20392 , 0.00000 , 0.29804 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.26275 , 0.00000 , 0.33725 ,
   0.29412 , 0.00000 , 0.35686 ,
   0.32157 , 0.00000 , 0.37647 ,
   0.35294 , 0.00000 , 0.39608 ,
   0.38039 , 0.00000 , 0.41569 ,
   0.41176 , 0.00000 , 0.43529 ,
   0.43922 , 0.00000 , 0.45490 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.49804 , 0.00000 , 0.49412 ,
   0.52941 , 0.00000 , 0.51373 ,
   0.55686 , 0.00000 , 0.53725 ,
   0.58824 , 0.00000 , 0.55686 ,
   0.55686 , 0.00000 , 0.57647 ,
   0.52941 , 0.00000 , 0.59608 ,
   0.49804 , 0.00000 , 0.61569 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.43922 , 0.00000 , 0.65882 ,
   0.41176 , 0.00000 , 0.67843 ,
   0.38039 , 0.00000 , 0.70196 ,
   0.35294 , 0.00000 , 0.72157 ,
   0.32157 , 0.00000 , 0.74118 ,
   0.29412 , 0.00000 , 0.76471 ,
   0.26275 , 0.00000 , 0.78431 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.20392 , 0.00000 , 0.82745 ,
   0.17647 , 0.00000 , 0.84706 ,
   0.14510 , 0.00000 , 0.87059 ,
   0.11373 , 0.00000 , 0.89020 ,
   0.08627 , 0.00000 , 0.91373 ,
   0.05882 , 0.00000 , 0.93333 ,
   0.02745 , 0.00000 , 0.95686 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 1.00000 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00784 , 0.95686 ,
   0.00000 , 0.01569 , 0.93333 ,
   0.00000 , 0.02353 , 0.91373 ,
   0.00000 , 0.03137 , 0.89020 ,
   0.00000 , 0.03922 , 0.87059 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.06275 , 0.83137 ,
   0.00000 , 0.07843 , 0.81176 ,
   0.00000 , 0.09804 , 0.79216 ,
   0.00000 , 0.11765 , 0.77255 ,
   0.00000 , 0.13725 , 0.75294 ,
   0.00000 , 0.15686 , 0.73333 ,
   0.00000 , 0.17647 , 0.71373 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.21569 , 0.67451 ,
   0.00000 , 0.23529 , 0.65882 ,
   0.00000 , 0.25490 , 0.64314 ,
   0.00000 , 0.27059 , 0.62745 ,
   0.00000 , 0.28627 , 0.61176 ,
   0.00000 , 0.30196 , 0.59608 ,
   0.00000 , 0.32157 , 0.58039 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.34510 , 0.54902 ,
   0.00000 , 0.35686 , 0.53333 ,
   0.00000 , 0.36863 , 0.51765 ,
   0.00000 , 0.38039 , 0.50196 ,
   0.00000 , 0.39216 , 0.48627 ,
   0.00000 , 0.40392 , 0.47059 ,
   0.00000 , 0.41176 , 0.45882 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.43529 , 0.43529 ,
   0.00000 , 0.44706 , 0.42353 ,
   0.00000 , 0.45882 , 0.41176 ,
   0.00000 , 0.46667 , 0.40000 ,
   0.00000 , 0.47843 , 0.38824 ,
   0.00000 , 0.49020 , 0.37647 ,
   0.00000 , 0.49804 , 0.36471 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.52157 , 0.34118 ,
   0.00000 , 0.52941 , 0.32941 ,
   0.00000 , 0.54118 , 0.31765 ,
   0.00000 , 0.55294 , 0.30588 ,
   0.00000 , 0.56078 , 0.29412 ,
   0.00000 , 0.57255 , 0.28235 ,
   0.00000 , 0.58431 , 0.27059 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.60392 , 0.24706 ,
   0.00000 , 0.61176 , 0.23529 ,
   0.00000 , 0.62353 , 0.22353 ,
   0.00000 , 0.63137 , 0.21176 ,
   0.00000 , 0.64314 , 0.20000 ,
   0.00000 , 0.65098 , 0.18824 ,
   0.00000 , 0.66275 , 0.17647 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.68235 , 0.15294 ,
   0.00000 , 0.69020 , 0.14118 ,
   0.00000 , 0.70196 , 0.12941 ,
   0.00000 , 0.70980 , 0.11765 ,
   0.00000 , 0.72157 , 0.10196 ,
   0.00000 , 0.72941 , 0.08627 ,
   0.00000 , 0.74118 , 0.07059 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.76078 , 0.03922 ,
   0.00000 , 0.76863 , 0.02353 ,
   0.00000 , 0.77647 , 0.00000 ,
   0.00000 , 0.78824 , 0.00000 ,
   0.00000 , 0.79608 , 0.00000 ,
   0.00000 , 0.80784 , 0.00000 ,
   0.00000 , 0.81569 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.83529 , 0.00000 ,
   0.00000 , 0.84314 , 0.00000 ,
   0.00000 , 0.85490 , 0.00000 ,
   0.00000 , 0.86275 , 0.00000 ,
   0.00000 , 0.87059 , 0.00000 ,
   0.00000 , 0.88235 , 0.00000 ,
   0.00000 , 0.89020 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.90980 , 0.00000 ,
   0.00000 , 0.91765 , 0.00000 ,
   0.00000 , 0.92549 , 0.00000 ,
   0.00000 , 0.93725 , 0.00000 ,
   0.00000 , 0.94510 , 0.00000 ,
   0.00000 , 0.95294 , 0.00000 ,
   0.00000 , 0.96078 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.98039 , 0.00000 ,
   0.00000 , 0.98824 , 0.00000 ,
   0.00784 , 1.00000 , 0.00000 ,
   0.01569 , 0.98824 , 0.00000 ,
   0.02353 , 0.98039 , 0.00000 ,
   0.03137 , 0.97255 , 0.00000 ,
   0.04314 , 0.96078 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.06667 , 0.94510 , 0.00000 ,
   0.07843 , 0.93725 , 0.00000 ,
   0.09020 , 0.92549 , 0.00000 ,
   0.10196 , 0.91765 , 0.00000 ,
   0.11373 , 0.90980 , 0.00000 ,
   0.12549 , 0.89804 , 0.00000 ,
   0.13725 , 0.89020 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.16471 , 0.87059 , 0.00000 ,
   0.20000 , 0.86275 , 0.00000 ,
   0.23529 , 0.85490 , 0.00000 ,
   0.26667 , 0.84314 , 0.00000 ,
   0.30588 , 0.83529 , 0.00000 ,
   0.34118 , 0.82353 , 0.00000 ,
   0.37647 , 0.81569 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.44706 , 0.79608 , 0.00000 ,
   0.48627 , 0.78824 , 0.00000 ,
   0.52157 , 0.77647 , 0.00000 ,
   0.56078 , 0.76863 , 0.00000 ,
   0.59608 , 0.77647 , 0.00000 ,
   0.63529 , 0.78824 , 0.00000 ,
   0.67059 , 0.80000 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.74902 , 0.82745 , 0.00000 ,
   0.78431 , 0.84314 , 0.00000 ,
   0.82353 , 0.85882 , 0.00000 ,
   0.85882 , 0.87059 , 0.00000 ,
   0.89804 , 0.89020 , 0.00000 ,
   0.93333 , 0.90196 , 0.00000 ,
   0.97647 , 0.92157 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.95294 , 0.00000 ,
   1.00000 , 0.96863 , 0.00000 ,
   1.00000 , 0.98824 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   0.99608 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 0.97647 , 0.00000 ,
   1.00000 , 0.93725 , 0.00000 ,
   1.00000 , 0.89804 , 0.00000 ,
   1.00000 , 0.85882 , 0.00000 ,
   1.00000 , 0.81961 , 0.00000 ,
   1.00000 , 0.78039 , 0.00000 ,
   1.00000 , 0.74118 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.66275 , 0.00000 ,
   1.00000 , 0.62353 , 0.00000 ,
   1.00000 , 0.58431 , 0.00000 ,
   1.00000 , 0.54510 , 0.00000 ,
   1.00000 , 0.50980 , 0.00000 ,
   1.00000 , 0.46667 , 0.00000 ,
   1.00000 , 0.43137 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.35294 , 0.00000 ,
   1.00000 , 0.31765 , 0.00000 ,
   1.00000 , 0.27451 , 0.00000 ,
   1.00000 , 0.23922 , 0.00000 ,
   1.00000 , 0.20000 , 0.00000 ,
   1.00000 , 0.16863 , 0.00000 ,
   1.00000 , 0.12941 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.08235 , 0.00000 ,
   1.00000 , 0.06275 , 0.00000 ,
   1.00000 , 0.04706 , 0.00000 ,
   1.00000 , 0.02353 , 0.00000 ,
   1.00000 , 0.00000 , 0.00000 ,
   0.99216 , 0.00000 , 0.00000 ,
   0.98431 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.96863 , 0.00000 , 0.00000 ,
   0.96078 , 0.00000 , 0.00000 ,
   0.95294 , 0.00000 , 0.00000 ,
   0.94510 , 0.00000 , 0.00000 ,
   0.93725 , 0.00000 , 0.00000 ,
   0.92941 , 0.00000 , 0.00000 ,
   0.92157 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.90588 , 0.00000 , 0.00000 ,
   0.89804 , 0.00000 , 0.00000 ,
   0.89020 , 0.00000 , 0.00000 ,
   0.88235 , 0.00000 , 0.00000 ,
   0.87451 , 0.00000 , 0.00000 ,
   0.86667 , 0.00000 , 0.00000 ,
   0.85882 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.84314 , 0.00000 , 0.00000 ,
   0.83529 , 0.00000 , 0.00000 ,
   0.82745 , 0.00000 , 0.00000 ,
   0.81961 , 0.00000 , 0.00000 ,
   0.81176 , 0.00000 , 0.00000 ,
   0.80392 , 0.00000 , 0.00000 ,
   0.79608 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78039 , 0.00000 , 0.00000 ,
   0.77255 , 0.00000 , 0.00000 ,
   0.76471 , 0.00000 , 0.00000 ,
   0.75686 , 0.00000 , 0.00000 ,
   0.74902 , 0.00000 , 0.00000 ,
   0.74118 , 0.00000 , 0.00000 ,
   0.73333 , 0.00000 , 0.00000 ,
};
/*! \var static float step32[256*3]
 *  \brief Rainbow in 32 steps
 *   Automatically generated from NEMO's lut2c script - do not edit */
static float step32[256*3] = { 
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.00000 , 0.00000 , 0.16471 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.23137 , 0.00000 , 0.31765 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.47451 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.47059 , 0.00000 , 0.63922 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.23137 , 0.00000 , 0.80392 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.00000 , 0.97647 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.05098 , 0.85098 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.19608 , 0.69412 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.33333 , 0.56471 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.42353 , 0.44706 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.50980 , 0.35294 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.59216 , 0.25882 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.67059 , 0.16471 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.74902 , 0.05490 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.82353 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.89804 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.00000 , 0.97255 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.05490 , 0.95294 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.14902 , 0.88235 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.41176 , 0.80784 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   0.70980 , 0.81176 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 0.93333 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 1.00000 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.70196 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.39216 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   1.00000 , 0.09804 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.97647 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.91373 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.85098 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
   0.78824 , 0.00000 , 0.00000 ,
};

/*! \struct RGB 
 *  \brief Structure typedef containing RGB color tables. */
typedef struct RGB_s {
   char *name;
   float *rgb;
} RGB;
/*! \var static RGB rgb[]
 *  \brief RGB color tables */
static RGB rgb[] = {
    {"rainbow", rainbow},
    {"jh_colors", jh_colors},
    {"step8", step8},
    {"step32", step32},
    {"idl1", idl1},
    {"idl2", idl2},
    {"heat", heat},
    {0,0}
};
