# -*- coding: utf-8 -*-
# Authored by: Ryan

from amazon_ad.api.base import ZADOpenAPI

# CreateReportRequestBodyV2.type
REPORT_TYPE_ENUM = ["CAMPAIGN", "INVENTORY", "AUDIENCE", "PRODUCTS", "TECHNOLOGY", "GEOGRAPHY"]


# CreateReportRequestBodyV2.format
REPORT_FORMAT_ENUM = ["JSON", "CSV"]


# CreateReportRequestBodyV2.metrics
# These fields will be added when reportType is CAMPAIGN, INVENTORY, or AUDIENCE.
COMMON_FIELDS = [
    "totalCost",
    "supplyCost",
    "amazonAudienceFee",
    "advertiserTimezone",
    "advertiserCountry",
    "amazonPlatformFee",
    "impressions",
    "clickThroughs",
    "CTR",
    "eCPM",
    "eCPC",
    "dpv14d",
    "dpvViews14d",
    "dpvClicks14d",
    "dpvr14d",
    "eCPDPV14d",
    "pRPV14d",
    "pRPVViews14d",
    "pRPVClicks14d",
    "pRPVr14d",
    "eCPPRPV14d",
    "atl14d",
    "atlViews14d",
    "atlClicks14d",
    "atlr14d",
    "eCPAtl14d",
    "atc14d",
    "atcViews14d",
    "atcClicks14d",
    "atcr14d",
    "eCPAtc14d",
    "purchases14d",
    "purchasesViews14d",
    "purchasesClicks14d",
    "purchaseRate14d",
    "eCPP14d",
    "newToBrandPurchases14d",
    "newToBrandPurchasesViews14d",
    "newToBrandPurchasesClicks14d",
    "newToBrandPurchaseRate14d",
    "newToBrandECPP14d",
    "percentOfPurchasesNewToBrand14d",
    "addToWatchlist14d",
    "addToWatchlistViews14d",
    "addToWatchlistClicks14d",
    "addToWatchlistCVR14d",
    "addToWatchlistCPA14d",
    "downloadedVideoPlays14d",
    "downloadedVideoPlaysViews14d",
    "downloadedVideoPlaysClicks14d",
    "downloadedVideoPlayRate14d",
    "eCPDVP14d",
    "videoStreams14d",
    "videoStreamsViews14d",
    "videoStreamsClicks14d",
    "videoStreamsRate14d",
    "eCPVS14d",
    "playTrailers14d",
    "playTrailersViews14d",
    "playerTrailersClicks14d",
    "playTrailerRate14d",
    "eCPPT14d",
    "rentals14d",
    "rentalsViews14d",
    "rentalsClicks14d",
    "rentalRate14d",
    "ecpr14d",
    "videoDownloads14d",
    "videoDownloadsViews14d",
    "videoDownloadsClicks14d",
    "videoDownloadRate14d",
    "ecpvd14d",
    "newSubscribeAndSave14d",
    "newSubscribeAndSaveViews14d",
    "newSubscribeAndSaveClicks14d",
    "newSubscribeAndSaveRate14d",
    "eCPnewSubscribeAndSave14d",
    "totalPixel14d",
    "totalPixelViews14d",
    "totalPixelClicks14d",
    "totalPixelCVR14d",
    "totalPixelCPA14d",
    "marketingLandingPage14d",
    "marketingLandingPageViews14d",
    "marketingLandingPageClicks14d",
    "marketingLandingPageCVR14d",
    "marketingLandingPageCPA14d",
    "subscriptionPage14d",
    "subscriptionPageViews14d",
    "subscriptionPageClicks14d",
    "subscriptionPageCVR14d",
    "subscriptionPageCPA14d",
    "signUpPage14d",
    "signUpPageViews14d",
    "signUpPageClicks14d",
    "signUpPageCVR14d",
    "signUpPageCPA14d",
    "application14d",
    "applicationViews14d",
    "applicationClicks14d",
    "applicationCVR14d",
    "applicationCPA14d",
    "gameLoad14d",
    "gameLoadViews14d",
    "gameLoadClicks14d",
    "gameLoadCVR14d",
    "gameLoadCPA14d",
    "widgetLoad14d",
    "widgetLoadViews14d",
    "widgetLoadClicks14d",
    "widgetLoadCVR14d",
    "widgetLoadCPA14d",
    "surveyStart14d",
    "surveyStartViews14d",
    "surveyStartClicks14d",
    "surveyStartCVR14d",
    "surveyStartCPA14d",
    "surveyFinish14d",
    "surveyFinishViews14d",
    "surveyFinishClicks14d",
    "surveyFinishCVR14d",
    "surveyFinishCPA14d",
    "bannerInteraction14d",
    "bannerInteractionViews14d",
    "bannerInteractionClicks14d",
    "bannerInteractionCVR14d",
    "bannerInteractionCPA14d",
    "widgetInteraction14d",
    "widgetInteractionViews14d",
    "widgetInteractionClicks14d",
    "widgetInteractionCVR14d",
    "widgetInteractionCPA14d",
    "gameInteraction14d",
    "gameInteractionViews14d",
    "gameInteractionClicks14d",
    "gameInteractionCVR14d",
    "gameInteractionCPA14d",
    "emailLoad14d",
    "emailLoadViews14d",
    "emailLoadClicks14d",
    "emailLoadCVR14d",
    "emailLoadCPA14d",
    "emailInteraction14d",
    "emailInteractionViews14d",
    "emailInteractionClicks14d",
    "emailInteractionCVR14d",
    "emailInteractionCPA14d",
    "submitButton14d",
    "submitButtonViews14d",
    "submitButtonClicks14d",
    "submitButtonCVR14d",
    "submitButtonCPA14d",
    "purchaseButton14d",
    "purchaseButtonViews14d",
    "purchaseButtonClicks14d",
    "purchaseButtonCVR14d",
    "purchaseButtonCPA14d",
    "clickOnRedirect14d",
    "clickOnRedirectViews14d",
    "clickOnRedirectClicks14d",
    "clickOnRedirectCVR14d",
    "clickOnRedirectCPA14d",
    "signUpButton14d",
    "signUpButtonViews14d",
    "signUpButtonClicks14d",
    "signUpButtonCVR14d",
    "signUpButtonCPA14d",
    "subscriptionButton14d",
    "subscriptionButtonViews14d",
    "subscriptionButtonClicks14d",
    "subscriptionButtonCVR14d",
    "subscriptionButtonCPA14d",
    "successPage14d",
    "successPageViews14d",
    "successPageClicks14d",
    "successPageCVR14d",
    "successPageCPA14d",
    "thankYouPage14d",
    "thankYouPageViews14d",
    "thankYouPageClicks14d",
    "thankYouPageCVR14d",
    "thankYouPageCPA14d",
    "registrationForm14d",
    "registrationFormViews14d",
    "registrationFormClicks14d",
    "registrationFormCVR14d",
    "registrationFormCPA14d",
    "registrationConfirmPage14d",
    "registrationConfirmPageViews14d",
    "registrationConfirmPageClicks14d",
    "registrationConfirmPageCVR14d",
    "registrationConfirmPageCPA14d",
    "storeLocatorPage14d",
    "storeLocatorPageViews14d",
    "storeLocatorPageClicks14d",
    "storeLocatorPageCVR14d",
    "storeLocatorPageCPA14d",
    "mobileAppFirstStarts14d",
    "mobileAppFirstStartViews14d",
    "mobileAppFirstStartClicks14d",
    "mobileAppFirstStartCVR14d",
    "mobileAppFirstStartsCPA14d",
    "brandStoreEngagement1",
    "brandStoreEngagement1Views",
    "brandStoreEngagement1Clicks",
    "brandStoreEngagement1CVR",
    "brandStoreEngagement1CPA",
    "brandStoreEngagement2",
    "brandStoreEngagement2Views",
    "brandStoreEngagement2Clicks",
    "brandStoreEngagement2CVR",
    "brandStoreEngagement2CPA",
    "brandStoreEngagement3",
    "brandStoreEngagement3Views",
    "brandStoreEngagement3Clicks",
    "brandStoreEngagement3CVR",
    "brandStoreEngagement3CPA",
    "brandStoreEngagement4",
    "brandStoreEngagement4Views",
    "brandStoreEngagement4Clicks",
    "brandStoreEngagement4CVR",
    "brandStoreEngagement4CPA",
    "brandStoreEngagement5",
    "brandStoreEngagement5Views",
    "brandStoreEngagement5Clicks",
    "brandStoreEngagement5CVR",
    "brandStoreEngagement5CPA",
    "brandStoreEngagement6",
    "brandStoreEngagement6Views",
    "brandStoreEngagement6Clicks",
    "brandStoreEngagement6CVR",
    "brandStoreEngagement6CPA",
    "brandStoreEngagement7",
    "brandStoreEngagement7Views",
    "brandStoreEngagement7Clicks",
    "brandStoreEngagement7CVR",
    "brandStoreEngagement7CPA",
    "addedToShoppingCart14d",
    "addedToShoppingCartViews14d",
    "addedToShoppingCartClicks14d",
    "addedToShoppingCartCVR14d",
    "addedToShoppingCartCPA14d",
    "productPurchased",
    "productPurchasedViews",
    "productPurchasedClicks",
    "productPurchasedCVR",
    "productPurchasedCPA",
    "homepageVisit14d",
    "homepageVisitViews14d",
    "homepageVisitClicks14d",
    "homepageVisitCVR14d",
    "homepageVisitCPA14d",
    "videoStarted",
    "videoStartedViews",
    "videoStartedClicks",
    "videoStartedCVR",
    "videoStartedCPA",
    "videoCompleted",
    "videoCompletedViews",
    "videoEndClicks",
    "videoCompletedCVR",
    "videoCompletedCPA",
    "messageSent14d",
    "messageSentViews14d",
    "messageSentClicks14d",
    "messageSentCVR14d",
    "messageSentCPA14d",
    "mashupClickToPage",
    "mashupClickToPageViews",
    "mashupClickToPageClicks",
    "mashupClickToPageCVR",
    "mashupClickToPageCPA",
    "mashupBackupImage",
    "mashupBackupImageViews",
    "mashupBackupImageClicks",
    "mashupBackupImageCVR",
    "mashupBackupImageCPA",
    "mashupAddToCart14d",
    "mashupAddToCartViews14d",
    "mashupAddToCartClicks14d",
    "mashupAddToCartClickCVR14d",
    "mashupAddToCartCPA14d",
    "mashupAddToWishlist14d",
    "mashupAddToWishlistViews14d",
    "mashupAddToWishlistClicks14d",
    "mashupAddToWishlistCVR14d",
    "mashupAddToWishlistCPA14d",
    "mashupSubscribeAndSave14d",
    "mashupSubscribeAndSaveClickViews14d",
    "mashupSubscribeAndSaveClick14d",
    "mashupSubscribeAndSaveCVR14d",
    "mashupSubscribeAndSaveCPA14d",
    "mashupClipCouponClick14d",
    "mashupClipCouponClickViews14d",
    "mashupClipCouponClickClicks14d",
    "mashupClipCouponClickCVR14d",
    "mashupClipCouponClickCPA14d",
    "mashupShopNowClick14d",
    "mashupShopNowClickViews14d",
    "mashupShopNowClickClicks14d",
    "mashupShopNowClickCVR14d",
    "mashupShopNowClickCPA14d",
    "referral14d",
    "referralViews14d",
    "referralClicks14d",
    "referralCVR14d",
    "referralCPA14d",
    "accept14d",
    "acceptViews14d",
    "acceptClicks14d",
    "acceptCVR14d",
    "acceptCPA14d",
    "decline14d",
    "declineViews14d",
    "declineClicks14d",
    "declineCVR14d",
    "declineCPA14d",
    "videoStart",
    "videoFirstQuartile",
    "videoMidpoint",
    "videoThirdQuartile",
    "videoComplete",
    "videoCompletionRate",
    "ecpvc",
    "videoPause",
    "videoResume",
    "videoMute",
    "videoUnmute",
    "dropDownSelection14d",
    "dropDownSelectionViews14d",
    "dropDownSelectionClicks14d",
    "dropDownSelectionCVR14d",
    "dropDownSelectionCPA14d",
    "brandSearch14d",
    "brandSearchViews14d",
    "brandSearchClicks14d",
    "brandSearchRate14d",
    "brandSearchCPA14d",
    "grossImpressions",
    "grossClickThroughs",
    "invalidImpressions",
    "invalidClickThroughs",
    "invalidImpressionRate",
    "invalidClickThroughsRate",
]

# These fields will be added when reportType is Campaign.
CAMPAIGN_FIELDS = [
    "agencyFee",
    "totalFee",
    "3pFeeAutomotive",
    "3pFeeAutomotiveAbsorbed",
    "3pFeeComScore",
    "3pFeeComScoreAbsorbed",
    "3pFeeCPM1",
    "3pFeeCPM1Absorbed",
    "3pFeeCPM2",
    "3pFeeCPM2Absorbed",
    "3pFeeCPM3",
    "3pFeeCPM3Absorbed",
    "3pFeeDoubleclickCampaignManager",
    "3pFeeDoubleclickCampaignManagerAbsorbed",
    "3pFeeDoubleVerify",
    "3pFeeDoubleVerifyAbsorbed",
    "3pFeeIntegralAdScience",
    "3pFeeIntegralAdScienceAbsorbed",
    "3PFees",
    "unitsSold14d",
    "sales14d",
    "ROAS14d",
    "eRPM14d",
    "newToBrandUnitsSold14d",
    "newToBrandProductSales14d",
    "newToBrandROAS14d",
    "newToBrandERPM14d",
    "totalPRPV14d",
    "totalPRPVViews14d",
    "totalPRPVClicks14d",
    "totalPRPVr14d",
    "totalECPPRPV14d",
    "totalPurchases14d",
    "totalPurchasesViews14d",
    "totalPurchasesClicks14d",
    "totalPurchaseRate14d",
    "totalECPP14d",
    "totalNewToBrandPurchases14d",
    "totalNewToBrandPurchasesViews14d",
    "totalNewToBrandPurchasesClicks14d",
    "totalNewToBrandPurchaseRate14d",
    "totalNewToBrandECPP14d",
    "totalPercentOfPurchasesNewToBrand14d",
    "totalUnitsSold14d",
    "totalSales14d",
    "totalROAS14d",
    "totalERPM14d",
    "totalNewToBrandUnitsSold14d",
    "totalNewToBrandProductSales14d",
    "totalNewToBrandROAS14d",
    "totalNewToBrandERPM14d",
    "viewableImpressions",
    "measurableImpressions",
    "measurableRate",
    "viewabilityRate",
    "totalDetailPageViews14d",
    "totalDetailPageViewViews14d",
    "totalDetailPageClicks14d",
    "totalDetailPageViewsCVR14d",
    "totalDetaiPageViewCPA14d",
    "totalAddToList14d",
    "totalAddToListViews14d",
    "totalAddToListClicks14d",
    "totalAddToListCVR14d",
    "totalAddToListCPA14d",
    "totalAddToCart14d",
    "totalAddToCartViews14d",
    "totalAddToCartClicks14d",
    "totalAddToCartCVR14d",
    "totalAddToCartCPA14d",
    "totalSubscribeAndSaveSubscriptions14d",
    "totalSubscribeAndSaveSubscriptionViews14d",
    "totalSubscribeAndSaveSubscriptionClicks14d",
    "totalSubscribeAndSaveSubscriptionCVR14d",
    "totalSubscribeAndSaveSubscriptionCPA14d",
]

# These fields will be added when reportType is Inventory
INVENTORY_FIELDS = [
    "agencyFee",
    "totalFee",
    "3pFeeAutomotive",
    "3pFeeAutomotiveAbsorbed",
    "3pFeeComScore",
    "3pFeeComScoreAbsorbed",
    "3pFeeCPM1",
    "3pFeeCPM1Absorbed",
    "3pFeeCPM2",
    "3pFeeCPM2Absorbed",
    "3pFeeCPM3",
    "3pFeeCPM3Absorbed",
    "3pFeeDoubleclickCampaignManager",
    "3pFeeDoubleclickCampaignManagerAbsorbed",
    "3pFeeDoubleVerify",
    "3pFeeDoubleVerifyAbsorbed",
    "3pFeeIntegralAdScience",
    "3pFeeIntegralAdScienceAbsorbed",
    "3PFees",
    "unitsSold14d",
    "sales14d",
    "ROAS14d",
    "eRPM14d",
    "newToBrandUnitsSold14d",
    "newToBrandProductSales14d",
    "newToBrandROAS14d",
    "newToBrandERPM14d",
    "totalPRPV14d",
    "totalPRPVViews14d",
    "totalPRPVClicks14d",
    "totalPRPVr14d",
    "totalECPPRPV14d",
    "totalPurchases14d",
    "totalPurchasesViews14d",
    "totalPurchasesClicks14d",
    "totalPurchaseRate14d",
    "totalECPP14d",
    "totalNewToBrandPurchases14d",
    "totalNewToBrandPurchasesViews14d",
    "totalNewToBrandPurchasesClicks14d",
    "totalNewToBrandPurchaseRate14d",
    "totalNewToBrandECPP14d",
    "totalPercentOfPurchasesNewToBrand14d",
    "totalUnitsSold14d",
    "totalSales14d",
    "totalROAS14d",
    "totalERPM14d",
    "totalNewToBrandUnitsSold14d",
    "totalNewToBrandProductSales14d",
    "totalNewToBrandROAS14d",
    "totalNewToBrandERPM14d",
    "viewableImpressions",
    "measurableImpressions",
    "measurableRate",
    "viewabilityRate",
    "totalDetailPageViews14d",
    "totalDetailPageViewViews14d",
    "totalDetailPageClicks14d",
    "totalDetailPageViewsCVR14d",
    "totalDetaiPageViewCPA14d",
    "totalAddToList14d",
    "totalAddToListViews14d",
    "totalAddToListClicks14d",
    "totalAddToListCVR14d",
    "totalAddToListCPA14d",
    "totalAddToCart14d",
    "totalAddToCartViews14d",
    "totalAddToCartClicks14d",
    "totalAddToCartCVR14d",
    "totalAddToCartCPA14d",
    "totalSubscribeAndSaveSubscriptions14d",
    "totalSubscribeAndSaveSubscriptionViews14d",
    "totalSubscribeAndSaveSubscriptionClicks14d",
    "totalSubscribeAndSaveSubscriptionCVR14d",
    "totalSubscribeAndSaveSubscriptionCPA14d",
    "placementName",
    "placementSize",
    "dealType",
]

# These fields will be added when reportType is Audience.
AUDIENCE_FIELDS = [
    "lineitemtype",
    "segmentClassCode",
    "segmentSource",
    "segmentType",
    "segmentMarketplaceID",
    "targetingMethod",
]

# These fields can be specified when reportType is PRODUCTS.
PRODUCT_FIELDS = [
    "reportGranularity(Default)",
    "amazonStandardId(Default)",
    "parentASIN(Default)",
    "marketplace(Default)",
    "brandName(Default)",
    "asinConversionType(Default)",
    "featuredASIN(Default)",
    "productName",
    "productGroup",
    "productCategory",
    "productSubcategory",
    "dpv14d",
    "dpvViews14d",
    "dpvClicks14d",
    "pRPV14d",
    "pRPVViews14d",
    "pRPVClicks14d",
    "atl14d",
    "atlViews14d",
    "atlClicks14d",
    "atc14d",
    "atcViews14d",
    "atcClicks14d",
    "purchases14d",
    "purchasesViews14d",
    "purchasesClicks14d",
    "newToBrandPurchases14d",
    "newToBrandPurchasesViews14d",
    "newToBrandPurchasesClicks14d",
    "percentOfPurchasesNewToBrand14d",
    "totalDetailPageViews14d",
    "totalDetailPageViewViews14d",
    "totalDetailPageClicks14d",
    "totalPRPV14d",
    "totalPRPVViews14d",
    "totalPRPVClicks14d",
    "totalAddToList14d",
    "totalAddToListViews14d",
    "totalAddToListClicks14d",
    "totalAddToCart14d",
    "totalAddToCartViews14d",
    "totalAddToCartClicks14d",
    "totalPurchases14d",
    "totalPurchasesViews14d",
    "totalPurchasesClicks14d",
    "totalNewToBrandPurchases14d",
    "totalNewToBrandPurchasesViews14d",
    "totalNewToBrandPurchasesClicks14d",
    "totalPercentOfPurchasesNewToBrand14d",
    "newSubscribeAndSave14d",
    "newSubscribeAndSaveViews14d",
    "newSubscribeAndSaveClicks14d",
    "totalSubscribeAndSaveSubscriptions14d",
    "totalSubscribeAndSaveSubscriptionViews14d",
    "totalSubscribeAndSaveSubscriptionClicks14d",
    "unitsSold14d",
    "sales14d",
    "totalUnitsSold14d",
    "totalSales14d",
    "newToBrandUnitsSold14d",
    "newToBrandProductSales14d",
    "brandHaloDetailPage14d",
    "brandHaloDetailPageViews14d",
    "brandHaloDetailPageClicks14d",
    "brandHaloProductReviewPage14d",
    "brandHaloProductReviewPageViews14d",
    "brandHaloProductReviewPageClicks14d",
    "brandHaloAddToList14d",
    "brandHaloAddToListViews14d",
    "brandHaloAddToListClicks14d",
    "brandHaloAddToCart14d",
    "brandHaloAddToCartViews14d",
    "brandHaloAddToCartClicks14d",
    "brandHaloPurchases14d",
    "brandHaloPurchasesViews14d",
    "brandHaloPurchasesClicks14d",
    "brandHaloNewToBrandPurchases14d",
    "brandHaloNewToBrandPurchasesViews14d",
    "brandHaloNewToBrandPurchasesClicks14d",
    "brandHaloPercentOfPurchasesNewToBrand14d",
    "brandHaloNewSubscribeAndSave14d",
    "brandHaloNewSubscribeAndSaveViews14d",
    "brandHaloNewSubscribeAndSaveClicks14d",
    "brandHaloTotalUnitsSold14d",
    "brandHaloTotalSales14d",
    "brandHaloTotalNewToBrandSales14d",
    "brandHaloTotalNewToBrandUnitsSold14d",
]

# These fields can be specified when reportType is TECHNOLOGY or Geography.
TECH_AND_GEO_FIELDS = [
    "agencyFee",
    "totalCost",
    "impressions",
    "viewableImpressions",
    "clickThroughs",
    "totalPixel14d",
    "totalPixelViews14d",
    "totalPixelClicks14d",
    "marketingLandingPage14d",
    "marketingLandingPageViews14d",
    "marketingLandingPageClicks14d",
    "subscriptionPage14d",
    "subscriptionPageViews14d",
    "subscriptionPageClicks14d",
    "signUpPage14d",
    "signUpPageViews14d",
    "signUpPageClicks14d",
    "application14d",
    "applicationViews14d",
    "applicationClicks14d",
    "gameLoad14d",
    "gameLoadViews14d",
    "gameLoadClicks14d",
    "widgetLoad14d",
    "widgetLoadViews14d",
    "widgetLoadClicks14d",
    "surveyStart14d",
    "surveyStartViews14d",
    "surveyStartClicks14d",
    "surveyFinish14d",
    "surveyFinishViews14d",
    "surveyFinishClicks14d",
    "bannerInteraction14d",
    "bannerInteractionViews14d",
    "bannerInteractionClicks14d",
    "widgetInteraction14d",
    "widgetInteractionViews14d",
    "widgetInteractionClicks14d",
    "gameInteraction14d",
    "gameInteractionViews14d",
    "gameInteractionClicks14d",
    "emailLoad14d",
    "emailLoadViews14d",
    "emailLoadClicks14d",
    "emailInteraction14d",
    "emailInteractionViews14d",
    "emailInteractionClicks14d",
    "submitButton14d",
    "submitButtonViews14d",
    "submitButtonClicks14d",
    "purchaseButton14d",
    "purchaseButtonViews14d",
    "purchaseButtonClicks14d",
    "clickOnRedirect14d",
    "clickOnRedirectViews14d",
    "clickOnRedirectClicks14d",
    "dropDownSelection14d",
    "dropDownSelectionViews14d",
    "dropDownSelectionClicks14d",
    "signUpButton14d",
    "signUpButtonViews14d",
    "signUpButtonClicks14d",
    "subscriptionButton14d",
    "subscriptionButtonViews14d",
    "subscriptionButtonClicks14d",
    "successPage14d",
    "successPageViews14d",
    "successPageClicks14d",
    "thankYouPage14d",
    "thankYouPageViews14d",
    "thankYouPageClicks14d",
    "registrationForm14d",
    "registrationFormViews14d",
    "registrationFormClicks14d",
    "registrationConfirmPage14d",
    "registrationConfirmPageViews14d",
    "registrationConfirmPageClicks14d",
    "storeLocatorPage14d",
    "storeLocatorPageViews14d",
    "storeLocatorPageClicks14d",
    "mobileAppFirstStarts14d",
    "mobileAppFirstStartViews14d",
    "mobileAppFirstStartClicks14d",
    "brandStoreEngagement1",
    "brandStoreEngagement1Views",
    "brandStoreEngagement1Clicks",
    "brandStoreEngagement2",
    "brandStoreEngagement2Views",
    "brandStoreEngagement2Clicks",
    "brandStoreEngagement3",
    "brandStoreEngagement3Views",
    "brandStoreEngagement3Clicks",
    "brandStoreEngagement4",
    "brandStoreEngagement4Views",
    "brandStoreEngagement4Clicks",
    "brandStoreEngagement5",
    "brandStoreEngagement5Views",
    "brandStoreEngagement5Clicks",
    "brandStoreEngagement6",
    "brandStoreEngagement6Views",
    "brandStoreEngagement6Clicks",
    "brandStoreEngagement7",
    "brandStoreEngagement7Views",
    "brandStoreEngagement7Clicks",
    "addedToShoppingCart14d",
    "addedToShoppingCartViews14d",
    "addedToShoppingCartClicks14d",
    "productPurchased",
    "productPurchasedViews",
    "productPurchasedClicks",
    "homepageVisit14d",
    "homepageVisitViews14d",
    "homepageVisitClicks14d",
    "videoStarted",
    "videoStartedViews",
    "videoStartedClicks",
    "videoCompleted",
    "videoCompletedViews",
    "videoEndClicks",
    "messageSent14d",
    "messageSentViews14d",
    "messageSentClicks14d",
    "mashupClickToPage",
    "mashupClickToPageViews",
    "mashupClickToPageClicks",
    "mashupBackupImage",
    "mashupBackupImageViews",
    "mashupBackupImageClicks",
    "mashupAddToCart14d",
    "mashupAddToCartViews14d",
    "mashupAddToCartClicks14d",
    "mashupAddToWishlist14d",
    "mashupAddToWishlistViews14d",
    "mashupAddToWishlistClicks14d",
    "mashupSubscribeAndSave14d",
    "mashupSubscribeAndSaveClickViews14d",
    "mashupSubscribeAndSaveClick14d",
    "mashupClipCouponClick14d",
    "mashupClipCouponClickViews14d",
    "mashupClipCouponClickClicks14d",
    "mashupShopNowClick14d",
    "mashupShopNowClickViews14d",
    "mashupShopNowClickClicks14d",
    "referral14d",
    "referralViews14d",
    "referralClicks14d",
    "accept14d",
    "acceptViews14d",
    "acceptClicks14d",
    "decline14d",
    "declineViews14d",
    "declineClicks14d",
    "dpv14d",
    "dpvViews14d",
    "dpvClicks14d",
    "pRPV14d",
    "pRPVViews14d",
    "pRPVClicks14d",
    "atl14d",
    "atlViews14d",
    "atlClicks14d",
    "atc14d",
    "atcViews14d",
    "atcClicks14d",
    "purchases14d",
    "purchasesViews14d",
    "purchasesClicks14d",
    "newToBrandPurchases14d",
    "newToBrandPurchasesViews14d",
    "newToBrandPurchasesClicks14d",
    "newSubscribeAndSave14d",
    "newSubscribeAndSaveViews14d",
    "newSubscribeAndSaveClicks14d",
    "addToWatchlist14d",
    "addToWatchlistViews14d",
    "addToWatchlistClicks14d",
    "downloadedVideoPlays14d",
    "downloadedVideoPlaysViews14d",
    "downloadedVideoPlaysClicks14d",
    "videoStreams14d",
    "videoStreamsViews14d",
    "videoStreamsClicks14d",
    "playTrailers14d",
    "playTrailersViews14d",
    "playerTrailersClicks14d",
    "rentals14d",
    "rentalsViews14d",
    "rentalsClicks14d",
    "videoDownloads14d",
    "videoDownloadsViews14d",
    "videoDownloadsClicks14d",
    "videoStart",
    "videoFirstQuartile",
    "videoMidpoint",
    "videoThirdQuartile",
    "videoComplete",
    "videoPause",
    "videoResume",
    "videoMute",
    "videoUnmute",
    "unitsSold14d",
    "sales14d",
    "newToBrandUnitsSold14d",
    "newToBrandProductSales14d",
    "brandSearch14d",
    "brandSearchViews14d",
    "brandSearchClicks14d",
    "brandSearchRate14d",
    "brandSearchCPA14d",
    "grossImpressions",
    "grossClickThroughs",
    "invalidImpressions",
    "invalidClickThroughs",
    "invalidImpressionRate",
    "invalidClickThroughsRate",
]


# CreateReportRequestBodyV2.dimensions
DIMENSIONS_ENUM = [
    "ORDER", "LINE_ITEM", "CREATIVE", "SITE", "SUPPLY", "DEAL", "COUNTRY", "STATE_COUNTY_REGION", "CITY", "DMA",
    "POSTAL_CODE", "OPERATING_SYSTEM", "BROWSER_TYPE", "BROWSER_VERSION", "DEVICE_TYPE", "ENVIRONMENT_TYPE"
]

DIMENSIONS_DEFAULT_FIELDS = [
    # "date (for timeUnit DAILY)",  # TIME_UNIT_FIELDS 中取
    # "intervalStart (for timeUnit SUMMARY)",  # TIME_UNIT_FIELDS 中取
    # "intervalEnd (for timeUnit SUMMARY)",  # TIME_UNIT_FIELDS 中取
    # "segment (Only present for AUDIENCE Report)",  # TODO 需要单独去添加
    "entityId",
    "advertiserName",
    "advertiserId",
]

DIMENSIONS_FIELDS = {
    "ORDER": [
        "orderName",
        "orderId",
        "orderStartDate",
        "orderEndDate",
        "orderBudget",
        "orderExternalId",
        "orderCurrency",
    ],
    "LINE_ITEM": [
        "lineItemName",
        "lineItemId",
        "lineItemStartDate",
        "lineItemEndDate",
        "lineItemBudget",
        "lineItemExternalId",
    ],
    "CREATIVE": [
        "creativeName",
        "creativeID",
        "creativeType",
        "creativeSize",
        "creativeAdId",
    ],
    "SITE": [
        "siteName",
    ],
    "SUPPLY": [
        "supplySourceName",
    ],
    "DEAL": [
        "deal",
        "dealID",
    ],
    "COUNTRY": [
        "country",
    ],
    "STATE_COUNTY_REGION": [
        "region",
    ],
    "CITY": [
        "city",
    ],
    "DMA": [
        "designatedMarketAreaCode",
        "designatedMarketAreaName",
    ],
    "POSTAL_CODE": [
        "postalCode",
    ],
    "OPERATING_SYSTEM": [
        "operatingSystem",
    ],
    "BROWSER_TYPE": [
        "browser",
    ],
    "BROWSER_VERSION": [
        "browserVersion",
    ],
    "DEVICE_TYPE": [
        "device",
    ],
    "ENVIRONMENT_TYPE": [
        "environmentType",
    ],
}

# 如果列表为空或为空，则报告数据的聚合在 ORDER 级别。
# 允许的值可以在此数组中一起用作允许值，在这种情况下，报告聚合将处于最低聚合级别，并且报告将包含报告中包含的所有维度的字段。
REPORT_TYPE_DIMENSIONS_MAPPING = {
    "CAMPAIGN": ["ORDER", "LINE_ITEM", "CREATIVE"],
    "INVENTORY": ["ORDER", "LINE_ITEM", "SITE", "SUPPLY", "DEAL"],
    "AUDIENCE": ["ORDER", "LINE_ITEM"],
    "PRODUCTS": ["ORDER", "LINE_ITEM"],
    "TECHNOLOGY": ["ORDER", "LINE_ITEM", "OPERATING_SYSTEM", "BROWSER_TYPE", "BROWSER_VERSION", "DEVICE_TYPE",
                   "ENVIRONMENT_TYPE"],
    "GEOGRAPHY": ["ORDER", "LINE_ITEM", "COUNTRY", "STATE_COUNTY_REGION", "CITY", "DMA", "POSTAL_CODE"],
}


# CreateReportRequestBodyV2.timeUnit
TIME_UNIT_ENUM = ["DAILY", "SUMMARY"]
TIME_UNIT_FIELDS = {"SUMMARY": ["intervalStart", "intervalEnd"],
                    "DAILY": ["Date"]}


class DspReport(ZADOpenAPI):

    def get_header(self):
        _headers = {
            'Amazon-Advertising-API-ClientId': self._client.client_id,
            'Authorization': 'Bearer %s' % self._client.access_token,
            'Content-Type': 'application/vnd.dspcreatereports.v2_2+json',  # 'application/json'
            'Connection': 'close',
        }

        if self._client.profile_id is not None:
            _headers.update(
                {
                    "Amazon-Advertising-API-Scope": self._client.profile_id
                }
            )

        return _headers

    def request(self,
                report_type=None,
                start_date=None,
                end_date=None,
                time_unit=None,
                dimensions=None,
                metrics=None,
                advertiser_ids=None,
                order_ids=None,
                report_format=None,
                ):
        """
        POST    /dsp/reports
        """

        path = '/dsp/reports'

        assert report_type in REPORT_TYPE_ENUM

        if not time_unit:
            time_unit = "SUMMARY"
        assert time_unit in TIME_UNIT_ENUM

        if not dimensions:
            dimensions = "ORDER"
        assert dimensions in REPORT_TYPE_DIMENSIONS_MAPPING[report_type]

        if not report_format:
            report_format = "JSON"
        assert report_format in REPORT_FORMAT_ENUM

        data = {
            "type": report_type,
            "format": report_format,
            "timeUnit": time_unit,
            "startDate": start_date,
            "endDate": end_date,
            "dimensions": dimensions,
        }

        if isinstance(metrics, (list, tuple)):
            metrics = ','.join(metrics)

        if metrics:
            data["metrics"] = metrics

        if advertiser_ids:
            data["advertiserIds"] = advertiser_ids

        if order_ids:
            data["orderIds"] = order_ids

        return self.post(path, data)

    def _get_metrics(self, metrics, default):
        if not metrics:
            metrics = default

        return metrics

    def campaign(self, start_date=None, end_date=None, dimensions=None):
        # metrics = self._get_metrics(metrics, None)
        return self.request(report_type='CAMPAIGN', start_date=start_date, end_date=end_date, dimensions=dimensions)

    def campaign_order(self, start_date=None, end_date=None):
        return self.request(report_type='CAMPAIGN', dimensions="ORDER", start_date=start_date, end_date=end_date)
