# generated by datamodel-codegen:
#   filename:  api/feed/createThread.json
#   timestamp: 2022-10-26T10:25:00+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...entity.feed import thread
from ...type import basic, entityReference


class CreateTaskDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    type: thread.TaskType
    assignees: entityReference.EntityReferenceList = Field(
        ..., description='List of users or teams the task is assigned to'
    )
    oldValue: Optional[str] = Field(
        None, description='The value of old object for which the task is created.'
    )
    suggestion: Optional[str] = Field(
        None, description='The suggestion object for the task provided by the creator.'
    )


class CreateThreadRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    message: str = Field(..., description='Message')
    from_: str = Field(
        ...,
        alias='from',
        description='Name of the User (regular user or bot) posting the message',
    )
    addressedTo: Optional[basic.EntityLink] = Field(
        None,
        description='User or team this thread is addressed to in format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
    )
    about: basic.EntityLink = Field(
        ...,
        description='Data asset about which this thread is created for with format <#E::{entities}::{entityType}::{field}::{fieldValue}',
    )
    type: Optional[thread.ThreadType] = None
    taskDetails: Optional[CreateTaskDetails] = None
    announcementDetails: Optional[thread.AnnouncementDetails] = None
