# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pynfogen', 'pynfogen.cli']

package_data = \
{'': ['*']}

install_requires = \
['Unidecode>=1.2.0,<2.0.0',
 'appdirs>=1.4.4,<2.0.0',
 'click>=8.0.0,<9.0.0',
 'dunamai>=1.5.5,<2.0.0',
 'pycountry>=20.7.3,<21.0.0',
 'pyd2v>=1.3.0,<2.0.0',
 'pymediainfo>=5.1.0,<6.0.0',
 'pytomlpp>=1.0.3,<2.0.0',
 'requests>=2.25.1,<3.0.0']

entry_points = \
{'console_scripts': ['nfo = pynfogen.cli:cli']}

setup_kwargs = {
    'name': 'pynfogen',
    'version': '1.0.0',
    'description': 'Scriptable MediaInfo-fed NFO Generator for Movies and TV',
    'long_description': '# pynfogen\n\n[![License](https://img.shields.io/github/license/rlaphoenix/pynfogen)](https://github.com/rlaphoenix/pynfogen/blob/master/LICENSE)\n[![Python version tests](https://img.shields.io/github/workflow/status/rlaphoenix/pynfogen/Build)](https://github.com/rlaphoenix/pynfogen/releases)\n[![Python versions](https://img.shields.io/pypi/pyversions/pynfogen)](https://pypi.python.org/pypi/pynfogen)\n[![PyPI version](https://img.shields.io/pypi/v/pynfogen)](https://pypi.python.org/pypi/pynfogen)\n[![GitHub issues](https://img.shields.io/github/issues/rlaphoenix/pynfogen)](https://github.com/rlaphoenix/pynfogen/issues)\n[![DeepSource issues](https://deepsource.io/gh/rlaphoenix/pynfogen.svg/?label=active+issues)](https://deepsource.io/gh/rlaphoenix/pynfogen)\n\nScriptable MediaInfo-fed NFO Generator for Movies and TV.\n\n## Installation\n\n    pip install --user pynfogen\n\n## Development\n\n### Dependencies\n\n- [Python](https://python.org/downloads) (v3.6 or newer)\n- [PIP](https://pip.pypa.io/en/stable/installing) (v19.0 or newer)\n- [Poetry](https://python-poetry.org/docs) (latest recommended)\n\n### Installation\n\n1. `git clone https://github.com/rlaphoenix/pynfogen`\n2. `cd pynfogen`\n3. `poetry config virtualenvs.in-project true` (optional, but recommended)\n4. `poetry install`\n5. `nfo -h`\n\n## F.A.Q\n\nUsing pynfogen is fairly simple, it\'s a multi-command CLI program. You can see up-to-date help information by\nrunning `nfo --help`, or reading the readme file.\n\nThe main command is `generate`, which will create NFO and description files based on *one* file. The description file\nis intended to be used for a forum or post, while the NFO file is intended to be shared alongside the release.\nHowever, modern day media sharing platforms do not allow either to be shared with the files, but allow them to be with\nthe forum thread or post instead.\n\n### What is an NFO?\n\nAn NFO (aka .nfo, .NFO, a contraction of "Info" or "Information") is a commonly used filename extension for text files\nthat accompany various releases with information about them.\n\nThey are used to deliver release information about the media, such as the title, release date, authorship, etc. They\nalso commonly contain elaborate [ANSI art](https://en.wikipedia.org/wiki/ANSI_art).\n\nAn NFO is generally archaic, do not think otherwise. Originally, NFO files would be shared through IRC, Usenet,\nEmail, etc. However, these days, most platforms do not allow NFO files to be shared with the release itself, but\nrather within a forum thread or post. NFOs are becoming more and more phased out in P2P sharing, but still remains\nin use in some cases.\n\nWhile there isn\'t any hard-rules, If you plan to create a modern-style NFO then the following is recommended:\n\n- Max line-length of 70 characters.\n- Text should not reach the edge of the file (col. 1 and 70), instead it should be padded by spacing or ANSI art.\n- Text-encoding should be UTF-8 and not CP437. CP437 is far too restricted compared to UTF-8.\n\nNote that, elaborate ANSI art is no longer really used or wanted. Modern NFO files tend to be verbose with minimal\nANSI art, rather than concise with elaborate ANSI art.\n\n### What should I do after installation?\n\nOn initial installation, you won\'t have any [artwork](#templates) or [templates](#templates). You can take a\nlook at some example artwork and template files within the git project.\nHowever, please see the [Copyright](#copyright-agreement-for-included-artwork-and-template-files) relating to the\nincluded artwork and template files before you start using them.\n\nYou may also want to take a look at the [Configuration](#configuration) options.\n\nOnce you have everything set up as much as you want, simply take a look at the available commands with `nfo --help`.\nThe main command you want to take a look at would be `nfo generate -h`.\n\n### What file do I pass to `nfo generate`?\n\nIt\'s simple actually. Pass whichever file you wish best describes the release, as in whichever gives the most\nappropriate metadata and such that will be used within the NFO.\n\nLet\'s say you\'re doing an NFO for a full season release, but the first episode has a problem and isn\'t representative\nof most of the season, then use the second episode.\n\nIt\'s important to specify the appropriate `-s/--season`, `-e/--episode` parameters (or not!) as they clue in pynfogen\nwhat kind of media this release is (wheter it\'s a Movie, a Season, or a Episode). More information on this can be seen\nin `nfo generate -h`.\n\nFinally, if pynfogen get\'s clued in that it\'s a season release, then it takes the release name from the folder name\nof the parent folder of the file you passed. It\'s also important not to include any other file except the files you\nwill be releasing within said folder. Otherwise it may cause mistakes with the season episode count.\n\n## Templates\n\nThere are three kinds of templates to use. NFO Template, Description Template, and Artwork Templates.\n\n| Template             | Description                                                                        | File Extension |\n| -------------------- | ---------------------------------------------------------------------------------- | -------------- |\n| NFO Template         | Primary Scriptable, structural data, like the Title, Year, Media Information, etc. | .nfo           |\n| Description Template | Similar to NFO templates, but are used for the description output.                 | .desc.txt      |\n| Artwork Template     | Used for surrounding the template output with art, common text, etc.               | .nfo           |\n\nTo give you an example scenerio. I would create an Artwork template named \'phoenix\' with concise ASCII artwork placed\nabove the NFO, and an NFO template for \'season\', \'episode\', and \'movie\' releases. I would also make a corresponding\nDescription template for each of those NFO templates. I now have the ability to create NFO files for a Full Season\nrelease, a Single Episode release, or a Single Movie release. E.g. `nfo generate movie Movie.2021.mkv -a phoenix`.\n\nIf you notice you are copy pasting something between templates that is not structural or media information, then\nyou should probably put it into the Artwork Template instead. Or, if you notice you are changing something in a\ntemplate often, for a different kind of release, perhaps think of making a seperate template for those kinds of\nreleases.\n\nArtwork templates are not applied to the Description output, they are only used for the NFO output.\n\nDescription templates are intended to be the contents or body of your forum post, IRC message, Email, etc.\nNot the NFO to share alongside you\'re release directly.\n\nWhere-as, NFO templates are intended to be shared alongside the release. However, not all platforms allow you to\nshare the .NFO directly with the file, but may ask you to share it separately, e.g. a specific input field.\n\n## Configuration\n\nAll configuration is optional, and currently quite minimal. Configuration can be done manually to the configuration\nfile, or via `nfo config` (see `nfo config -h`). All available config options are listed below (with descriptions).\n\n| Key            | Type   | Description                                                                    |\n| -------------- | ------ | ------------------------------------------------------------------------------ |\n| art            | string | The default artwork template to use, unless overridden by the `-a/--art` flag. |\n| fanart_api_key | string | A Fanart.tv API Key to use for the fanart banner image (if available).         |\n\n## Copyright Agreement for included Artwork and Template files\n\nThere\'s already example template files and artwork files for you to look at.\nHowever, the Artwork files are copyright to whomever committed them where-as the templates are not copyright.\nThe copyrighted files may not be used, even under the conditions of the License, except for viewing as examples.\nNo derivative work is permitted based on their general concept.\nSimply remember that artwork files are themselves pieces of Art, and should be treated as such.\n\n## Text-encoding\n\nTraditional NFOs expect to use the codepage 437 (cp437) "ascii" text-encoding.\npynfogen generally doesn\'t care what you use, but may not respect you\'re choice correctly in the NFO output.\nIt has not been set up for specific text-encoding choice and generally speaking UTF-8 is expected.\n\n## Scripting\n\nThe scripting system used by pynfogen is by no means ideal. It is however, consistent.\nIt\'s mostly a mix of python\'s normal new-style string formatting, with custom formatters.\nIt also uses a PHP-like `<?{x:y}..?>` custom syntax for if statements.\n\nScripting is generally not recommended to be used within Artwork templates.\n\n### If statement\n\nFor example the following will check if the `{note}` variable (python new-style formatting) is a truthy value,\nand only if so, print it:\n\n    # note = "Hello World!"\n    <?{note:true}Has note: {note}?>\n    # returns: `Has note: Hello World!`\n\n    # note = ""  # or None, 0, False, 1==2, e.t.c\n    <?{note:true}Has note: {note}?>\n    # returns: ``\n\nIt\'s obvious this is in no way good syntax for `if` statements (no `else` or `elif` support either), but it works.\n\nIt uses `1` and `0` in the `<?{here}?...>` section to determine if it should print or not.\nEssentially speaking any time the If statement is used, you should be using the [Boolean custom formatter](#boolean).\n\n### Custom Formatting\n\nThe following custom additional formatting to pythons new-style formatting is available:\n\n#### Chaining\n\nExample: `{var:bbimg:layout,2x2x0}`\n\nUsing `:` you can chain formatter results from left to right, passing previous value as it goes on.\nThe previous value does not necessarily need to be used.\n\nFor less confusion, since `:` is already used as standard in new-string formatting, look at the above example as\n`{(var:bbimg):(layout,2x2x0)}`\n\n#### Boolean\n\nExample: `{var:true}` or `{var:!false}`.  \nType-hint: func(var: Any) -> Fixed\\[1, 0]\n\nReturns `1` if `var` is a truthy value, otherwise `0`.\n\nThere\'s also `{var:false}` and `{var:!true}` which is the flip-reverse of the above result.\n\n#### BBCode Image Links\n\nExample: `{var:bbimg}`  \nType-hint: bbimg(var: Union\\[List\\[dict], dict]) -> Union\\[List\\[str], str]  \nEach dictionary: e.g. `{url: \'https://url/to/image/page\', src: \'https://url/to/image/src.png\'}`\n\nEvery dictionary is converted to BBCode `[IMG]` wrapped in `[URL]`. For example:\n`[URL=https://url/to/image/page][IMG]https://url/to/image/src.png[/IMG][/URL]`\n\nReturns a list of converted bbcode strings, or a single string if only one dictionary was provided.\n\n#### Layout\n\nExample: `{var:layout,3x2x1}`  \nType-hint: layout(var: Union\\[List\\[Any], Any], width: int, height: int, spacing: int) -> str\n\nLays out items in a grid-like layout, spacing out items using spaces (or new lines) as specified.\nNew-lines are used when spacing vertically.\n\n#### Wrapping\n\nExample: `{var:>>2x68}`  \nType-hint: wrap(var: Any, indent: int, wrap: int)\n\nText-wrap to a specific length. Each subsequent new-line caused by the wrapping can be intended (or not if 0).\n\n#### Centering\n\nExample: `{var:^>70x68}`  \nType-hint: center(var: Any, centering: int, wrap: int)\n\nCenters and also Text-wraps (while also centering wraps) to a specific width.\n\n## Contribute\n\nPlease do contribute! Issues, pull requests, and discussion topics are welcome.\n\nThank you to anyone who helps contribute to the project!\n',
    'author': 'PHOENiX',
    'author_email': 'rlaphoenix@pm.me',
    'maintainer': 'PHOENiX',
    'maintainer_email': 'rlaphoenix@pm.me',
    'url': 'https://github.com/rlaphoenix/pynfogen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0',
}


setup(**setup_kwargs)
