# this module includes base64 data for all icons

# APP_ICON 48x48 pixel VDM logo
APP_ICON = b'iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAHRAAAB0QEMkUzzAAAA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\nEU7hAeVrWPtl5yt+MuV/AUdiBuReRD9mAAAAAElFTkSuQmCC\n'

# 32x30 pixels black
home_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAeCAYAAABNChwpAAAACXBIWXMAAAd0AAAHdAHxbc2KAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAfpJREFUSInVlj1LW1EYx383L6aD\nFPwCXQKi30KwBedOxaUUh0opCkYUt3boKmpoqJLWNGIbLSUR3yYlcwf7CTpUEIeAk+JgXjrcc+Dw\n5Nzk5PbG0gf+Q56X8/uf3JdzIVw8BqrAtVIVmAi5Vs/xGqgDLaEmkBG9Y8ApUAAeRgGft4Clloz+\nX0b+TT/gP5Rk/q2auTVyK1HDD4CU0qGlvix+r0YJ31dgHSmV63Rp1sLA5ywLHQEPLL0DQLmDgWyv\n8IxlkYoCAXjAO/zr7Rkm9gIMvO8FPmNZoGzA48Bno7YuTNj+iS+u8Cn8Z9oc/g4kA+BaH4GY6kmq\nGdmz2A3+AmiIoW8OcJuJOLBt6VkIgj+3wHeAhCNc65NhIgHsinoTeCXhk7S/Xr8a8JgjXGtTmCiJ\nekNtGICnwJ1oKBlwD/8mc4XbTMSBoqjXgWcANVEoqgG983wIuFZemNgS9RrATyNRMOAesPEXcNsj\nKu+jM4A08AH/2dduPSAXAVwrZ5iIAbP4Z0OagMhGCNdyPgum+wDXeilhMZkARl2dhogRFwOeJRdV\ntK2dcGkS0QJOAmrjXebbNhzGQBN4ElBrOMx3dnTfYTPQ6iOv8V8YaP5rA5d9NPDbpWkIuCD4bVbv\nMCs/aEydA4OuToeBY+BKyfxY6cXADf6RWwEe2Qb+AP3yZGXPWUKPAAAAAElFTkSuQmCC\n'

# 32x32 pixels black
download_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAf0AAAH9AHUXkEZAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAgtJREFUWIXF171rFFEUBfDfLhbr\naoylaxD8gCUgGEljk0JSBrUSg/4jlhpsLEJahWBaQbARtNQyRiws7BUSvxuRTUwiOBZvFibjzs4b\nd+MeuLC7b+45d9+c+z5q4jGOS7iIKZzE0XTsO97jDV7gKX5U4O6LSaxgC0lkbOEB2oMIN7GEXxWE\n87GLRTSqirfxdgDhfKzheKz4NL4OUbwbG4J3Sv/5fohni2hlBWuZz028wtmSIp/gc8HYMVwpyV8T\nOmk7P7BUUn03ZvqQz0Ry3MknTop3+zAK6EhfRT1NvIkDfYiHjUO41f1yBJsFle7XDCSp5lgdlwUD\n/m80MVcXHDkqzNZxfoQFTNWFXW1UOFUXTDgqjMOO3i79hBNDEGlhvUBjG74VDCZ4bbAOaaYcRfxf\nCOt/v359bO+eEYsaHpZwr8JyyUMJFv6hgIUI3vtwPeLB35ivID6f5pTxXiN+Kf6JCxHi05F8mzjc\nTVqJSEjwARN9xCfSZ2K4lrOJbfHbcVFnlDk+Gzs4kydYjExO8Mjezqilv8Xm3+01fQ28rEByO5Mb\n4/jsDB7sVQDhTFe0avXqjBu4Ks7xCT7q7yGEo/NGJOGW+BvTOs6ViXfRUu11lMWq3HE8Bg3h9NoZ\nQHhXMFzlq1kWLdxT7dzYEfr8r1bLo8omM4Y5zAo+OS3dz4Xr+Tvhev4cz9IiSvEH5VjROf8eZREA\nAAAASUVORK5CYII=\n'

# log_icon 32x32 pixels black
log_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAA0bAAANGwFDTd31AAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAYlJREFUWIXl179LVlEcB+DHWpoC\nCXJxqCXXEHEtscagKExtMMsXJ6NFh5YIIqKhMVqLQhocJfwjlAgXh7YIhyKHyl/v69twzoVDRPnC\nOTe0Lxw4957LfT73nsPlXOqps1jEF3zEC/TUZJvELvbwCZ/RxjpOHi2MP8Vj7OAJXuJtHBtE95GC\neAN3Y/8YTsV+GwvYwIVSAabwHF+F+YYbuJSE+I7jJfBnwnxvoD+eexTRNl7hQbxmKTc+HW/cxibO\nJGNpiB/CwhwogVcBKigN8SYZa+TEb6P1C161TfThPL4JT/6wLrxqW8Ki28HVnHhjH3jVWriWE5/a\nJ76HJu7nxG91gO/i8qHBJzvEr/yXeBOjOfGbBwkfOzT46EHCx3Picx3iIznx039Bi+Jw71/iXfgg\nbB7e/QFvCZvL7DUckdcxzMpv8Caul8BhPkJD8bgLq0mAlsxfuLROYFt4yglcFDaP20mAmVI44e8l\nfdVVfw2z6C2Jw/sE3RJ+HM4J01BLLQsr/w6660Kr+glsph+VDg3kNQAAAABJRU5ErkJggg==\n'

# sett_icon 32x32 pixels black
sett_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAd0AAAHdAHxbc2KAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAArxJREFUWIWt18+LVmUUB/DPfcdR\nY8x+oDmagqQzJIRpqxYqIkITtWjnRjAMIgRp05/RrhA1kmrjRkGsKEhwZSqVijQLm1HwRzb2Y1Mp\nNlG2OPfCfa/zPvd5m/cLD7z3fb73nHPvPed7zkMeFmAnDuBi+buJF/EDPsAEFmbaTmIYe0vD92rr\nOlbWeMsx3eBM4c35BLIYlxpG6+tzdFDgRII3iaW9nBSJAArcwZIE5xYeYE2Cc1+8oX/m2uwkbnwg\nXmMKq1ucw7VeztsCgCst+zmYTm3WA3ikcb0ITw8ggLHSdt3nSHVR5cAwvhGvc0pk/Si2DCAA+Bq3\ny2DG8RNewGwVwF68PyBnudiPDwshMpPak6nCjziIL3ATf2AdXi6N5tq5gY2EqvWq4eb6WLosR3Ck\nD3sTQ3gHmzIiPoY9mE1w/sZJrMdzGTbvFULtxluIt8sg/8wwCo+Wdle28K538DZmWoiH+nBO5MWB\nFs4dvFVdLJfW8w19OK+wIWHvU6yguxcUQgNWzWHsSaHp/eAxUe9NzIgc+Zdu5Us1pjbJ7ueeYi7S\nqMjeuZ6e/Nqu45ke/6/AZ8oE7WArzmJHwtgr/yOA1xJ723EeOwuh+6tbjM2IMvw90/kyXMbjLbwr\nHZzOMDgq5Hcog7sAn2Q4hzMdHM8gEq/0KJ5IcJ4SJbY90+ZXhWjF38tPtN9wWCTSzyKr1+JVvC4x\n/zVwFZuqkngD72XeOCjsw0f1geQ78a2nxBg1jucH5OyCeOJ1Yij5FZvVBhKizdb1fqHQhm3zdH5J\n5ES9i47gLt1q1Ww2s+Ibzxc3PNzC71Y/2iS2rU3nYCy12ab/v+ieaJvIOZj8JYSp74PJYnEG7IVT\neLZcXyZ4N9XG8H4xhF34Vnc/vyZEp8IyDx9OL2C3qLB5o8BLYnSfFA2siS04h3fF8Tyrhf8HtVWw\nghy4Wb0AAAAASUVORK5CYII=\n'

# 24x20 pixels black
folder_icon = b'iVBORw0KGgoAAAANSUhEUgAAABgAAAAUCAYAAACXtf2DAAAACXBIWXMAAAGaAAABmgF6gyCSAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAKpJREFUOI3V1TsKAkEQhOHP2TUx\nE/EwYmBg7lU8rGIkGAkGsgoGGvgKZgMRQV1owYKKBuqnephpGGGBCgfcnlzV50MNNX8R+sqzpoD1\nh4AbxujW7nwK2HwBeOeLPNIKS0xa2KLXqPt7zRPKoHDoJxSBgCK6QRndoIxuUKTAcOoG50BASvLj\niNLlJ4DIEV3/vsFv7qAKBOwKeR0O5C/j9GBofxm4x1FevStM76PwTrzJmc7vAAAAAElFTkSuQmCC\n'

# playlist_icon 32x35 pixels black
playlist_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAjCAYAAAD17ghaAAAACXBIWXMAAAbqAAAG6gGednyuAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAA3pJREFUWIWt11uIlVUUB/CfOtaI\nJd2v0JWieggM6skoK4kiuthLCNnTSA8SVFRQdEEzsttDvSRRZNBDD1FhPRVdMaKkC5VO9SAZKgo2\nzVijR8c5Pey9Pfvs+b4z58yZP3zs831r7bX+Z+2911qbzngKzT6frTi7zsHANAQa0chH2IZJjMfv\ncAAHO8y/C0vxOW7An9P4m4Il2NDrpAwva0ViBy4uFeYU78dXKfWIA0LY4XGsyWR7cBn+rpu8VP9r\nPon7o735WIYhfBbl5+UOyz0wFsfX8SkO4Z9MPlLHPOI6PIeXsBBP4+MoOwfX4nAnA4NYW0GsWyzX\nHo1nM9kT8dvpM7TdFRYLeyAncXuUPRrfT84nDOiwIXrA27gPP2ABFsXnLxwXdVLoJ0oCJ8aJ78zQ\n+XKsFvbLg/HbmLAZcxwuxqMEYBjrZ0jgQlyFB4RorqvRmyhGMDeO82boHEaz32tweY3eIWEPzDqB\ntcJZX4Y/cHONXkrhbUuTlqAfAmP4JPudCk9ylNb8P+GEtGFuMc4G5scxFaxUrMbjU0mgnwiUSLaO\nCOueiHSMQB2BIZzZg/NJ7eW5kb3PiMBD+BUruyQwHh0ljGgluj34t1cCC4VEtREf6tDZZARyJyvx\nS/y9WyhwU9AUOpYq7NWe1/fhzg4E3sCN05CsJPBljWxUdc1/TYhOidTgnIvHsAlbov0NuE1FtJvY\nXENgvIZAE19X6B+D54Wz38CLWIU7IqHUpF5ZEvimhsD+GucT0XCOAXyQ6bxXyG/JZOO4JifwXQ2B\nfRXOd+H6Ct1HCr1XC/lNhXy3ULI18X0NgV3FpE04rUJvgXDc8r5wdaFzqVZBSs/DicCPNQS2a+3+\nTrng1szosKLryTAoFKukuzkR+Llmwhd4F2d0cA5Pav9nz9TonSoktqS3NxHYWjPhomkcJ6wvCEzi\n7kLnJKHzyvUaicBvXTqqw7rCcFM4iiui/CwhI5Y6O2ejHyD8sxIDeEtISkM4v0LnpzmRyXZc0AeB\nRcJ6HivkiB1CczKh/WJzinAzOiG+3ysS6PnWWoEXoq0lXZA9En0OztYSEFLtFXgTXwnld1TYC+nK\nNw+XCD3CChxMSzAqJoUu0NBqrZpCiHfi9+jgFVPTdI5h3INvCdWr2aVjwpruL76NCCHdqHUnuFrI\nhIsjqVHhqL8v1Iujl5P/AWN0QXHDhK63AAAAAElFTkSuQmCC\n'

# refresh_icon 32x33 pixels black
refresh_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAhCAYAAAC4JqlRAAAACXBIWXMAAAHyAAAB8gEzAEwKAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAl9JREFUWIW9102ITlEYB/Cfj0Tj\ne0hILDTDRiGRsrEQUoYSGxZSSlYkaSwIKQsWNmooNvIdihTJBimfRSiJQc2kfOermWFx3mvO3Lnv\neGfmvu+/Tvd0n+c+//859zznOYfuYxXuYFkPvs0F+/Cn0G5hdiVIJ2IHnkbkSWvFEVSXg7gGpwsk\naeJ0e4vJeRH3Qz1+l0CctIcYmxFrYHfJB+NKKngbrmMNjqdsv7CrCNExYfbOYWgp5FW4nSJ4hvmR\nz5bIdhFTi8Tqgw+R7x0M6Yq8L86nyE/oPLIFOIl5JQxoIVqieFcLPJnYmCI/UBhFb7E5FXdrltM4\nfIucznaltAdoiGL/FNK6Aw5GDq+EtZAnBglrKeFoiI3D8D0yrsyZPMFiHTNnZGJYFxmey3fq07gf\nca1XIFsaORwWcr5cOBr1Fyed5kjVlDKSQ23E1ZS8/FF48UXYgsuNr5GIkX2FaXmBtcK2WW68ifpj\nKsDXCY+0z8DMcq74YhgR9b9VirRayLgq7bWhDcP7V0jAg8LzpvaF/hqfEodJ2IPRZRIQl+W40v5D\nsht+xnb514KmDAGXROeD+pTxHZbnKKAxQ8Af3Esc9hZxOIVROQh4nBG7GXVJGg4o8uEcPThUZuBD\n1G8Ryn8tzidZUOzks0g4bvcWHwvPC9gm3C86YL/sX/ASs3IQsBDTu3LYLdTq1TovyFYcElK1Ylgh\nVMdYSAsuYxPmYoJwmhqPGdgg3KIahWtcrzEF12T/mv+1d3kISLAEN4S9u1QBO0sN3p1zfw3qhAvJ\nNKGqDRT28/d4grs4IyzekvAXYJ7txNRGRn0AAAAASUVORK5CYII=\n'

# subtitle_icon 32x32 pixels black
subtitle_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAPoAAAD6AG1e1JrAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAdpJREFUWIXt102IjWEUB/DfnTsa\n3Uw+SpSSz2SHlYWwsbFQVmLhIxtSPmLH2leymRorxUJWFkrKSlGzs5kwNMZqkpKNQmPmuhbn3Hrn\n3juIeq9y//X2dp5znvf8n3Pe55wOVHAGE2iU9LzBaVT6cRxHsS9JlIG1uIUpGMO2khwXsR0vYQaD\nXSAwiJk+VFHvAoE6qn1dcDwLPQI9Aj0CcxE4hreYxgc8warUnRcl+3DBfiTXlqb8POUJjOIetnZy\n1N9hbQuG8QoXMQ87sCj1S7AGCwt7VmKFKGqwGjVcwHocEuV+uWhGPyWwQXTIkSQw1Yn5b+IaBnAA\nC9LfdNGgUwqe4pPokB/xWKSk2sH2VxjDOxHFq63O5yIwiU24ItKwEzdE/6YlhInKHLqbGBIHOinS\n1IaGyFcTg2af9mDa3E35bMqXUh7AV5Gq5r7PaTOQ8p2U9xe+W0Oj0z+wC9fxAO+xO9dH8/0Il0Va\n6iJa83Ffe1c9h8XYg++y/7eiNQIbxbWZxDeRw+F00sRePMOX1N/GsoK+eA1f4GHuKaKWvtsIlIUa\nGv9sJewR6BH4vwjU/Vmj+VtUUe/DuCinZWMzXlfEcHoCR8TUWgbWieF0iGilp0QkyhrPx9Nn5Qef\nmpdsaNgIXwAAAABJRU5ErkJggg==\n'

# wmap 220x115 pixels blue
wmap = b'iVBORw0KGgoAAAANSUhEUgAAANwAAABzCAYAAADzEGy6AAAACXBIWXMAAAOhAAADoQG8l/2DAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAIABJREFUeJztnXl4VOX1xz/nZmFV\nEQIoLrWK1krFrXVXaMW9VqpStypYNUDmTggWqdWKqa2tIsoydwKi1qLWDflRtaJ1q7jjijuKgrsC\nQUFAyDJzfn+8dyaZzL4nMZ/n4SEz973vfSeZc+/7nvec7xEKha0/BN5A+CM+cSKOjddtKaecmbKK\nWi1lHTvSh8/4hkHM5FMqKaWcR4CvEWbjk8cA8OowgvwNWIlwBLAB4Tf45J2I/idqXxp5DqHMfacc\n6BVnpGVA7xx84tdxZN8c9NO+sHUQyo/xy+M57tcHVAGrEPbBJ2uo1J7Mle9yep0iIwW9WrXuzixZ\njlf7o7yGMJUgS7E4AWVfKjgBgHqeAw5yR3gWPrmTWrVYw1gEP0H2p06WRvQ9XodSynk0MJm50hR1\nbY9eAOwNfIFQDuwFnAz0yMtnVTbgl63z0nchGa/bUsoJKDsBewIjgQtxZH5Or2NrJXCD+2o1sBXQ\nA+U6/DIpp9cqIoU1uBBePRPlDvdVEFCgBFhOgOMoYzuCPOsefw1hNv24mY8opzffYsb9P+BF4HWU\n1+nPB9RKMK1xeHR/hCVAaU4+VyRrcBgIonnou3DY+gDwSwCU/wHj8Mv7WfQ3DrgcaACWEmQCdfIp\ntv4CiPfUPBlH7s/4miG8ujUBdqU3HzJVNmTdXwZYxbgo0A/4AOU9dwwlCG8A21PKBmbJcwijEX6L\ncAnKadQzjX/KFuBtjIEcDVwG3IPwHvV8jkcPSmsUfnkVeDinnyyEMK5DG5tX+2PrnRhjawT+TH9G\nZGls5wN1wCDgh8CvsXgOr56G8qe45wlfZXzNlmsPR1mJxWtsZlHW/WVIPu7syTFrOAevjkWpBTYC\npxBkK+pkjdvm1nB7W79GmQmAMgOLaSgV7tEmYC3wPsq3aY9FmI+6d/Bc0szS5I3aMcq1wBnAIyiV\n+OXjrPrz6giUOUTPqnZEmZ9grvUhPnkxq2uP0e7ADKAbcBWwJHysWg9A+IyZsiqra6RIYaaUtVrO\nGn6C8i0D+IhaaQbMXdRHfdpPgjHand6cjPIjLP6BTz6jVq20p5Rg1pVBMr9rx0O5BL9ck/N+C0Gt\nWtSzGniQCs4P/70yxaNHI9wM7JTmmcuxOJNZ8kpW1wcYpSX0YzvmyOdZ95UFhTE4j85BGOu+2gRc\njiPTUz7ffAEuQqhHeQRHvohqM1H7ogSZIevSGlulllHOd+TuaR8EPqWCXTO6AbQHqvVQgkxlFcOY\nL4Gs+vLoQQjPkP7v926CXECdbMzq+lGoUEWv3PebGoVZwwk/bvWqF3A9th6f8Jzxui0enYZH92At\nRwDXotwCvMdE7YGtC/DqhQBM0l40sQPNvItHPWmNzXg030zrnNisJMjOVFCGI7t0WGMDUDbRk+Oz\nNjZUsJhG+sb2KWWch9APjz6LVx/Do4dkNxYXL3/E4rWc9JUB+Tc4r26NsFebdxdTyvNU60/w6n5x\nRjYa4feAh1LexHi1vkM4i2YOA04BdsPW37KFW3HkTZQLEX6UwSivz+CctvwQi4s7tKEBoIJPXs/a\ni+fR0Xh5FOXwtM8VvqGJCxBeQTgU5SiExcbDqbFnZeN1KBO1b9K+G7iW7hRtfzT/U0qPXoRwXat3\n7ke5GuEeYEfMFOx6SrmeGfIlAJN1KzZxH8LPgc3AYJSjsHgPn7yIR8cj1AHNmLunAhOxeIYAW7D4\nFJ+k7kDx6l4ob+fg0z6NI0fmoJ/iYetkYC8cGZOw3UTtwWb6htdEXj0Yn7wQPtbIKoSt8jDCTzH7\ndOuBd4B3UX6GcC7wFRbDmSXL4549Rru73u6iUIgp5eutfv6URs5FmIAxttAYJtHMk3jVvDdVNtCf\nEe7c/ysaWYNfbmvlrQptKIemKgLMIMjLCG+hrMfWjXj1mJRGGGQVEMC4v7PhCGy9i0kaL4qlfVOr\nFsrvkCTfi0qtoJlHKOUzPPobAJRF2HosANNlM8L5eRrlTsABwC8AG/AjjMF8jwYRCPsKorF1OL35\nGq9WU6km6iiVp2IOyb/B+eVxhF8Bv6aMfZkr64HBMVrugbIEWwcBuFOzMZRyGGUcQpW2TE2ET1O4\nci/MXk8qY1xLKTsBx2O2GDKhCeEa4FS2MC3DPorLWk5xp+SJf2/d+Ht4qmgR8iBuBTyMrYuw9Yc4\nMh/lX3kdbyyEvRMcPR8TvTKTclZj6wc0sRZbn2KcDijE8KIXs9X6cwJcjrAJ4QPgZeCBtKZoYNyw\n29KbubIenzzQ5uhGjKOiCdgHE2UCMAhlDl4dhU8a8MmHAHh1NspxjNOdmSOrceQOPLodwtRW50YT\nZARefQGfvB63TYgZ8iVVugHhn+7aMR3eRLgGn/wLr75DkAPSPL+98CGwCmV/KrUsZogcgPKD8M9N\nhNZ6a4GBmJvWXOBohLfyO9yY7IpHL0CwELZgvmfv8BXNELHf2sf9B3AEJVwGTMjJCLx6Ncp7OHJL\n20ORBufR8QTxI+7armV3rAGPPofF0ygvIHxFgHrqJP6TZiDDgCuAYVHHHBnOZN2K7zgNcICe4WPC\nSSgLwY2rBAgwDYtjKOVEwHwIv1yPrUuAcxH2QhlKy1Qz1NdpKL/Cq2fik/+LO1aAWi2lnmWQUVTD\nh0CJ63C4Fbg12Qk5pVK3oRsXoJyKmXKtwJHo33syfPIatboja/kF5m+yPk7LPcM/lbAnZk31Jsbg\nAHZ2/x+U9hiyZzDCjUDr72+QgaylxcCiEUbj1bdQloe/N3AJjtwR95x4fMVlDIn9IDCGValldOMP\nKH8mvWnmiwiX45NHAOOeb+BKlBMwQcE7IxxDkEaaeDki8tvWFwgFKEfTiEP3iA1xW0cCV+Cwf9yN\ncq9einIp0ZkA3yLslPQpbUKM7iTTPTnlAYR5OLIgo/PTYZSWsB1TUPbFrGdCGQ6KMhq/3Ja36w5k\nC6HfkTILv0xw9+5ux0xHv8N4keuAXfMyjkKgvIfFEfjc6KccIEzQgQR4FBLOfRMPC67G3NX/AcTb\nL1mLcBNB7sEvrzJJe7GZsQgjMX+8NRjXfy+Ud/HLJCp1G8r5H8JfaeBxylmHMJl+XBd2v3v19zSz\nkNmyAjDu4RJuAA6OuHqAfZgtbyT9NLb6MWkimbAF+BuO/CXD81PHqxejTE3Q4l3gdBzJfo/RZAyc\njfIJQh+Uea2OLsWRlq2dGu1DM6/T8pTr6GwCFqMsweJf4WVOCHPjG4/F/FTCw4QJujMBsouTS58l\nVHBoxJ6VR/shjEJ5Gr9Eu+ht/S0Qumv/EUeuxqs7hqcAPnkQMKFayiEos4Bt3PZB4BwquCvhPpmJ\naHkJ2D/Nz7MCuIZS7kk70iUTbN0TeJXkqUUmIl+5j/5cR63E9sJ69AdYfBd1J6/W3WlmNyx8xHZ0\nAXyMI7sAJj/RJ4ux9V/AWal+nA5EEOVBhCtx5GUgNKu6CtiMcC9wMz5ZHK8DM6W09TDgHgo55xbu\nIUAtdfKue1d8AgjdKb8E3kO5AosfuVPU4zHBp7ghXhcCU9xzppinigo2n2P27u4FJre56os0ciJz\npT7mmLx6bpu7d3KUf2FRlbZTKVNqtZS1PIfyszTPXEoJZzBT3gPMnXkQOzBTPgGgUntSxiSEC4GH\nML/rc0i+V/syjvyMSt2GMpbilx+6Qelz0hxfR0KBu1EWuY677docv5kyvEyXzW1PbPll2noYwtUZ\nRQZkThB4EjP9iHcHTaWX46kTk2Zj6yAaaaSUHlh8EqP12wQZR508E3XEq0+n8fmXo5zhpvgUDlv/\niklLSkYz5u/bevG+hlL2YIasw6NTEHbBkd+5s5zHgN3THk8oQdSrx6DcjyPd8erWKF8QP6v++8AK\nlEcp42pmyEehNy1sHUStWjjyLFCdxwGsA6YjXIbZajDXNwv+TI3tY+AOoMV4HPmCuVJPWSvPZyRD\nsHg6ZmyephwWtpESTiq4sVXpj4E/ptRWmYrQF+GmVu/2p9n1/gorgJHYOpEAT5C+sa0EHmqVNnUa\n0I1xugPKsSTarvl+sCvCWJqJWM+XAm9SzyZsvRvl3LxcWrmXAB7myGr3jb9jsxJa7eekivAwyksI\nT9GPJ6LWZCba4XICSeLlhIOB59u89wrKcSmMwROemsWiSgfTky9pYAjKsSib2ERddiFFKpRQi6bo\nRRbOJMAcBjCWNaxAGIrwPAFM5nQjd1PORWQaRyqcF16reHUYyu8AKOWzjPrrrCgnM0F3JsjpKG+U\nYu6YoU2/ssRnZ8QKhMsJ8g2AO91YQCbGBmbTNchM6uQxvHoSXu2GjwXhrQJlZoIA5o0Id2G2CR6N\nOhpkHpLQ4L5FqMIniSMoLBazhQGEXOcC9GJv4LxkHy8uXkaj/CbGkS0Yr+pYIrdZfojwKLX8GOTv\n4XdtHYetE4DdyObvrZxGjb5PgFEof6HridaWxcDBCFu1ckqubVnD1WgfAvwNZXweLv45yj4IpyMM\ni/PFSYUvgEcJcjkmlOp9N0D2KSo4ilppxqu7uVOa4cCoiLOFN/DJPnF7n6g9aKIe4kxHLX7BLPlf\n0lHauoLI8KjNBDklvM5MF5Oz9zpEpDmFmIYjF2PrM8BhUUeD7EWdvOve6K4FKjMaQxfpcAeOnO1u\nuY3HPMz6AFdFeqCMqE722bVtMV7FBmCHLHpxqGBCeAo5TneglFeAfii3s4nxkVM2FWzuxWzAhsbQ\nlwAVzJZv4l7F1vuAX8U48l8cST7dBKjWnxDkOOAkYBBBzqJOXkrp3NhjuoZojytAM8qRBFlFCe8T\n+ylzIw5j8bIkA89mF+nzIhUcEbEFM1H70syp9ONmY3Bm8+4AlCtoHVLVfviYCgZHpfobo/sJjvw3\n5llV2huLF4AhwC0oD2CxCJ80xL2SicO7sc27q1AOylrXI13MH+oalAtiHA2gnI9f5mHrDBLHAX5G\nS3ZGF/lEuA+fjIx3uJQqPRyLBSgFiZbOkJtj6mqYXKxIjQpb96aRT5gr66mTjVTqcMrYDYtdCfJ8\nQmMDCHA/pdQRub6ZV3Bj8+geNPEULfGJrVGUY/HL424M6JgkvXUZW6HQuN5xAEqx2AsSGlsQEyY0\nJIfDugPlc4RJpJIEK228iYm5lXJ+gq3PAwuowEet1NNaqSkRc2Q1Xl2EcnL4PeWFNK6fG4TTiW1s\nAO+GlY/XszUtETVdFBNlA0JChbFSyriNZk6I+IK1RpiMEkQYiDIEM+XMLo9OWI0jk/HoPISXSBai\n1JCi5JxJKtwL4x08AjiCer4llGGQOjZKE8I+wBL8/DvN83NBEg+iCojSTHaKWl3kgo3AdMq4Pllo\nX8sabiDvAHu0Of45q/gBA3mQnoxiqmygRnehmbHAiZgvdybu4Kms4lIGMhu4MEnbV3Dkpyn1amIM\n3414T3gYnyQWLGqPePTXCPFTioRfhfMMbb0H4VOCrEA4ERMG10X2fAq8BAzFTMu7x2izFuGgqKDm\nOJgn1XwJoDwXdVRY6So3zQyLysyQj3DkjzgyFGUgynVAfK9fdJ+PA7cwkIdIbmygLGOMdneLgSRr\nGz01VoZTrYcCYOt5hU6pz5hNPAQJhG2Vo8I/O/IbfPJ7/OLHkROAp/M/wE6O8j9KGYojp+LI7m7M\nZIhGN7v/HIIcnKqxQWQs5WSgtXDpN64XbGHSXmrVYi1VKL4Urvk15k6RcHHZigCwAQjiSL+ELSfo\njwiwLMaRJpTb3CnioziSWnhUsbG1CvADcxF6oJwTPqYcg19abd6r4OUMlErMHmQXifkWExr4Y0AR\nlqDsjInr/ZCe7Bd+yJiUrycxD5ZGLKpS2o+NQYvBmQzsj4FtgScQRuOT9MJ0bF1EPqczFnvQzJa4\nmebGY7eFxNPcjTSzW0uYWRGZoDvTzBiU6+MKk3p1P3wsZTK9+Y4vMQHB86JUtWwdhcn46CIRZj92\nIsJ8fNLARO2B0o0Zss61gT8S5DbqxCxNjMr3OwgTYkiFpE2L88NY8z8RJlDB0Wkbm1f7AxeRvfJV\nfIIsw+J9N50oGrN1kCw7tzdl1OZ6aBkR4DyEP1PKLnHb+OQ1EGWqbEB5CFiDxtBckRhSFl20ZRNB\njsWR28PbQ9Nlc9jRMVU24MilYWMD6E01Jmoo8XZSikR6Gx25CJ/MykjMtB/rcWQZRkAmX1iY6ehN\nTNDoeEnjpUw87QRQLsSr8UO8CsfTmG2XbnFbVOlxVKqZfgepJMAI/NKiLGbrM9i6GSU9xenvI8r4\ntDI8zKzhb+652URJhcmdTF4olKWZqzFqXJkhzAZqkrTakwDL8OoaPHo7NWrEYXqyA6kF5JYCj2Hr\n6RmPMxc48gTwJEG8cdtYnECZK1sxW76JkInw6BBM/GQs71kXkTyUls6L8XjfRmh5ornZfsmtLqWJ\nIVyNZryWaCbIPCrwkcojXKlAOJtmtypLUxoJj6bc1V14ta0Me/6p1J549c8AlHAe8BuqNDrOsUp3\nAk7H4khqdHv3vK3x6hi8ejVWp86qzjWJ9F+iEXrQeuYRJLnUYgrk1uBmyVvMlZAgaiZz3lKEf7hT\n2ljZ2rEJhdNYDM3gmvlISUpMOWNRtgVaVJ8tro1oU6PbY/E4MABlCs18QTmbUNaj3ILyhwJn53ds\nAmkaTLDVd0m5LiUBqhTIj/KyKaxxLplNLfsDIKReIE94GI+OdsVc0uEDGngnzXNyQW8auRIADUvc\nDcOrRmmsRrenOUPJgy5iU8LDbsa8CWpPTuiB4clljfH8SZ375R6UkZgEyXToj62Taalwmgp9EP5J\nYonuZSiXuDlhJs5SOTGuunA+ceQvrYSMhmB0HBcQZDkeHUIzz0NUxaEusuNALPeGLK32M+Nh8RHC\nbBypy+Ug8l89x6t/cjOCs2EL5uZQnuH5S+jOUUyTTW3GthvKPAKcG9a1LDQe3QOLj/FJg1tYfgGJ\nFIK7yIavcaQfXr2OANdSJ9nXDk+T/BfzUL7MsoelCAOpoAfKLih/zWAMq2mIEX2heIHDKGUhtVqY\n4pRtMUXq93Fz2h6my9jyScjjWIbEVf3OK4X4kh2VvElC9kC5iXouwi8f42cK4IM03LSmXsF/qNLB\nbd6fAvyFIK9SqGqwbTGFH5aQP02ZLloIxTwKwtnFGEAhvmTZ1s7uidEmGWdeiuJINUGGuoHQqSM8\nGlEbzCff4sgU/HJe1oXjM2ctSnbVRrNnI/CC+y923YbOQShAfwtanL3LQhhc6t7GxBh5N1vPokZ3\nccNvnkzx3HWYzXQfygzKW1V/KTY+uRajIJ1LvgNq3AyQt1HGYDTyY7U7A6ECRw7BkUOQCBGpTQij\nya9eaaFQxJXKVzZg8c9iDKIQa7jcaO0ri6nVUuBqmvkdXrVTcsYIbyD8FEdmIgRQzstJgYtcYqVU\nRy2A4CeVqbQwBUdmotQADn6ZhxLL2zYdR+6OkJ1oonV2SC0+uZUKZqcwvvbO7HAFXWERkkZKWQ7J\ndrqXCrlxuwsnU88OmPpnl6c48XmBEo4PB6c6MjMnY8mWMdqdXuyD8CmOfIHG1OhcifIAig+LvwCj\naOJKyngC5R/Ek1UQ3qCbG4FilMKMWlgTl1HOfsCIVq0j8+28Wh0xvRU+AmBtTuU1isFSGrk4/CpU\niKMI5H9bIDrPrlA8QU9GhnOa2hOmDt1899UmzHZHyGGyglKOaq1H72bk3wpU0J1TaGZrmrmJ2Apr\nJ+PI/TGva8p/vUhLZv/XNPKj8J6gV6e7T8UQ7yAc0sH1LN8myIjwFoCtP0XYhQ38Jzsl7MwoxBru\niwJcoy3TaOS4dmlsAMEI138vWnsnFX+EsYHJyF/FuShr2MxbBNifRs7CODta8yWNLDbJqHowtk7C\no6Op1gOo1XK3vnrrYpF9KW/lrSthZhsHzl6Yohwd0dheRbgM4dCI/TZlXxQPvYsTxZP/J5xHj0SI\nWy8rL5SybUHqtGVK7GTRLSgX0cRNEdEvXt06XAqrVsup5y2giVUMZTt8rlL2lwh/Bh5EGYXZYmg7\nTW3EZM73JfLvvo4gQ8NJvalX52nPmPqB7ZD8P+F68ArpBCJnzxZmxK1N3T7QmJ7bq/HL7KhQsya2\nCv9cK40oF6NcynwJYHE1JuF2IT65AWVvTHGOWGvCckyuYNubbB+sVusbi0WZfKQi8GabykAh3qaC\naQUfTYrk3+CmySaCnFbAvaZFcWuAtxf68xzwoPtqPcI9CLHvyEbs1lClg/FzP365D4CZ8gkBDka5\nGYAgT5NZlkZLMK9VlCVAeggvEeRQulEDnIFyKC039evi7qmO0e6M16LWHM//lDKERw9B+A9mSpMv\nXqOMEUyXr/N4jdwxXoeymffDi3dTRXQ4QgVCH4KUIqhbyvijlPo0DpntUbbDYjCm/NbWCc9R3iPI\nCcyWFW0cOu2VqWzkiginhykweQXKgIiM+BDjdAAlLKSEamZJ7utnpEjhDA5C6kdLyE+G8luUMazD\nGFulVlCOD2EjQVYj7AaMJLbcwh9wJL0EyhBe3Q8lVVmBb0lmnO2HBpRL8MuM8Du2/gflKvzSotQ9\nSkvYnoMIcifQhMPuxZwBFWIfroXZ8gZe/UsGeWvJUSo7jLEBlDEBMx1KftvLZl0VRNK4rXYUYwP4\nkLKoaJH3UVZGvLMdr4aTSYUZxV5uFNbgAPoxlXrOwRS+3w7YPoNeNgELUbZB+CXQhL8I+v+ZMk4H\nIAl0TNoSZC62fonwCUGeZxP380/ZgkeHIOxMI48lyOs7IzeDbnfMifJEVzApSgArwGFYXIEilDCr\nkAOMRWGnlCE8WoPQF5iDqfedyOg+Q7kb4QMgiBKklAeYKcbTZ+sVwBQc6RgVOGvVYg3/Rjgp4z5M\n0YglwOGY6flnwM0I/wNeC28jmPy6RSRSBYO3MTewfck837AYVONIKsLD7YriGFyN9qGZ56hgX9Zw\nCsKdcVq+SU8OS7iB7dGjERZRQbeM5P0KiamwehexCz7mks+B9RgV4W4kSvsRzscn/8CjeyC8RuqK\n2MXGhyMdLqi6ODlgM2Qdyk2swcYvd6HEU7SdmjRaRCgFnmj3xgbQSDX5NzYwlWb3wtT9Po5EKTeh\nYo9+eR9JSaq+vXAOtg4q9iDSpTgGB9CfWQgjGKc7uHWQozerrRTKVDnyEBUdoFqMV4chWUtNpMuF\nOPIEyh0J2hwcLpTSjynA3zGaL4ECjC8b+mDldYspLxRnShnCq1tj0YeZ8gleHYu20VkMcmDS2tiV\nWkYpgymhMZ0qJgVlgu5MgFdJRRU611j8gkbep5TlxK/D9yTKbPzSEm7m0X4IpyOciTKU9ubBFO7B\nJ8UV8s2A4j3hwGRczxQTIdCPG6HNflFJEt2JKt2XMqZgcSfKcrz6b6r1gHwNN2MCXEkxjM1c+0A3\nWiWRaOxwhOnUaqkrNHsx/fkGR+rwyRE4sg0l/AD4NcoNpCNvkR9W0NAxpd2L+4RrS5X+DIvFtNyJ\n36aEo8IeSTAOlyaOibgbm/SVEcAlwHB3Q7QYKUGxsXUt+Y2wiU+oIOU4HUApKyChOvXLCOXuE20u\nQnXMmui2Dgf+D1wx28KyAovjmCXLi3DtrGlfBgchTff7aRFBXYNwDUHeQDgCsBE+wCcHRp07UfvS\nQC/q5FOqdXeC/AnhenySE5nqjDDljjYX7fqmWMhgHFmJrX/H3JRS5e84cmnMI149GOUZMquAmwkr\ngVsJMJPZYrK1bR2OI08W6Po5of0ZHIS+pBeiXITEKOWknIhfEkdfTNJefIeE665V6b7USWq1wnNJ\nle6EVdBsiWiEGfhkolv/7HUSC+aGWAkcjiPxg5m9OoYgs5BWGQ1tMfohZxPkOSwGohwEXEfip+O3\nwDTgM4ReCK8yi+eLHSWSC9qnwYUwlVVHAMe705xDMNPNF4F5KC+kVX4oXcwUd0tWGige3R+haMGy\nLgGCDKdOnnHjWZ8n8X7bUwQ5PSWhVFsvwXg2Y/EBykj88nabc34LJKpk8wiOHEul9qSUPYpyo8wT\nxXWaJKNWgvjkEXwyEUeOopHtgenAgYAf4RW8Gl2cMFcoawkmLfCYGHFrJRSXEiyuA3CLUvw5Trul\nKGfiMDxlVeIKphJbEexZlIOjjA3AkduBhzAlf2NhHEzf0EAz76c0jg5C+37CxcPWK4HL3VdLcOTg\nqDa1Wh6uWVdMPHoUwmPFHgZmLXcqDvdRwzYEWI5iAc8h/IcgD+OXeAaQGFvvBU4Nv1Y2EOQH4bVW\nXFSweR6ivNEBghySdEvIqyPwSXv43aZM+37CxcORKcA5GN3E6DvgKC1hrStcNF63pVIriiZl3p+n\nIYUN/PxjAQvxMIMZsg6f9MeRfjhyEj65IWNjA9wN/dbrqwXJjQ1AFOG/MQ6UYHELtZo4tlO5igk6\nMJ2hFpuOaXAQmpaMRtkPj47G1lOxdW+qdDADuRMYhFcvpYTPKGcN9QSwdR22vo1XLyzYOGulkUaG\nQ8wvVuExeXe5xXiBW3RrgkxP4+xlwCsI44icmg5hLUcnPLORwyO2jDoAHdfgABxZgMUYhLHAscCD\nWCwHRqH8xs27a+0c2AajRDUXrxZOW36urCfIaZio/mKzH7ZWhqUGarQPHs0+hael6u3CtIoXKssJ\nUuNqsown8kmZeP1bjFJjWdKxDQ5glryCI4fiSCWkUVlHuRGPXoRHCxMBUicbEc6n+FEag4AbKOEp\nbP0vzXwJ1Gbda4AFwAJ6Mjqt8xpZjsXPAfDLbQhjMApj72I21zsVHdNpEo8a3YXmNhm/yWlAuZMm\nLm5VJDF/2Hoqyi3u3tU6oB5oXdVnDeZJuF/ex9LCBThyc056qtE+BNgTn6SeEGzrElZxKPMl4L4e\nhLA2ZpRLB6fjP+Fa05xRUmc3hDGUsxiv5j9A15EFBPkBQfajgv44sjuN9AdORhnJRnbGkf1RqqAA\nESrKvTj8I2f9baEXJaRX6FBZzEDOD7925IuUjc2r3fDo7VRrhyjP3HmecGaT+nmyCzWahiMXJ29W\nILy6G0HGIlQSr5ZANijvYXFgOEO8WJjIogcqX9liAAAIL0lEQVRRxrsFKuMzWbeKypGs0n0p4XN8\nkt2eaQHoPAZn67VAtsXPm4DT4mrzFwtbP8EUMcklayjhCGbKeznuNzOMjN31+OW3MY+P0hJXafp3\nBNnPLVfW4egcU8ox2p3ciOWUAffh0dup1Ioc9JcrBuS0N7MxfWLRja1Gd8HWWVTr7syR1QiT8Wq0\n/kqN7sJA7ne9mN0o4cjCDzY3dA6D68WvgB1z1p9wNuW8hUevwta7sHUxtl7DJE2U2pInVMjtWq4R\ni1OSRnEUghnyEcq9BFmCrX+lkXVRazdbD6OZd4msFNRSa6E1xQpuSIN2P8CUsNguD70ORLgUOB04\nEphMA/fm4TpJECV3xTWCwLntKhzKL0+5VVYvo5xn3dlKa35JpHDwZiyeoFLLqGcBXh0WPrKaHcI/\nj9HujNJ2p+TWOQwOngbyX+tLOQ6vnpv367SlkRvJzab5VThydw76yS0+eQC4HdiXrVxRoxAB7kS4\nB7MvtxThEmbKKsr5FTCYhnDdbsIVgAB6M4aBLGWC7sw4HdBeQsA6k9NkJHAv+U+I/Jae7Fjw2nNG\nf7M2ix4aKGNbpksxk2HjM1F70MhpwGH4ZVzS9rZ+AOyGcFC4lHBrjArAIuAITErXFuAGlBtjZjAU\niM5jcAC2+gA7z1dZRwX9Ci7LZzb1PyTzWckXOLJD8mYdBFvPAk5CGJNwz87WnwJ3Ehlc8BmKHa5C\nVEA6m8HtCbxO/hSENwHXu9kKhcfWxZCxh05R+sesLNMeMcK0w4GNKM/GzGYYpSXh6JREeHVrlNnA\nWa3e3QKMoYL5hbx5dpY1nMGRZW4l0HywkSCHF83YAIRspkKCcUB0DPrzEfAVMALhKar08Kg2qRgb\nGHU4R85GGQbMA95FaQLuYi2LqdT4ytQ5pnM94QA3qfFfwJk57ngBjpyW4z7Tw9bHgV9kfL5wHz4Z\nmbsBtRPG67aUU552qo4p4VwNBHAknZSijOmEBkdowTwLqMpZn8op+GVhzvpLl1q1qOcbshNk3Uwj\n2zNXWlSux+kOlFGLch2OLMt6nF0kpHNNKUPMlwCOeNCclSdSylslWBaD1exK9urHPShvE+Bdyp9Q\nLkDpPA6VEF4dgUentqfA5sLXhyskwkIgFxVWPmwHxR5zIbo6D3HLCRtHwi+Bk4F1lLfaz+roGDnA\neSi/RgAlSGs9zmo9gL68WQzNm85tcORM8an4Na+VzL2Lwhsol+DIQ636e5mQ2K7gb7f7c6ni1bNR\nBgDL+I5rgSHhY8E23/Mg11HPUtCJhda67NwGt5Gv6Z1VD2+jLGRTHkokp8tsVuLlJZSfpXnmJ/Rj\nvyjXt7BtWMxAEtYdaN+Y1J4/oVxKPJ+EcD5e/ZIG5jFX6hE2o0zAZltW6e9S9nbmgM7pNGmNrZtI\nv8jgauBhGrmgXelmePXMJKWnolHewy97RrxXpdth8TlmDf8ajuyfu0EWEhVs/k3qNfeagOeAQwkV\nqUylQlMO6dxPOMM60jO4bwiyW1givT3RxOOUoqRzoxSiN3Ut+rTq4+GcjK1QVGpPyhmGEQM+Gjgs\njbPLgGER75RwNFAwg+ucXspI0tvUVBa1S2MDmCOrSU/j8h0CMfIETYDAs8C7BJmdq+HllTHaHY/e\nTjn1mLrltaRnbLFRavHor7PuJ0W+DwaXXg6bReriN8VhWsotLey4knUNHIsje0VE2LdntuYQhLOJ\nX1QyU8oQFuDV6YVI5+ncBjdZtyLdP5DwfH4GkyMcuQN4JIWWH9A3wd7hXPkuZ2MqBAFW5LF3Qalh\nYP5LQndug9vMkaS33nmDWVLsSjfJEW5N2ka5suAZDfklWnoh91yMR/PqQOrcBqcclUbr1Vgck7ex\n5JIG/gsxnCEtPIqf2ws1nILQxEqMLHo+KSWdKXsGdGKDU0FJthhe42YTA1zbYXTq50o9GnetuYxS\nRneG4oURmO2ZmXm/jvDjfHbfeQ3Oy5Exq6dGsgwfZ6Ccy0acQgwrh8T68i2ihOHMkC8LPppCICwg\n/1Lxed0E77z7cBqRbBiP70AUf8JqnO2T1SxgADdg8RbKJqwOsv7MBp+swauPoRyXpOVmTH2CTMRz\n8xpT2jkNbpL2Ygunp9CyfQm+poMJR0qu/dHZUF6BmAb3GsrtlHIvM8XUVK/WA1AeRqkAlhOKHU1M\nXqetndPgtnA2ie9utwILqejABvd9RbkTcR0oQbeenMVqHPkiqu0seQWvVgONVLCQeupJnHWxGEee\nzcewQ3ROg4MDYr4r1BPkFvz8odM5Fb4vGMWt1KUmfHJn+Gdbn6B1aeRo8r606JxOE+WBOO9fiF8m\ndxnb9xRHTkOYEOfoUiT/Wymd0+D6swgTGd6W7JJ1uuj4+GQWEhU/+hnKyKzr0YWqyiagcxrcWnoT\nHbS8CatdFLfvotg0MAHhSCwOQ6iklANjyvClSynXU6UJPaidMx/Oo2cgtMzdlQcQxsVcWHfRRa6w\ndSmwJ8rQeHXuOqvT5JA2rx/qMrYu8o5FFUozTvyikp3V4CLz2Sz2LtI4umjPVOm+WNwBPIAjf8i6\nv1mSdNO8c67hLNZFvNa8SZ930ZEp42vMsipzAaUJOhCPTks1l66zPuHWtXm9oCij6KJ9YyJSMg9W\n9ugeBLgNYT+GcCnzk8dhds4nnNK6SPyHVPDfoo2li85JjfZBeARYQgmDU9W47JwGZ/E2YIRblbpO\nlojZRXugmSHATjTz13Ds5veaaj0AW9dTo32KPZQuOikebesNT0rn3IcLMUEH0kgjwuB2UUS+i+89\nnXNKGWKmrMJiEhZ1xR5KF10A/D/QV5ZG5gtzAAAAAABJRU5ErkJggg==\n'

# 34x34 pixels black
about_icon = b'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAYAAAA6RwvCAAAACXBIWXMAAA6uAAAOrgGjVqEKAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAphJREFUWIXF2LlrVUEUBvBfHnGp\nIiJuiPpiKm3cCzEhoiAq2AlCsAgEcQFLSxfQKn+B67/gRjAWEhXRQhAXUBARo5WaQqOgRsFYnPvw\nJSa+Ozc3+MEt3txzvvnezJmZ706TNCzCLmzBKixHS/buM97gGW7jOt7nJW7KGdeJo9iBVxjAYwzi\nUxYzF1WswVa04gZ6cTevoMnQhn58x9msk7xYh3MYQR9WFBWxD19wCcuKkojpuyKmris1+SS+onsK\nAsajJ+M8kSLiI9pLFFFDh6ip440C9wnV0yGiXsxX/5imNlET3QmkFezGHsxIyOvJ+pqwgPtFYabg\nAkaz52pi7lWxmsagUyzRlNXRJIZ4tO6Zl5BfFUu7o76xD2cSSGp4WifiA5oT88/jWu3HYvzE2gJC\nVuKy2EE3Fchfn/W9gCicFwVIysJLdDeL+hhITJ6FJePafomzJxUDmQYPcSAxeQluGluoXwqIgMN4\nAEPYXpDkVQlCduBDRfiJzwVJ3hXMq8cwWiolEJWCihiNlkaB04g5GK4Ie1fYtJSANgxWhMdMcV5l\nYzWeV3BHeMz/hW3CbFsottl1BUjumdry3YAfmF8Rlr8fBwsQTRWHsr6Hag0d4kiuJhI98WdEfmJ2\nQm5r1ufm8S/6hNvOgxacFudL/TZ/Sv6t4Jo6M1XvH46If9iDiw1IZuKtiadzZg4R+8VBt3qygC7h\nujomCygBnfiGvY0CTwjLPx1iOjPuY3kTjouR6SlRxH4xErlF1NAlzqEr4rOxKFpFYQ7LMR2TYYVY\nTSPC6K5PyN0oPjdGxOqo/is477VEu7iW2CXs4C08wmtjryVahQnfiqXijqQX9xt1kFdIDQux05+L\nmqo4xkfFNA4ae1Ez9DfFxPgN6lCbI19RTj4AAAAASUVORK5CYII=\n'

# play_icon 10x11 pixels black
play_icon = b'iVBORw0KGgoAAAANSUhEUgAAAAoAAAALCAYAAABGbhwYAAAACXBIWXMAAAYoAAAGKAE7mnbdAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAIRJREFUGJV9zzEKwlAQhOHPQJrU\nloIQ9CSpPYWFTQpv5QUsBFuPI9gEixRq84IbfcnAFjv7szvLVzv0eKfqkweKAG5Rhr5M3h84qwIV\nGtSZeZ1mFazRhWy/9YxL2hnwGE8scMlAt9wfKzwC1GEz9dw+gIcpaNAZ1xRnlO2EZfCGTK/g3T9o\npCU8zhdVhQAAAABJRU5ErkJggg==\n'

# pause_icon 10x11 pixels black
pause_icon = b'iVBORw0KGgoAAAANSUhEUgAAAAoAAAALCAYAAABGbhwYAAAACXBIWXMAAAU+AAAFPgHBI4ZIAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAEVJREFUGJXtyrEJgEAQRNGHqC2Y\nXB3Xfy9rYgleosmCm2kBDnyY+QwEruRET0bxMaN5smLLvhTfJh/zH1+Pe9kDRzKKjxuo0w4ffxYr\nKQAAAABJRU5ErkJggg==\n'

# 10x10 pixels black
delete_icon = b'iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAACXBIWXMAAASSAAAEkgEK+sW7AAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAHhJREFUGJXFzbENgWEUheHn00iU\nFjABY5jBHlZQmsIUv8ISlCI0EhXRCBGJ5nzJLxGtU70377n3Fp8ZYRxeYlNFwQSDzH08wl2cw4eC\nFYbo+Z4b1nVoMM2FWfiIeZxOa/OUt5fwHdcq28Wf+WOxZoEtXtiFn9jHeQOOAhmpEdVYMAAAAABJ\nRU5ErkJggg==\n'

# done_icon 16x14 pixels black
done_icon = b'iVBORw0KGgoAAAANSUhEUgAAABAAAAAOCAYAAAAmL5yKAAAACXBIWXMAAADiAAAA4gHdoT1DAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAjdJREFUKJF1kk1IVGEUhp9z78yo\ntXERRQVuIqGIQImISGcc74wW6SIQKahQyhLaBZlOiwF/GiRxYVDUIijTMIQ2IenYaFhBEUkGQQRB\n6KI2QaE217nfaSEzTqFnd97zPS+H93xCXl2Ziezwe9qqSi2wSyCt8BV47KatOzdqxhezb2PT0Uqj\nGvLlhKnISc3oTVXuqq1nCzzv85J/pcjnbjqIxblAgTkDlMVToS2u+PqMMXPXQ8lOycHQi8rRnqrx\nj6xT8ZfRrSuuKVXhlkGbE6HJtwBWbDK8U9EBlLqNYADX9cIqDKqRS1kYwFLLOg+M9FRNzG4Ex6ai\ndYjctoU6S2jqeBEuzxmIUK9GHgJ0JKu3taecRx2p6L4cnIocUMwwQktnMDkHOqvGPp6d+xR2e4Gl\nD6sdLQKNYPbHX9Uc+eP5VL30KCqDPaGJEQBVPlmijbkNAM8sbjYAgWBFN8IosMd1vQnbS/cpFBpf\noD0LiG0tK1q8lgEy7ys0pQBxiZtl/+JpkDdAuUKTqMQSFU9/5gIxuhfl21oGqk9sOJEV+g+/XiZj\n6oEvCj9+L/se5AeqoqcQfZYzsIy5p8qFthmnJCv2OJPfjU2NQNfAsbH02jUiDQrFgWBlzmD1I007\nLapczmimurdqan69U15LOY4Rho0QTQST7/8xAOiYdppRuoB+8cxQd/XzBYCr006ZrbQqOMZYDYnw\n+Lt8Y8lv2macEjsjFwWtBbYruMCCKEP+Iv/9+KGxX/9v9hfGX/rP0chocgAAAABJRU5ErkJggg==\n'

# hourglass_icon 11x16 pixels black
hourglass_icon = b'iVBORw0KGgoAAAANSUhEUgAAAAsAAAAQCAYAAADAvYV+AAAACXBIWXMAAAD/AAAA/wGdhUAaAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAARdJREFUKJGN0r8rhXEUBvCP94qb\nQZLucrEhFsVgsRosIjuSQXaLP8FqkIxSNgzKwGIgynCz2PwovxYM4kq6hvfcehlw6nTqfJ/vc57z\ndGowjTF0ohENUct4wz3OsJsgjyHU4hUveMJj1HqMBE4H9vwe++hLgq3wB7iA5wQ3+MAgVjAcuqvR\njzpcVBujOMI6KpEPmMIxxiEX4PPQ3oLDYNtAL06xBElm3ILUqlb0oCh1ZqEKyILzaA9tTbhCm9S6\nb5HDFpZRg8moi9j8QWoO29Esxg7F+LCD2ayU65Agxs5nxneFpEQscxIPhXDhDqtojn4J3TAQds1I\nva1k8hYTQTZQ/VX5R5Zy0tv4jMzhXXqeZanPlzjA2hdPMUrLQtYMpQAAAABJRU5ErkJggg==\n'

# dropdown_icon 20x12 pixels black
dropdown_icon = b'iVBORw0KGgoAAAANSUhEUgAAABQAAAAMCAYAAABiDJ37AAAACXBIWXMAAADAAAAAwAEwd99eAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAHFJREFUKJGt07ENwlAMRdFjRJMA\nC4FQqJg0S1AhpfqsAHOkBYogGujsK7lxcSXbz4ERJ6zkeOIKD7yK6h444PhpZAhMScd/6w5n9EnX\njAvc1O2wZS/7Q2BrGXmTdH1HLiWwx2AJZtY1URzsNRo6Na/X3hasSJejQLGSAAAAAElFTkSuQmCC\n'

# undo_icon 333x33 pixels black
undo_icon = b'iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAACXBIWXMAAADMAAAAzAHrAFApAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAALpJREFUKJGV0DFKA1EQh/HfRgOi\nndqmSWWuYBfs0nkBL+ABtLPyAh5CsLFNlTZNIKQJ2Nka2CIBF7Vai30LK85C9oOB9/jPN+8xcOov\nAzxhhR9s8IxRs2mJM2S4wzfKoD4xrqUyiY9BY5GqvufpgXDqG67QwwFu8JWyh0h6x7n/3KZ8EUkz\nnARSH1vs2r43x1EgTlEc4j4I4UK19iY5PrIWoY0XlL2O0hCvXYRjrFUL2ZsJrrsIcFkffgFtbj2m\n5MkfIgAAAABJRU5ErkJggg==\n'

# batch icon 32x32 pixels black
bat_icon = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAHOAAABzgEzS/IjAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAActJREFUWIXt179rFEEUB/BPNERE\nIUoQbKwkhcbuBO1ikcJYiE0EISjxB3b+B4KIhZqojZVY2AgBm7SxuGC003RpTjAgQghJTlATEDGe\nxbyTTbglEdxL4X5h2Zk3j/l+Z97b2XkkdOIq3qCORkFPPTiuYCd0YBcm0R9ilvFVMehGT7SncBoe\nhbpXOFIQcRZHMR2cD2AR30Jdu7AvOBeEklobyZuoobFjG4jXoRRQCigFdObYj+FZpr+Et7iPlYz9\nGq5H+yzmpWO9R2sMxlx/kLcDe1DBAVRxEDdxe4PfjfCrYDhsHzGHX2Hvjv4cfrYia3USngh7Nfrn\no/8841MJ2wRWMbthjpEYf5yzyBoaeSFo4iQ+4JC09aOZsUvxfoofGMJxvNtkznXYLAnn8QQvsBe3\nwt6FC/iMlxgP+8W/IW9iKyEg7cCalLjntL5wLIU4/lEIDuMueqXEnJUSqbnSO/gU7SEM4IyUF1tC\nnoBVzER7AN+lUNzDbumrmJJCshZ+77FfyoMJ6WY1kxGYi/I+UAooBfzfAti+wmRFFCYPpcNoGn1t\nIO/D6+Ac65B+HpM4FQ51fCmIPFucVqUbElKpfDmUFVmeL0s7PRKcfgNRzaAcU0lblgAAAABJRU5E\nrkJggg==\n'

# audio_icon 20x20 pixels black
audio_icon = b'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAACxAAAAsQHGLUmNAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAYFJREFUOI2l1D1rFUEYxfHfrjcJ\nvpQqpLIRLUynrSBYWCkaAmqjgt9A8BNIICm1ERVBC1HBxj75CCLamGBjfEdBIRiRa66xmGdwWe+s\nxHtgYfeZc/7z7OzOMFwTuIBHeIM+BniNxziHrYXsXzqL99j4x/U2vEXVuNEIfMZVnMQhHMSpqH1q\n+K6hGga8HoZ1zGF7x+Q7MI9fkZlrG87EwE/MdL1GS6ejgQ0cz8UJrETx0iZgWZcju4SxZndPpXXc\nrLbgeTCm4WE8nP8PWNbFYNyGZWlxd40AnAzgcoXvWBsRCF/Rr6Wv9GNEGKmpbT18xB7pp90bExyV\ntteXQngn7mAB43iJ3XgB9/z56xdwK+73d3RzIDw3sdjI363xqmXO22i8A9hrebNWapwohLqAY4X6\nsRr7WsU8a09ZpQ6naunkyBo0TIMOYB6rpLXL+lDjQQHY7wDmsUraFFn3a1zBsyisDwl1ATU6fIL5\nGqs4LJ1v72LWtaiXtBqeSjq5Z3EE334DgHNrz6KVYRQAAAAASUVORK5CYII=\n'

# filter_icon 15x15 pixels
filter_icon = b'iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAYAAAA71pVKAAAACXBIWXMAAADNAAAAzQE5R7LNAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAKFJREFUKJG10DsOAVEUgOFvkNDR\nqcWU1mEnswGlXZCwBFNZA7EDCjsQhV4yBaOZaSbzUsyfnNxH7n8eN0CMEIFmEryz/SvAEvuWcs4X\nUX5YI/0jVsVsm5birqyVPo4NYoxe1SwjXCrEE4a1P4ExrgXxhklZq0USnDHFPYsIz6aqOYtC5XnZ\no8rh29CJnHYuDyruP9maYItHm2Q5IQ6Y1T36ATzsPfzX0hcXAAAAAElFTkSuQmCC\n' 

# select_icon 20x17 pixels
select_icon = b'iVBORw0KGgoAAAANSUhEUgAAABQAAAARCAYAAADdRIy+AAAACXBIWXMAAADVAAAA1QFU2apiAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAWBJREFUOI2d089LVFEYxvEPOojj\nMC7DiH5I/4jQIgL3Rm3CfqzaBUGgbh1oEYIgBe3Ef8C10GJgohZqFJSVVlTLlmmOzrS459LpzL3T\n5AMH3nPu8355zuG9ZLqOVzhEd8C1hUron8SIcHANqwG4gn3lqkeQDRzhJh6jiWnYxg6qfUBluoXj\nKPU6/MTTE8BuJ7AuNqGNJ/8Ju4NOAnuDU2TvsBKZL2IOtT7JUthbTOSGDpZDfQ57wdTEeAKb1XvN\n9zgTmzpYCvWLxNyKoEWwXZxNr9DFo1Df0ztvLdwtgH3ChaI3iRPCfAE0XXsBNoaFFHjszxvmWuwD\n28X54Gvge9w4FEzDCfABHhbc5iOm8Dns64HxTyDcDwlyfQiwL9HZSNpUkQ12ETBP+guXcBXfku+1\nEOgvbeMdRkugZarjK16mCRtYw3M8w8EAsCou4zRuFBlm8Bo/9M5b0WrL/t0rKeg3TXSI1Z2tAfUA\nAAAASUVORK5CYII=\n' 

# view_icon 20x14 pixels
view_icon = b'iVBORw0KGgoAAAANSUhEUgAAABQAAAAOCAYAAAAvxDzwAAAACXBIWXMAAACdAAAAnQGPcuduAAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAQtJREFUOI2V071KA1EQBeAvySqK\nRFQEEREt7MRC9Dl8Ix/FUmxsBHvFBzCksbCJAQsDYizUiBFjcW9gXXc3mwMDw525h/k7cIwXvOED\nzzgRsIYuRhXsG+ciQV7CBvbxU5FwhE6Cefmoo4VDrGRiM1jAa+b9PsFsAeEYnZyPRXhKJiRs4Tan\nwiLc1HGZE2ijh7loVdGsCbPaFmYybv8Og1SVqyUkX3iPfi+JhEuopZLS/gD96CdolpDX4ML/9bdj\ntTvCbVY9mxbhIPOCm7Hd/hSE10mmvSy6WPf3VhtYLMh/TAQl1EtId7FcEk/jm6DhIuntmU56Dw0M\ncSAsYSio4gynkexI2OwkEXzi6hcpGHSqmLcPlgAAAABJRU5ErkJggg==\n' 

# clear_icon 28x32 pixels
clear_icon = b'iVBORw0KGgoAAAANSUhEUgAAABwAAAAgCAYAAAABtRhCAAAACXBIWXMAAAUiAAAFIgFTQBn1AAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAArBJREFUSIm9lk1oE0EUx99mP7If\nk83usjsOTSAKIRBLEmLaQA+FhWJFIZDLXiUq5CK51ut6LX5A20sOBS961qMKHryooAiCCIJHUcGK\n9KAIseuhnXaybppsm+0fBpY3895v3rw3yQCcgDDGfQAIMMb3uZMAAkBAP1JJkwzDeEq/s9nsk0Rh\nvu+nYDe7AACCdrttJApECL1ngYnCPM9TWJhpmmuJAhVF+cYC9443GS0tLZ1iYTzP7yQGAwCQJOkX\nCySEXE8M5vt+iuf5ASTVLJ7nIcuybuu6ftfzPIfaXdcliqJ8kSTpx9Rgtm0/hOFMAp7nB8Vi8cLU\nIFSVSmUhDAsPQsiNqUJ935cymcyLceBms3nmWKBarTYbtpmmuTEGfCwFABCUSqWL4YlCoXAtCjgz\nM3P1SCRBEP7QIK7rnh61bm5uri6K4v59NAxjPRao1+ulU6nUDg3gOM7mJH6e5yGE0IdyuXx+Yphl\nWZvAHE8mk3kWa7eTaH5+fhYh9A5Ctcjn8xO3uqqqb5vNZmnI2Gq1bNM0VwzDWNM07SXHcZFdpijK\n1263K8bZMPVdXFw8y84deod0XX/e7XbVSUFUCKFPTJwDybL8nQWoqrplmuYq+7t4RNHufPTfDMdx\nf+kCjPGDKO84G7Bt+yaN1+/3o8vA1k6W5c/Uvry8jGVZ3h4VfMQ/eQAAwd49HC32UrOj0+nIUetd\n182zmwMAIIRcoX6NRqNyKBAAQNO01ywsnU5/7PV66fA6x3HWYfetIkRlF+tZUSgULkEoS03T3mCM\nFyzLWoWDet9h/TDGt+hcvV6vTQykymazj8NgJoPBUFpBsP/oFUXxZ2wYE4jbe6JHgjmOC1RVfSUI\nwja1jap5bOVyucuiKEY2Fh2EkI2pwMKqVqvndF2/J0nSbzg4yq1xfv8AVBAGM8fw8t0AAAAASUVO\nRK5CYII=\n'

# paste_icon 25x32 pixels
paste_icon = b'iVBORw0KGgoAAAANSUhEUgAAABkAAAAgCAYAAADnnNMGAAAACXBIWXMAAAUiAAAFIgFTQBn1AAAA\nGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAh5JREFUSInd1jtoFUEUBuAvT41J\nNBEUC5+NpSAhlklnrzYW2omtloKlIJZWiqBoYWFhERstbGxioygWWiiKoI0vMMn1bXYtZoZMNvcF\nNzeFPwzszpzZ//xz5pyztI8duIcFPMaBdjf2tVjfi0kcwk28wGGsxw2MYijafmn0kR5MZO+92ISB\nSHAxzn/FfRzHrzh3Bsei3QBO4RX+YA5FTlLiaTY5Gj3dEr2cwJMmaqfxAD/wCT+FI01O7xdJhuts\n3h3Xhuqs5dgc7XbVWRtGmZSM4LRw9qKSrVHNHrxtQtIrHNHnTAncwmXU+jPjnfiLK6hFDy8J5/xG\nCOy3BkSLOIfXkfCocBtBTlLiJa5nc3ejoo2WbuI6S8FfxDw+4H22bxLbGpEsVjx8F0dH6K2QFI0M\nO0GupIhECWdxRMibhAHhktSEs0+Yw22cb0VSVTKDj0IuiWS58iJ+PO2dbUdJNSbP4+gYaxKTqvyu\nB760PPBj2IdBjMe5cY3xSKiBLUnymEzjYLQZEW5WFSkZC6GktCSpHtWdODpByfKYJM9WEyXNk3E1\nUFRJqoEn9IPB+NwnFMqEvPv9Vr9CryCpKjmBk0KmJ7t+oXMuCG2BUF7mhRZxrRUJy2NyNY5OsCLw\n3UjGokrSrbJSrgVJ8f8oqV7hKauTkFPCT8kKklls0LzStotneJhI0s/ddnxvsinP/IQeoR0kpP5P\nSNixOC4kkq7iH+xVlw4uTdjBAAAAAElFTkSuQmCC\n'

# downloadbtn_icon 95x36 pixels
downloadbtn_icon = b'iVBORw0KGgoAAAANSUhEUgAAAF8AAAAkCAYAAADvqeb3AAAABHNCSVQICAgIfAhkiAAAAAlwSFlz\nAAACjwAAAo8BLYPxagAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAS0SURB\nVGiB7dtriFVVFAfw35ipPeydZT6yJ/QgIoskTAssP0QZPS2CqMCkwIqICiqpIJCiqL5khOSj6FN+\nSIqiIimrIXrYw5qiUqMyK0ltKnX09mGt0z1zHcO5jl5hzh82Z6+119l73bX3Wvt1LnUMwwNYik7U\nqtRnqROf4H4cogHnYPVuoGR/SL9gQmH4Y/FnFizC2Rjc2DsVdgiDhcFfFnZej6NhfjKeRVuLlOsv\naMM8Ye95hBvUMKKFSvUnjBL2XgVb0NVSdfofurBlgHCFWouV6W+ooW1Aq7Xoz6iM30JUxm8hKuO3\nEAN7KX8Y9sl8F9Zm2p1wPc5EO+bs5LYuwWR8g0eaqaCGTdsp+6Ket8vP4IhmGt8JKDaN83dBW7Oy\nrcW9fG8Tas2GnS6xRSYO5G4QI21kk/X1S/Q27BRox3gcjJvEad1IPCFcscBZuAyHYyUW4PMsm4Sx\nWIaXMAi3YSMeS5mrMBpvZZu3YEjKH48pWIFHse5/9B2Ai3Ee9kWH8NZVWT4YU3EKDhWhdJnwnj9L\n9YzE7RiKuf/T3najmbDzTgN/QfK7cEDybhO753KI2ohLs3xa8j5M+syS3Kjk/Zz0BUn/nvR7DfW+\nVtKlMey04Xlbh8tfcVLKjOyhvIaPsGfKHIrlpbKu1L3psEPfGP+aklLjhPGKBuYILylO9H4To/dE\n9Q7ZGzNKdVyOozK/GQdmO4Xx14pQN7v0TjHnNBr/opLMHTgXXyX9RsocLEb0CdnWJPyVMuenzINJ\nr8OVYmLfYDcw/hT1HzhBGK+od2jKnFSSGStG5G9Jj8dz+FoY9hERcmr4tNROYfyHkh6he6eztfEf\nTnppqZ7rkvcP9ijVNSPlZ2NNytyc5UuSfrpUz0I7YPxmY34jTi7lf8IZmV+jPjEvL8mMFi67RIzM\ncZneFiFgnLq7N3Y0MXLpHo+3dQcxOp8rS7wVpXcOzzYXJ71ZjO79UqbwuuEN7zbme42+2GSNERMh\nfIdvRQcQ8X9I5oeX3inKl+TzQnG50I73cZr6bc8SW6M4hd2yHfoVbR1W4hW6bBI3eNOF4RcLTz1I\n98Ei5YjOaqynKTRr/DFijfsCPhOTEdwt3PADYZhBmIkjcW/KrMcXmS9GdWHo9kx74dTk9WT83qA9\nn6eLFc1xuDV5H+oeGjeIOehiHNNQz7v5nCpu+yarLwSaxo5usmrC/ac3yM7qQW4LbizJDMbfWdYp\nlr7DSvI/NNRZxPyrkx5akp2YvMaYPxCv96BLp1gKw7Ul/gb8ob7SuidlRpXaL1KHXRjzF4pJscA6\nsbV+MxUr407hAVcIN14lVj5vlmQ24C7hvj+JcLIa94ljjI6GOh8XK6NlSW8UnUw9pi/Cj/g46S4x\nQqeJlcte+RuexJcpM08MhCn5m2aJzhyuPuJ/EB46M3WbLxYHE/G9JtGbkV+hb7BDxwsV+gCV8VuI\nyvgtRGX8FqIyfgtRGb+FGCC/IWm1Iv0M/30rVXwuWN1C7Rp0+1yw2I7PU3nAzkab+sXTXOIAaX0y\nXhHb5SHbertCUxgi/gPxqvqFzFFF4QT18FOlnZtWiVPR/25xVojv8//C/uIiYZAKfYVO8eHAU+IE\ntQP+Bf/wfFOVoabvAAAAAElFTkSuQmCC\n'

# later_icon 36x36 pixels
later_icon = b'iVBORw0KGgoAAAANSUhEUgAAAF8AAAAkCAYAAADvqeb3AAAABHNCSVQICAgIfAhkiAAAAAlwSFlz\nAAACjwAAAo8BLYPxagAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAMnSURB\nVGiB7dtLiBxFHMfxz26CSZBETUwiJEJcF8xFiKj4wqggCEpQUTz5SDZHD0E8BBEEDQTxJBJ1BQ9x\n9STe1Eh8HATRgyARIipqTMJiHgTBxFFh120P/+r0OAyuOL2pwe4vFFVdXd3971/XY+pfNVSswTP4\nEh0UbagtdHAAT+NiPdyKk0NgZBPCCWwuhR/Hr+nEO7gZS3q/TstALBGC7xM6n8EYvJ4y9mIkk3FN\nYQRTQu8pohkUWJfRqCZxqdD7OMxhNqs5zWMWc6OiKRSZjWkaBUZGc1vRZFrxM9KKn5FW/Iy04mdk\ncabnjuEi4fP4JpMNQ0GBmXP8zLfScz8d4B4T+AH7a7Ho3DKDIlfNr4MLRQv6I7ch/5VhFX8cW3EF\nLsAxfIZXxezwbtyVyq7Bsyn9An7CKjyK68QM/iNMqj7UFtyEb3EQj+NHPLFwr9SfYex2tqpcsLNd\n6b3p/B793bWbcIkQshDCz6X0+1iUrn8+5X2t8uh+UM+r/Stm0jOHUvyrcRuWCffHNtWHOB8b8XLK\nO4zbU1iOF1P+AdEqNqjWKh5I9y/FL/AuHsKDtb3d/Ax1n/8F7sRurBWCEzV3A77Cdymvgw+7rr0h\nxYdwT0pPYzVuxJtdZU/hPpnGjWEVfxeeTOlp/Nl1bsU8165P8b0pdHNZz/FBGQfsYRV/IsU78Rwu\nx/c9ZeZSvKgn/6io5XtUY0TJLz3Hvw9k5YDknuGO4ZWesFy1jLlSLDg/1efaUykex2O4Px1/kuIt\n4sMcFpVsAlfVan0N5Bxw+4XVeKkn7/OudNmnr8XprvxyQWilGBP63fvhVKYccPct0PvNR9YB9w0h\naD862CEG1GvEz8FJbE/nj6T4BK7EHcJVUS4I/YxrhdDXi9Y9LX7rf5zKvC3mDodqeZsByFHzm84M\nitx9fqNpxc9IK35GWvEz0oqfkVFpD0luQxrG2b1S5XbB9f9YvKUu/rZdsNwoO6VtAQvNiJhgFniN\ncFqdSRnv4RYszWXd/5Sl4j8Q+4XOp3V5WDerup82LGw4Lv4DcdYde0S4X38Ta6YrcJ6WuuiItYNJ\nPCLWjv0FcMTWTXkVvw4AAAAASUVORK5CYII=\n'


if __name__ == '__main__':
	icons = [x for x in globals().keys() if x.lower().endswith('icon')]
	import awesometkinter as atk
	import tkinter as tk
	root = tk.Tk()
	for name in icons:
		img = atk.create_image(b64=globals()[name])
		print(f'# {name} {img.width()}x{img.height()} pixels')