"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_ec2_1 = require("monocdk/aws-ec2");
const monocdk_1 = require("monocdk");
const nag_rules_1 = require("../../nag-rules");
/**
 * EC2 instances do not have public IPs
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const networkInterfaces = monocdk_1.Stack.of(node).resolve(node.networkInterfaces);
        if (networkInterfaces != undefined) {
            //Iterate through network interfaces, checking if public IPs are enabled
            for (const networkInterface of networkInterfaces) {
                const resolvedInterface = monocdk_1.Stack.of(node).resolve(networkInterface);
                const associatePublicIpAddress = nag_rules_1.NagRules.resolveIfPrimitive(node, resolvedInterface.associatePublicIpAddress);
                if (associatePublicIpAddress === true) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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